/*
 * Decompiled with CFR 0.152.
 */
package fr.xgouchet.elmyr.junit5.params;

import fr.xgouchet.elmyr.Forge;
import fr.xgouchet.elmyr.annotation.Forgery;
import fr.xgouchet.elmyr.junit5.params.ForgeryResolver;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u001d\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J-\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\"\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R$\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R \u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lfr/xgouchet/elmyr/junit5/params/ForgeryParamResolver;", "Lfr/xgouchet/elmyr/junit5/params/ForgeryResolver;", "()V", "listClasses", "", "Ljava/lang/Class;", "", "[Ljava/lang/Class;", "mapClasses", "", "setClasses", "Ljava/util/Set;", "resolveParameter", "", "type", "Ljava/lang/reflect/Type;", "forge", "Lfr/xgouchet/elmyr/Forge;", "resolveParameter$junit5", "parameterContext", "Lorg/junit/jupiter/api/extension/ParameterContext;", "extensionContext", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "resolveParameterizedForgery", "rawType", "typeArgs", "(Lfr/xgouchet/elmyr/Forge;Ljava/lang/reflect/Type;[Ljava/lang/reflect/Type;)Ljava/lang/Object;", "supportsParameter", "", "junit5"})
public final class ForgeryParamResolver
implements ForgeryResolver {
    private static final Class<? extends Iterable<?>>[] listClasses;
    private static final Class<Set<?>>[] setClasses;
    private static final Class<Map<?, ?>>[] mapClasses;
    public static final ForgeryParamResolver INSTANCE;

    @Override
    public boolean supportsParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkParameterIsNotNull((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkParameterIsNotNull((Object)extensionContext, (String)"extensionContext");
        return parameterContext.isAnnotated(Forgery.class);
    }

    @Override
    @Nullable
    public Object resolveParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext, @NotNull Forge forge) {
        Intrinsics.checkParameterIsNotNull((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkParameterIsNotNull((Object)extensionContext, (String)"extensionContext");
        Intrinsics.checkParameterIsNotNull((Object)forge, (String)"forge");
        Parameter parameter = parameterContext.getParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"parameterContext.parameter");
        Class<?> type = parameter.getType();
        Parameter parameter2 = parameterContext.getParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameter2, (String)"parameterContext.parameter");
        Type parameterizedType = parameter2.getParameterizedType();
        Type type2 = parameterizedType;
        if (type2 == null) {
            Class<?> clazz = type;
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type");
            type2 = clazz;
        }
        return this.resolveParameter$junit5(type2, forge);
    }

    @Nullable
    public final Object resolveParameter$junit5(@NotNull Type type, @NotNull Forge forge) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)forge, (String)"forge");
        Type type2 = type;
        if (type2 instanceof Class) {
            object = forge.getForgery((Class)type);
        } else if (type2 instanceof WildcardType) {
            Object[] objectArray = ((WildcardType)type).getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"type.upperBounds");
            Object object2 = ArraysKt.first((Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"type.upperBounds.first()");
            object = this.resolveParameter$junit5((Type)object2, forge);
        } else if (type2 instanceof ParameterizedType) {
            Type type3 = ((ParameterizedType)type).getRawType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeArray, (String)"type.actualTypeArguments");
            object = this.resolveParameterizedForgery(forge, type3, typeArray);
        } else {
            object = null;
        }
        return object;
    }

    private final Object resolveParameterizedForgery(Forge forge, Type rawType, Type[] typeArgs) {
        Type type = rawType;
        return ArraysKt.contains((Object[])listClasses, (Object)type) ? Forge.aList$default((Forge)forge, (int)0, (Function1)((Function1)new Function1<Forge, Object>(typeArgs, forge){
            final /* synthetic */ Type[] $typeArgs;
            final /* synthetic */ Forge $forge;

            @Nullable
            public final Object invoke(@NotNull Forge $this$aList) {
                Intrinsics.checkParameterIsNotNull((Object)$this$aList, (String)"$receiver");
                return ForgeryParamResolver.INSTANCE.resolveParameter$junit5(this.$typeArgs[0], this.$forge);
            }
            {
                this.$typeArgs = typeArray;
                this.$forge = forge;
                super(1);
            }
        }), (int)1, null) : (ArraysKt.contains((Object[])setClasses, (Object)type) ? CollectionsKt.toSet((Iterable)Forge.aList$default((Forge)forge, (int)0, (Function1)((Function1)new Function1<Forge, Object>(typeArgs, forge){
            final /* synthetic */ Type[] $typeArgs;
            final /* synthetic */ Forge $forge;

            @Nullable
            public final Object invoke(@NotNull Forge $this$aList) {
                Intrinsics.checkParameterIsNotNull((Object)$this$aList, (String)"$receiver");
                return ForgeryParamResolver.INSTANCE.resolveParameter$junit5(this.$typeArgs[0], this.$forge);
            }
            {
                this.$typeArgs = typeArray;
                this.$forge = forge;
                super(1);
            }
        }), (int)1, null)) : (ArraysKt.contains((Object[])mapClasses, (Object)type) ? MapsKt.toMap((Iterable)Forge.aList$default((Forge)forge, (int)0, (Function1)((Function1)new Function1<Forge, Pair<? extends Object, ? extends Object>>(typeArgs, forge){
            final /* synthetic */ Type[] $typeArgs;
            final /* synthetic */ Forge $forge;

            @NotNull
            public final Pair<Object, Object> invoke(@NotNull Forge $this$aList) {
                Intrinsics.checkParameterIsNotNull((Object)$this$aList, (String)"$receiver");
                Object key = ForgeryParamResolver.INSTANCE.resolveParameter$junit5(this.$typeArgs[0], this.$forge);
                Object value = ForgeryParamResolver.INSTANCE.resolveParameter$junit5(this.$typeArgs[1], this.$forge);
                return TuplesKt.to((Object)key, (Object)value);
            }
            {
                this.$typeArgs = typeArray;
                this.$forge = forge;
                super(1);
            }
        }), (int)1, null)) : this.resolveParameter$junit5(rawType, forge)));
    }

    private ForgeryParamResolver() {
    }

    static {
        ForgeryParamResolver forgeryParamResolver;
        INSTANCE = forgeryParamResolver = new ForgeryParamResolver();
        listClasses = new Class[]{List.class, Collection.class};
        setClasses = new Class[]{Set.class};
        mapClasses = new Class[]{Map.class};
    }
}

