/*
 * Decompiled with CFR 0.152.
 */
package com.github.wtekiela.opensub4j.xmlrpc.client;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriableXmlRpcClient
extends XmlRpcClient {
    public static final int DEFAULT_MAX_ATTEMPTS = 5;
    public static final int DEFAULT_INTERVAL = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(RetriableXmlRpcClient.class);
    private final int maxAttempts;
    private final long interval;

    public RetriableXmlRpcClient(XmlRpcClientConfig xmlRpcClientConfig) {
        this(xmlRpcClientConfig, 5, 1000);
    }

    public RetriableXmlRpcClient(XmlRpcClientConfig xmlRpcClientConfig, int maxAttempts, int interval) {
        this.maxAttempts = maxAttempts;
        this.interval = interval;
        this.setConfig(xmlRpcClientConfig);
    }

    public Object execute(String method, Object[] params) throws XmlRpcException {
        RetryTask execTask = new RetryTask(this.maxAttempts, this.interval, method, params);
        try {
            return execTask.call();
        }
        catch (Exception e) {
            throw new XmlRpcException("Exception occurred during XML-RPC call", (Throwable)e);
        }
    }

    private class RetryTask
    implements Callable<Object> {
        private final Callable<Object> task;
        private final int maxAttempts;
        private final long interval;

        private RetryTask(int maxAttempts, long interval, String method, Object[] params) {
            this.maxAttempts = maxAttempts;
            this.interval = interval;
            this.task = () -> {
                LOGGER.debug("Calling method: {}, with params: {}", (Object)method, (Object)Arrays.deepToString(params));
                Object response = RetriableXmlRpcClient.super.execute(method, params);
                LOGGER.debug("Response: {}", response);
                return response;
            };
        }

        @Override
        public Object call() throws Exception {
            int attemptsLeft = this.maxAttempts;
            while (true) {
                try {
                    --attemptsLeft;
                    return this.task.call();
                }
                catch (XmlRpcException e) {
                    if (attemptsLeft > 0) {
                        Thread.sleep(this.interval);
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
    }
}

