/*
 * Decompiled with CFR 0.152.
 */
package com.github.wtekiela.opensub4j.response;

import com.github.wtekiela.opensub4j.response.OpenSubtitlesApiSpec;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class SubtitleFile {
    public static final int BUFFER_SIZE = 10240;
    public static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    @OpenSubtitlesApiSpec(fieldName="idsubtitlefile")
    private int id;
    @OpenSubtitlesApiSpec(fieldName="data")
    private String encodedContent;
    private Map<String, Content> contentCache = new HashMap<String, Content>();

    public int getId() {
        return this.id;
    }

    public Content getContent() {
        return this.getContent(DEFAULT_CHARSET);
    }

    public Content getContent(String charsetName) {
        return this.getSubtitleFileContent(charsetName);
    }

    private Content getSubtitleFileContent(String charsetName) {
        Content content = this.contentCache.get(charsetName);
        if (content == null) {
            content = new ContentBuilder(charsetName).build();
            this.contentCache.put(charsetName, content);
        }
        return content;
    }

    public String getContentAsString(String charsetName) {
        Content content = this.getSubtitleFileContent(charsetName);
        return content.getContent();
    }

    private class ContentBuilder {
        private final String charsetName;

        public ContentBuilder(String charsetName) {
            this.charsetName = charsetName;
        }

        public Content build() {
            return new Content(this.charsetName, this.decode(this.charsetName));
        }

        private String decode(String charsetName) {
            String content = null;
            try {
                byte[] rawContent = Base64.getDecoder().decode(SubtitleFile.this.encodedContent);
                content = this.decompress(rawContent, 10240, charsetName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return content;
        }

        /*
         * Exception decompiling
         */
        private String decompress(byte[] bytes, int bufferSize, String charsetName) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public class Content {
        private final String content;
        private final String charsetName;

        public Content(String charsetName, String content) {
            this.charsetName = charsetName;
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public String getCharsetName() {
            return this.charsetName;
        }
    }
}

