/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.connection;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.github.wrdlbrnft.simplerest.connection.BackendConnection;
import com.github.wrdlbrnft.simplerest.connection.CookiesImpl;
import com.github.wrdlbrnft.simplerest.connection.ResponseImpl;
import com.github.wrdlbrnft.simplerest.connection.exception.BackendConnectionException;
import com.github.wrdlbrnft.simplerest.connection.request.QueryParameter;
import com.github.wrdlbrnft.simplerest.connection.request.Request;
import com.github.wrdlbrnft.simplerest.connection.response.Cookies;
import com.github.wrdlbrnft.simplerest.connection.response.Response;
import com.github.wrdlbrnft.simplerest.connection.spec.ConnectionSpec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

class BackendConnectionImpl
implements BackendConnection {
    private static final String TAG = "BackendConnectionImpl";
    private final String mEndpointUrl;
    private final ConnectionSpec mConnectionSpec;
    private final List<BackendConnection.Observer> mObservers = new CopyOnWriteArrayList<BackendConnection.Observer>();

    public BackendConnectionImpl(String endpointUrl, ConnectionSpec connectionSpec) {
        this.mEndpointUrl = endpointUrl;
        this.mConnectionSpec = connectionSpec;
    }

    @Override
    public Response perform(Request request) {
        Response response = null;
        Exception error = null;
        try {
            this.notifyPerformingRequest(request);
            byte[] data = request.getData();
            HttpURLConnection connection = this.performConnect(request);
            if (data != null) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(data);
                outputStream.flush();
                outputStream.close();
            }
            response = this.readResponse(connection);
            this.notifyResponseReceived(response);
            Response response2 = response;
            this.notifyRequestProcessed(request, response, error);
            return response2;
        }
        catch (Exception e) {
            try {
                error = e;
                this.notifyRequestFailed(e);
                throw new BackendConnectionException("Connection to backend failed!", e);
            }
            catch (Throwable throwable) {
                this.notifyRequestProcessed(request, response, error);
                throw throwable;
            }
        }
    }

    private void notifyPerformingRequest(Request request) {
        for (BackendConnection.Observer observer : this.mObservers) {
            observer.onPerformingRequest(request);
        }
    }

    private void notifyResponseReceived(Response response) {
        for (BackendConnection.Observer observer : this.mObservers) {
            observer.onResponseReceived(response);
        }
    }

    private void notifyRequestFailed(Exception e) {
        for (BackendConnection.Observer observer : this.mObservers) {
            observer.onRequestFailed(e);
        }
    }

    private void notifyRequestProcessed(Request request, Response response, Throwable error) {
        for (BackendConnection.Observer observer : this.mObservers) {
            observer.onRequestProcessed(request, response, error);
        }
    }

    @Override
    public void registerObserver(BackendConnection.Observer observer) {
        this.mObservers.add(observer);
    }

    @Override
    public void unregisterObserver(BackendConnection.Observer observer) {
        this.mObservers.remove(observer);
    }

    private Response readResponse(HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        Map<String, String> headers = this.parseResponseHeaders(connection);
        Cookies cookies = this.parseCookieFromHeaders(headers);
        byte[] data = this.readResponseData(connection);
        return new ResponseImpl(status, data, headers, cookies, connection.getURL());
    }

    private byte[] readResponseData(HttpURLConnection connection) throws IOException {
        if (connection.getDoInput()) {
            InputStream inputStream = connection.getResponseCode() < 400 ? connection.getInputStream() : connection.getErrorStream();
            return this.readDataFromStream(inputStream);
        }
        return null;
    }

    private Cookies parseCookieFromHeaders(Map<String, String> headers) {
        String cookieString = headers.get("Set-Cookie");
        if (cookieString == null) {
            return new CookiesImpl(Collections.emptyList(), Collections.emptyMap());
        }
        List<String> cookies = Arrays.asList(cookieString.split(";"));
        ArrayMap keyValueCookies = new ArrayMap();
        for (String cookie : cookies) {
            if (!cookie.contains("=")) continue;
            String[] split = cookie.split("=");
            keyValueCookies.put(split[0], split[1]);
        }
        return new CookiesImpl(cookies, (Map<String, String>)keyValueCookies);
    }

    private Map<String, String> parseResponseHeaders(HttpURLConnection connection) {
        ArrayMap headers = new ArrayMap();
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        for (String key : headerFields.keySet()) {
            List<String> values = headerFields.get(key);
            if (values.size() > 1) continue;
            headers.put(key, values.get(0));
        }
        return headers;
    }

    private byte[] readDataFromStream(InputStream stream) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((n = stream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, n);
        }
        return outputStream.toByteArray();
    }

    private HttpURLConnection performConnect(Request request) throws BackendConnectionException {
        try {
            String urlString = this.createUrl(request);
            Log.i((String)TAG, (String)("Opening Connection to: " + urlString));
            HttpURLConnection connection = this.mConnectionSpec.openConnection(urlString);
            connection.setInstanceFollowRedirects(request.shouldFollowRedirects());
            Map<String, String> headers = request.getHeaders();
            for (String key : headers.keySet()) {
                connection.setRequestProperty(key, headers.get(key));
            }
            connection.setUseCaches(false);
            Request.Method method = request.getMethod();
            connection.setDoOutput(method.doesOutput());
            connection.setDoInput(method.doesInput());
            connection.setRequestMethod(method.getHttpRepresentation());
            connection.connect();
            return connection;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new BackendConnectionException("Connection to backend failed!", e);
        }
    }

    @NonNull
    private String createUrl(Request request) {
        Uri.Builder builder = Uri.parse((String)this.mEndpointUrl).buildUpon().appendPath(request.getRelativeUrl());
        for (String segment : request.getPathSegments()) {
            builder.appendPath(segment);
        }
        for (QueryParameter parameter : request.getQueryParameters()) {
            builder.appendQueryParameter(parameter.getKey(), parameter.getValue());
        }
        return builder.build().toString();
    }
}

