/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.connection.spec.https;

import com.github.wrdlbrnft.simplerest.connection.spec.ConnectionSpec;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public abstract class AbsHttpsConnectionSpec
implements ConnectionSpec {
    @Override
    public HttpURLConnection openConnection(String urlString) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagers = this.createKeyManagers();
        TrustManager[] trustManagers = this.createTrustManagers();
        SSLContext sslContext = this.createSSLContext(keyManagers, trustManagers);
        return this.openConnectionWithSSLContext(sslContext, urlString);
    }

    protected abstract KeyManager[] createKeyManagers() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException;

    protected abstract TrustManager[] createTrustManagers() throws NoSuchAlgorithmException, KeyStoreException;

    private SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    private HttpURLConnection openConnectionWithSSLContext(SSLContext context, String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setSSLSocketFactory(context.getSocketFactory());
        }
        return connection;
    }
}

