/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.caches;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import com.github.wrdlbrnft.simplerest.caches.Cache;

public class BitmapCache<K>
implements Cache<K, Bitmap> {
    private final LruImageCache<K> mInternalCache;

    public BitmapCache(int maxSize) {
        this.mInternalCache = new LruImageCache(maxSize);
    }

    @Override
    public void put(K key, Bitmap item) {
        this.mInternalCache.put(key, item);
    }

    @Override
    public Bitmap get(K key) {
        return (Bitmap)this.mInternalCache.get(key);
    }

    @Override
    public void evict(K key) {
        this.mInternalCache.remove(key);
    }

    @Override
    public void clear() {
        this.mInternalCache.evictAll();
    }

    private static class LruImageCache<K>
    extends LruCache<K, Bitmap> {
        public LruImageCache(int maxSize) {
            super(maxSize);
        }

        protected int sizeOf(K key, Bitmap value) {
            return value.getByteCount();
        }
    }
}

