/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.certificates;

import android.content.Context;
import com.github.wrdlbrnft.simplerest.certificates.RawResourceReader;
import com.github.wrdlbrnft.simplerest.exceptions.CertificateCreationException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class Certificates {
    private Certificates() {
    }

    public static Certificate fromRawResource(Context context, String fileName) {
        RawResourceReader reader = new RawResourceReader(context);
        InputStream stream = reader.openStream(fileName);
        return Certificates.fromInputStream(stream);
    }

    public static Certificate fromInputStream(InputStream stream) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(stream);
            stream.close();
            return certificate;
        }
        catch (IOException | CertificateException e) {
            throw new CertificateCreationException(e);
        }
    }
}

