/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.requestmanager;

import android.support.v4.util.ArrayMap;
import com.github.wrdlbrnft.simplerest.BaseApi;
import com.github.wrdlbrnft.simplerest.caches.Cache;
import com.github.wrdlbrnft.simplerest.callbacks.ApiCallback;
import com.github.wrdlbrnft.simplerest.callbacks.ErrorCallback;
import com.github.wrdlbrnft.simplerest.callbacks.OnModificationCallback;
import com.github.wrdlbrnft.simplerest.callbacks.ResultCallback;
import com.github.wrdlbrnft.simplerest.taskrunners.ApiTaskRunner;
import com.github.wrdlbrnft.simplerest.tasks.ApiTask;
import com.github.wrdlbrnft.simplerest.tasks.Result;
import com.github.wrdlbrnft.simplerest.util.StatusCode;
import com.github.wrdlbrnft.simpletasks.utils.TaskUtils;
import java.util.Map;
import java.util.concurrent.Callable;

public class MultiCacheRequestManager<K, T> {
    private final Map<K, ApiTask<T>> mTaskMap = new ArrayMap();
    private final ApiTaskRunner mTaskRunner;
    private final Cache<K, T> mCache;
    private final OnModificationCallback<T> mModificationCallback;

    public MultiCacheRequestManager(ApiTaskRunner taskRunner, Cache<K, T> cache, OnModificationCallback<T> modificationCallback) {
        this.mTaskRunner = taskRunner;
        this.mCache = cache;
        this.mModificationCallback = modificationCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiTask<T> perform(final K key, Callable<Result<T>> callable) {
        Map<K, ApiTask<T>> map = this.mTaskMap;
        synchronized (map) {
            T cachedValue = this.mCache.get(key);
            if (cachedValue != null) {
                return new CacheApiTaskImpl(cachedValue);
            }
            ApiTask<T> cachedTask = this.mTaskMap.get(key);
            if (cachedTask != null) {
                return cachedTask;
            }
            ApiTask<T> task = this.mTaskRunner.queueTask(callable).onResult(new ResultCallback<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResult(@StatusCode int statusCode, T result) {
                    Map map = MultiCacheRequestManager.this.mTaskMap;
                    synchronized (map) {
                        MultiCacheRequestManager.this.mTaskMap.remove(key);
                        if (result == null) {
                            return;
                        }
                        MultiCacheRequestManager.this.mCache.put(key, result);
                        if (MultiCacheRequestManager.this.mModificationCallback != null) {
                            MultiCacheRequestManager.this.mModificationCallback.onModification(result);
                        }
                    }
                }
            }).onError(new ErrorCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError() {
                    Map map = MultiCacheRequestManager.this.mTaskMap;
                    synchronized (map) {
                        MultiCacheRequestManager.this.mTaskMap.remove(key);
                    }
                }
            });
            this.mTaskMap.put(key, task);
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(K id) {
        Map<K, ApiTask<T>> map = this.mTaskMap;
        synchronized (map) {
            this.mCache.evict(id);
            this.mTaskMap.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<K, ApiTask<T>> map = this.mTaskMap;
        synchronized (map) {
            this.mCache.clear();
            this.mTaskMap.clear();
        }
    }

    private static class CacheApiTaskImpl<T>
    implements ApiTask<T> {
        private final T mResult;

        private CacheApiTaskImpl(T result) {
            this.mResult = result;
        }

        @Override
        public Result<T> await() {
            return new BaseApi.ResultImpl<T>(200, this.mResult);
        }

        @Override
        public Result<T> await(long timeoutMillis) {
            return new BaseApi.ResultImpl<T>(200, this.mResult);
        }

        @Override
        public ApiTask<T> addCallback(final ApiCallback<T> callback) {
            TaskUtils.MAIN_HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    callback.onResult(200, CacheApiTaskImpl.this.mResult);
                }
            });
            return this;
        }

        @Override
        public ApiTask<T> onResult(final ResultCallback<T> callback) {
            TaskUtils.MAIN_HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    callback.onResult(200, CacheApiTaskImpl.this.mResult);
                }
            });
            return this;
        }

        @Override
        public ApiTask<T> onError(ErrorCallback callback) {
            return this;
        }

        @Override
        public void cancel() {
        }
    }
}

