/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.util;

import android.support.annotation.NonNull;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorHelper {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE = 1;

    @NonNull
    public static ThreadPoolExecutor createOptimalThreadPoolExecutor(final String threadNamePrefix) {
        ThreadFactory factory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                return new Thread(runnable, threadNamePrefix + " #" + this.mCount.getAndIncrement());
            }
        };
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(128);
        return new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, workQueue, factory);
    }
}

