/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.connection.spec.https;

import com.github.wrdlbrnft.simplerest.connection.spec.ConnectionSpec;
import com.github.wrdlbrnft.simplerest.connection.spec.https.AbsHttpsConnectionSpec;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class HttpsClientAuthConnectionSpec
extends AbsHttpsConnectionSpec
implements ConnectionSpec {
    private final KeyStore mServerKeyStore;
    private final KeyStore mClientKeyStore;
    private final char[] mClientKeyStorePassword;

    public HttpsClientAuthConnectionSpec(KeyStore serverKeyStore, KeyStore clientKeyStore, char[] clientKeyStorePassword) {
        this.mServerKeyStore = serverKeyStore;
        this.mClientKeyStore = clientKeyStore;
        this.mClientKeyStorePassword = clientKeyStorePassword;
    }

    @Override
    protected KeyManager[] createKeyManagers() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
        keyManagerFactory.init(this.mClientKeyStore, this.mClientKeyStorePassword);
        return keyManagerFactory.getKeyManagers();
    }

    @Override
    protected TrustManager[] createTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        String trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
        trustManagerFactory.init(this.mServerKeyStore);
        return trustManagerFactory.getTrustManagers();
    }
}

