/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.requestmanager;

import com.github.wrdlbrnft.simplerest.callbacks.ApiCallback;
import com.github.wrdlbrnft.simplerest.callbacks.OnModificationCallback;
import com.github.wrdlbrnft.simplerest.taskrunners.ApiTaskRunner;
import com.github.wrdlbrnft.simplerest.tasks.ApiTask;
import com.github.wrdlbrnft.simplerest.tasks.Result;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class SingleCacheRequestManager<T> {
    private final AtomicReference<ApiTask<T>> mTaskReference = new AtomicReference<Object>(null);
    private final AtomicReference<T> mCache = new AtomicReference<Object>(null);
    private final ApiTaskRunner mTaskRunner;
    private final OnModificationCallback<T> mModificationCallback;

    public SingleCacheRequestManager(ApiTaskRunner taskRunner, OnModificationCallback<T> modificationCallback) {
        this.mTaskRunner = taskRunner;
        this.mModificationCallback = modificationCallback;
    }

    public ApiTask<T> perform(Callable<Result<T>> callable) {
        T cachedItem = this.mCache.get();
        if (cachedItem != null) {
            return this.mTaskRunner.cacheTask(cachedItem);
        }
        ApiTask<T> runningTask = this.mTaskReference.get();
        if (runningTask != null) {
            return runningTask;
        }
        ApiTask<T> task = this.mTaskRunner.queueTask(callable, new ApiCallback<T>(){

            @Override
            public void onResult(int statusCode, T item) {
                SingleCacheRequestManager.this.mTaskReference.set(null);
                if (item != null) {
                    SingleCacheRequestManager.this.mCache.set(item);
                    if (SingleCacheRequestManager.this.mModificationCallback != null) {
                        SingleCacheRequestManager.this.mModificationCallback.onModification(item);
                    }
                }
            }

            @Override
            public void onError() {
                SingleCacheRequestManager.this.mTaskReference.set(null);
            }
        });
        this.mTaskReference.set(task);
        return task;
    }

    public void invalidateCache() {
        this.mCache.set(null);
    }
}

