/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.glideloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GenericLoaderFactory;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.stream.StreamModelLoader;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.glideloader.extensions.BitmapExtensionKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/wordpress/aztec/glideloader/GlideVideoThumbnailLoader;", "Lorg/wordpress/aztec/Html$VideoThumbnailGetter;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "loadVideoThumbnail", "", "source", "", "callbacks", "Lorg/wordpress/aztec/Html$VideoThumbnailGetter$Callbacks;", "maxWidth", "", "minWidth", "ThumbnailLoader", "glide-loader_release"})
public final class GlideVideoThumbnailLoader
implements Html.VideoThumbnailGetter {
    private final Context context;

    public void loadVideoThumbnail(@NotNull String source, @NotNull Html.VideoThumbnailGetter.Callbacks callbacks, int maxWidth) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)callbacks, (String)"callbacks");
        this.loadVideoThumbnail(source, callbacks, maxWidth, 0);
    }

    public void loadVideoThumbnail(@NotNull String source, @NotNull Html.VideoThumbnailGetter.Callbacks callbacks, int maxWidth, int minWidth) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)callbacks, (String)"callbacks");
        Glide.with((Context)this.context).using((StreamModelLoader)new ThumbnailLoader(this.context)).load((Object)source).asBitmap().fitCenter().into((Target)new Target<Bitmap>(this, callbacks, minWidth, maxWidth){
            final /* synthetic */ GlideVideoThumbnailLoader this$0;
            final /* synthetic */ Html.VideoThumbnailGetter.Callbacks $callbacks;
            final /* synthetic */ int $minWidth;
            final /* synthetic */ int $maxWidth;

            public void onLoadStarted(@Nullable Drawable placeholder) {
                this.$callbacks.onThumbnailLoading(placeholder);
            }

            public void onLoadFailed(@Nullable Exception e, @Nullable Drawable errorDrawable) {
                this.$callbacks.onThumbnailFailed();
            }

            public void onResourceReady(@Nullable Bitmap resource, @Nullable GlideAnimation<? super Bitmap> glideAnimation) {
                if (resource != null && resource.getWidth() < this.$minWidth) {
                    this.$callbacks.onThumbnailLoaded((Drawable)new BitmapDrawable(GlideVideoThumbnailLoader.access$getContext$p(this.this$0).getResources(), BitmapExtensionKt.upscaleTo(resource, this.$minWidth)));
                    return;
                }
                Bitmap bitmap = resource;
                if (bitmap != null) {
                    bitmap.setDensity(160);
                }
                this.$callbacks.onThumbnailLoaded((Drawable)new BitmapDrawable(GlideVideoThumbnailLoader.access$getContext$p(this.this$0).getResources(), resource));
            }

            public void onLoadCleared(@Nullable Drawable placeholder) {
            }

            public void getSize(@Nullable SizeReadyCallback cb) {
                block0: {
                    SizeReadyCallback sizeReadyCallback = cb;
                    if (sizeReadyCallback == null) break block0;
                    sizeReadyCallback.onSizeReady(this.$maxWidth, this.$maxWidth);
                }
            }

            public void setRequest(@Nullable Request request) {
            }

            @Nullable
            public Request getRequest() {
                return null;
            }

            public void onStart() {
            }

            public void onStop() {
            }

            public void onDestroy() {
            }
            {
                this.this$0 = $outer;
                this.$callbacks = $captured_local_variable$1;
                this.$minWidth = $captured_local_variable$2;
                this.$maxWidth = $captured_local_variable$3;
            }
        });
    }

    public GlideVideoThumbnailLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public static final /* synthetic */ Context access$getContext$p(GlideVideoThumbnailLoader $this) {
        return $this.context;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/wordpress/aztec/glideloader/GlideVideoThumbnailLoader$ThumbnailLoader;", "Lcom/bumptech/glide/load/model/stream/StreamModelLoader;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "getResourceFetcher", "Lorg/wordpress/aztec/glideloader/GlideVideoThumbnailLoader$ThumbnailLoader$VideoThumbnailFetcher;", "src", "width", "", "height", "Factory", "VideoThumbnailFetcher", "glide-loader_release"})
    public static final class ThumbnailLoader
    implements StreamModelLoader<String> {
        @NotNull
        private final Context context;

        @NotNull
        public VideoThumbnailFetcher getResourceFetcher(@NotNull String src, int width, int height) {
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            return new VideoThumbnailFetcher(src, this.context);
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        public ThumbnailLoader(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/wordpress/aztec/glideloader/GlideVideoThumbnailLoader$ThumbnailLoader$Factory;", "Lcom/bumptech/glide/load/model/ModelLoaderFactory;", "", "Ljava/io/InputStream;", "()V", "build", "Lorg/wordpress/aztec/glideloader/GlideVideoThumbnailLoader$ThumbnailLoader;", "context", "Landroid/content/Context;", "factories", "Lcom/bumptech/glide/load/model/GenericLoaderFactory;", "teardown", "", "glide-loader_release"})
        public static final class Factory
        implements ModelLoaderFactory<String, InputStream> {
            @NotNull
            public ThumbnailLoader build(@NotNull Context context, @NotNull GenericLoaderFactory factories) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)factories, (String)"factories");
                return new ThumbnailLoader(context);
            }

            public void teardown() {
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/wordpress/aztec/glideloader/GlideVideoThumbnailLoader$ThumbnailLoader$VideoThumbnailFetcher;", "Lcom/bumptech/glide/load/data/DataFetcher;", "Ljava/io/InputStream;", "source", "", "context", "Landroid/content/Context;", "(Ljava/lang/String;Landroid/content/Context;)V", "cancelled", "", "getCancelled", "()Z", "setCancelled", "(Z)V", "getContext", "()Landroid/content/Context;", "getSource", "()Ljava/lang/String;", "stream", "getStream", "()Ljava/io/InputStream;", "setStream", "(Ljava/io/InputStream;)V", "cancel", "", "cleanup", "getId", "loadData", "priority", "Lcom/bumptech/glide/Priority;", "glide-loader_release"})
        public static final class VideoThumbnailFetcher
        implements DataFetcher<InputStream> {
            @Nullable
            private InputStream stream;
            private volatile boolean cancelled;
            @NotNull
            private final String source;
            @NotNull
            private final Context context;

            @Nullable
            public final InputStream getStream() {
                return this.stream;
            }

            public final void setStream(@Nullable InputStream inputStream) {
                this.stream = inputStream;
            }

            public final boolean getCancelled() {
                return this.cancelled;
            }

            public final void setCancelled(boolean bl) {
                this.cancelled = bl;
            }

            @NotNull
            public String getId() {
                return this.source;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public InputStream loadData(@NotNull Priority priority) {
                block16: {
                    Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
                    MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                    try {
                        byte[] byArray;
                        boolean isRemote;
                        Uri uri = Uri.parse((String)this.source);
                        Object object = uri;
                        boolean bl = object != null && (object = object.getScheme()) != null ? StringsKt.startsWith((String)object, (String)"http", (boolean)true) : (isRemote = false);
                        if (isRemote) {
                            retriever.setDataSource(this.source, MapsKt.emptyMap());
                        } else {
                            retriever.setDataSource(this.context, uri);
                        }
                        if (this.cancelled) {
                            InputStream inputStream = null;
                            return inputStream;
                        }
                        Bitmap picture = retriever.getFrameAtTime();
                        if (this.cancelled) {
                            InputStream inputStream = null;
                            return inputStream;
                        }
                        if (picture == null) break block16;
                        Closeable closeable = new ByteArrayOutputStream();
                        Throwable throwable = null;
                        try {
                            ByteArrayOutputStream bos = (ByteArrayOutputStream)closeable;
                            picture.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bos);
                            byArray = bos.toByteArray();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        byte[] bitmapData = byArray;
                        if (this.cancelled) {
                            closeable = null;
                            return closeable;
                        }
                        this.stream = new ByteArrayInputStream(bitmapData);
                        closeable = this.stream;
                        return closeable;
                    }
                    finally {
                        retriever.release();
                    }
                }
                return null;
            }

            public void cleanup() {
                Unit unit;
                Unit unit2;
                try {
                    Unit unit3;
                    InputStream inputStream = this.stream;
                    if (inputStream != null) {
                        inputStream.close();
                        unit3 = Unit.INSTANCE;
                    } else {
                        unit3 = null;
                    }
                    unit2 = unit3;
                }
                catch (IOException e) {
                    unit2 = Unit.INSTANCE;
                }
                if ((unit = unit2) == null) {
                    unit = Unit.INSTANCE;
                }
            }

            public void cancel() {
                this.cancelled = true;
            }

            @NotNull
            public final String getSource() {
                return this.source;
            }

            @NotNull
            public final Context getContext() {
                return this.context;
            }

            public VideoThumbnailFetcher(@NotNull String source, @NotNull Context context) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                this.source = source;
                this.context = context;
            }
        }
    }
}

