/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.util;

import android.text.Editable;
import android.text.Spannable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wordpress.android.util.AppLog;
import org.wordpress.aztec.AztecText;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/wordpress/aztec/util/AztecLog;", "", "()V", "Companion", "ExternalLogger", "aztec_release"})
public final class AztecLog {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/util/AztecLog$ExternalLogger;", "", "log", "", "message", "", "logException", "tr", "", "aztec_release"})
    public static interface ExternalLogger {
        public void log(@NotNull String var1);

        public void logException(@NotNull Throwable var1);

        public void logException(@NotNull Throwable var1, @NotNull String var2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/util/AztecLog$Companion;", "", "()V", "logContentDetails", "", "text", "Landroid/text/Spannable;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "aztec_release"})
    public static final class Companion {
        public final void logContentDetails(@NotNull AztecText aztecText) {
            Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
            AppLog.d((AppLog.T)AppLog.T.EDITOR, (String)"Below are the details of the content in the editor:");
            Editable editable = aztecText.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"aztecText.text");
            this.logContentDetails((Spannable)editable);
        }

        public final void logContentDetails(@NotNull Spannable text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            try {
                JSONObject logContentJSON = new JSONObject();
                logContentJSON.put("content", (Object)text.toString());
                logContentJSON.put("length", text.length());
                JSONArray spansJSON = new JSONArray();
                Object[] spans = text.getSpans(0, text.length(), Object.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
                Object[] $receiver$iv = spans;
                int n = $receiver$iv.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv;
                    Object it = element$iv = $receiver$iv[i];
                    JSONObject currenSpanJSON = new JSONObject();
                    currenSpanJSON.put("clazz", (Object)it.getClass().getName());
                    currenSpanJSON.put("start", text.getSpanStart(it));
                    currenSpanJSON.put("end", text.getSpanEnd(it));
                    currenSpanJSON.put("flags", text.getSpanFlags(it));
                    spansJSON.put((Object)currenSpanJSON);
                }
                logContentJSON.put("spans", (Object)spansJSON);
                AppLog.d((AppLog.T)AppLog.T.EDITOR, (String)logContentJSON.toString());
            }
            catch (JSONException e) {
                AppLog.e((AppLog.T)AppLog.T.EDITOR, (String)"Uhh ohh! There was an error logging the content of the Editor. This shouldnever happen.", (Throwable)e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

