/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextWatcher;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.spans.IParagraphFlagged;
import org.wordpress.aztec.util.SpanWrapper;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/wordpress/aztec/watchers/ParagraphCollapseRemover;", "Landroid/text/TextWatcher;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "(Lorg/wordpress/aztec/AztecText;)V", "aztecTextRef", "Ljava/lang/ref/WeakReference;", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "", "count", "after", "onTextChanged", "before", "Companion", "aztec_release"})
public final class ParagraphCollapseRemover
implements TextWatcher {
    private final WeakReference<AztecText> aztecTextRef;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        if (aztecText != null ? aztecText.isTextChangedListenerDisabled() : true) {
            return;
        }
        CharSequence charSequence = s.subSequence(start, start + count);
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        Spanned charsOld = (Spanned)charSequence;
        List<SpanWrapper<IParagraphFlagged>> paragraphs = SpanWrapper.Companion.getSpans((Spannable)s, start, start + count, IParagraphFlagged.class);
        if (paragraphs.isEmpty() && start + count >= s.length()) {
            return;
        }
        int firstNewlineBeyondChangeIndex = StringsKt.indexOf$default((CharSequence)((Object)s).toString(), (char)Constants.INSTANCE.getNEWLINE(), (int)(start + count), (boolean)false, (int)4, null);
        if (firstNewlineBeyondChangeIndex == -1) {
            firstNewlineBeyondChangeIndex = s.length();
        }
        String charsOldString = charsOld.toString();
        int lastNewlineIndex = charsOldString.length();
        while ((lastNewlineIndex = StringsKt.lastIndexOf$default((CharSequence)charsOldString, (char)Constants.INSTANCE.getNEWLINE(), (int)(lastNewlineIndex - 1), (boolean)false, (int)4, null)) != -1) {
            if (start + lastNewlineIndex + 2 <= s.length()) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                IParagraphFlagged[] paragraphsToCheck;
                Object postNewline;
                if (start + lastNewlineIndex + 1 < s.length()) {
                    CharSequence charSequence2 = s.subSequence(start + lastNewlineIndex + 1, start + lastNewlineIndex + 2);
                    if (charSequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
                    }
                    postNewline = (Spanned)charSequence2;
                    Object[] objectArray = postNewline.getSpans(0, 1, IParagraphFlagged.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"postNewline.getSpans<IPa\u2026graphFlagged::class.java)");
                    paragraphsToCheck = (IParagraphFlagged[])objectArray;
                } else {
                    Object[] objectArray = charsOld.getSpans(lastNewlineIndex + 1, lastNewlineIndex + 1, IParagraphFlagged.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"charsOld.getSpans<IParag\u2026graphFlagged::class.java)");
                    paragraphsToCheck = (IParagraphFlagged[])objectArray;
                }
                postNewline = SpanWrapper.Companion.getSpans((Spannable)s, paragraphsToCheck);
                Iterator iterator = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    SpanWrapper it = (SpanWrapper)element$iv$iv;
                    if (!(it.getStart() == start + lastNewlineIndex + 1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    SpanWrapper it = (SpanWrapper)element$iv;
                    if (it.getEnd() > firstNewlineBeyondChangeIndex + 1) continue;
                    it.remove();
                }
            }
            if (lastNewlineIndex > -1) continue;
        }
    }

    public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
    }

    public void afterTextChanged(@NotNull Editable s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
    }

    private ParagraphCollapseRemover(AztecText aztecText) {
        this.aztecTextRef = new WeakReference<AztecText>(aztecText);
    }

    public /* synthetic */ ParagraphCollapseRemover(@NotNull AztecText aztecText, DefaultConstructorMarker $constructor_marker) {
        this(aztecText);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/wordpress/aztec/watchers/ParagraphCollapseRemover$Companion;", "", "()V", "install", "", "text", "Lorg/wordpress/aztec/AztecText;", "aztec_release"})
    public static final class Companion {
        public final void install(@NotNull AztecText text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            text.addTextChangedListener(new ParagraphCollapseRemover(text, null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

