/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.ITextFormat;
import org.wordpress.aztec.R;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecHorizontalRuleSpan;
import org.wordpress.aztec.spans.AztecImageSpan;
import org.wordpress.aztec.spans.AztecMediaClickableSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecVideoSpan;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.watchers.EndOfBufferMarkerAdder;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ,\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u001c\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/wordpress/aztec/formatting/LineBlockFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "(Lorg/wordpress/aztec/AztecText;)V", "applyHorizontalRule", "", "containHeadingType", "", "textFormat", "Lorg/wordpress/aztec/ITextFormat;", "index", "", "containsHeading", "selStart", "selEnd", "insertImage", "drawable", "Landroid/graphics/drawable/Drawable;", "attributes", "Lorg/xml/sax/Attributes;", "onImageTappedListener", "Lorg/wordpress/aztec/AztecText$OnImageTappedListener;", "onMediaDeletedListener", "Lorg/wordpress/aztec/AztecText$OnMediaDeletedListener;", "insertMedia", "span", "Lorg/wordpress/aztec/spans/AztecMediaSpan;", "insertVideo", "onVideoTappedListener", "Lorg/wordpress/aztec/AztecText$OnVideoTappedListener;", "aztec_release"})
public final class LineBlockFormatter
extends AztecFormatter {
    /*
     * WARNING - void declaration
     */
    public final boolean containsHeading(@NotNull ITextFormat textFormat, int selStart, int selEnd) {
        boolean bl;
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            int n2 = lines.length;
            while (n < n2) {
                void i;
                block11: {
                    block12: {
                        int n3 = 0;
                        Iterable $receiver$iv = (Iterable)new IntRange(n3, (int)(i - true));
                        int sum$iv = 0;
                        Iterator iterator = $receiver$iv.iterator();
                        while (iterator.hasNext()) {
                            void it;
                            int element$iv;
                            int n4 = element$iv = ((IntIterator)iterator).nextInt();
                            int n5 = sum$iv;
                            int n6 = lines[it].length() + 1;
                            sum$iv = n5 + n6;
                        }
                        int lineStart = sum$iv;
                        int lineEnd = lineStart + lines[i].length();
                        if (lineStart >= lineEnd) break block11;
                        if (lineStart >= selStart && selEnd >= lineEnd || lineStart <= (sum$iv = selEnd) && lineEnd >= sum$iv) break block12;
                        sum$iv = selStart;
                        if (lineStart > sum$iv || lineEnd < sum$iv) break block11;
                    }
                    list.add((int)i);
                }
                ++i;
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!this.containHeadingType(textFormat, it)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containHeadingType(ITextFormat textFormat, int index) {
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= lines.length) {
            return false;
        }
        int n = 0;
        Iterable $receiver$iv = (Iterable)new IntRange(n, index - 1);
        int sum$iv = 0;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int element$iv;
            int n2 = element$iv = ((IntIterator)iterator).nextInt();
            int n3 = sum$iv;
            int n4 = lines[it].length() + 1;
            sum$iv = n3 + n4;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        int n5 = 0;
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        AztecHeadingSpan[] aztecHeadingSpanArray = spans;
        int n6 = aztecHeadingSpanArray.length;
        if (n5 < n6) {
            AztecHeadingSpan span = aztecHeadingSpanArray[n5];
            ITextFormat iTextFormat = textFormat;
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_1) {
                return span.getHeading() == AztecHeadingSpan.Heading.H1;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_2) {
                return span.getHeading() == AztecHeadingSpan.Heading.H2;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_3) {
                return span.getHeading() == AztecHeadingSpan.Heading.H3;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_4) {
                return span.getHeading() == AztecHeadingSpan.Heading.H4;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_5) {
                return span.getHeading() == AztecHeadingSpan.Heading.H5;
            }
            if (iTextFormat == AztecTextFormat.FORMAT_HEADING_6) {
                return span.getHeading() == AztecHeadingSpan.Heading.H6;
            }
            return false;
        }
        return false;
    }

    public final void applyHorizontalRule() {
        this.getEditor().removeInlineStylesFromRange(this.getSelectionStart(), this.getSelectionEnd());
        this.getEditor().removeBlockStylesFromRange(this.getSelectionStart(), this.getSelectionEnd(), true);
        int nestingLevel = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), this.getSelectionStart(), 0, 4, null);
        Context context = this.getEditor().getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"editor.context");
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getEditor().getContext(), (int)R.drawable.img_hr);
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026ext, R.drawable.img_hr)!!");
        AztecHorizontalRuleSpan span = new AztecHorizontalRuleSpan(context, drawable2, nestingLevel, new AztecAttributes(null, 1, null), this.getEditor());
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)Constants.INSTANCE.getMAGIC_STRING());
        builder.setSpan((Object)span, 0, 1, 33);
        int start = this.getSelectionStart();
        this.getEditableText().replace(start, this.getSelectionEnd(), (CharSequence)builder);
        int newSelectionPosition = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getEditableText()), (char)Constants.INSTANCE.getMAGIC_CHAR(), (int)start, (boolean)false, (int)4, null) + 1;
        this.getEditor().setSelection(newSelectionPosition);
    }

    public final void insertVideo(@Nullable Drawable drawable2, @NotNull Attributes attributes, @Nullable AztecText.OnVideoTappedListener onVideoTappedListener, @Nullable AztecText.OnMediaDeletedListener onMediaDeletedListener) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        int nestingLevel = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), this.getSelectionStart(), 0, 4, null);
        Context context = this.getEditor().getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"editor.context");
        AztecVideoSpan span = new AztecVideoSpan(context, drawable2, nestingLevel, new AztecAttributes(attributes), onVideoTappedListener, onMediaDeletedListener, this.getEditor());
        this.insertMedia(span);
    }

    public final void insertImage(@Nullable Drawable drawable2, @NotNull Attributes attributes, @Nullable AztecText.OnImageTappedListener onImageTappedListener, @Nullable AztecText.OnMediaDeletedListener onMediaDeletedListener) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        int nestingLevel = IAztecNestable.Companion.getNestingLevelAt$default(IAztecNestable.Companion, (Spanned)this.getEditableText(), this.getSelectionStart(), 0, 4, null);
        Context context = this.getEditor().getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"editor.context");
        AztecImageSpan span = new AztecImageSpan(context, drawable2, nestingLevel, new AztecAttributes(attributes), onImageTappedListener, onMediaDeletedListener, this.getEditor());
        this.insertMedia(span);
    }

    private final void insertMedia(AztecMediaSpan span) {
        this.getEditor().removeInlineStylesFromRange(this.getSelectionStart(), this.getSelectionEnd());
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)Constants.INSTANCE.getIMG_STRING());
        ssb.setSpan((Object)span, 0, 1, 33);
        ssb.setSpan((Object)new AztecMediaClickableSpan(span), 0, 1, 33);
        boolean isLastItem = this.getSelectionEnd() == EndOfBufferMarkerAdder.Companion.safeLength((TextView)this.getEditor());
        this.getEditableText().replace(this.getSelectionStart(), this.getSelectionEnd(), (CharSequence)ssb);
        int newSelection = isLastItem ? EndOfBufferMarkerAdder.Companion.safeLength((TextView)this.getEditor()) : (this.getSelectionEnd() < EndOfBufferMarkerAdder.Companion.safeLength((TextView)this.getEditor()) ? this.getSelectionEnd() + 1 : this.getSelectionEnd());
        this.getEditor().setSelection(newSelection);
        this.getEditor().setMediaAdded(true);
    }

    public LineBlockFormatter(@NotNull AztecText editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        super(editor);
    }
}

