/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.toolbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.text.TextUtilsCompat;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.Toast;
import android.widget.ToggleButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.android.util.AppLog;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.ITextFormat;
import org.wordpress.aztec.R;
import org.wordpress.aztec.plugins.IMediaToolbarButton;
import org.wordpress.aztec.plugins.IToolbarButton;
import org.wordpress.aztec.source.SourceViewEditText;
import org.wordpress.aztec.toolbar.IAztecToolbar;
import org.wordpress.aztec.toolbar.IAztecToolbarClickListener;
import org.wordpress.aztec.toolbar.IToolbarAction;
import org.wordpress.aztec.toolbar.RippleToggleButton;
import org.wordpress.aztec.toolbar.ToolbarAction;
import org.wordpress.aztec.toolbar.ToolbarActionType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000206H\u0016J\b\u0010<\u001a\u00020:H\u0002J\b\u0010=\u001a\u00020:H\u0002J\u000e\u0010>\u001a\u00020:2\u0006\u0010?\u001a\u00020\u001fJ\u000e\u0010@\u001a\u00020:2\u0006\u0010?\u001a\u00020\u001fJ\b\u0010A\u001a\u0004\u0018\u00010\u001cJ\b\u0010B\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020D05H\u0002J\b\u0010E\u001a\u0004\u0018\u00010FJ\b\u0010G\u001a\u0004\u0018\u00010FJ\u0006\u0010H\u001a\u00020:J\u0014\u0010I\u001a\u00020:2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020D05J\u0016\u0010K\u001a\u00020:2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020F05H\u0002J\b\u0010M\u001a\u00020:H\u0002J\u0018\u0010M\u001a\u00020:2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0002J\u0012\u0010P\u001a\u00020:2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010Q\u001a\u00020\u001fH\u0002J\u0006\u0010!\u001a\u00020\u001fJ\u0018\u0010R\u001a\u00020\u001f2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020UH\u0016J\u0012\u0010V\u001a\u00020\u001f2\b\u0010W\u001a\u0004\u0018\u00010XH\u0016J\u0012\u0010Y\u001a\u00020:2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0014J\b\u0010\\\u001a\u00020[H\u0014J\u0010\u0010]\u001a\u00020:2\u0006\u0010^\u001a\u00020DH\u0002J\u0006\u0010_\u001a\u00020:J\u0016\u0010`\u001a\u00020:2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020F05H\u0002J\u0016\u0010b\u001a\u00020:2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020F05H\u0002J\b\u0010c\u001a\u00020:H\u0002J\b\u0010d\u001a\u00020:H\u0002J\b\u0010e\u001a\u00020:H\u0002J\u001a\u0010f\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u00172\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u000e\u0010g\u001a\u00020:2\u0006\u0010h\u001a\u00020\u001fJ\u0010\u0010i\u001a\u00020:2\u0006\u0010j\u001a\u000200H\u0002J\u0010\u0010k\u001a\u00020:2\u0006\u0010j\u001a\u000200H\u0002J\u0010\u0010l\u001a\u00020:2\u0006\u0010m\u001a\u00020\u000eH\u0016J\b\u0010n\u001a\u00020:H\u0002J\b\u0010o\u001a\u00020:H\u0002J\b\u0010p\u001a\u00020:H\u0002J\b\u0010q\u001a\u00020:H\u0003J\b\u0010r\u001a\u00020:H\u0002J\u0006\u0010s\u001a\u00020:J\u001a\u0010t\u001a\u00020:2\b\u0010u\u001a\u0004\u0018\u0001002\u0006\u0010v\u001a\u00020\u001fH\u0002J\u001a\u0010w\u001a\u00020:2\b\u0010u\u001a\u0004\u0018\u0001002\u0006\u0010x\u001a\u00020\u001fH\u0002J\b\u0010y\u001a\u00020:H\u0016J\u0010\u0010z\u001a\u00020:2\u0006\u0010{\u001a\u00020\u001fH\u0002J\u0018\u0010|\u001a\u00020:2\u0006\u0010}\u001a\u00020\u000b2\u0006\u0010~\u001a\u00020\u001fH\u0002J\b\u0010\u007f\u001a\u00020:H\u0016J\u001c\u0010\u0080\u0001\u001a\u00020:2\u0007\u0010\u0081\u0001\u001a\u00020F2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\u001c\u0010\u0084\u0001\u001a\u00020:2\u0007\u0010\u0081\u0001\u001a\u00020F2\b\u0010\u0085\u0001\u001a\u00030\u0083\u0001H\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020605X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Lorg/wordpress/aztec/toolbar/AztecToolbar;", "Landroid/widget/FrameLayout;", "Lorg/wordpress/aztec/toolbar/IAztecToolbar;", "Landroid/widget/PopupMenu$OnMenuItemClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "aztecToolbarListener", "Lorg/wordpress/aztec/toolbar/IAztecToolbarClickListener;", "buttonEllipsisCollapsed", "Lorg/wordpress/aztec/toolbar/RippleToggleButton;", "buttonEllipsisExpanded", "buttonMediaCollapsed", "buttonMediaExpanded", "dialogShortcuts", "Landroid/support/v7/app/AlertDialog;", "editor", "Lorg/wordpress/aztec/AztecText;", "ellipsisSpinLeft", "Landroid/view/animation/Animation;", "ellipsisSpinRight", "headingMenu", "Landroid/widget/PopupMenu;", "htmlButton", "isAdvanced", "", "isExpanded", "isMediaModeEnabled", "isMediaToolbarAvailable", "isMediaToolbarVisible", "layoutExpanded", "Landroid/widget/LinearLayout;", "layoutExpandedTranslateInEnd", "layoutExpandedTranslateOutStart", "layoutMediaTranslateInEnd", "layoutMediaTranslateInStart", "layoutMediaTranslateOutEnd", "layoutMediaTranslateOutStart", "listMenu", "mediaButtonSpinLeft", "mediaButtonSpinRight", "mediaToolbar", "Landroid/view/View;", "sourceEditor", "Lorg/wordpress/aztec/source/SourceViewEditText;", "stylingToolbar", "toolbarButtonPlugins", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/plugins/IToolbarButton;", "toolbarScrolView", "Landroid/widget/HorizontalScrollView;", "addButton", "", "buttonPlugin", "animateToolbarCollapse", "animateToolbarExpand", "enableFormatButtons", "isEnabled", "enableMediaMode", "getHeadingMenu", "getListMenu", "getSelectedActions", "Lorg/wordpress/aztec/toolbar/IToolbarAction;", "getSelectedHeadingMenuItem", "Lorg/wordpress/aztec/ITextFormat;", "getSelectedListMenuItem", "hideMediaToolbar", "highlightActionButtons", "toolbarActions", "highlightAlignButtons", "appliedStyles", "highlightAppliedStyles", "selStart", "selEnd", "initView", "isEditorAttached", "onKeyUp", "keyCode", "event", "Landroid/view/KeyEvent;", "onMenuItemClick", "item", "Landroid/view/MenuItem;", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onToolbarAction", "action", "scrollToBeginingOfToolbar", "selectHeadingMenuItem", "textFormats", "selectListMenuItem", "setAdvancedState", "setAnimations", "setButtonViews", "setEditor", "setExpanded", "expanded", "setHeadingMenu", "view", "setListMenu", "setToolbarListener", "listener", "setupMediaToolbar", "setupMediaToolbarAnimations", "showCollapsedToolbar", "showDialogShortcuts", "showExpandedToolbar", "showMediaToolbar", "toggleButton", "button", "checked", "toggleButtonState", "enabled", "toggleEditorMode", "toggleHtmlMode", "isHtmlMode", "toggleListMenuSelection", "listMenuItemId", "isChecked", "toggleMediaToolbar", "updateHeadingMenuItem", "textFormat", "headingButton", "Landroid/widget/ToggleButton;", "updateListMenuItem", "listButton", "aztec_release"})
public final class AztecToolbar
extends FrameLayout
implements IAztecToolbar,
PopupMenu.OnMenuItemClickListener {
    private IAztecToolbarClickListener aztecToolbarListener;
    private AztecText editor;
    private PopupMenu headingMenu;
    private PopupMenu listMenu;
    private SourceViewEditText sourceEditor;
    private AlertDialog dialogShortcuts;
    private boolean isAdvanced;
    private boolean isMediaToolbarAvailable;
    private boolean isExpanded;
    private boolean isMediaToolbarVisible;
    private boolean isMediaModeEnabled;
    private HorizontalScrollView toolbarScrolView;
    private RippleToggleButton buttonEllipsisCollapsed;
    private RippleToggleButton buttonEllipsisExpanded;
    private Animation layoutExpandedTranslateInEnd;
    private Animation layoutExpandedTranslateOutStart;
    private RippleToggleButton htmlButton;
    private RippleToggleButton buttonMediaCollapsed;
    private RippleToggleButton buttonMediaExpanded;
    private Animation layoutMediaTranslateInEnd;
    private Animation layoutMediaTranslateOutStart;
    private Animation layoutMediaTranslateOutEnd;
    private Animation layoutMediaTranslateInStart;
    private Animation ellipsisSpinLeft;
    private Animation ellipsisSpinRight;
    private Animation mediaButtonSpinLeft;
    private Animation mediaButtonSpinRight;
    private LinearLayout layoutExpanded;
    private View mediaToolbar;
    private View stylingToolbar;
    private ArrayList<IToolbarButton> toolbarButtonPlugins;

    @Override
    public void setToolbarListener(@NotNull IAztecToolbarClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.aztecToolbarListener = listener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyUp(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (keyCode) {
            case 8: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_1, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_1);
                return true;
            }
            case 9: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_2, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_2);
                return true;
            }
            case 10: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_3, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_3);
                return true;
            }
            case 11: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_4, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_4);
                return true;
            }
            case 12: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_5, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_5);
                return true;
            }
            case 13: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_6, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_6);
                return true;
            }
            case 14: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_PARAGRAPH, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_PARAGRAPH);
                return true;
            }
            case 15: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_PREFORMAT, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_PREFORMAT);
                return true;
            }
            case 30: {
                if (!event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_BOLD, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.BOLD.getButtonId())).performClick();
                return true;
            }
            case 32: {
                if (!event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_STRIKETHROUGH, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.STRIKETHROUGH.getButtonId())).performClick();
                return true;
            }
            case 36: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                this.showDialogShortcuts();
                return true;
            }
            case 37: {
                if (!event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_ITALIC, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.ITALIC.getButtonId())).performClick();
                return true;
            }
            case 39: {
                if (!event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_LINK, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.LINK.getButtonId())).performClick();
                return true;
            }
            case 41: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                if (this.aztecToolbarListener != null) {
                    IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                    if (iAztecToolbarClickListener == null) {
                        Intrinsics.throwNpe();
                    }
                    if (iAztecToolbarClickListener.onToolbarMediaButtonClicked()) return true;
                }
                ToolbarAction mediaAction = this.isMediaToolbarVisible ? ToolbarAction.ADD_MEDIA_EXPAND : ToolbarAction.ADD_MEDIA_COLLAPSE;
                ((ToggleButton)this.findViewById(mediaAction.getButtonId())).performClick();
                return true;
            }
            case 43: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_ORDERED_LIST, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_ORDERED_LIST);
                return true;
            }
            case 45: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_QUOTE, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.QUOTE.getButtonId())).performClick();
                return true;
            }
            case 49: {
                if (event.isAltPressed() && event.isCtrlPressed()) {
                    IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                    if (iAztecToolbarClickListener != null) {
                        iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_UNORDERED_LIST, true);
                    }
                    AztecText aztecText = this.editor;
                    if (aztecText == null) return true;
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_UNORDERED_LIST);
                    return true;
                }
                if (!event.isCtrlPressed()) return false;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_UNDERLINE, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.UNDERLINE.getButtonId())).performClick();
                return true;
            }
            case 52: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) return false;
                return true;
            }
            case 53: {
                if (!event.isCtrlPressed()) return false;
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.redo();
                return true;
            }
            case 54: {
                if (!event.isCtrlPressed()) return false;
                AztecText aztecText = this.editor;
                if (aztecText == null) return true;
                aztecText.undo();
                return true;
            }
            default: {
                Iterable $receiver$iv = this.toolbarButtonPlugins;
                for (Object element$iv : $receiver$iv) {
                    IToolbarButton it = (IToolbarButton)element$iv;
                    if (!it.matchesKeyShortcut(keyCode, event)) continue;
                    IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                    if (iAztecToolbarClickListener != null) {
                        iAztecToolbarClickListener.onToolbarFormatButtonClicked(it.getAction().getTextFormat(), true);
                    }
                    it.toggle();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onMenuItemClick(@Nullable MenuItem item) {
        Integer n;
        MenuItem menuItem = item;
        boolean checked = menuItem != null && !menuItem.isChecked();
        MenuItem menuItem2 = item;
        if (menuItem2 != null) {
            menuItem2.setChecked(checked);
        }
        ToggleButton headingButton = (ToggleButton)this.findViewById(ToolbarAction.HEADING.getButtonId());
        MenuItem menuItem3 = item;
        Integer n2 = n = menuItem3 != null ? Integer.valueOf(menuItem3.getItemId()) : null;
        int n3 = R.id.paragraph;
        if (n2 != null && n2 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_PARAGRAPH, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_PARAGRAPH);
            }
            ITextFormat iTextFormat = AztecTextFormat.FORMAT_PARAGRAPH;
            ToggleButton toggleButton = headingButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"headingButton");
            this.updateHeadingMenuItem(iTextFormat, toggleButton);
            return true;
        }
        Integer n4 = n;
        n3 = R.id.heading_1;
        if (n4 != null && n4 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_1, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_1);
            }
            ITextFormat iTextFormat = AztecTextFormat.FORMAT_HEADING_1;
            ToggleButton toggleButton = headingButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"headingButton");
            this.updateHeadingMenuItem(iTextFormat, toggleButton);
            return true;
        }
        Integer n5 = n;
        n3 = R.id.heading_2;
        if (n5 != null && n5 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_2, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_2);
            }
            ITextFormat iTextFormat = AztecTextFormat.FORMAT_HEADING_2;
            ToggleButton toggleButton = headingButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"headingButton");
            this.updateHeadingMenuItem(iTextFormat, toggleButton);
            return true;
        }
        Integer n6 = n;
        n3 = R.id.heading_3;
        if (n6 != null && n6 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_3, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_3);
            }
            ITextFormat iTextFormat = AztecTextFormat.FORMAT_HEADING_3;
            ToggleButton toggleButton = headingButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"headingButton");
            this.updateHeadingMenuItem(iTextFormat, toggleButton);
            return true;
        }
        Integer n7 = n;
        n3 = R.id.heading_4;
        if (n7 != null && n7 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_4, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_4);
            }
            ITextFormat iTextFormat = AztecTextFormat.FORMAT_HEADING_4;
            ToggleButton toggleButton = headingButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"headingButton");
            this.updateHeadingMenuItem(iTextFormat, toggleButton);
            return true;
        }
        Integer n8 = n;
        n3 = R.id.heading_5;
        if (n8 != null && n8 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_5, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_5);
            }
            ITextFormat iTextFormat = AztecTextFormat.FORMAT_HEADING_5;
            ToggleButton toggleButton = headingButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"headingButton");
            this.updateHeadingMenuItem(iTextFormat, toggleButton);
            return true;
        }
        Integer n9 = n;
        n3 = R.id.heading_6;
        if (n9 != null && n9 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_6, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_6);
            }
            ITextFormat iTextFormat = AztecTextFormat.FORMAT_HEADING_6;
            ToggleButton toggleButton = headingButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"headingButton");
            this.updateHeadingMenuItem(iTextFormat, toggleButton);
            return true;
        }
        Integer n10 = n;
        n3 = R.id.list_ordered;
        if (n10 != null && n10 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_ORDERED_LIST, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_ORDERED_LIST);
            }
            this.toggleListMenuSelection(item.getItemId(), checked);
            AztecText aztecText2 = this.editor;
            if (aztecText2 != null) {
                AztecText aztecText3;
                AztecText it = aztecText3 = aztecText2;
                AztecText aztecText4 = this.editor;
                if (aztecText4 == null) {
                    Intrinsics.throwNpe();
                }
                int n11 = aztecText4.getSelectionStart();
                AztecText aztecText5 = this.editor;
                if (aztecText5 == null) {
                    Intrinsics.throwNpe();
                }
                this.highlightAppliedStyles(n11, aztecText5.getSelectionEnd());
            }
            return true;
        }
        Integer n12 = n;
        n3 = R.id.list_unordered;
        if (n12 != null && n12 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_UNORDERED_LIST, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_UNORDERED_LIST);
            }
            this.toggleListMenuSelection(item.getItemId(), checked);
            AztecText aztecText6 = this.editor;
            if (aztecText6 != null) {
                AztecText aztecText7;
                AztecText it = aztecText7 = aztecText6;
                AztecText aztecText8 = this.editor;
                if (aztecText8 == null) {
                    Intrinsics.throwNpe();
                }
                int n13 = aztecText8.getSelectionStart();
                AztecText aztecText9 = this.editor;
                if (aztecText9 == null) {
                    Intrinsics.throwNpe();
                }
                this.highlightAppliedStyles(n13, aztecText9.getSelectionEnd());
            }
            return true;
        }
        return false;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable parcelable = state;
        if (parcelable == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.source.SourceViewEditText.SavedState");
        }
        SourceViewEditText.SavedState savedState = (SourceViewEditText.SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        Bundle restoredState = savedState.getState();
        this.toggleHtmlMode(restoredState.getBoolean("isSourceVisible"));
        this.enableMediaMode(restoredState.getBoolean("isMediaMode"));
        this.isExpanded = restoredState.getBoolean("isExpanded");
        this.isMediaToolbarVisible = restoredState.getBoolean("isMediaToolbarVisible");
        this.setAdvancedState();
        this.setupMediaToolbar();
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        SourceViewEditText.SavedState savedState = new SourceViewEditText.SavedState(parcelable);
        Bundle bundle = new Bundle();
        SourceViewEditText sourceViewEditText = this.sourceEditor;
        bundle.putBoolean("isSourceVisible", sourceViewEditText != null && sourceViewEditText.getVisibility() == 0);
        bundle.putBoolean("isMediaMode", this.isMediaModeEnabled);
        bundle.putBoolean("isExpanded", this.isExpanded);
        bundle.putBoolean("isMediaToolbarVisible", this.isMediaToolbarVisible);
        savedState.setState(bundle);
        return (Parcelable)savedState;
    }

    private final boolean isEditorAttached() {
        return this.editor != null && this.editor instanceof AztecText;
    }

    @Override
    public void setEditor(@NotNull AztecText editor, @Nullable SourceViewEditText sourceEditor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.sourceEditor = sourceEditor;
        AztecText aztecText = this.editor = editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        aztecText.setOnSelectionChangedListener(new AztecText.OnSelectionChangedListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onSelectionChanged(int selStart, int selEnd) {
                AztecToolbar.access$highlightAppliedStyles(this.this$0, selStart, selEnd);
            }
            {
                this.this$0 = $outer;
            }
        });
        if (sourceEditor == null) {
            RippleToggleButton rippleToggleButton = this.htmlButton;
            if (rippleToggleButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"htmlButton");
            }
            rippleToggleButton.setVisibility(8);
        } else {
            RippleToggleButton rippleToggleButton = this.htmlButton;
            if (rippleToggleButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"htmlButton");
            }
            rippleToggleButton.setVisibility(0);
        }
    }

    private final void initView(AttributeSet attrs) {
        TypedArray styles = this.getContext().obtainStyledAttributes(attrs, R.styleable.AztecToolbar, 0, R.style.AztecToolbarStyle);
        this.isAdvanced = styles.getBoolean(R.styleable.AztecToolbar_advanced, false);
        this.isMediaToolbarAvailable = styles.getBoolean(R.styleable.AztecToolbar_mediaToolbarAvailable, true);
        styles.recycle();
        int layout2 = this.isAdvanced ? R.layout.aztec_format_bar_advanced : R.layout.aztec_format_bar_basic;
        View.inflate((Context)this.getContext(), (int)layout2, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.format_bar_button_scroll);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.format_bar_button_scroll)");
        this.toolbarScrolView = (HorizontalScrollView)view;
        View view2 = this.findViewById(R.id.format_bar_button_html);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.format_bar_button_html)");
        this.htmlButton = (RippleToggleButton)view2;
        this.setAdvancedState();
        this.setupMediaToolbar();
        for (ToolbarAction toolbarAction : ToolbarAction.values()) {
            ToggleButton button;
            ToggleButton toggleButton = button = (ToggleButton)this.findViewById(toolbarAction.getButtonId());
            if (toggleButton != null) {
                toggleButton.setOnClickListener(new View.OnClickListener(this, toolbarAction){
                    final /* synthetic */ AztecToolbar this$0;
                    final /* synthetic */ ToolbarAction $toolbarAction;

                    public final void onClick(View it) {
                        AztecToolbar.access$onToolbarAction(this.this$0, this.$toolbarAction);
                    }
                    {
                        this.this$0 = aztecToolbar;
                        this.$toolbarAction = toolbarAction;
                    }
                });
            }
            if (Intrinsics.areEqual((Object)toolbarAction, (Object)ToolbarAction.HEADING)) {
                View view3 = this.findViewById(toolbarAction.getButtonId());
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(toolbarAction.buttonId)");
                this.setHeadingMenu(view3);
            }
            if (!Intrinsics.areEqual((Object)toolbarAction, (Object)ToolbarAction.LIST)) continue;
            View view4 = this.findViewById(toolbarAction.getButtonId());
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(toolbarAction.buttonId)");
            this.setListMenu(view4);
        }
    }

    @Override
    public void addButton(@NotNull IToolbarButton buttonPlugin) {
        LinearLayout pluginContainer;
        Intrinsics.checkParameterIsNotNull((Object)buttonPlugin, (String)"buttonPlugin");
        LinearLayout linearLayout = pluginContainer = buttonPlugin instanceof IMediaToolbarButton ? (LinearLayout)this.findViewById(R.id.media_toolbar) : (LinearLayout)this.findViewById(R.id.plugin_buttons);
        Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"pluginContainer");
        buttonPlugin.inflateButton((ViewGroup)linearLayout);
        this.toolbarButtonPlugins.add(buttonPlugin);
        ToggleButton button = (ToggleButton)this.findViewById(buttonPlugin.getAction().getButtonId());
        button.setOnClickListener(new View.OnClickListener(buttonPlugin){
            final /* synthetic */ IToolbarButton $buttonPlugin;

            public final void onClick(@NotNull View $noName_0) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                this.$buttonPlugin.toggle();
            }
            {
                this.$buttonPlugin = iToolbarButton;
            }
        });
    }

    public final void highlightActionButtons(@NotNull ArrayList<IToolbarAction> toolbarActions) {
        Intrinsics.checkParameterIsNotNull(toolbarActions, (String)"toolbarActions");
        for (Object element$iv : (Object[])ToolbarAction.values()) {
            ToolbarAction action = (ToolbarAction)element$iv;
            if (toolbarActions.contains(action)) {
                this.toggleButton(this.findViewById(action.getButtonId()), true);
                continue;
            }
            this.toggleButton(this.findViewById(action.getButtonId()), false);
        }
    }

    private final ArrayList<IToolbarAction> getSelectedActions() {
        ArrayList<IToolbarAction> actions = new ArrayList<IToolbarAction>();
        for (ToolbarAction action : ToolbarAction.values()) {
            ToggleButton view;
            if (!(Intrinsics.areEqual((Object)action, (Object)ToolbarAction.ELLIPSIS_COLLAPSE) ^ true) || !(Intrinsics.areEqual((Object)action, (Object)ToolbarAction.ELLIPSIS_EXPAND) ^ true)) continue;
            ToggleButton toggleButton = view = (ToggleButton)this.findViewById(action.getButtonId());
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"view");
            if (!toggleButton.isChecked()) continue;
            actions.add(action);
        }
        return actions;
    }

    private final void toggleButton(View button, boolean checked) {
        if (button != null && button instanceof ToggleButton) {
            ((ToggleButton)button).setChecked(checked);
        }
    }

    private final void toggleButtonState(View button, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    private final void highlightAppliedStyles(int selStart, int selEnd) {
        if (!this.isEditorAttached()) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<ITextFormat> appliedStyles = aztecText.getAppliedStyles(selStart, selEnd);
        this.highlightActionButtons(ToolbarAction.Companion.getToolbarActionsForStyles(appliedStyles));
        this.selectHeadingMenuItem(appliedStyles);
        this.selectListMenuItem(appliedStyles);
        this.highlightAlignButtons(appliedStyles);
    }

    private final void highlightAlignButtons(ArrayList<ITextFormat> appliedStyles) {
        if (!appliedStyles.contains(AztecTextFormat.FORMAT_ALIGN_LEFT)) {
            this.toggleButton(this.findViewById(ToolbarAction.ALIGN_LEFT.getButtonId()), false);
        }
        if (!appliedStyles.contains(AztecTextFormat.FORMAT_ALIGN_CENTER)) {
            this.toggleButton(this.findViewById(ToolbarAction.ALIGN_CENTER.getButtonId()), false);
        }
        if (!appliedStyles.contains(AztecTextFormat.FORMAT_ALIGN_RIGHT)) {
            this.toggleButton(this.findViewById(ToolbarAction.ALIGN_RIGHT.getButtonId()), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onToolbarAction(IToolbarAction action) {
        block40: {
            IToolbarAction iToolbarAction;
            block38: {
                block39: {
                    if (!this.isEditorAttached()) {
                        return;
                    }
                    AztecText aztecText = this.editor;
                    if (aztecText == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!aztecText.isTextSelected() && Intrinsics.areEqual((Object)((Object)action.getActionType()), (Object)((Object)ToolbarActionType.INLINE_STYLE))) {
                        void $receiver$iv$iv;
                        ArrayList<IToolbarAction> actions = this.getSelectedActions();
                        ArrayList<ITextFormat> textFormats = new ArrayList<ITextFormat>();
                        Iterable $receiver$iv = actions;
                        Iterable iterable = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList();
                        for (Object element$iv$iv : $receiver$iv$iv) {
                            IToolbarAction it = (IToolbarAction)element$iv$iv;
                            if (!it.isStylingAction()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        for (Object element$iv : $receiver$iv) {
                            IToolbarAction it = (IToolbarAction)element$iv;
                            textFormats.add(it.getTextFormat());
                        }
                        if (this.getSelectedHeadingMenuItem() != null) {
                            ITextFormat iTextFormat = this.getSelectedHeadingMenuItem();
                            if (iTextFormat == null) {
                                Intrinsics.throwNpe();
                            }
                            textFormats.add(iTextFormat);
                        }
                        if (this.getSelectedListMenuItem() != null) {
                            ITextFormat iTextFormat = this.getSelectedListMenuItem();
                            if (iTextFormat == null) {
                                Intrinsics.throwNpe();
                            }
                            textFormats.add(iTextFormat);
                        }
                        IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                        if (iAztecToolbarClickListener != null) {
                            iAztecToolbarClickListener.onToolbarFormatButtonClicked(action.getTextFormat(), false);
                        }
                        AztecText aztecText2 = this.editor;
                        if (aztecText2 == null) {
                            Intrinsics.throwNpe();
                        }
                        aztecText2.setSelectedStyles(textFormats);
                        return;
                    }
                    if (action.isStylingAction() && Intrinsics.areEqual((Object)action, (Object)ToolbarAction.HEADING) ^ true && Intrinsics.areEqual((Object)action, (Object)ToolbarAction.LIST) ^ true) {
                        IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                        if (iAztecToolbarClickListener != null) {
                            iAztecToolbarClickListener.onToolbarFormatButtonClicked(action.getTextFormat(), false);
                        }
                        AztecText aztecText3 = this.editor;
                        if (aztecText3 == null) {
                            Intrinsics.throwNpe();
                        }
                        aztecText3.toggleFormatting(action.getTextFormat());
                        Unit returnValue = Unit.INSTANCE;
                        this.highlightAppliedStyles();
                        return;
                    }
                    iToolbarAction = action;
                    if (!Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.ADD_MEDIA_COLLAPSE) && !Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.ADD_MEDIA_EXPAND)) break block38;
                    if (this.aztecToolbarListener == null) break block39;
                    IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                    if (iAztecToolbarClickListener == null) {
                        Intrinsics.throwNpe();
                    }
                    if (iAztecToolbarClickListener.onToolbarMediaButtonClicked()) break block40;
                }
                this.toggleMediaToolbar();
                break block40;
            }
            if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.HEADING)) {
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarHeadingButtonClicked();
                }
                PopupMenu popupMenu = this.headingMenu;
                if (popupMenu != null) {
                    popupMenu.show();
                }
            } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.LIST)) {
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarListButtonClicked();
                }
                PopupMenu popupMenu = this.listMenu;
                if (popupMenu != null) {
                    popupMenu.show();
                }
            } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.LINK)) {
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_LINK, false);
                }
                AztecText aztecText = this.editor;
                if (aztecText == null) {
                    Intrinsics.throwNpe();
                }
                AztecText.showLinkDialog$default(aztecText, null, null, 3, null);
            } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.HTML)) {
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarHtmlButtonClicked();
                }
            } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.ELLIPSIS_COLLAPSE)) {
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarCollapseButtonClicked();
                }
                this.animateToolbarCollapse();
            } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.ELLIPSIS_EXPAND)) {
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarExpandButtonClicked();
                }
                this.animateToolbarExpand();
            } else {
                Toast.makeText((Context)this.getContext(), (CharSequence)"Unsupported action", (int)0).show();
            }
        }
    }

    private final void highlightAppliedStyles() {
        block2: {
            AztecText aztecText;
            AztecText aztecText2 = this.editor;
            if (aztecText2 == null) break block2;
            AztecText it = aztecText = aztecText2;
            AztecText aztecText3 = this.editor;
            if (aztecText3 == null) {
                Intrinsics.throwNpe();
            }
            int n = aztecText3.getSelectionStart();
            AztecText aztecText4 = this.editor;
            if (aztecText4 == null) {
                Intrinsics.throwNpe();
            }
            this.highlightAppliedStyles(n, aztecText4.getSelectionEnd());
        }
    }

    @Override
    public void toggleEditorMode() {
        if (this.sourceEditor == null) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        if (aztecText.getVisibility() == 0) {
            SourceViewEditText sourceViewEditText = this.sourceEditor;
            if (sourceViewEditText == null) {
                Intrinsics.throwNpe();
            }
            AztecText aztecText2 = this.editor;
            if (aztecText2 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText.displayStyledAndFormattedHtml(aztecText2.toPlainHtml(true));
            AztecText aztecText3 = this.editor;
            if (aztecText3 == null) {
                Intrinsics.throwNpe();
            }
            aztecText3.setVisibility(8);
            SourceViewEditText sourceViewEditText2 = this.sourceEditor;
            if (sourceViewEditText2 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText2.setVisibility(0);
            this.toggleHtmlMode(true);
        } else {
            AztecText aztecText4 = this.editor;
            if (aztecText4 == null) {
                Intrinsics.throwNpe();
            }
            SourceViewEditText sourceViewEditText = this.sourceEditor;
            if (sourceViewEditText == null) {
                Intrinsics.throwNpe();
            }
            aztecText4.fromHtml(sourceViewEditText.getPureHtml(true));
            AztecText aztecText5 = this.editor;
            if (aztecText5 == null) {
                Intrinsics.throwNpe();
            }
            aztecText5.setVisibility(0);
            SourceViewEditText sourceViewEditText3 = this.sourceEditor;
            if (sourceViewEditText3 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText3.setVisibility(8);
            this.toggleHtmlMode(false);
        }
    }

    @Nullable
    public final PopupMenu getHeadingMenu() {
        return this.headingMenu;
    }

    @Nullable
    public final PopupMenu getListMenu() {
        return this.listMenu;
    }

    @Nullable
    public final ITextFormat getSelectedHeadingMenuItem() {
        PopupMenu popupMenu = this.headingMenu;
        Boolean bl = popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.paragraph)) != null ? Boolean.valueOf(popupMenu.isChecked()) : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            return AztecTextFormat.FORMAT_PARAGRAPH;
        }
        PopupMenu popupMenu2 = this.headingMenu;
        Boolean bl2 = popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.findItem(R.id.heading_1)) != null ? Boolean.valueOf(popupMenu2.isChecked()) : null;
        if (bl2 == null) {
            Intrinsics.throwNpe();
        }
        if (bl2.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_1;
        }
        PopupMenu popupMenu3 = this.headingMenu;
        Boolean bl3 = popupMenu3 != null && (popupMenu3 = popupMenu3.getMenu()) != null && (popupMenu3 = popupMenu3.findItem(R.id.heading_2)) != null ? Boolean.valueOf(popupMenu3.isChecked()) : null;
        if (bl3 == null) {
            Intrinsics.throwNpe();
        }
        if (bl3.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_2;
        }
        PopupMenu popupMenu4 = this.headingMenu;
        Boolean bl4 = popupMenu4 != null && (popupMenu4 = popupMenu4.getMenu()) != null && (popupMenu4 = popupMenu4.findItem(R.id.heading_3)) != null ? Boolean.valueOf(popupMenu4.isChecked()) : null;
        if (bl4 == null) {
            Intrinsics.throwNpe();
        }
        if (bl4.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_3;
        }
        PopupMenu popupMenu5 = this.headingMenu;
        Boolean bl5 = popupMenu5 != null && (popupMenu5 = popupMenu5.getMenu()) != null && (popupMenu5 = popupMenu5.findItem(R.id.heading_4)) != null ? Boolean.valueOf(popupMenu5.isChecked()) : null;
        if (bl5 == null) {
            Intrinsics.throwNpe();
        }
        if (bl5.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_4;
        }
        PopupMenu popupMenu6 = this.headingMenu;
        Boolean bl6 = popupMenu6 != null && (popupMenu6 = popupMenu6.getMenu()) != null && (popupMenu6 = popupMenu6.findItem(R.id.heading_5)) != null ? Boolean.valueOf(popupMenu6.isChecked()) : null;
        if (bl6 == null) {
            Intrinsics.throwNpe();
        }
        if (bl6.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_5;
        }
        PopupMenu popupMenu7 = this.headingMenu;
        Boolean bl7 = popupMenu7 != null && (popupMenu7 = popupMenu7.getMenu()) != null && (popupMenu7 = popupMenu7.findItem(R.id.heading_6)) != null ? Boolean.valueOf(popupMenu7.isChecked()) : null;
        if (bl7 == null) {
            Intrinsics.throwNpe();
        }
        if (bl7.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_6;
        }
        return null;
    }

    @Nullable
    public final ITextFormat getSelectedListMenuItem() {
        PopupMenu popupMenu = this.listMenu;
        Boolean bl = popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_unordered)) != null ? Boolean.valueOf(popupMenu.isChecked()) : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            return AztecTextFormat.FORMAT_UNORDERED_LIST;
        }
        PopupMenu popupMenu2 = this.listMenu;
        Boolean bl2 = popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.findItem(R.id.list_ordered)) != null ? Boolean.valueOf(popupMenu2.isChecked()) : null;
        if (bl2 == null) {
            Intrinsics.throwNpe();
        }
        if (bl2.booleanValue()) {
            return AztecTextFormat.FORMAT_ORDERED_LIST;
        }
        return null;
    }

    public final void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        this.setAdvancedState();
    }

    private final void animateToolbarCollapse() {
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapsed;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapsed");
        }
        Animation animation = this.ellipsisSpinLeft;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinLeft");
        }
        rippleToggleButton.startAnimation(animation);
        this.isExpanded = false;
    }

    private final void animateToolbarExpand() {
        RippleToggleButton rippleToggleButton = this.buttonEllipsisExpanded;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpanded");
        }
        Animation animation = this.ellipsisSpinRight;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinRight");
        }
        rippleToggleButton.startAnimation(animation);
        this.isExpanded = true;
    }

    private final void setAdvancedState() {
        if (this.isAdvanced) {
            this.setButtonViews();
            this.setAnimations();
            if (this.isExpanded) {
                this.showExpandedToolbar();
            } else {
                this.showCollapsedToolbar();
            }
        }
    }

    private final void selectHeadingMenuItem(ArrayList<ITextFormat> textFormats) {
        ToggleButton headingButton = (ToggleButton)this.findViewById(ToolbarAction.HEADING.getButtonId());
        ITextFormat iTextFormat = AztecTextFormat.FORMAT_PARAGRAPH;
        ToggleButton toggleButton = headingButton;
        Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"headingButton");
        this.updateHeadingMenuItem(iTextFormat, toggleButton);
        PopupMenu popupMenu = this.headingMenu;
        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.paragraph)) != null) {
            popupMenu.setChecked(true);
        }
        for (ITextFormat it : textFormats) {
            ITextFormat iTextFormat2 = it;
            if (Intrinsics.areEqual((Object)iTextFormat2, (Object)AztecTextFormat.FORMAT_HEADING_1)) {
                PopupMenu popupMenu2 = this.headingMenu;
                if (popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.findItem(R.id.heading_1)) != null) {
                    popupMenu2.setChecked(true);
                }
            } else if (Intrinsics.areEqual((Object)iTextFormat2, (Object)AztecTextFormat.FORMAT_HEADING_2)) {
                PopupMenu popupMenu3 = this.headingMenu;
                if (popupMenu3 != null && (popupMenu3 = popupMenu3.getMenu()) != null && (popupMenu3 = popupMenu3.findItem(R.id.heading_2)) != null) {
                    popupMenu3.setChecked(true);
                }
            } else if (Intrinsics.areEqual((Object)iTextFormat2, (Object)AztecTextFormat.FORMAT_HEADING_3)) {
                PopupMenu popupMenu4 = this.headingMenu;
                if (popupMenu4 != null && (popupMenu4 = popupMenu4.getMenu()) != null && (popupMenu4 = popupMenu4.findItem(R.id.heading_3)) != null) {
                    popupMenu4.setChecked(true);
                }
            } else if (Intrinsics.areEqual((Object)iTextFormat2, (Object)AztecTextFormat.FORMAT_HEADING_4)) {
                PopupMenu popupMenu5 = this.headingMenu;
                if (popupMenu5 != null && (popupMenu5 = popupMenu5.getMenu()) != null && (popupMenu5 = popupMenu5.findItem(R.id.heading_4)) != null) {
                    popupMenu5.setChecked(true);
                }
            } else if (Intrinsics.areEqual((Object)iTextFormat2, (Object)AztecTextFormat.FORMAT_HEADING_5)) {
                PopupMenu popupMenu6 = this.headingMenu;
                if (popupMenu6 != null && (popupMenu6 = popupMenu6.getMenu()) != null && (popupMenu6 = popupMenu6.findItem(R.id.heading_5)) != null) {
                    popupMenu6.setChecked(true);
                }
            } else {
                if (!Intrinsics.areEqual((Object)iTextFormat2, (Object)AztecTextFormat.FORMAT_HEADING_6)) continue;
                PopupMenu popupMenu7 = this.headingMenu;
                if (popupMenu7 != null && (popupMenu7 = popupMenu7.getMenu()) != null && (popupMenu7 = popupMenu7.findItem(R.id.heading_6)) != null) {
                    popupMenu7.setChecked(true);
                }
            }
            ITextFormat iTextFormat3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)iTextFormat3, (String)"it");
            this.updateHeadingMenuItem(iTextFormat3, headingButton);
        }
    }

    private final void selectListMenuItem(ArrayList<ITextFormat> textFormats) {
        ToggleButton listButton = (ToggleButton)this.findViewById(ToolbarAction.LIST.getButtonId());
        ITextFormat iTextFormat = AztecTextFormat.FORMAT_NONE;
        ToggleButton toggleButton = listButton;
        Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"listButton");
        this.updateListMenuItem(iTextFormat, toggleButton);
        PopupMenu popupMenu = this.listMenu;
        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_none)) != null) {
            popupMenu.setChecked(true);
        }
        for (ITextFormat it : textFormats) {
            ITextFormat iTextFormat2 = it;
            if (Intrinsics.areEqual((Object)iTextFormat2, (Object)AztecTextFormat.FORMAT_UNORDERED_LIST)) {
                PopupMenu popupMenu2 = this.listMenu;
                if (popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.findItem(R.id.list_unordered)) != null) {
                    popupMenu2.setChecked(true);
                }
            } else {
                if (!Intrinsics.areEqual((Object)iTextFormat2, (Object)AztecTextFormat.FORMAT_ORDERED_LIST)) continue;
                PopupMenu popupMenu3 = this.listMenu;
                if (popupMenu3 != null && (popupMenu3 = popupMenu3.getMenu()) != null && (popupMenu3 = popupMenu3.findItem(R.id.list_ordered)) != null) {
                    popupMenu3.setChecked(true);
                }
            }
            ITextFormat iTextFormat3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)iTextFormat3, (String)"it");
            this.updateListMenuItem(iTextFormat3, listButton);
        }
    }

    private final void setAnimations() {
        Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_in_end);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation, (String)"AnimationUtils.loadAnima\u2026 R.anim.translate_in_end)");
        this.layoutExpandedTranslateInEnd = animation;
        Animation animation2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_out_start);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation2, (String)"AnimationUtils.loadAnima\u2026anim.translate_out_start)");
        Animation animation3 = this.layoutExpandedTranslateOutStart = animation2;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateOutStart");
        }
        animation3.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).setVisibility(8);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation4 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.spin_left_90);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation4, (String)"AnimationUtils.loadAnima\u2026ext, R.anim.spin_left_90)");
        Animation animation5 = this.ellipsisSpinLeft = animation4;
        if (animation5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinLeft");
        }
        animation5.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonEllipsisCollapsed$p(this.this$0).setVisibility(8);
                AztecToolbar.access$getButtonEllipsisExpanded$p(this.this$0).setVisibility(0);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                this.this$0.scrollToBeginingOfToolbar();
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).startAnimation(AztecToolbar.access$getLayoutExpandedTranslateOutStart$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation6 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.spin_right_90);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation6, (String)"AnimationUtils.loadAnima\u2026xt, R.anim.spin_right_90)");
        Animation animation7 = this.ellipsisSpinRight = animation6;
        if (animation7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinRight");
        }
        animation7.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonEllipsisCollapsed$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getButtonEllipsisExpanded$p(this.this$0).setVisibility(8);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getToolbarScrolView$p(this.this$0).requestChildFocus((View)AztecToolbar.access$getButtonMediaCollapsed$p(this.this$0), (View)AztecToolbar.access$getButtonMediaCollapsed$p(this.this$0));
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).startAnimation(AztecToolbar.access$getLayoutExpandedTranslateInEnd$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void scrollToBeginingOfToolbar() {
        if (TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 0 || Build.VERSION.SDK_INT <= 18) {
            HorizontalScrollView horizontalScrollView = this.toolbarScrolView;
            if (horizontalScrollView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarScrolView");
            }
            horizontalScrollView.fullScroll(17);
        } else {
            HorizontalScrollView horizontalScrollView = this.toolbarScrolView;
            if (horizontalScrollView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarScrolView");
            }
            horizontalScrollView.fullScroll(66);
        }
    }

    private final void setButtonViews() {
        View view = this.findViewById(R.id.format_bar_button_layout_expanded);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.format\u2026r_button_layout_expanded)");
        this.layoutExpanded = (LinearLayout)view;
        View view2 = this.findViewById(R.id.format_bar_button_ellipsis_collapsed);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.format\u2026utton_ellipsis_collapsed)");
        this.buttonEllipsisCollapsed = (RippleToggleButton)view2;
        View view3 = this.findViewById(R.id.format_bar_button_ellipsis_expanded);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.format\u2026button_ellipsis_expanded)");
        this.buttonEllipsisExpanded = (RippleToggleButton)view3;
    }

    private final void setupMediaToolbar() {
        View view = this.findViewById(R.id.media_button_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.media_button_container)");
        LinearLayout mediaToolbarContainer = (LinearLayout)view;
        mediaToolbarContainer.setVisibility(this.isMediaToolbarAvailable ? 0 : 8);
        if (!this.isMediaToolbarAvailable) {
            return;
        }
        View view2 = this.findViewById(R.id.media_toolbar);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.media_toolbar)");
        this.mediaToolbar = view2;
        View view3 = this.findViewById(R.id.styling_toolbar);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.styling_toolbar)");
        this.stylingToolbar = view3;
        View view4 = this.findViewById(R.id.format_bar_button_media_collapsed);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.format\u2026r_button_media_collapsed)");
        this.buttonMediaCollapsed = (RippleToggleButton)view4;
        View view5 = this.findViewById(R.id.format_bar_button_media_expanded);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"findViewById(R.id.format\u2026ar_button_media_expanded)");
        this.buttonMediaExpanded = (RippleToggleButton)view5;
        if (this.isMediaToolbarVisible) {
            RippleToggleButton rippleToggleButton = this.buttonMediaExpanded;
            if (rippleToggleButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonMediaExpanded");
            }
            rippleToggleButton.setVisibility(0);
            RippleToggleButton rippleToggleButton2 = this.buttonMediaCollapsed;
            if (rippleToggleButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonMediaCollapsed");
            }
            rippleToggleButton2.setVisibility(8);
            View view6 = this.stylingToolbar;
            if (view6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stylingToolbar");
            }
            view6.setVisibility(8);
            View view7 = this.mediaToolbar;
            if (view7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaToolbar");
            }
            view7.setVisibility(0);
        } else {
            RippleToggleButton rippleToggleButton = this.buttonMediaExpanded;
            if (rippleToggleButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonMediaExpanded");
            }
            rippleToggleButton.setVisibility(8);
            RippleToggleButton rippleToggleButton3 = this.buttonMediaCollapsed;
            if (rippleToggleButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonMediaCollapsed");
            }
            rippleToggleButton3.setVisibility(0);
            View view8 = this.stylingToolbar;
            if (view8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stylingToolbar");
            }
            view8.setVisibility(0);
            View view9 = this.mediaToolbar;
            if (view9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaToolbar");
            }
            view9.setVisibility(8);
        }
        this.setupMediaToolbarAnimations();
    }

    private final void setupMediaToolbarAnimations() {
        if (!this.isMediaToolbarAvailable) {
            return;
        }
        Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_in_end);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation, (String)"AnimationUtils.loadAnima\u2026 R.anim.translate_in_end)");
        this.layoutMediaTranslateInEnd = animation;
        Animation animation2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_out_end);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation2, (String)"AnimationUtils.loadAnima\u2026R.anim.translate_out_end)");
        Animation animation3 = this.layoutMediaTranslateOutEnd = animation2;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutMediaTranslateOutEnd");
        }
        animation3.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getStylingToolbar$p(this.this$0).setVisibility(8);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation4 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_in_start);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation4, (String)"AnimationUtils.loadAnima\u2026.anim.translate_in_start)");
        Animation animation5 = this.layoutMediaTranslateInStart = animation4;
        if (animation5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutMediaTranslateInStart");
        }
        animation5.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getStylingToolbar$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getToolbarScrolView$p(this.this$0).requestChildFocus((View)AztecToolbar.access$getButtonMediaCollapsed$p(this.this$0), (View)AztecToolbar.access$getButtonMediaCollapsed$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation6 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_out_start);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation6, (String)"AnimationUtils.loadAnima\u2026anim.translate_out_start)");
        Animation animation7 = this.layoutMediaTranslateOutStart = animation6;
        if (animation7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutMediaTranslateOutStart");
        }
        animation7.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getMediaToolbar$p(this.this$0).setVisibility(8);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation8 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.spin_right_45);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation8, (String)"AnimationUtils.loadAnima\u2026xt, R.anim.spin_right_45)");
        Animation animation9 = this.mediaButtonSpinRight = animation8;
        if (animation9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaButtonSpinRight");
        }
        animation9.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonMediaCollapsed$p(this.this$0).setVisibility(8);
                AztecToolbar.access$getButtonMediaExpanded$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getButtonMediaExpanded$p(this.this$0).sendAccessibilityEvent(8);
                AztecToolbar.access$getButtonMediaExpanded$p(this.this$0).setChecked(true);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                this.this$0.scrollToBeginingOfToolbar();
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation10 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.spin_left_45);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation10, (String)"AnimationUtils.loadAnima\u2026ext, R.anim.spin_left_45)");
        Animation animation11 = this.mediaButtonSpinLeft = animation10;
        if (animation11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaButtonSpinLeft");
        }
        animation11.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonMediaCollapsed$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getButtonMediaExpanded$p(this.this$0).setVisibility(8);
                AztecToolbar.access$getButtonMediaCollapsed$p(this.this$0).sendAccessibilityEvent(8);
                AztecToolbar.access$getButtonMediaCollapsed$p(this.this$0).setChecked(false);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void setHeadingMenu(View view) {
        block2: {
            PopupMenu popupMenu = this.headingMenu = new PopupMenu(this.getContext(), view);
            if (popupMenu != null) {
                popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
            }
            PopupMenu popupMenu2 = this.headingMenu;
            if (popupMenu2 != null) {
                popupMenu2.inflate(R.menu.heading);
            }
            PopupMenu popupMenu3 = this.headingMenu;
            if (popupMenu3 == null) break block2;
            popupMenu3.setOnDismissListener(new PopupMenu.OnDismissListener(this){
                final /* synthetic */ AztecToolbar this$0;

                public final void onDismiss(PopupMenu it) {
                    if (this.this$0.getSelectedHeadingMenuItem() == null || Intrinsics.areEqual((Object)this.this$0.getSelectedHeadingMenuItem(), (Object)AztecTextFormat.FORMAT_PARAGRAPH)) {
                        View view = this.this$0.findViewById(ToolbarAction.HEADING.getButtonId());
                        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ToggleButto\u2026rAction.HEADING.buttonId)");
                        ((ToggleButton)view).setChecked(false);
                    } else {
                        View view = this.this$0.findViewById(ToolbarAction.HEADING.getButtonId());
                        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ToggleButto\u2026rAction.HEADING.buttonId)");
                        ((ToggleButton)view).setChecked(true);
                    }
                }
                {
                    this.this$0 = aztecToolbar;
                }
            });
        }
    }

    private final void setListMenu(View view) {
        block2: {
            PopupMenu popupMenu = this.listMenu = new PopupMenu(this.getContext(), view);
            if (popupMenu != null) {
                popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
            }
            PopupMenu popupMenu2 = this.listMenu;
            if (popupMenu2 != null) {
                popupMenu2.inflate(R.menu.list);
            }
            PopupMenu popupMenu3 = this.listMenu;
            if (popupMenu3 == null) break block2;
            popupMenu3.setOnDismissListener(new PopupMenu.OnDismissListener(this){
                final /* synthetic */ AztecToolbar this$0;

                public final void onDismiss(PopupMenu it) {
                    if (this.this$0.getSelectedListMenuItem() == null) {
                        View view = this.this$0.findViewById(ToolbarAction.LIST.getButtonId());
                        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ToggleButto\u2026lbarAction.LIST.buttonId)");
                        ((ToggleButton)view).setChecked(false);
                    } else {
                        View view = this.this$0.findViewById(ToolbarAction.LIST.getButtonId());
                        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ToggleButto\u2026lbarAction.LIST.buttonId)");
                        ((ToggleButton)view).setChecked(true);
                    }
                }
                {
                    this.this$0 = aztecToolbar;
                }
            });
        }
    }

    private final void updateListMenuItem(ITextFormat textFormat, ToggleButton listButton) {
        int backgroundRes = R.drawable.format_bar_button_ul_selector;
        int contentDescriptionRes = R.string.format_bar_description_list;
        boolean check = true;
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ORDERED_LIST)) {
            backgroundRes = R.drawable.format_bar_button_ol_selector;
            contentDescriptionRes = R.string.item_format_list_ordered;
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNORDERED_LIST)) {
            contentDescriptionRes = R.string.item_format_list_unordered;
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_NONE)) {
            check = false;
        } else {
            AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)"Unknown list menu item - text format");
            return;
        }
        listButton.setBackgroundResource(backgroundRes);
        listButton.setContentDescription((CharSequence)this.getContext().getString(contentDescriptionRes));
        listButton.setChecked(check);
    }

    private final void updateHeadingMenuItem(ITextFormat textFormat, ToggleButton headingButton) {
        int backgroundRes = R.drawable.format_bar_button_heading_selector;
        int contentDescriptionRes = R.string.format_bar_description_heading;
        boolean check = true;
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1)) {
            backgroundRes = R.drawable.format_bar_button_heading_1_selector;
            contentDescriptionRes = R.string.heading_1;
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2)) {
            backgroundRes = R.drawable.format_bar_button_heading_2_selector;
            contentDescriptionRes = R.string.heading_2;
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3)) {
            backgroundRes = R.drawable.format_bar_button_heading_3_selector;
            contentDescriptionRes = R.string.heading_3;
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4)) {
            backgroundRes = R.drawable.format_bar_button_heading_4_selector;
            contentDescriptionRes = R.string.heading_4;
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5)) {
            backgroundRes = R.drawable.format_bar_button_heading_5_selector;
            contentDescriptionRes = R.string.heading_5;
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6)) {
            backgroundRes = R.drawable.format_bar_button_heading_6_selector;
            contentDescriptionRes = R.string.heading_6;
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_PARAGRAPH)) {
            check = false;
        } else {
            AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)"Unknown heading menu item - text format");
            return;
        }
        headingButton.setBackgroundResource(backgroundRes);
        headingButton.setContentDescription((CharSequence)this.getContext().getString(contentDescriptionRes));
        headingButton.setChecked(check);
    }

    private final void showCollapsedToolbar() {
        LinearLayout linearLayout = this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        linearLayout.setVisibility(8);
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapsed;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapsed");
        }
        rippleToggleButton.setVisibility(8);
        RippleToggleButton rippleToggleButton2 = this.buttonEllipsisExpanded;
        if (rippleToggleButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpanded");
        }
        rippleToggleButton2.setVisibility(0);
    }

    private final void showExpandedToolbar() {
        LinearLayout linearLayout = this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        linearLayout.setVisibility(0);
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapsed;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapsed");
        }
        rippleToggleButton.setVisibility(0);
        RippleToggleButton rippleToggleButton2 = this.buttonEllipsisExpanded;
        if (rippleToggleButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpanded");
        }
        rippleToggleButton2.setVisibility(8);
    }

    private final void toggleHtmlMode(boolean isHtmlMode) {
        for (Object element$iv : (Object[])ToolbarAction.values()) {
            ToolbarAction action = (ToolbarAction)element$iv;
            if (Intrinsics.areEqual((Object)action, (Object)ToolbarAction.HTML)) {
                this.toggleButton(this.findViewById(action.getButtonId()), isHtmlMode);
                continue;
            }
            this.toggleButtonState(this.findViewById(action.getButtonId()), !isHtmlMode);
        }
        Iterable $receiver$iv = this.toolbarButtonPlugins;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            IToolbarButton it = (IToolbarButton)element$iv;
            this.toggleButtonState(this.findViewById(it.getAction().getButtonId()), !isHtmlMode);
        }
    }

    private final void toggleListMenuSelection(int listMenuItemId, boolean isChecked) {
        ToggleButton listButton = (ToggleButton)this.findViewById(ToolbarAction.LIST.getButtonId());
        if (isChecked) {
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(listMenuItemId)) != null) {
                popupMenu.setChecked(true);
            }
            int n = listMenuItemId;
            if (n == R.id.list_ordered) {
                ITextFormat iTextFormat = AztecTextFormat.FORMAT_ORDERED_LIST;
                ToggleButton toggleButton = listButton;
                Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"listButton");
                this.updateListMenuItem(iTextFormat, toggleButton);
            } else if (n == R.id.list_unordered) {
                ITextFormat iTextFormat = AztecTextFormat.FORMAT_UNORDERED_LIST;
                ToggleButton toggleButton = listButton;
                Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"listButton");
                this.updateListMenuItem(iTextFormat, toggleButton);
            } else {
                AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)"Unknown list menu item");
                ITextFormat iTextFormat = AztecTextFormat.FORMAT_UNORDERED_LIST;
                ToggleButton toggleButton = listButton;
                Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"listButton");
                this.updateListMenuItem(iTextFormat, toggleButton);
            }
        } else {
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_none)) != null) {
                popupMenu.setChecked(true);
            }
            ITextFormat iTextFormat = AztecTextFormat.FORMAT_NONE;
            ToggleButton toggleButton = listButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)toggleButton, (String)"listButton");
            this.updateListMenuItem(iTextFormat, toggleButton);
        }
    }

    public final void enableFormatButtons(boolean isEnabled) {
        for (Object element$iv : (Object[])ToolbarAction.values()) {
            ToolbarAction action = (ToolbarAction)element$iv;
            if (!(Intrinsics.areEqual((Object)action, (Object)ToolbarAction.HTML) ^ true)) continue;
            this.toggleButtonState(this.findViewById(action.getButtonId()), isEnabled);
        }
        Iterable $receiver$iv = this.toolbarButtonPlugins;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            IToolbarButton it = (IToolbarButton)element$iv;
            this.toggleButtonState(this.findViewById(it.getAction().getButtonId()), isEnabled);
        }
    }

    public final boolean isMediaModeEnabled() {
        return this.isMediaModeEnabled;
    }

    public final void enableMediaMode(boolean isEnabled) {
        this.isMediaModeEnabled = isEnabled;
        Iterable $receiver$iv = this.toolbarButtonPlugins;
        for (Object element$iv : $receiver$iv) {
            IToolbarButton button = (IToolbarButton)element$iv;
            if (button instanceof IMediaToolbarButton) continue;
            button.toolbarStateAboutToChange(this, !isEnabled);
        }
    }

    @SuppressLint(value={"InflateParams"})
    private final void showDialogShortcuts() {
        View layout2 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dialog_shortcuts, null);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setView(layout2);
        AlertDialog alertDialog = this.dialogShortcuts = builder.create();
        if (alertDialog == null) {
            Intrinsics.throwNpe();
        }
        alertDialog.show();
    }

    public final void hideMediaToolbar() {
        if (!this.isMediaToolbarVisible) {
            return;
        }
        RippleToggleButton rippleToggleButton = this.buttonMediaExpanded;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonMediaExpanded");
        }
        Animation animation = this.mediaButtonSpinLeft;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaButtonSpinLeft");
        }
        rippleToggleButton.startAnimation(animation);
        View view = this.stylingToolbar;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stylingToolbar");
        }
        Animation animation2 = this.layoutMediaTranslateInStart;
        if (animation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutMediaTranslateInStart");
        }
        view.startAnimation(animation2);
        View view2 = this.mediaToolbar;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaToolbar");
        }
        Animation animation3 = this.layoutMediaTranslateOutStart;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutMediaTranslateOutStart");
        }
        view2.startAnimation(animation3);
        this.isMediaToolbarVisible = false;
    }

    public final void showMediaToolbar() {
        if (this.isMediaToolbarVisible) {
            return;
        }
        RippleToggleButton rippleToggleButton = this.buttonMediaCollapsed;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonMediaCollapsed");
        }
        Animation animation = this.mediaButtonSpinRight;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaButtonSpinRight");
        }
        rippleToggleButton.startAnimation(animation);
        View view = this.stylingToolbar;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stylingToolbar");
        }
        Animation animation2 = this.layoutMediaTranslateOutEnd;
        if (animation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutMediaTranslateOutEnd");
        }
        view.startAnimation(animation2);
        View view2 = this.mediaToolbar;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaToolbar");
        }
        view2.setVisibility(0);
        View view3 = this.mediaToolbar;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaToolbar");
        }
        Animation animation3 = this.layoutMediaTranslateInEnd;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutMediaTranslateInEnd");
        }
        view3.startAnimation(animation3);
        this.isMediaToolbarVisible = true;
    }

    @Override
    public void toggleMediaToolbar() {
        if (this.isMediaToolbarVisible) {
            this.hideMediaToolbar();
        } else {
            this.showMediaToolbar();
        }
    }

    public AztecToolbar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.toolbarButtonPlugins = new ArrayList();
        this.initView(null);
    }

    public AztecToolbar(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.toolbarButtonPlugins = new ArrayList();
        this.initView(attrs);
    }

    public AztecToolbar(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.toolbarButtonPlugins = new ArrayList();
        this.initView(attrs);
    }

    public static final /* synthetic */ void access$highlightAppliedStyles(AztecToolbar $this, int selStart, int selEnd) {
        $this.highlightAppliedStyles(selStart, selEnd);
    }

    public static final /* synthetic */ void access$onToolbarAction(AztecToolbar $this, @NotNull IToolbarAction action) {
        $this.onToolbarAction(action);
    }

    @NotNull
    public static final /* synthetic */ LinearLayout access$getLayoutExpanded$p(AztecToolbar $this) {
        LinearLayout linearLayout = $this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        return linearLayout;
    }

    public static final /* synthetic */ void access$setLayoutExpanded$p(AztecToolbar $this, @NotNull LinearLayout linearLayout) {
        $this.layoutExpanded = linearLayout;
    }

    @NotNull
    public static final /* synthetic */ RippleToggleButton access$getButtonEllipsisCollapsed$p(AztecToolbar $this) {
        RippleToggleButton rippleToggleButton = $this.buttonEllipsisCollapsed;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapsed");
        }
        return rippleToggleButton;
    }

    public static final /* synthetic */ void access$setButtonEllipsisCollapsed$p(AztecToolbar $this, @NotNull RippleToggleButton rippleToggleButton) {
        $this.buttonEllipsisCollapsed = rippleToggleButton;
    }

    @NotNull
    public static final /* synthetic */ RippleToggleButton access$getButtonEllipsisExpanded$p(AztecToolbar $this) {
        RippleToggleButton rippleToggleButton = $this.buttonEllipsisExpanded;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpanded");
        }
        return rippleToggleButton;
    }

    public static final /* synthetic */ void access$setButtonEllipsisExpanded$p(AztecToolbar $this, @NotNull RippleToggleButton rippleToggleButton) {
        $this.buttonEllipsisExpanded = rippleToggleButton;
    }

    @NotNull
    public static final /* synthetic */ Animation access$getLayoutExpandedTranslateOutStart$p(AztecToolbar $this) {
        Animation animation = $this.layoutExpandedTranslateOutStart;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateOutStart");
        }
        return animation;
    }

    public static final /* synthetic */ void access$setLayoutExpandedTranslateOutStart$p(AztecToolbar $this, @NotNull Animation animation) {
        $this.layoutExpandedTranslateOutStart = animation;
    }

    @NotNull
    public static final /* synthetic */ HorizontalScrollView access$getToolbarScrolView$p(AztecToolbar $this) {
        HorizontalScrollView horizontalScrollView = $this.toolbarScrolView;
        if (horizontalScrollView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarScrolView");
        }
        return horizontalScrollView;
    }

    public static final /* synthetic */ void access$setToolbarScrolView$p(AztecToolbar $this, @NotNull HorizontalScrollView horizontalScrollView) {
        $this.toolbarScrolView = horizontalScrollView;
    }

    @NotNull
    public static final /* synthetic */ RippleToggleButton access$getButtonMediaCollapsed$p(AztecToolbar $this) {
        RippleToggleButton rippleToggleButton = $this.buttonMediaCollapsed;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonMediaCollapsed");
        }
        return rippleToggleButton;
    }

    public static final /* synthetic */ void access$setButtonMediaCollapsed$p(AztecToolbar $this, @NotNull RippleToggleButton rippleToggleButton) {
        $this.buttonMediaCollapsed = rippleToggleButton;
    }

    @NotNull
    public static final /* synthetic */ Animation access$getLayoutExpandedTranslateInEnd$p(AztecToolbar $this) {
        Animation animation = $this.layoutExpandedTranslateInEnd;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateInEnd");
        }
        return animation;
    }

    public static final /* synthetic */ void access$setLayoutExpandedTranslateInEnd$p(AztecToolbar $this, @NotNull Animation animation) {
        $this.layoutExpandedTranslateInEnd = animation;
    }

    @NotNull
    public static final /* synthetic */ View access$getStylingToolbar$p(AztecToolbar $this) {
        View view = $this.stylingToolbar;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stylingToolbar");
        }
        return view;
    }

    public static final /* synthetic */ void access$setStylingToolbar$p(AztecToolbar $this, @NotNull View view) {
        $this.stylingToolbar = view;
    }

    @NotNull
    public static final /* synthetic */ View access$getMediaToolbar$p(AztecToolbar $this) {
        View view = $this.mediaToolbar;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaToolbar");
        }
        return view;
    }

    public static final /* synthetic */ void access$setMediaToolbar$p(AztecToolbar $this, @NotNull View view) {
        $this.mediaToolbar = view;
    }

    @NotNull
    public static final /* synthetic */ RippleToggleButton access$getButtonMediaExpanded$p(AztecToolbar $this) {
        RippleToggleButton rippleToggleButton = $this.buttonMediaExpanded;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonMediaExpanded");
        }
        return rippleToggleButton;
    }

    public static final /* synthetic */ void access$setButtonMediaExpanded$p(AztecToolbar $this, @NotNull RippleToggleButton rippleToggleButton) {
        $this.buttonMediaExpanded = rippleToggleButton;
    }
}

