/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.util;

import android.text.Editable;
import android.text.Spanned;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.android.util.AppLog;
import org.wordpress.aztec.AztecText;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/wordpress/aztec/util/AztecLog;", "", "()V", "Companion", "ExternalLogger", "aztec_release"})
public final class AztecLog {
    private static final int MARK = 1;
    private static final int POINT = 2;
    private static final int PARAGRAPH = 3;
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final String logSpansDetails(@NotNull Spanned text) {
        return Companion.logSpansDetails(text);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/util/AztecLog$ExternalLogger;", "", "log", "", "message", "", "logException", "tr", "", "aztec_release"})
    public static interface ExternalLogger {
        public void log(@NotNull String var1);

        public void logException(@NotNull Throwable var1);

        public void logException(@NotNull Throwable var1, @NotNull String var2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/wordpress/aztec/util/AztecLog$Companion;", "", "()V", "MARK", "", "PARAGRAPH", "POINT", "logContentDetails", "", "text", "Landroid/text/Spanned;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "logSpansDetails", "", "spaces", "count", "char", "aztec_release"})
    public static final class Companion {
        public final void logContentDetails(@NotNull AztecText aztecText) {
            Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
            AppLog.d((AppLog.T)AppLog.T.EDITOR, (String)"Below are the details of the content in the editor:");
            Editable editable = aztecText.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"aztecText.text");
            this.logContentDetails((Spanned)editable);
        }

        public final void logContentDetails(@NotNull Spanned text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            try {
                AppLog.d((AppLog.T)AppLog.T.EDITOR, (String)this.logSpansDetails(text));
            }
            catch (Exception e) {
                AppLog.e((AppLog.T)AppLog.T.EDITOR, (String)"Uhh ohh! There was an error logging the spans details of the Editor. This shouldnever happen.", (Throwable)e);
            }
        }

        @JvmStatic
        @NotNull
        public final String logSpansDetails(@NotNull Spanned text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Object[] spans = text.getSpans(0, text.length(), Object.class);
            List<Object> spansList = Arrays.asList(Arrays.copyOf(spans, spans.length));
            StringBuilder sb = new StringBuilder();
            sb.append('\n').append(StringsKt.replace$default((String)StringsKt.replace$default((String)text.toString(), (char)'\n', (char)'\u00b6', (boolean)false, (int)4, null), (char)'\u200b', (char)'\u00ac', (boolean)false, (int)4, null));
            sb.append("  length = " + text.length());
            for (Object span : spansList) {
                int start = text.getSpanStart(span);
                int end = text.getSpanEnd(span);
                int gap = text.length() + 5;
                sb.append('\n');
                if (start > 0) {
                    sb.append(org.wordpress.aztec.util.AztecLog$Companion.spaces$default(this, start, null, 2, null));
                    gap -= start;
                }
                int spanMode = text.getSpanFlags(span) & 0x33;
                int leftMode = (spanMode & 0x30) >>> 4;
                int rightMode = spanMode & 3;
                if (end - start > 0) {
                    switch (leftMode) {
                        case 1: {
                            sb.append('>');
                            break;
                        }
                        case 2: {
                            sb.append('<');
                            break;
                        }
                        case 3: {
                            sb.append(start == 0 ? (char)'<' : '>');
                        }
                    }
                    --gap;
                } else if (spanMode == 18) {
                    sb.append('x');
                } else if (spanMode == 17) {
                    sb.append('>');
                } else if (spanMode == 34) {
                    sb.append('<');
                } else if (spanMode == 33) {
                    sb.append('!');
                } else if (spanMode == 51) {
                    if (start == 0) {
                        sb.append('!');
                    } else if (start == text.length()) {
                        sb.append('<');
                    } else {
                        sb.append('>');
                    }
                }
                if (end - start - 1 > 0) {
                    sb.append(this.spaces(end - start - 1, "-"));
                    gap -= end - start - 1;
                }
                if (end - start > 0) {
                    switch (rightMode) {
                        case 1: {
                            sb.append('>');
                            break;
                        }
                        case 2: {
                            sb.append('<');
                            break;
                        }
                        case 3: {
                            sb.append(end == text.length() ? (char)'<' : '>');
                        }
                    }
                    --gap;
                }
                sb.append(org.wordpress.aztec.util.AztecLog$Companion.spaces$default(this, gap, null, 2, null));
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%03d";
                Object[] objectArray = new Object[]{start};
                StringBuilder stringBuilder = sb.append("   ");
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string3;
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "%03d";
                objectArray = new Object[]{end};
                stringBuilder = stringBuilder.append(string4).append(" -> ");
                String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                string4 = string5;
                stringBuilder.append(string4).append(" : ").append(span.getClass().getSimpleName());
            }
            String string6 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"sb.toString()");
            return string6;
        }

        private final String spaces(int count, String string2) {
            String string3 = TextUtils.join((CharSequence)"", (Iterable)Collections.nCopies(count, string2));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"TextUtils.join(\"\", Colle\u2026ons.nCopies(count, char))");
            return string3;
        }

        static /* synthetic */ String spaces$default(Companion companion, int n, String string2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                string2 = " ";
            }
            return companion.spaces(n, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

