/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.source;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.wordpress.aztec.source.Format;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecVisualLinebreak;
import org.wordpress.aztec.spans.EndOfParagraphMarker;
import org.wordpress.aztec.spans.IAztecParagraphStyle;
import org.wordpress.aztec.spans.ParagraphSpan;
import org.wordpress.aztec.util.CleaningUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/wordpress/aztec/source/Format;", "", "()V", "block", "", "iframePlaceholder", "addSourceEditorFormatting", "content", "isCalypsoFormat", "", "postProcessSpannedText", "", "text", "Landroid/text/SpannableStringBuilder;", "preProcessSpannedText", "removeSourceEditorFormatting", "html", "replace", "pattern", "replacement", "replaceAll", "toCalypsoHtml", "formattedHtml", "toCalypsoSourceEditorFormat", "htmlContent", "aztec_release"})
public final class Format {
    private static final String block = "div|br|blockquote|ul|ol|li|p|pre|h1|h2|h3|h4|h5|h6|iframe|hr";
    private static final String iframePlaceholder = "iframe-replacement-0x0";
    public static final Format INSTANCE;

    @JvmStatic
    @NotNull
    public static final String addSourceEditorFormatting(@NotNull String content, boolean isCalypsoFormat) {
        Object object;
        Document doc;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        String html = INSTANCE.replaceAll(content, "iframe", iframePlaceholder);
        html = StringsKt.replace$default((String)html, (String)"<aztec_cursor>", (String)"", (boolean)false, (int)4, null);
        Document document = doc = Jsoup.parseBodyFragment((String)html).outputSettings(new Document.OutputSettings().prettyPrint(!isCalypsoFormat));
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"doc");
        CleaningUtils.cleanNestedBoldTags(document);
        if (isCalypsoFormat) {
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            Elements elements = doc.select("*");
            Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"doc.select(\"*\")");
            object = (Iterable)elements;
            void var5_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                Element it = (Element)element$iv$iv;
                if (!(!it.hasText() && Intrinsics.areEqual((Object)it.tagName(), (Object)"span") && it.childNodes().size() == 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Element it = (Element)element$iv;
                it.remove();
            }
            String string2 = doc.body().html();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"doc.body().html()");
            html = INSTANCE.replaceAll(string2, iframePlaceholder, "iframe");
            html = INSTANCE.replaceAll(html, "<p>(?:<br ?/?>|\u00a0|\ufeff| )*</p>", "<p>&nbsp;</p>");
            html = INSTANCE.toCalypsoSourceEditorFormat(html);
        } else {
            String string3 = doc.body().html();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"doc.body().html()");
            html = INSTANCE.replaceAll(string3, iframePlaceholder, "iframe");
            String newlineToTheLeft = INSTANCE.replaceAll(html, "(?<!</?(" + block + ")>)\n<((?!/?(" + block + ")).*?)>", "<$2>");
            String newlineToTheRight = INSTANCE.replaceAll(newlineToTheLeft, "<(/?(?!" + block + ").)>\n(?!</?(" + block + ")>)", "<$1>");
            String fixBrNewlines = INSTANCE.replaceAll(newlineToTheRight, "([\t ]*)(<br>)(?!\n)", "$1$2\n$1");
            html = INSTANCE.replaceAll(fixBrNewlines, ">([\t ]*)(<br>)", ">\n$1$2");
        }
        Object object2 = object = html;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
    }

    @JvmStatic
    @NotNull
    public static /* synthetic */ String addSourceEditorFormatting$default(String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Format.addSourceEditorFormatting(string2, bl);
    }

    @JvmStatic
    @NotNull
    public static final String removeSourceEditorFormatting(@NotNull String html, boolean isCalypsoFormat) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        if (isCalypsoFormat) {
            String htmlWithoutSourceFormatting = INSTANCE.toCalypsoHtml(html);
            Document doc = Jsoup.parseBodyFragment((String)StringsKt.replace$default((String)htmlWithoutSourceFormatting, (String)"\n", (String)"", (boolean)false, (int)4, null)).outputSettings(new Document.OutputSettings().prettyPrint(false));
            String string2 = doc.body().html();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"doc.body().html()");
            return string2;
        }
        return INSTANCE.replaceAll(html, "\\s*<(/?(" + block + ")(.*?))>\\s*", "<$1>");
    }

    @JvmStatic
    @NotNull
    public static /* synthetic */ String removeSourceEditorFormatting$default(String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Format.removeSourceEditorFormatting(string2, bl);
    }

    private final String replaceAll(String content, String pattern, String replacement) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        String string2 = m.replaceAll(replacement);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"m.replaceAll(replacement)");
        return string2;
    }

    @NotNull
    public final String toCalypsoSourceEditorFormat(@NotNull String htmlContent) {
        CharSequence charSequence;
        Object object;
        int n;
        String content;
        Intrinsics.checkParameterIsNotNull((Object)htmlContent, (String)"htmlContent");
        String $receiver$iv = content = htmlContent;
        CharSequence $receiver$iv$iv = $receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (TextUtils.isEmpty((CharSequence)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) {
            return "";
        }
        boolean preserve_linebreaks = false;
        boolean preserve_br = false;
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)"<pre", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)content, (CharSequence)"<script", (boolean)false, (int)2, null)) {
            preserve_linebreaks = true;
            CharSequence index$iv$iv = content;
            Regex regex = new Regex("<(pre|script)[^>]*>[\\s\\S]+?</\\1>");
            Function1 function1 = toCalypsoSourceEditorFormat.2.INSTANCE;
            content = regex.replace(index$iv$iv, function1);
        }
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)"[caption", (boolean)false, (int)2, null)) {
            preserve_br = true;
            Pattern pattern = Pattern.compile("\\[caption[\\s\\S]+?\\[/caption]");
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"\\\\[capt\u2026n[\\\\s\\\\S]+?\\\\[/caption]\")");
            Pattern p = pattern;
            Matcher matcher = p.matcher(content);
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher, (String)"p.matcher(content)");
            Matcher m = matcher;
            StringBuffer sb = new StringBuffer();
            if (m.find()) {
                String string2 = content;
                int n2 = m.start();
                n = m.end();
                object = this;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n2, n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                charSequence = string4;
                String result = ((Format)object).replaceAll((String)charSequence, "<br([^>]*)>", "<wp-temp-br$1>");
                m.appendReplacement(sb, Matcher.quoteReplacement(this.replace(result, "[\\r\\n\\t]+", "")));
            }
            m.appendTail(sb);
            String string5 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sb.toString()");
            content = string5;
        }
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)"<hr", (boolean)false, (int)2, null)) {
            content = this.replaceAll(content, "<hr ?/?>", "<hr>");
        }
        String blocklist = "blockquote|ul|ol|li|table|thead|tbody|tfoot|tr|th|td|h[1-6]|fieldset|div|p";
        content = this.replaceAll(content, "\\s*</(" + blocklist + ")>\\s*", "</$1>\n");
        content = this.replaceAll(content, "\\s*<((?:" + blocklist + ")(?: [^>]*)?)>", "\n<$1>");
        content = this.replaceAll(content, "\\s*<(!--.*?--|hr)>\\s*", "\n\n<$1>\n\n");
        content = this.replaceAll(content, "(<p [^>]+>.*?)</p>", "$1</p#>");
        content = this.replaceAll(content, "(?i)<div( [^>]*)?>\\s*<p>", "<div$1>\n\n");
        content = this.replaceAll(content, "(?i)\\s*<p>", "");
        content = this.replaceAll(content, "(?i)\\s*</p>\\s*", "\n\n");
        content = this.replaceAll(content, "\\n[\\s\\u00a0]+\\n", "\n\n");
        content = this.replaceAll(content, "(?i)\\s*<br ?/?>\\s*", "\n");
        content = this.replaceAll(content, "\n\n<div", "\n<div");
        content = this.replaceAll(content, "</div>\n\n", "</div>\n");
        content = this.replaceAll(content, "(?i)\\s*\\[caption([^\\[]+)\\[/caption\\]\\s*", "\n\n[caption$1[/caption]\n\n");
        content = this.replaceAll(content, "caption\\]\\n\\n+\\[caption", "caption]\n\n[caption");
        if (StringsKt.contains$default((CharSequence)(content = this.replaceAll(content, "<li([^>]*)>", "\t<li$1>")), (CharSequence)"<option", (boolean)false, (int)2, null)) {
            content = this.replaceAll(content, "\\s*<option", "\n<option");
            content = this.replaceAll(content, "\\s*</select>", "\n</select>");
        }
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)"<object", (boolean)false, (int)2, null)) {
            Pattern pattern = Pattern.compile("<object[\\s\\S]+?</object>");
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"<object[\\\\s\\\\S]+?</object>\")");
            Pattern p = pattern;
            Matcher matcher = p.matcher(content);
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher, (String)"p.matcher(content)");
            Matcher m = matcher;
            StringBuffer sb = new StringBuffer();
            if (m.find()) {
                String string6 = content;
                int n3 = m.start();
                n = m.end();
                Format format = this;
                charSequence = sb;
                object = m;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n3, n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string9 = string8;
                ((Matcher)object).appendReplacement((StringBuffer)charSequence, Matcher.quoteReplacement(format.replace(string9, "[\\r\\n]+", "")));
            }
            m.appendTail(sb);
            String string10 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"sb.toString()");
            content = string10;
        }
        content = this.replaceAll(content, "</p#>", "</p>");
        content = this.replaceAll(content, "\\s*(<p [^>]+>[\\s\\S]*?</p>)", "\n$1");
        content = this.replaceAll(content, "^\\s+", "");
        content = this.replaceAll(content, "[\\s\\u00a0]+$", "");
        content = this.replaceAll(content, "&nbsp;", " ");
        if (preserve_linebreaks) {
            content = this.replaceAll(content, "<wp-line-break>", "\n");
        }
        if (preserve_br) {
            content = this.replaceAll(content, "<wp-temp-br([^>]*)>", "<br$1>");
        }
        return content;
    }

    @NotNull
    public final String toCalypsoHtml(@NotNull String formattedHtml) {
        String string2;
        String string3;
        Matcher matcher;
        StringBuffer stringBuffer;
        Format format;
        int $i$a$1$trim2;
        int match$iv$iv22;
        String html;
        Intrinsics.checkParameterIsNotNull((Object)formattedHtml, (String)"formattedHtml");
        String $receiver$iv = html = StringsKt.replace$default((String)formattedHtml, (String)"<aztec_cursor></aztec_cursor>", (String)"", (boolean)false, (int)4, null);
        CharSequence $receiver$iv$iv = $receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            int n = match$iv$iv22 = it <= ' ' ? 1 : 0;
            if (!startFound$iv$iv) {
                if (match$iv$iv22 == 0) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (match$iv$iv22 == 0) break;
            --endIndex$iv$iv;
        }
        if (TextUtils.isEmpty((CharSequence)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) {
            return "";
        }
        boolean preserve_linebreaks = false;
        boolean preserve_br = false;
        String blocklist = "table|thead|tfoot|caption|col|colgroup|tbody|tr|td|th|div|dl|dd|dt|ul|ol|li|pre|form|map|area|blockquote|address|math|style|p|h[1-6]|hr|fieldset|legend|section|article|aside|hgroup|header|footer|nav|figure|details|menu|summary";
        if (StringsKt.contains$default((CharSequence)html, (CharSequence)"<object", (boolean)false, (int)2, null)) {
            Pattern pattern = Pattern.compile("<object[\\s\\S]+?</object>");
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"<object[\\\\s\\\\S]+?</object>\")");
            Pattern p = pattern;
            Matcher matcher2 = p.matcher(html);
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher2, (String)"p.matcher(html)");
            Matcher m = matcher2;
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String it = html;
                $i$a$1$trim2 = m.start();
                match$iv$iv22 = m.end();
                format = this;
                stringBuffer = sb;
                matcher = m;
                String string4 = it;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring($i$a$1$trim2, match$iv$iv22), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(format.replaceAll(string3, "[\\r\\n]+", "")));
            }
            m.appendTail(sb);
            String string5 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sb.toString()");
            html = string5;
        }
        Pattern pattern = Pattern.compile("<[^<>]+>");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"<[^<>]+>\")");
        Pattern p = pattern;
        Matcher matcher3 = p.matcher(html);
        Intrinsics.checkExpressionValueIsNotNull((Object)matcher3, (String)"p.matcher(html)");
        Matcher m = matcher3;
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String it = html;
            $i$a$1$trim2 = m.start();
            match$iv$iv22 = m.end();
            format = this;
            stringBuffer = sb;
            matcher = m;
            String string6 = it;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring($i$a$1$trim2, match$iv$iv22), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(format.replaceAll(string3, "[\\r\\n]+", "")));
        }
        m.appendTail(sb);
        String string7 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"sb.toString()");
        html = string7;
        if (StringsKt.contains$default((CharSequence)html, (CharSequence)"<pre", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"<script", (boolean)false, (int)2, null)) {
            preserve_linebreaks = true;
            CharSequence it = html;
            Regex $i$a$1$trim2 = new Regex("<(pre|script)[^>]*>[\\s\\S]+?</\\1>");
            Function1 match$iv$iv22 = toCalypsoHtml.2.INSTANCE;
            html = $i$a$1$trim2.replace(it, match$iv$iv22);
        }
        if (StringsKt.contains$default((CharSequence)html, (CharSequence)"[caption' )", (boolean)false, (int)2, null)) {
            preserve_br = true;
            Pattern pattern2 = Pattern.compile("\\[caption[\\s\\S]+?\\[/caption]");
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"Pattern.compile(\"\\\\[capt\u2026n[\\\\s\\\\S]+?\\\\[/caption]\")");
            p = pattern2;
            Matcher matcher4 = p.matcher(html);
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher4, (String)"p.matcher(html)");
            m = matcher4;
            sb = new StringBuffer();
            while (m.find()) {
                int n;
                int n2;
                String content;
                String it = html;
                int $i$a$1$trim2 = m.start();
                match$iv$iv22 = m.end();
                format = this;
                stringBuffer = sb;
                matcher = m;
                String string8 = it;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring($i$a$1$trim2, match$iv$iv22);
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string3 = string9;
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(format.replaceAll(string3, "<br([^>]*)>", "<wp-temp-br$1>")));
                Pattern p2 = Pattern.compile("<[a-zA-Z0-9]+( [^<>]+)?>");
                String match$iv$iv22 = html;
                int $i$f$trim = m.start();
                int n3 = m.end();
                String string10 = match$iv$iv22;
                if (string10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string10.substring($i$f$trim, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Matcher m2 = p2.matcher(content);
                StringBuffer sb2 = new StringBuffer();
                while (m2.find()) {
                    String string11 = content;
                    n2 = m2.start();
                    n = m2.end();
                    format = this;
                    stringBuffer = sb2;
                    matcher = m2;
                    String string12 = string11;
                    if (string12 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string12.substring(n2, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(format.replace(string3, "[\\r\\n\\t]+", " ")));
                }
                m2.appendTail(sb2);
                m.appendReplacement(sb, Matcher.quoteReplacement(sb2.toString()));
                String string13 = html;
                n2 = m.start();
                n = m.end();
                format = this;
                stringBuffer = sb;
                matcher = m;
                String string14 = string13;
                if (string14 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string15 = string14.substring(n2, n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string3 = string15;
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(format.replaceAll(string3, "\\s*\\n\\s*", "<wp-temp-br />")));
            }
            m.appendTail(sb);
            String string16 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"sb.toString()");
            html = string16;
        }
        html = this.replaceAll(html, "(?i)<br ?/?>\\s*<br ?/?>", "\n\n");
        html = this.replaceAll(html, "(?i)(<(?:" + blocklist + ")(?: [^>]*)?>)", "\n$1");
        html = this.replaceAll(html, "(?i)(</(?:" + blocklist + ")>)", "$1\n\n");
        html = this.replaceAll(html, "(?i)(<!--(.*?)-->)", "\n$1\n\n");
        html = this.replaceAll(html, "(?i)<hr ?/?>", "<hr>\n\n");
        html = this.replaceAll(html, "(?i)\\s*<option", "<option");
        html = this.replaceAll(html, "(?i)</option>\\s*", "</option>");
        html = this.replaceAll(html, "\\r\\n|\\r", "\n");
        html = this.replaceAll(html, "\\n\\s*\\n+", "\n\n");
        html = this.replaceAll(html, "([\\s\\S]+?)\\n\\n", "<p>$1</p>\n");
        html = this.replaceAll(html, "(?i)<p>\\s*?</p>", "");
        html = this.replaceAll(html, "(?i)<p>\\s*(</?(?:" + blocklist + ")(?: [^>]*)?>)\\s*</p>", "$1");
        html = this.replaceAll(html, "(?i)<p>(<li.+?)</p>", "$1");
        html = this.replaceAll(html, "(?i)<p>\\s*<blockquote([^>]*)>", "<blockquote$1><p>");
        html = this.replaceAll(html, "(?i)</blockquote>\\s*</p>", "</p></blockquote>");
        html = this.replaceAll(html, "(?i)<p>\\s*(</?(?:div)(?: [^>]*)?>)", "$1<p>");
        html = this.replaceAll(html, "(?i)(</?(?:div)(?: [^>]*)?>)\\s*</p>", "</p>$1");
        html = this.replaceAll(html, "(?i)<p>\\s*(</?(?:" + blocklist + ")(?: [^>]*)?>)", "$1");
        html = this.replaceAll(html, "(?i)(</?(?:" + blocklist + ")(?: [^>]*)?>)\\s*</p>", "$1");
        html = this.replaceAll(html, "(?i)\\s*\\n", "<br>\n");
        html = this.replaceAll(html, "(?i)(</?(?:" + blocklist + ")[^>]*>)\\s*<br ?/?>", "$1");
        html = this.replaceAll(html, "(?i)<br ?/?>(\\s*</?(?:p|li|div|dl|dd|dt|th|pre|td|ul|ol)>)", "$1");
        html = this.replaceAll(html, "(?i)(?:<p>|<br ?/?>)*\\s*\\[caption([^\\[]+)\\[/caption\\]\\s*(?:</p>|<br ?/?>)*", "[caption$1[/caption]");
        if (preserve_linebreaks) {
            html = this.replaceAll(html, "<wp-line-break>", "<br>");
        }
        if (preserve_br) {
            html = this.replaceAll(html, "<wp-temp-br([^>]*)>", "<br$1>");
        }
        String string17 = string2 = StringsKt.replace$default((String)html, (String)"\n", (String)"", (boolean)false, (int)4, null);
        if (string17 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string17)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void preProcessSpannedText(@NotNull SpannableStringBuilder text, boolean isCalypsoFormat) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (isCalypsoFormat) {
            void $receiver$iv$iv;
            Object $receiver$iv;
            Object[] objectArray = text.getSpans(0, text.length(), AztecVisualLinebreak.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"text.getSpans(0, text.le\u2026ualLinebreak::class.java)");
            for (Object element$iv : $receiver$iv = objectArray) {
                Object[] objectArray2;
                AztecVisualLinebreak it = (AztecVisualLinebreak)element$iv;
                int spanStart = text.getSpanStart((Object)it);
                int spanEnd = text.getSpanEnd((Object)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)text.getSpans(spanStart, spanEnd, ParagraphSpan.class), (String)"text.getSpans(spanStart,\u2026aragraphSpan::class.java)");
                Object[] objectArray3 = objectArray2;
                if (!(!(objectArray3.length == 0))) continue;
                text.setSpan((Object)new EndOfParagraphMarker(0, 1, null), spanEnd, spanEnd + 1, 33);
            }
            Object[] objectArray4 = text.getSpans(0, text.length(), ParagraphSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray4, (String)"text.getSpans(0, text.le\u2026aragraphSpan::class.java)");
            $receiver$iv = objectArray4;
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                ParagraphSpan it = (ParagraphSpan)element$iv$iv;
                if (!it.getAttributes().isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                ParagraphSpan it = (ParagraphSpan)element$iv;
                text.removeSpan((Object)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void postProcessSpannedText(@NotNull SpannableStringBuilder text, boolean isCalypsoFormat) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (isCalypsoFormat) {
            void $receiver$iv$iv;
            Object it;
            Object object;
            Object[] spans = (EndOfParagraphMarker[])text.getSpans(0, text.length(), EndOfParagraphMarker.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            Object $receiver$iv = spans;
            if (((EndOfParagraphMarker[])$receiver$iv).length > 1) {
                object = $receiver$iv;
                Comparator comparator = new Comparator<T>(text){
                    final /* synthetic */ SpannableStringBuilder $text$inlined;
                    {
                        this.$text$inlined = spannableStringBuilder;
                    }

                    public final int compare(T a, T b) {
                        EndOfParagraphMarker it = (EndOfParagraphMarker)b;
                        Comparable comparable = Integer.valueOf(this.$text$inlined.getSpanStart((Object)it));
                        it = (EndOfParagraphMarker)a;
                        Comparable comparable2 = comparable;
                        Integer n = this.$text$inlined.getSpanStart((Object)it);
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                ArraysKt.sortWith((Object[])object, (Comparator)comparator);
            }
            object = $receiver$iv = spans;
            int n = ((EndOfParagraphMarker[])object).length;
            for (int $i$f$sortByDescending = 0; $i$f$sortByDescending < n; ++$i$f$sortByDescending) {
                IAztecParagraphStyle it2;
                Object[] $receiver$iv$iv2;
                Collection destination$iv$iv;
                Object[] $receiver$iv2;
                Object element$iv;
                it = element$iv = object[$i$f$sortByDescending];
                int spanStart = text.getSpanStart(it);
                int spanEnd = text.getSpanEnd(it);
                if (text.charAt(spanStart) == '\n') {
                    Intrinsics.checkExpressionValueIsNotNull((Object)text.getSpans(spanEnd, spanEnd + 1, IAztecParagraphStyle.class), (String)"text.getSpans(spanEnd, s\u2026ragraphStyle::class.java)");
                    Object[] objectArray = $receiver$iv2;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv2) {
                        it2 = (IAztecParagraphStyle)element$iv$iv;
                        if (!((!(it2 instanceof ParagraphSpan) || !it2.getAttributes().isEmpty()) && text.getSpanStart((Object)it2) == spanEnd)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    if (((List)destination$iv$iv).isEmpty()) {
                        text.insert(spanEnd, (CharSequence)"\n");
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)text.getSpans(spanStart, spanEnd, AztecQuoteSpan.class), (String)"text.getSpans(spanStart,\u2026tecQuoteSpan::class.java)");
                $receiver$iv$iv2 = $receiver$iv2;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    it2 = (AztecQuoteSpan)element$iv$iv;
                    if (!(text.getSpanEnd((Object)it2) == spanEnd)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                if (!((List)destination$iv$iv).isEmpty()) continue;
                Object[] objectArray = text.getSpans(spanStart, spanEnd, ParagraphSpan.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"text.getSpans(spanStart,\u2026aragraphSpan::class.java)");
                $receiver$iv2 = objectArray;
                $receiver$iv$iv2 = $receiver$iv2;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    it2 = (ParagraphSpan)element$iv$iv;
                    if (!(!((ParagraphSpan)it2).getAttributes().isEmpty())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                if (!((List)destination$iv$iv).isEmpty()) continue;
                Object[] objectArray2 = text.getSpans(spanStart, spanEnd, AztecVisualLinebreak.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"text.getSpans(spanStart,\u2026ualLinebreak::class.java)");
                $receiver$iv$iv2 = $receiver$iv2 = objectArray2;
                int destination$iv$iv2 = $receiver$iv$iv2.length;
                for (int i = 0; i < destination$iv$iv2; ++i) {
                    Object element$iv2 = $receiver$iv$iv2[i];
                    AztecVisualLinebreak it3 = (AztecVisualLinebreak)element$iv2;
                    text.removeSpan((Object)it3);
                }
            }
            Object[] objectArray = text.getSpans(0, text.length(), ParagraphSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"text.getSpans(0, text.le\u2026aragraphSpan::class.java)");
            $receiver$iv = objectArray;
            for (Object element$iv : $receiver$iv) {
                it = (ParagraphSpan)element$iv;
                int start = text.getSpanStart(it);
                int end = text.getSpanEnd(it);
                int n2 = StringsKt.indexOf$default((CharSequence)((CharSequence)text), (String)"\n\n", (int)start, (boolean)false, (int)4, null);
                if (n2 == -1 || n2 >= end) continue;
                text.setSpan(it, start, n2 + 1, text.getSpanFlags(it));
                text.setSpan((Object)new AztecVisualLinebreak(), n2 + 1, n2 + 2, text.getSpanFlags(it));
            }
            Object[] objectArray3 = text.getSpans(0, text.length(), ParagraphSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray3, (String)"text.getSpans(0, text.le\u2026aragraphSpan::class.java)");
            $receiver$iv = objectArray3;
            object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                ParagraphSpan it4 = (ParagraphSpan)element$iv$iv;
                if (!(it4.getAttributes().isEmpty() && it4.getAlign() == null || text.getSpanStart((Object)it4) == text.getSpanEnd((Object)it4) - 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                ParagraphSpan it5 = (ParagraphSpan)element$iv;
                text.removeSpan((Object)it5);
            }
        }
    }

    private final String replace(String content, String pattern, String replacement) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        String string2 = m.replaceFirst(replacement);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"m.replaceFirst(replacement)");
        return string2;
    }

    private Format() {
    }

    static {
        Format format;
        INSTANCE = format = new Format();
        block = block;
        iframePlaceholder = iframePlaceholder;
    }

    @NotNull
    public static final /* synthetic */ String access$replaceAll(Format $this, @NotNull String content, @NotNull String pattern, @NotNull String replacement) {
        return $this.replaceAll(content, pattern, replacement);
    }
}

