/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.toolbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;
import android.widget.ToggleButton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.R;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0012\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/wordpress/aztec/toolbar/RippleToggleButton;", "Landroid/widget/ToggleButton;", "Landroid/view/View$OnLongClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mAnimationIsRunning", "", "mFillPaint", "Landroid/graphics/Paint;", "mHalfWidth", "", "mStrokePaint", "mTimer", "draw", "", "canvas", "Landroid/graphics/Canvas;", "init", "onLongClick", "view", "Landroid/view/View;", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "startRippleAnimation", "Companion", "aztec_release"})
public final class RippleToggleButton
extends ToggleButton
implements View.OnLongClickListener {
    private float mHalfWidth;
    private boolean mAnimationIsRunning;
    private int mTimer;
    private Paint mFillPaint;
    private Paint mStrokePaint;
    private static final int FRAME_RATE = 10;
    private static final int DURATION = 250;
    private static final int FILL_INITIAL_OPACITY = 200;
    private static final int STROKE_INITIAL_OPACITY = 255;
    public static final Companion Companion = new Companion(null);

    private final void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.setOnLongClickListener(this);
        int rippleColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.format_bar_ripple_animation);
        Paint paint = this.mFillPaint = new Paint();
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setAntiAlias(true);
        Paint paint2 = this.mFillPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setColor(rippleColor);
        Paint paint3 = this.mFillPaint;
        if (paint3 == null) {
            Intrinsics.throwNpe();
        }
        paint3.setStyle(Paint.Style.FILL);
        Paint paint4 = this.mFillPaint;
        if (paint4 == null) {
            Intrinsics.throwNpe();
        }
        paint4.setAlpha(FILL_INITIAL_OPACITY);
        Paint paint5 = this.mStrokePaint = new Paint();
        if (paint5 == null) {
            Intrinsics.throwNpe();
        }
        paint5.setAntiAlias(true);
        Paint paint6 = this.mStrokePaint;
        if (paint6 == null) {
            Intrinsics.throwNpe();
        }
        paint6.setColor(rippleColor);
        Paint paint7 = this.mStrokePaint;
        if (paint7 == null) {
            Intrinsics.throwNpe();
        }
        paint7.setStyle(Paint.Style.STROKE);
        Paint paint8 = this.mStrokePaint;
        if (paint8 == null) {
            Intrinsics.throwNpe();
        }
        paint8.setStrokeWidth(2.0f);
        Paint paint9 = this.mStrokePaint;
        if (paint9 == null) {
            Intrinsics.throwNpe();
        }
        paint9.setAlpha(STROKE_INITIAL_OPACITY);
        this.setWillNotDraw(false);
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.draw(canvas);
        if (this.mAnimationIsRunning) {
            if (DURATION <= this.mTimer * FRAME_RATE) {
                this.mAnimationIsRunning = false;
                this.mTimer = 0;
            } else {
                float progressFraction = (float)this.mTimer * (float)FRAME_RATE / (float)DURATION;
                Paint paint = this.mFillPaint;
                if (paint == null) {
                    Intrinsics.throwNpe();
                }
                paint.setAlpha((int)((float)FILL_INITIAL_OPACITY * (1.0f - progressFraction)));
                Paint paint2 = this.mStrokePaint;
                if (paint2 == null) {
                    Intrinsics.throwNpe();
                }
                paint2.setAlpha((int)((float)STROKE_INITIAL_OPACITY * (1.0f - progressFraction)));
                Paint paint3 = this.mFillPaint;
                if (paint3 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(this.mHalfWidth, this.mHalfWidth, this.mHalfWidth * progressFraction, paint3);
                Paint paint4 = this.mStrokePaint;
                if (paint4 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawCircle(this.mHalfWidth, this.mHalfWidth, this.mHalfWidth * progressFraction, paint4);
                int n = this.mTimer;
                this.mTimer = n + 1;
            }
            this.invalidate();
        }
    }

    public boolean onLongClick(@Nullable View view) {
        if (this.getContentDescription() == null || StringsKt.equals((String)((Object)this.getContentDescription()).toString(), (String)"", (boolean)true)) {
            return false;
        }
        Toast.makeText((Context)this.getContext(), (CharSequence)this.getContentDescription(), (int)0).show();
        return true;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.startRippleAnimation();
        return super.onTouchEvent(event);
    }

    private final void startRippleAnimation() {
        if (this.isEnabled() && !this.mAnimationIsRunning) {
            this.mHalfWidth = this.getMeasuredWidth() / 2;
            this.mAnimationIsRunning = true;
            this.invalidate();
        }
    }

    public RippleToggleButton(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.init();
    }

    public RippleToggleButton(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.init();
    }

    public RippleToggleButton(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.init();
    }

    static {
        FRAME_RATE = 10;
        DURATION = 250;
        FILL_INITIAL_OPACITY = 200;
        STROKE_INITIAL_OPACITY = 255;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/wordpress/aztec/toolbar/RippleToggleButton$Companion;", "", "()V", "DURATION", "", "FILL_INITIAL_OPACITY", "FRAME_RATE", "STROKE_INITIAL_OPACITY", "aztec_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

