/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.view.Gravity;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.spans.AztecDynamicImageSpan;
import org.wordpress.aztec.spans.IAztecAttributedSpan;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\u001dH\u0002J\u0006\u0010\"\u001a\u00020\u001fJP\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u000fH\u0016J\u0006\u00102\u001a\u00020\u000fJ\b\u00103\u001a\u00020\u001fH&J\u0006\u00104\u001a\u00020\u001fJ \u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u001d2\b\u00107\u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\u001dJ\u0016\u00108\u001a\u0002092\u0006\u00106\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u001dR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/wordpress/aztec/spans/AztecMediaSpan;", "Lorg/wordpress/aztec/spans/AztecDynamicImageSpan;", "Lorg/wordpress/aztec/spans/IAztecAttributedSpan;", "context", "Landroid/content/Context;", "drawable", "Landroid/graphics/drawable/Drawable;", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "onMediaDeletedListener", "Lorg/wordpress/aztec/AztecText$OnMediaDeletedListener;", "editor", "Lorg/wordpress/aztec/AztecText;", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;Lorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/AztecText$OnMediaDeletedListener;Lorg/wordpress/aztec/AztecText;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getAttributes", "()Lorg/wordpress/aztec/AztecAttributes;", "setAttributes", "(Lorg/wordpress/aztec/AztecAttributes;)V", "getOnMediaDeletedListener", "()Lorg/wordpress/aztec/AztecText$OnMediaDeletedListener;", "setOnMediaDeletedListener", "(Lorg/wordpress/aztec/AztecText$OnMediaDeletedListener;)V", "overlays", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "applyOverlayGravity", "", "overlay", "gravity", "clearOverlays", "draw", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getHtml", "getSource", "onClick", "onMediaDeleted", "setOverlay", "index", "newDrawable", "setOverlayLevel", "", "level", "aztec_release"})
public abstract class AztecMediaSpan
extends AztecDynamicImageSpan
implements IAztecAttributedSpan {
    private final ArrayList<Pair<Drawable, Integer>> overlays;
    @NotNull
    private AztecAttributes attributes;
    @Nullable
    private AztecText.OnMediaDeletedListener onMediaDeletedListener;

    @NotNull
    public abstract String getTAG();

    public final void setOverlay(int index, @Nullable Drawable newDrawable, int gravity) {
        if (CollectionsKt.getLastIndex((List)this.overlays) >= index) {
            this.overlays.remove(index);
        }
        if (newDrawable != null) {
            this.overlays.ensureCapacity(index + 1);
            this.overlays.add(index, (Pair<Drawable, Integer>)new Pair((Object)newDrawable, (Object)gravity));
            AztecDynamicImageSpan.Companion.setInitBounds(newDrawable);
        }
    }

    public final void clearOverlays() {
        this.overlays.clear();
    }

    public final boolean setOverlayLevel(int index, int level) {
        Pair pair = (Pair)CollectionsKt.getOrNull((List)this.overlays, (int)index);
        return pair != null && (pair = (Drawable)pair.getFirst()) != null ? pair.setLevel(level) : false;
    }

    private final void applyOverlayGravity(Drawable overlay, int gravity) {
        if (this.getImageDrawable() != null && overlay != null) {
            Drawable drawable2 = this.getImageDrawable();
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            int n = drawable2.getBounds().width();
            Drawable drawable3 = this.getImageDrawable();
            if (drawable3 == null) {
                Intrinsics.throwNpe();
            }
            Rect rect = new Rect(0, 0, n, drawable3.getBounds().height());
            Rect outRect = new Rect();
            Gravity.apply((int)gravity, (int)overlay.getBounds().width(), (int)overlay.getBounds().height(), (Rect)rect, (Rect)outRect);
            overlay.setBounds(outRect.left, outRect.top, outRect.right, outRect.bottom);
        }
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Pair it;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.save();
        if (this.getImageDrawable() != null) {
            int transY = top;
            if (this.mVerticalAlignment == 1) {
                transY -= paint.getFontMetricsInt().descent;
            }
            canvas.translate(x, (float)transY);
            Drawable drawable2 = this.getImageDrawable();
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            drawable2.draw(canvas);
        }
        Iterable $receiver$iv = this.overlays;
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            this.applyOverlayGravity((Drawable)it.getFirst(), ((Number)it.getSecond()).intValue());
        }
        $receiver$iv = this.overlays;
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            Drawable drawable3 = (Drawable)it.getFirst();
            if (drawable3 == null) continue;
            drawable3.draw(canvas);
        }
        canvas.restore();
    }

    @NotNull
    public String getHtml() {
        StringBuilder sb = new StringBuilder('<' + this.getTAG() + ' ');
        this.getAttributes().removeAttribute("aztec_id");
        sb.append(this.getAttributes());
        StringsKt.trim((CharSequence)sb);
        sb.append(" />");
        String string2 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
        return string2;
    }

    @NotNull
    public final String getSource() {
        String string2 = this.getAttributes().getValue("src");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public abstract void onClick();

    public final void onMediaDeleted() {
        block0: {
            AztecText.OnMediaDeletedListener onMediaDeletedListener = this.onMediaDeletedListener;
            if (onMediaDeletedListener == null) break block0;
            onMediaDeletedListener.onMediaDeleted(this.getAttributes());
        }
    }

    @Override
    @NotNull
    public AztecAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AztecAttributes aztecAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)aztecAttributes, (String)"<set-?>");
        this.attributes = aztecAttributes;
    }

    @Nullable
    public final AztecText.OnMediaDeletedListener getOnMediaDeletedListener() {
        return this.onMediaDeletedListener;
    }

    public final void setOnMediaDeletedListener(@Nullable AztecText.OnMediaDeletedListener onMediaDeletedListener) {
        this.onMediaDeletedListener = onMediaDeletedListener;
    }

    public AztecMediaSpan(@NotNull Context context, @Nullable Drawable drawable2, @NotNull AztecAttributes attributes, @Nullable AztecText.OnMediaDeletedListener onMediaDeletedListener, @Nullable AztecText editor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        super(context, drawable2);
        this.attributes = attributes;
        this.onMediaDeletedListener = onMediaDeletedListener;
        this.overlays = new ArrayList();
        this.setTextView(editor);
    }

    public /* synthetic */ AztecMediaSpan(Context context, Drawable drawable2, AztecAttributes aztecAttributes, AztecText.OnMediaDeletedListener onMediaDeletedListener, AztecText aztecText, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        if ((n & 8) != 0) {
            onMediaDeletedListener = null;
        }
        if ((n & 0x10) != 0) {
            aztecText = null;
        }
        this(context, drawable2, aztecAttributes, onMediaDeletedListener, aztecText);
    }

    @Override
    public void applyInlineStyleAttributes(@NotNull Editable output, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        IAztecAttributedSpan.DefaultImpls.applyInlineStyleAttributes(this, output, start, end);
    }
}

