/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.util;

import android.text.Spannable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.android.util.AppLog;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000  *\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001 B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001c\u001a\u00020\u001dJ-\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001fR$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001c\u0010\u0005\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\n\"\u0004\b\u001b\u0010\f\u00a8\u0006!"}, d2={"Lorg/wordpress/aztec/util/SpanWrapper;", "T", "", "spannable", "Landroid/text/Spannable;", "span", "(Landroid/text/Spannable;Ljava/lang/Object;)V", "end", "", "getEnd", "()I", "setEnd", "(I)V", "flags", "getFlags", "setFlags", "getSpan", "()Ljava/lang/Object;", "setSpan", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getSpannable", "()Landroid/text/Spannable;", "setSpannable", "(Landroid/text/Spannable;)V", "start", "getStart", "setStart", "remove", "", "setSpanOrLogError", "(Ljava/lang/Object;III)V", "Companion", "aztec_release"})
public final class SpanWrapper<T> {
    @NotNull
    private Spannable spannable;
    private T span;
    private static final int START_MASK = 240;
    private static final int END_MASK = 15;
    private static final int START_SHIFT = 4;
    private static final int PARAGRAPH = 3;
    public static final Companion Companion = new Companion(null);

    public final void remove() {
        this.spannable.removeSpan(this.span);
    }

    public final int getStart() {
        return this.spannable.getSpanStart(this.span);
    }

    public final void setStart(int start) {
        this.setSpanOrLogError(this.span, start, this.getEnd(), this.getFlags());
    }

    public final int getEnd() {
        return this.spannable.getSpanEnd(this.span);
    }

    public final void setEnd(int end) {
        this.setSpanOrLogError(this.span, this.getStart(), end, this.getFlags());
    }

    public final int getFlags() {
        return this.spannable.getSpanFlags(this.span);
    }

    public final void setFlags(int flags) {
        this.setSpanOrLogError(this.span, this.getStart(), this.getEnd(), flags);
    }

    private final void setSpanOrLogError(T span, int start, int end, int flags) {
        if (Companion.isInvalidParagraph(this.spannable, start, end, flags)) {
            return;
        }
        this.spannable.setSpan(span, start, end, flags);
    }

    @NotNull
    public final Spannable getSpannable() {
        return this.spannable;
    }

    public final void setSpannable(@NotNull Spannable spannable) {
        Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"<set-?>");
        this.spannable = spannable;
    }

    public final T getSpan() {
        return this.span;
    }

    public final void setSpan(T t) {
        this.span = t;
    }

    public SpanWrapper(@NotNull Spannable spannable, T span) {
        Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
        this.spannable = spannable;
        this.span = span;
    }

    static {
        START_MASK = 240;
        END_MASK = 15;
        START_SHIFT = 4;
        PARAGRAPH = 3;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\u000e\"\u0004\b\u0001\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014\u00a2\u0006\u0002\u0010\u0015J9\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\u000e\"\n\b\u0001\u0010\u0010\u0018\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0086\bJ>\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\u000e\"\u0004\b\u0001\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/wordpress/aztec/util/SpanWrapper$Companion;", "", "()V", "END_MASK", "", "getEND_MASK", "()I", "PARAGRAPH", "getPARAGRAPH", "START_MASK", "getSTART_MASK", "START_SHIFT", "getSTART_SHIFT", "getSpans", "", "Lorg/wordpress/aztec/util/SpanWrapper;", "T", "spannable", "Landroid/text/Spannable;", "spanObjects", "", "(Landroid/text/Spannable;[Ljava/lang/Object;)Ljava/util/List;", "start", "end", "type", "Ljava/lang/Class;", "isInvalidParagraph", "", "index", "flag", "flags", "aztec_release"})
    public static final class Companion {
        private final int getSTART_MASK() {
            return START_MASK;
        }

        private final int getEND_MASK() {
            return END_MASK;
        }

        private final int getSTART_SHIFT() {
            return START_SHIFT;
        }

        private final int getPARAGRAPH() {
            return PARAGRAPH;
        }

        public final boolean isInvalidParagraph(@NotNull Spannable spannable, int start, int end, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
            int flagsStart = (flags & this.getSTART_MASK()) >> this.getSTART_SHIFT();
            if (this.isInvalidParagraph(spannable, start, flagsStart)) {
                AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)("PARAGRAPH span must start at paragraph boundary (" + start + " follows " + spannable.charAt(start - 1) + ")"));
                return true;
            }
            int flagsEnd = flags & this.getEND_MASK();
            if (this.isInvalidParagraph(spannable, end, flagsEnd)) {
                AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)("PARAGRAPH span must end at paragraph boundary (" + end + " follows " + spannable.charAt(end - 1) + ")"));
                return true;
            }
            return false;
        }

        private final boolean isInvalidParagraph(Spannable spannable, int index, int flag) {
            return flag == this.getPARAGRAPH() && index != 0 && index != spannable.length() && spannable.charAt(index - 1) != '\n';
        }

        private final <T> List<SpanWrapper<T>> getSpans(Spannable spannable, int start, int end) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object[] objectArray = spannable.getSpans(start, end, Object.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"spannable.getSpans(start, end, T::class.java)");
            return this.getSpans(spannable, objectArray);
        }

        @NotNull
        public final <T> List<SpanWrapper<T>> getSpans(@NotNull Spannable spannable, int start, int end, @NotNull Class<T> type) {
            Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Object[] objectArray = spannable.getSpans(start, end, type);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"spannable.getSpans(start, end, type)");
            return this.getSpans(spannable, objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T> List<SpanWrapper<T>> getSpans(@NotNull Spannable spannable, @NotNull T[] spanObjects) {
            void $receiver$iv$iv;
            T[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
            Intrinsics.checkParameterIsNotNull(spanObjects, (String)"spanObjects");
            T[] TArray = $receiver$iv = spanObjects;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            int n = ((void)$receiver$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $receiver$iv$iv[i];
                Collection collection = destination$iv$iv;
                SpanWrapper<void> spanWrapper = new SpanWrapper<void>(spannable, it);
                collection.add(spanWrapper);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

