/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.Spannable;
import android.text.TextWatcher;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.spans.IAztecInlineSpan;
import org.wordpress.aztec.watchers.TextChangedEvent;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0016J(\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\u0016H\u0002J(\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/wordpress/aztec/watchers/SuggestionWatcher;", "Landroid/text/TextWatcher;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "(Lorg/wordpress/aztec/AztecText;)V", "aztecTextRef", "Ljava/lang/ref/WeakReference;", "beforeAfter", "", "carryOverSpans", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/watchers/SuggestionWatcher$CarryOverSpan;", "frameworkEvent", "", "isRestoringSuggestedText", "previousCount", "previousInputEventWasRegular", "previousInputWasSuggestion", "previousStart", "textChangedEventDetails", "Lorg/wordpress/aztec/watchers/TextChangedEvent;", "afterTextChanged", "", "text", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "carryOverInlineSpans", "editableText", "Landroid/text/Spannable;", "clearCarriedOverSpans", "onTextChanged", "before", "reapplyCarriedOverInlineSpans", "CarryOverSpan", "Companion", "aztec_release"})
public final class SuggestionWatcher
implements TextWatcher {
    private final WeakReference<AztecText> aztecTextRef;
    private TextChangedEvent textChangedEventDetails;
    private final ArrayList<CarryOverSpan> carryOverSpans;
    private boolean isRestoringSuggestedText;
    private boolean frameworkEvent;
    private boolean previousInputWasSuggestion;
    private boolean previousInputEventWasRegular;
    private int previousStart;
    private int previousCount;
    private int beforeAfter;
    public static final Companion Companion = new Companion(null);

    public void beforeTextChanged(@NotNull CharSequence text, int start, int count, int after) {
        block12: {
            block11: {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                AztecText aztecText = (AztecText)this.aztecTextRef.get();
                if (aztecText == null) break block11;
                if (aztecText.isTextChangedListenerDisabled()) break block11;
                if (text instanceof Spannable) break block12;
            }
            return;
        }
        this.textChangedEventDetails = new TextChangedEvent(((Object)text).toString(), false, 0, 6, null);
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        Integer selectionStart = aztecText != null ? Integer.valueOf(aztecText.getSelectionStart()) : null;
        AztecText aztecText2 = (AztecText)this.aztecTextRef.get();
        Integer selectionEnd = aztecText2 != null ? Integer.valueOf(aztecText2.getSelectionEnd()) : null;
        boolean isMultiSelection = Intrinsics.areEqual((Object)selectionStart, (Object)selectionEnd) ^ true;
        Integer n = selectionStart;
        int n2 = start + 1;
        this.frameworkEvent = (n == null || n != n2) && after == 0 && !isMultiSelection && count > 1;
        boolean bl = this.isRestoringSuggestedText = this.previousStart == start && this.previousCount == after && this.previousInputWasSuggestion;
        if (!(this.frameworkEvent || this.isRestoringSuggestedText || isMultiSelection)) {
            AztecText aztecText3 = (AztecText)this.aztecTextRef.get();
            if (aztecText3 != null) {
                aztecText3.enableOnSelectionListener();
            }
            this.clearCarriedOverSpans();
            this.carryOverInlineSpans((Spannable)text, start, count, after);
            this.previousInputEventWasRegular = true;
        } else if (this.frameworkEvent && this.previousInputEventWasRegular) {
            AztecText aztecText4 = (AztecText)this.aztecTextRef.get();
            if (aztecText4 != null) {
                aztecText4.disableOnSelectionListener();
            }
            this.carryOverInlineSpans((Spannable)text, start, count, after);
            this.previousInputEventWasRegular = false;
        } else if (this.isRestoringSuggestedText) {
            AztecText aztecText5 = (AztecText)this.aztecTextRef.get();
            if (aztecText5 != null) {
                aztecText5.disableInlineTextHandling();
            }
            this.previousInputEventWasRegular = false;
        }
        this.previousStart = start;
        this.previousCount = count;
        this.beforeAfter = after;
    }

    public void onTextChanged(@NotNull CharSequence text, int start, int before, int count) {
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                AztecText aztecText = (AztecText)this.aztecTextRef.get();
                if (aztecText == null) break block5;
                if (aztecText.isTextChangedListenerDisabled()) break block5;
                if (text instanceof Spannable) break block6;
            }
            return;
        }
        this.textChangedEventDetails.setBefore(before);
        this.textChangedEventDetails.setText(text);
        this.textChangedEventDetails.setCountOfCharacters(count);
        this.textChangedEventDetails.setStart(start);
        this.textChangedEventDetails.initialize();
        if (!this.frameworkEvent && this.carryOverSpans.size() > 0) {
            this.reapplyCarriedOverInlineSpans((Spannable)text);
        }
        if (this.isRestoringSuggestedText) {
            this.clearCarriedOverSpans();
        }
    }

    public void afterTextChanged(@NotNull Editable text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        if (aztecText == null || aztecText.isTextChangedListenerDisabled()) {
            return;
        }
        if (this.isRestoringSuggestedText) {
            this.isRestoringSuggestedText = false;
            AztecText aztecText2 = (AztecText)this.aztecTextRef.get();
            if (aztecText2 != null) {
                aztecText2.enableOnSelectionListener();
            }
            AztecText aztecText3 = (AztecText)this.aztecTextRef.get();
            if (aztecText3 != null) {
                aztecText3.disableInlineTextHandling();
            }
        }
        this.previousInputWasSuggestion = this.frameworkEvent;
    }

    private final void clearCarriedOverSpans() {
        this.carryOverSpans.clear();
    }

    private final void carryOverInlineSpans(Spannable editableText, int start, int count, int after) {
        block7: {
            int charsAdded;
            block6: {
                boolean isAddingCharacters;
                charsAdded = after - count;
                boolean bl = isAddingCharacters = charsAdded >= 0 && count > 0;
                if (!isAddingCharacters) break block6;
                Object[] objectArray = editableText.getSpans(start, start + count, IAztecInlineSpan.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026ecInlineSpan::class.java)");
                Object[] $receiver$iv = objectArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                    int spanStart = editableText.getSpanStart((Object)it);
                    int spanEnd = editableText.getSpanEnd((Object)it);
                    IAztecInlineSpan iAztecInlineSpan = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                    this.carryOverSpans.add(new CarryOverSpan(iAztecInlineSpan, spanStart, spanEnd));
                }
                break block7;
            }
            if (charsAdded >= 0 || count <= 0) break block7;
            if (count - after <= 1) {
                Object[] objectArray = editableText.getSpans(start, start + after, IAztecInlineSpan.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026ecInlineSpan::class.java)");
                Object[] $receiver$iv = objectArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                    int spanStart = editableText.getSpanStart((Object)it);
                    int spanEnd = editableText.getSpanEnd((Object)it);
                    if ((start != spanEnd || editableText.charAt(start) != ' ') && start + after < spanEnd && start < spanEnd && count - after == 1) {
                        --spanEnd;
                    }
                    IAztecInlineSpan iAztecInlineSpan = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                    this.carryOverSpans.add(new CarryOverSpan(iAztecInlineSpan, spanStart, spanEnd));
                }
            } else {
                Object[] objectArray = editableText.getSpans(start, start + count, IAztecInlineSpan.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026ecInlineSpan::class.java)");
                Object[] $receiver$iv = objectArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                    boolean replacingDoubleSpaceDot = count == 2 && editableText.charAt(start) == ' ' && editableText.charAt(start + 1) == ' ';
                    int spanStart = editableText.getSpanStart((Object)it);
                    int spanEnd = editableText.getSpanEnd((Object)it) >= start + count && !replacingDoubleSpaceDot ? editableText.getSpanEnd((Object)it) - (count - after) : editableText.getSpanEnd((Object)it);
                    IAztecInlineSpan iAztecInlineSpan = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                    this.carryOverSpans.add(new CarryOverSpan(iAztecInlineSpan, spanStart, spanEnd));
                }
            }
        }
    }

    private final void reapplyCarriedOverInlineSpans(Spannable editableText) {
        Iterable $receiver$iv = this.carryOverSpans;
        for (Object element$iv : $receiver$iv) {
            CarryOverSpan it = (CarryOverSpan)element$iv;
            if (it.getStart() < 0 || it.getEnd() > editableText.length() || it.getStart() >= it.getEnd()) continue;
            editableText.setSpan((Object)it.getSpan(), it.getStart(), it.getEnd(), 33);
        }
    }

    public SuggestionWatcher(@NotNull AztecText aztecText) {
        Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
        this.aztecTextRef = new WeakReference<AztecText>(aztecText);
        this.textChangedEventDetails = new TextChangedEvent("", 0, 0, 0);
        this.carryOverSpans = new ArrayList();
        this.previousStart = -1;
        this.previousCount = -1;
        this.beforeAfter = -1;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/wordpress/aztec/watchers/SuggestionWatcher$CarryOverSpan;", "", "span", "Lorg/wordpress/aztec/spans/IAztecInlineSpan;", "start", "", "end", "(Lorg/wordpress/aztec/spans/IAztecInlineSpan;II)V", "getEnd", "()I", "getSpan", "()Lorg/wordpress/aztec/spans/IAztecInlineSpan;", "getStart", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class CarryOverSpan {
        @NotNull
        private final IAztecInlineSpan span;
        private final int start;
        private final int end;

        @NotNull
        public final IAztecInlineSpan getSpan() {
            return this.span;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public CarryOverSpan(@NotNull IAztecInlineSpan span, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
            this.span = span;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public final IAztecInlineSpan component1() {
            return this.span;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final CarryOverSpan copy(@NotNull IAztecInlineSpan span, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
            return new CarryOverSpan(span, start, end);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CarryOverSpan copy$default(CarryOverSpan carryOverSpan, IAztecInlineSpan iAztecInlineSpan, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                iAztecInlineSpan = carryOverSpan.span;
            }
            if ((n3 & 2) != 0) {
                n = carryOverSpan.start;
            }
            if ((n3 & 4) != 0) {
                n2 = carryOverSpan.end;
            }
            return carryOverSpan.copy(iAztecInlineSpan, n, n2);
        }

        public String toString() {
            return "CarryOverSpan(span=" + this.span + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            IAztecInlineSpan iAztecInlineSpan = this.span;
            return ((iAztecInlineSpan != null ? iAztecInlineSpan.hashCode() : 0) * 31 + this.start) * 31 + this.end;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CarryOverSpan)) break block3;
                    CarryOverSpan carryOverSpan = (CarryOverSpan)object;
                    if (!Intrinsics.areEqual((Object)this.span, (Object)carryOverSpan.span) || !(this.start == carryOverSpan.start) || !(this.end == carryOverSpan.end)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/wordpress/aztec/watchers/SuggestionWatcher$Companion;", "", "()V", "install", "", "text", "Lorg/wordpress/aztec/AztecText;", "aztec_release"})
    public static final class Companion {
        public final void install(@NotNull AztecText text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            text.addTextChangedListener(new SuggestionWatcher(text));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

