/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecTagHandler;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.plugins.IAztecPlugin;
import org.wordpress.aztec.plugins.html2visual.ISpanPostprocessor;
import org.wordpress.aztec.plugins.visual2html.IHtmlPostprocessor;
import org.wordpress.aztec.plugins.visual2html.IInlineSpanHandler;
import org.wordpress.aztec.plugins.visual2html.ISpanPreprocessor;
import org.wordpress.aztec.spans.AztecCursorSpan;
import org.wordpress.aztec.spans.AztecHorizontalRuleSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecURLSpan;
import org.wordpress.aztec.spans.AztecVisualLinebreak;
import org.wordpress.aztec.spans.CommentSpan;
import org.wordpress.aztec.spans.HiddenHtmlSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.IAztecFullWidthImageSpan;
import org.wordpress.aztec.spans.IAztecInlineSpan;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.spans.IAztecSpan;
import org.wordpress.aztec.spans.IAztecSurroundedWithNewlines;
import org.wordpress.aztec.spans.UnknownHtmlSpan;
import org.wordpress.aztec.util.SpanWrapper;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\r\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010\r\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017H\u0002J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\r\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010'\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010)\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001fH\u0002J\u0018\u0010,\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001cH\u0002J<\u00100\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\r\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00172\u000e\u00103\u001a\n\u0012\u0004\u0012\u000205\u0018\u000104H\u0002J\u001c\u00106\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\r\u001a\u00020\u001cH\u0002JD\u00106\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\r\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00172\u000e\u00107\u001a\n\u0012\u0004\u0012\u000205\u0018\u0001042\u0006\u00108\u001a\u00020\u0017H\u0002JL\u00109\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\r\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00172\u0006\u0010:\u001a\u00020;2\u000e\u00103\u001a\n\u0012\u0004\u0012\u000205\u0018\u0001042\u0006\u00108\u001a\u00020\u0017H\u0002JD\u0010<\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\r\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u00172\u000e\u00103\u001a\n\u0012\u0004\u0012\u000205\u0018\u000104H\u0002J4\u0010>\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\r\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u0017H\u0002J4\u0010?\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\r\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00172\u0006\u0010@\u001a\u00020AH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006B"}, d2={"Lorg/wordpress/aztec/AztecParser;", "", "plugins", "", "Lorg/wordpress/aztec/plugins/IAztecPlugin;", "(Ljava/util/List;)V", "getPlugins", "()Ljava/util/List;", "addVisualNewlinesToBlockElements", "", "spanned", "Landroid/text/Editable;", "cleanupZWJ", "text", "clearForegroundColorSpans", "spannable", "Landroid/text/SpannableStringBuilder;", "consumeCursorIfInInput", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "position", "", "fixOrderOfNestedMediaAndUrlSpans", "spans", "", "Landroid/text/style/CharacterStyle;", "Landroid/text/Spanned;", "fromHtml", "source", "", "context", "Landroid/content/Context;", "markBlockElementLineBreak", "Landroid/text/Spannable;", "startPos", "markBlockElementsAsParagraphs", "postprocessHtml", "postprocessSpans", "preprocessSpans", "syncVisualNewlinesOfBlockElements", "tidy", "html", "toHtml", "withCursor", "", "unbiasNestingLevel", "withinContent", "start", "end", "parents", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/spans/IAztecNestable;", "withinHtml", "grandParents", "nestingLevel", "withinNestable", "nestable", "Lorg/wordpress/aztec/spans/IAztecSpan;", "withinParagraph", "nl", "withinStyle", "withinUnknown", "unknownHtmlSpan", "Lorg/wordpress/aztec/spans/UnknownHtmlSpan;", "aztec_release"})
public final class AztecParser {
    @NotNull
    private final List<IAztecPlugin> plugins;

    @NotNull
    public final Spanned fromHtml(@NotNull String source, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String tidySource = this.tidy(source);
        SpannableStringBuilder spanned = new SpannableStringBuilder((CharSequence)Html.fromHtml(tidySource, new AztecTagHandler(context, this.plugins), context, this.plugins));
        this.addVisualNewlinesToBlockElements((Editable)spanned);
        this.markBlockElementsAsParagraphs((Spannable)spanned);
        this.cleanupZWJ((Editable)spanned);
        this.unbiasNestingLevel((Spanned)spanned);
        this.postprocessSpans(spanned);
        return (Spanned)spanned;
    }

    @NotNull
    public final String toHtml(@NotNull Spanned text, boolean withCursor) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        StringBuilder out = new StringBuilder();
        SpannableStringBuilder data = new SpannableStringBuilder((CharSequence)text);
        this.preprocessSpans(data);
        this.clearForegroundColorSpans(data);
        if (!withCursor) {
            AztecCursorSpan cursorSpan;
            Object[] objectArray = data.getSpans(0, data.length(), AztecCursorSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"data.getSpans(0, data.le\u2026ecCursorSpan::class.java)");
            AztecCursorSpan aztecCursorSpan = cursorSpan = (AztecCursorSpan)ArraysKt.firstOrNull((Object[])objectArray);
            if (aztecCursorSpan != null) {
                AztecCursorSpan aztecCursorSpan2;
                AztecCursorSpan it = aztecCursorSpan2 = aztecCursorSpan;
                data.removeSpan((Object)cursorSpan);
            }
        }
        this.withinHtml(out, (Spanned)data);
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        String html = this.postprocessHtml(this.tidy(string));
        return html;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String toHtml$default(AztecParser aztecParser, Spanned spanned, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return aztecParser.toHtml(spanned, bl);
    }

    private final void preprocessSpans(SpannableStringBuilder spannable) {
        IAztecPlugin it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.plugins;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)element$iv$iv;
            if (!(it instanceof ISpanPreprocessor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            IAztecPlugin iAztecPlugin = it;
            if (iAztecPlugin == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.visual2html.ISpanPreprocessor");
            }
            ISpanPreprocessor iSpanPreprocessor = (ISpanPreprocessor)iAztecPlugin;
            collection.add(iSpanPreprocessor);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            ISpanPreprocessor it2 = (ISpanPreprocessor)element$iv;
            it2.beforeSpansProcessed(spannable);
        }
    }

    private final void clearForegroundColorSpans(SpannableStringBuilder spannable) {
        Object[] objectArray = spannable.getSpans(0, spannable.length(), ForegroundColorSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"spannable.getSpans(0, sp\u2026undColorSpan::class.java)");
        Object[] $receiver$iv = objectArray;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ForegroundColorSpan it = (ForegroundColorSpan)element$iv;
            spannable.removeSpan((Object)it);
        }
    }

    private final String postprocessHtml(String source) {
        IAztecPlugin it;
        Iterable $receiver$iv$iv;
        String html = source;
        Iterable $receiver$iv = this.plugins;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)element$iv$iv;
            if (!(it instanceof IHtmlPostprocessor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            IAztecPlugin iAztecPlugin = it;
            if (iAztecPlugin == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.visual2html.IHtmlPostprocessor");
            }
            IHtmlPostprocessor iHtmlPostprocessor = (IHtmlPostprocessor)iAztecPlugin;
            collection.add(iHtmlPostprocessor);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            IHtmlPostprocessor it2 = (IHtmlPostprocessor)element$iv;
            html = it2.onHtmlProcessed(html);
        }
        return html;
    }

    private final void postprocessSpans(SpannableStringBuilder spannable) {
        IAztecPlugin it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.plugins;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)element$iv$iv;
            if (!(it instanceof ISpanPostprocessor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            IAztecPlugin iAztecPlugin = it;
            if (iAztecPlugin == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.html2visual.ISpanPostprocessor");
            }
            ISpanPostprocessor iSpanPostprocessor = (ISpanPostprocessor)iAztecPlugin;
            collection.add(iSpanPostprocessor);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            ISpanPostprocessor it2 = (ISpanPostprocessor)element$iv;
            it2.afterSpansProcessed(spannable);
        }
    }

    private final void markBlockElementLineBreak(Spannable text, int startPos) {
        text.setSpan((Object)new AztecVisualLinebreak(), startPos, startPos, 17);
    }

    /*
     * Unable to fully structure code
     */
    public final void addVisualNewlinesToBlockElements(@NotNull Editable spanned) {
        Intrinsics.checkParameterIsNotNull((Object)spanned, (String)"spanned");
        v0 = spanned.getSpans(0, spanned.length(), IAztecSurroundedWithNewlines.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"spanned.getSpans(0, span\u2026WithNewlines::class.java)");
        $receiver$iv = v0;
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            element$iv = $receiver$iv[var3_3];
            it = (IAztecSurroundedWithNewlines)element$iv;
            parent = IAztecNestable.Companion.getParent((Spannable)spanned, new SpanWrapper<IAztecSurroundedWithNewlines>((Spannable)spanned, it));
            if (!(it instanceof AztecListSpan)) ** GOTO lbl-1000
            v1 = parent;
            if ((v1 != null ? v1.getSpan() : null) instanceof AztecListItemSpan) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            repelling = v2;
            spanStart = spanned.getSpanStart((Object)it);
            spanEnd = spanned.getSpanEnd((Object)it);
            if (spanStart == spanEnd || !repelling && spanStart < 1) continue;
            v3 = parent;
            v4 = parentStart = v3 != null ? v3.getStart() : 0;
            if (!repelling && spanStart == parentStart || !repelling && spanned.charAt(spanStart - 1) == '\n') continue;
            spanned.insert(spanStart, (CharSequence)"\n");
            var11_14 = SpanWrapper.Companion;
            var12_15 = (Spannable)spanned;
            var13_17 = spanStart + 1;
            end$iv = spanStart + 2;
            v5 = spannable$iv.getSpans((int)start$iv, end$iv, IAztecNestable.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"spannable.getSpans(start, end, T::class.java)");
            this_$iv = this_$iv.getSpans((Spannable)spannable$iv, v5);
            spannable$iv = $receiver$iv;
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                subParent = (SpanWrapper)element$iv$iv;
                if (!(((IAztecNestable)subParent.getSpan()).getNestingLevel() < it.getNestingLevel() && subParent.getStart() == spanStart + 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (E element$iv : $receiver$iv) {
                v6 = subParent = (SpanWrapper)element$iv;
                var15_21 = v6.getStart();
                v6.setStart(var15_21 + -1);
            }
            this.markBlockElementLineBreak((Spannable)spanned, spanStart);
        }
        v7 = spanned.getSpans(0, spanned.length(), IAztecSurroundedWithNewlines.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"spanned.getSpans(0, span\u2026WithNewlines::class.java)");
        $receiver$iv = v7;
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            element$iv = $receiver$iv[var3_3];
            it = (IAztecSurroundedWithNewlines)element$iv;
            spanEnd = spanned.getSpanEnd((Object)it);
            if (spanEnd == spanned.length()) continue;
            if (spanned.charAt(spanEnd) == '\n') {
                Intrinsics.checkExpressionValueIsNotNull((Object)spanned.getSpans(spanEnd, spanEnd, AztecVisualLinebreak.class), (String)"spanned.getSpans(spanEnd\u2026ualLinebreak::class.java)");
                var8_11 = var7_9;
                if (var8_11.length == 0 == false) {
                    if (!(it instanceof IAztecBlockSpan)) continue;
                    spanned.setSpan((Object)it, spanned.getSpanStart((Object)it), spanEnd + 1, spanned.getSpanFlags((Object)it));
                    continue;
                }
            }
            spanned.insert(spanEnd, (CharSequence)"\n");
            if (it instanceof IAztecBlockSpan) {
                spanned.setSpan((Object)it, spanned.getSpanStart((Object)it), spanEnd + 1, spanned.getSpanFlags((Object)it));
            }
            this.markBlockElementLineBreak((Spannable)spanned, spanEnd);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void syncVisualNewlinesOfBlockElements(@NotNull Editable spanned) {
        Intrinsics.checkParameterIsNotNull((Object)spanned, (String)"spanned");
        v0 = spanned.getSpans(0, spanned.length(), AztecVisualLinebreak.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"spanned.getSpans(0, span\u2026ualLinebreak::class.java)");
        $receiver$iv = v0;
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            element$iv = $receiver$iv[var3_3];
            it = (AztecVisualLinebreak)element$iv;
            spanned.removeSpan(it);
        }
        v1 = spanned.getSpans(0, spanned.length(), IAztecSurroundedWithNewlines.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"spanned.getSpans(0, span\u2026WithNewlines::class.java)");
        $receiver$iv = v1;
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            element$iv = $receiver$iv[var3_3];
            it = (IAztecSurroundedWithNewlines)element$iv;
            spanEnd = spanned.getSpanEnd(it);
            v2 = newlineExpected = it instanceof IAztecBlockSpan != false && spanEnd > 0 ? spanEnd - 1 : spanEnd;
            if (spanEnd == spanned.length() || spanned.charAt(newlineExpected) != '\n') continue;
            this.markBlockElementLineBreak((Spannable)spanned, newlineExpected);
        }
        v3 = spanned.getSpans(0, spanned.length(), IAztecSurroundedWithNewlines.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"spanned.getSpans(0, span\u2026WithNewlines::class.java)");
        $receiver$iv = v3;
        for (var3_3 = 0; var3_3 < $receiver$iv.length; ++var3_3) {
            block6: {
                element$iv = $receiver$iv[var3_3];
                it = (IAztecSurroundedWithNewlines)element$iv;
                parent = IAztecNestable.Companion.getParent((Spannable)spanned, new SpanWrapper<Object>((Spannable)spanned, it));
                if (!(it instanceof AztecListSpan)) ** GOTO lbl-1000
                v4 = parent;
                if ((v4 != null ? v4.getSpan() : null) instanceof AztecListItemSpan) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                repelling = v5;
                spanStart = spanned.getSpanStart(it);
                if (spanStart == 0 || !repelling && spanStart < 2 || spanned.charAt(spanStart - 1) != '\n') continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)spanned.getSpans(spanStart, spanStart, IAztecSurroundedWithNewlines.class), (String)"spanned.getSpans(spanSta\u2026WithNewlines::class.java)");
                for (var10_11 = 0; var10_11 < $receiver$iv.length; ++var10_11) {
                    element$iv = $receiver$iv[var10_11];
                    before = (IAztecSurroundedWithNewlines)element$iv;
                    if (!(spanned.getSpanEnd((Object)before) == spanStart)) continue;
                    v6 = true;
                    break block6;
                }
                v6 = false;
            }
            if (v6 || spanStart > 1 && !repelling && spanned.charAt(spanStart - 2) == '\n') continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)spanned.getSpans(spanStart - 1, spanStart - 1, AztecVisualLinebreak.class), (String)"spanned.getSpans(spanSta\u2026ualLinebreak::class.java)");
            var10_12 = var9_10;
            if (var10_12.length == 0 == false) continue;
            this.markBlockElementLineBreak((Spannable)spanned, spanStart - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markBlockElementsAsParagraphs(Spannable text) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = SpanWrapper.Companion.getSpans(text, 0, text.length(), IAztecBlockSpan.class);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            SpanWrapper spanWrapper = (SpanWrapper)item$iv$iv;
            Collection collection = destination$iv$iv;
            it.setFlags(51);
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final void cleanupZWJ(Editable text) {
        int lastIndex = text.length();
        do {
            if ((lastIndex = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)text), (char)Constants.INSTANCE.getZWJ_CHAR(), (int)lastIndex, (boolean)false, (int)4, null)) == text.length() - 1) {
                return;
            }
            if (lastIndex <= -1) continue;
            text.delete(lastIndex, lastIndex + 1);
        } while (lastIndex > -1);
    }

    private final void unbiasNestingLevel(Spanned text) {
        Object[] objectArray = text.getSpans(0, text.length(), IAztecNestable.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"text.getSpans(0, text.le\u2026ztecNestable::class.java)");
        Object[] $receiver$iv = objectArray;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            IAztecNestable it;
            Object element$iv = $receiver$iv[i];
            IAztecNestable iAztecNestable = it = (IAztecNestable)element$iv;
            iAztecNestable.setNestingLevel(iAztecNestable.getNestingLevel() - 2);
        }
    }

    private final void withinHtml(StringBuilder out, Spanned text) {
        this.withinHtml(out, text, 0, text.length(), null, -1);
    }

    /*
     * WARNING - void declaration
     */
    private final void withinHtml(StringBuilder out, Spanned text, int start, int end, ArrayList<IAztecNestable> grandParents, int nestingLevel) {
        int next;
        int i = start;
        do {
            ArrayList<IAztecNestable> parents;
            Object object;
            IAztecNestable iAztecNestable;
            block11: {
                IAztecNestable[] nestableElements;
                void $receiver$iv$iv;
                Collection $receiver$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)text.getSpans(i, end, IAztecNestable.class), (String)"text.getSpans(i, end, IAztecNestable::class.java)");
                iAztecNestable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                    void element$iv$iv = $receiver$iv$iv[j];
                    IAztecNestable it = (IAztecNestable)element$iv$iv;
                    if (!(!(it instanceof IAztecFullWidthImageSpan))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Collection thisCollection$iv = $receiver$iv;
                if (thisCollection$iv.toArray(new IAztecNestable[thisCollection$iv.size()]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ArraysKt.sortWith((Object[])nestableElements, (Comparator)new Comparator<IAztecNestable>(text){
                    final /* synthetic */ Spanned $text;

                    public final int compare(IAztecNestable a, IAztecNestable b) {
                        int startComparison = Intrinsics.compare((int)this.$text.getSpanStart((Object)a), (int)this.$text.getSpanStart((Object)b));
                        if (startComparison == 0) {
                            int nestingComparison = Intrinsics.compare((int)a.getNestingLevel(), (int)b.getNestingLevel());
                            if (nestingComparison == 0) {
                                return Intrinsics.compare((int)this.$text.getSpanEnd((Object)a), (int)this.$text.getSpanEnd((Object)b));
                            }
                            return nestingComparison;
                        }
                        return startComparison;
                    }
                    {
                        this.$text = spanned;
                    }
                });
                Object[] $receiver$iv2 = nestableElements;
                for (int j = 0; j < $receiver$iv2.length; ++j) {
                    Object element$iv = $receiver$iv2[j];
                    IAztecNestable it = (IAztecNestable)element$iv;
                    if (!(it.getNestingLevel() > nestingLevel)) continue;
                    object = element$iv;
                    break block11;
                }
                object = null;
            }
            IAztecNestable nestable = (IAztecNestable)object;
            if (nestable == null) {
                next = end;
                parents = grandParents;
            } else if (text.getSpanStart((Object)nestable) > i) {
                next = text.getSpanStart((Object)nestable);
                nestable = null;
                parents = grandParents;
            } else {
                next = text.getSpanEnd((Object)nestable);
                ArrayList<IAztecNestable> arrayList = grandParents;
                parents = new ArrayList(arrayList != null ? (Collection)arrayList : (Collection)new ArrayList());
                parents.add(nestable);
            }
            iAztecNestable = nestable;
            if (iAztecNestable instanceof HiddenHtmlSpan) {
                this.withinNestable(out, text, i, next, (IAztecSpan)((Object)nestable), parents, nestable.getNestingLevel());
                continue;
            }
            if (iAztecNestable instanceof IAztecBlockSpan) {
                this.withinNestable(out, text, i, next, (IAztecSpan)((Object)nestable), parents, nestable.getNestingLevel());
                continue;
            }
            if (iAztecNestable instanceof UnknownHtmlSpan) {
                this.withinUnknown(out, text, i, next, (UnknownHtmlSpan)nestable);
                continue;
            }
            this.withinContent(out, text, i, next, parents);
        } while ((i = next) < end);
        this.consumeCursorIfInInput(out, (CharSequence)text, text.length());
    }

    private final void withinUnknown(StringBuilder out, Spanned text, int start, int end, UnknownHtmlSpan unknownHtmlSpan) {
        this.consumeCursorIfInInput(out, (CharSequence)text, start);
        out.append((CharSequence)unknownHtmlSpan.getRawHtml());
        this.consumeCursorIfInInput(out, (CharSequence)text, end);
    }

    /*
     * WARNING - void declaration
     */
    private final void withinNestable(StringBuilder out, Spanned text, int start, int end, IAztecSpan nestable, ArrayList<IAztecNestable> parents, int nestingLevel) {
        out.append('<' + nestable.getStartTag() + '>');
        this.withinHtml(out, text, start, end, parents, nestingLevel);
        out.append("</" + nestable.getEndTag() + '>');
        if (end > 0 && text.charAt(end - 1) == Constants.INSTANCE.getNEWLINE()) {
            Object[] objectArray = text.getSpans(end - 1, end, AztecVisualLinebreak.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"text.getSpans(end - 1, e\u2026ualLinebreak::class.java)");
            Object object = objectArray;
            if (((Object[])object).length == 0) {
                boolean bl;
                block8: {
                    ArrayList<IAztecNestable> arrayList = parents;
                    if (arrayList != null) {
                        void $receiver$iv;
                        object = arrayList;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $receiver$iv) {
                                IAztecNestable it = (IAztecNestable)element$iv;
                                if (!(Intrinsics.areEqual((Object)it, (Object)nestable) ^ true && text.getSpanEnd((Object)it) == end)) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (!bl) {
                    out.append("<br>");
                }
            }
        }
    }

    private final void withinContent(StringBuilder out, Spanned text, int start, int end, ArrayList<IAztecNestable> parents) {
        int i = start;
        while (i < end) {
            int next = TextUtils.indexOf((CharSequence)((CharSequence)text), (char)'\n', (int)i, (int)end);
            if (next < 0) {
                next = end;
            }
            int nl = 0;
            while (next < end && text.charAt(next) == '\n') {
                boolean isVisualLinebreak;
                Object[] objectArray;
                Intrinsics.checkExpressionValueIsNotNull((Object)text.getSpans(next, next, AztecVisualLinebreak.class), (String)"text.getSpans(next, next\u2026ualLinebreak::class.java)");
                Object[] objectArray2 = objectArray;
                boolean bl = isVisualLinebreak = !(objectArray2.length == 0);
                if (!isVisualLinebreak) {
                    ++nl;
                }
                ++next;
            }
            this.withinParagraph(out, text, i, next - nl, nl, parents);
            i = next;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void withinParagraph(StringBuilder out, Spanned text, int start, int end, int nl, ArrayList<IAztecNestable> parents) {
        next = new Ref.IntRef();
        i = start;
        while (i < end || start == end) {
            block31: {
                next.element = text.nextSpanTransition(i, end, CharacterStyle.class);
                if (i == next.element) break;
                v0 = text.getSpans(i, next.element, CharacterStyle.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"text.getSpans(i, next, CharacterStyle::class.java)");
                spans = ArraysKt.toMutableList((Object[])v0);
                this.fixOrderOfNestedMediaAndUrlSpans(spans, text);
                var10_11 = 0;
                var11_12 = ((Collection)spans).size();
                while (var10_11 < var11_12) {
                    span = (CharacterStyle)spans.get(j);
                    if (span instanceof IAztecInlineSpan) {
                        out.append('<' + ((IAztecInlineSpan)span).getStartTag() + '>');
                    }
                    if (span instanceof CommentSpan) {
                        out.append("<!--");
                        if (((CommentSpan)span).isHidden()) {
                            i = next.element;
                            out.append(((CommentSpan)span).getText());
                        }
                    }
                    var14_17 = $receiver$iv = (Iterable)this.plugins;
                    destination$iv$iv = new ArrayList<E>();
                    var16_19 = $receiver$iv$iv.iterator();
                    while (var16_19.hasNext()) {
                        element$iv$iv = var16_19.next();
                        it = (IAztecPlugin)element$iv$iv;
                        if (!(it instanceof IInlineSpanHandler)) ** GOTO lbl-1000
                        v1 = (IInlineSpanHandler)it;
                        v2 = span;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"span");
                        if (v1.canHandleSpan(v2)) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    var16_19 = $receiver$iv$iv.iterator();
                    while (var16_19.hasNext()) {
                        item$iv$iv = var16_19.next();
                        it = (IAztecPlugin)item$iv$iv;
                        var23_23 = destination$iv$iv;
                        v4 = it;
                        if (v4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.visual2html.IInlineSpanHandler");
                        }
                        var24_24 = (IInlineSpanHandler)v4;
                        var23_23.add(var24_24);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv /* !! */  = $receiver$iv$iv.next();
                        it = (IInlineSpanHandler)element$iv /* !! */ ;
                        v5 = span;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"span");
                        it.handleSpanStart(out, v5);
                        if (it.shouldParseContent()) continue;
                        i = next.element;
                    }
                    if (span instanceof AztecHorizontalRuleSpan) {
                        out.append('<' + ((AztecHorizontalRuleSpan)span).getStartTag() + '>');
                        i = next.element;
                    }
                    if (span instanceof AztecMediaSpan) {
                        out.append(((AztecMediaSpan)span).getHtml());
                        i = next.element;
                    }
                    ++j;
                }
                this.withinStyle(out, (CharSequence)text, i, next.element, nl);
                v6 = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)spans)));
                j = v6.getFirst();
                var11_12 = v6.getLast();
                span = v6.getStep();
                v7 = j;
                v8 = var11_12;
                if (!(span > 0 ? v7 <= v8 : v7 >= v8)) break block31;
                while (true) {
                    if ((span = (CharacterStyle)spans.get(j)) instanceof IAztecInlineSpan) {
                        out.append("</" + ((IAztecInlineSpan)span).getEndTag() + '>');
                    }
                    if (span instanceof CommentSpan) {
                        out.append("-->");
                    }
                    element$iv /* !! */  = $receiver$iv = (Iterable)this.plugins;
                    destination$iv$iv = new ArrayList<E>();
                    $i$a$3$forEach = $receiver$iv$iv.iterator();
                    while ($i$a$3$forEach.hasNext()) {
                        element$iv$iv = $i$a$3$forEach.next();
                        it = (IAztecPlugin)element$iv$iv;
                        if (!(it instanceof IInlineSpanHandler)) ** GOTO lbl-1000
                        v9 = (IInlineSpanHandler)it;
                        v10 = span;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"span");
                        if (v9.canHandleSpan(v10)) {
                            v11 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v11 = false;
                        }
                        if (!v11) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    $i$a$3$forEach = $receiver$iv$iv.iterator();
                    while ($i$a$3$forEach.hasNext()) {
                        item$iv$iv = $i$a$3$forEach.next();
                        it = (IAztecPlugin)item$iv$iv;
                        var23_23 = destination$iv$iv;
                        v12 = it;
                        if (v12 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.visual2html.IInlineSpanHandler");
                        }
                        var24_24 = (IInlineSpanHandler)v12;
                        var23_23.add(var24_24);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv = $receiver$iv$iv.next();
                        it = (IInlineSpanHandler)element$iv;
                        v13 = span;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"span");
                        it.handleSpanEnd(out, v13);
                    }
                    if (j == var11_12) break;
                    j += span;
                }
            }
            if (start == end) break;
            i = next.element;
        }
        if ((spans = 0) <= (var10_11 = nl - 1)) {
            while (true) {
                block30: {
                    v14 = parents;
                    if (v14 != null) {
                        $receiver$iv = v14;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            v15 = false;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                it = (IAztecNestable)element$iv;
                                if (!(text.getSpanEnd((Object)it) == end + 1 + z)) continue;
                                v15 = true;
                                break block30;
                            }
                            v15 = false;
                        }
                    } else {
                        v15 = parentSharesEnd = false;
                    }
                }
                if (!parentSharesEnd) {
                    out.append("<br>");
                    this.consumeCursorIfInInput(out, (CharSequence)text, end + z);
                }
                if (z == var10_11) break;
                ++z;
            }
        }
    }

    private final void fixOrderOfNestedMediaAndUrlSpans(List<CharacterStyle> spans, Spanned text) {
        Object v1;
        CharacterStyle urlSpan;
        block5: {
            Object v0;
            block4: {
                Iterable $receiver$iv = spans;
                for (Object element$iv : $receiver$iv) {
                    CharacterStyle it = (CharacterStyle)element$iv;
                    if (!(it instanceof AztecURLSpan)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            urlSpan = v0;
            Iterable $receiver$iv = spans;
            for (Object element$iv : $receiver$iv) {
                CharacterStyle it = (CharacterStyle)element$iv;
                if (!(it instanceof AztecMediaSpan)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        CharacterStyle mediaSpan = v1;
        if (urlSpan != null && mediaSpan != null) {
            boolean isMediaSpanWithinUrlSpan;
            int urlSpanStart = text.getSpanStart((Object)urlSpan);
            int urlSpanEnd = text.getSpanEnd((Object)urlSpan);
            boolean isUrlSpanFollowsMediaSpan = spans.indexOf(urlSpan) > spans.indexOf(mediaSpan);
            boolean bl = isMediaSpanWithinUrlSpan = text.getSpanStart((Object)mediaSpan) >= urlSpanStart && text.getSpanEnd((Object)mediaSpan) <= urlSpanEnd;
            if (isUrlSpanFollowsMediaSpan && isMediaSpanWithinUrlSpan) {
                Collections.swap(spans, spans.indexOf(urlSpan), spans.indexOf(mediaSpan));
            }
        }
    }

    private final void withinStyle(StringBuilder out, CharSequence text, int start, int end, int nl) {
        int i = start;
        while (i < end) {
            char c = text.charAt(i);
            if (c == Constants.INSTANCE.getZWJ_CHAR()) {
                ++i;
                continue;
            }
            this.consumeCursorIfInInput(out, text, i);
            if (c == '<') {
                out.append("&lt;");
            } else if (c == '>') {
                out.append("&gt;");
            } else if (c == '&') {
                out.append("&amp;");
            } else if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    this.consumeCursorIfInInput(out, text, ++i);
                }
                out.append(' ');
            } else if (c != '\n') {
                out.append(c);
            }
            ++i;
        }
        if (nl == 0 && text.length() > i && text.charAt(i) == '\n') {
            this.consumeCursorIfInInput(out, text, i);
        }
    }

    private final void consumeCursorIfInInput(StringBuilder out, CharSequence text, int position) {
        if (text instanceof SpannableStringBuilder) {
            Object[] objectArray = ((SpannableStringBuilder)text).getSpans(position, position, AztecCursorSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"text.getSpans(position, \u2026ecCursorSpan::class.java)");
            AztecCursorSpan cursorSpan = (AztecCursorSpan)ArraysKt.firstOrNull((Object[])objectArray);
            if (cursorSpan != null) {
                out.append(AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG());
                ((SpannableStringBuilder)text).removeSpan((Object)cursorSpan);
            }
        }
    }

    private final String tidy(String html) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)html, (String)Constants.INSTANCE.getZWJ_STRING(), (String)"", (boolean)false, (int)4, null), (String)Constants.INSTANCE.getMAGIC_STRING(), (String)"", (boolean)false, (int)4, null);
        String string = "(</? ?br>)*((aztec_cursor)?)</blockquote>";
        string = new Regex(string);
        String string2 = "$2</blockquote>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</li>";
        string = new Regex(string);
        string2 = "$2</li>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</p>";
        string = new Regex(string);
        string2 = "$2</p>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</pre>";
        string = new Regex(string);
        string2 = "$2</pre>";
        return string.replace(charSequence, string2);
    }

    @NotNull
    public final List<IAztecPlugin> getPlugins() {
        return this.plugins;
    }

    public AztecParser(@NotNull List<? extends IAztecPlugin> plugins) {
        Intrinsics.checkParameterIsNotNull(plugins, (String)"plugins");
        this.plugins = plugins;
    }

    public /* synthetic */ AztecParser(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        this(list);
    }

    public AztecParser() {
        this(null, 1, null);
    }
}

