/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers.event.sequence.known.space;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.watchers.event.sequence.EventSequence;
import org.wordpress.aztec.watchers.event.sequence.UserOperationEvent;
import org.wordpress.aztec.watchers.event.sequence.known.space.steps.TextWatcherEventDeleteText;
import org.wordpress.aztec.watchers.event.sequence.known.space.steps.TextWatcherEventInsertText;
import org.wordpress.aztec.watchers.event.text.AfterTextChangedEventData;
import org.wordpress.aztec.watchers.event.text.BeforeTextChangedEventData;
import org.wordpress.aztec.watchers.event.text.TextWatcherEvent;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u0016\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/wordpress/aztec/watchers/event/sequence/known/space/API26InWordSpaceInsertionEvent;", "Lorg/wordpress/aztec/watchers/event/sequence/UserOperationEvent;", "()V", "MAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS", "", "SPACE", "", "SPACE_STRING", "", "buildReplacementEventWithSequenceData", "Lorg/wordpress/aztec/watchers/event/text/TextWatcherEvent;", "sequence", "Lorg/wordpress/aztec/watchers/event/sequence/EventSequence;", "isUserOperationObservedInSequence", "", "isUserOperationPartiallyObservedInSequence", "aztec_release"})
public final class API26InWordSpaceInsertionEvent
extends UserOperationEvent {
    private final char SPACE = (char)32;
    private final String SPACE_STRING = "" + this.SPACE;
    private final int MAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS = 50;

    @Override
    public boolean isUserOperationObservedInSequence(@NotNull EventSequence<TextWatcherEvent> sequence) {
        Intrinsics.checkParameterIsNotNull(sequence, (String)"sequence");
        if (this.getSequence().size() == sequence.size()) {
            if (!this.isUserOperationPartiallyObservedInSequence(sequence)) {
                return false;
            }
            TextWatcherEvent firstEvent = (TextWatcherEvent)CollectionsKt.first((List)sequence);
            TextWatcherEvent lastEvent = (TextWatcherEvent)sequence.get(sequence.size() - 1);
            SpannableStringBuilder spannableStringBuilder = firstEvent.getBeforeEventData().getTextBefore();
            if (spannableStringBuilder != null) {
                int n = spannableStringBuilder.length();
                Editable editable = lastEvent.getAfterEventData().getTextAfter();
                if (editable == null) {
                    Intrinsics.throwNpe();
                }
                if (n == editable.length() - 1) {
                    BeforeTextChangedEventData data = firstEvent.getBeforeEventData();
                    Editable editable2 = lastEvent.getAfterEventData().getTextAfter();
                    if (editable2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (editable2.charAt(data.getStart() + data.getCount()) == this.SPACE) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isUserOperationPartiallyObservedInSequence(@NotNull EventSequence<TextWatcherEvent> sequence) {
        Intrinsics.checkParameterIsNotNull(sequence, (String)"sequence");
        int n = 0;
        int n2 = ((Collection)sequence).size();
        while (n < n2) {
            void i;
            TextWatcherEvent eventHolder = (TextWatcherEvent)this.getSequence().get((int)i);
            TextWatcherEvent observableEvent = (TextWatcherEvent)sequence.get((int)i);
            if (i > 0) {
                long timestampForPreviousEvent = ((TextWatcherEvent)sequence.get((int)(i - true))).getTimestamp();
                long timeDistance = observableEvent.getTimestamp() - timestampForPreviousEvent;
                if (timeDistance > (long)this.MAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS) {
                    return false;
                }
            }
            eventHolder.setBeforeEventData(observableEvent.getBeforeEventData());
            eventHolder.setOnEventData(observableEvent.getOnEventData());
            eventHolder.setAfterEventData(observableEvent.getAfterEventData());
            if (!eventHolder.testFitsBeforeOnAndAfter()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    @NotNull
    public TextWatcherEvent buildReplacementEventWithSequenceData(@NotNull EventSequence<TextWatcherEvent> sequence) {
        Intrinsics.checkParameterIsNotNull(sequence, (String)"sequence");
        TextWatcherEventInsertText.Builder builder = new TextWatcherEventInsertText.Builder();
        TextWatcherEvent firstEvent = (TextWatcherEvent)CollectionsKt.first((List)sequence);
        TextWatcherEvent lastEvent = (TextWatcherEvent)sequence.get(sequence.size() - 1);
        BeforeTextChangedEventData beforeTextChangedEventData = firstEvent.getBeforeEventData();
        SpannableStringBuilder oldText = beforeTextChangedEventData.component1();
        int differenceIndex = StringUtils.indexOfDifference((CharSequence)((CharSequence)oldText), (CharSequence)((CharSequence)lastEvent.getAfterEventData().getTextAfter()));
        SpannableStringBuilder spannableStringBuilder = oldText;
        if (spannableStringBuilder != null) {
            spannableStringBuilder.insert(differenceIndex, (CharSequence)this.SPACE_STRING);
        }
        builder.setAfterEventData(new AfterTextChangedEventData((Editable)oldText));
        TextWatcherEventInsertText replacementEvent = builder.build();
        replacementEvent.setInsertionStart(differenceIndex);
        replacementEvent.setInsertionLength(1);
        return replacementEvent;
    }

    public API26InWordSpaceInsertionEvent() {
        super(null, 1, null);
        TextWatcherEventDeleteText.Builder builder = new TextWatcherEventDeleteText.Builder();
        TextWatcherEventDeleteText step1 = builder.build();
        TextWatcherEventDeleteText.Builder builderStep2 = new TextWatcherEventDeleteText.Builder();
        TextWatcherEventDeleteText step2 = builderStep2.build();
        TextWatcherEventInsertText.Builder builderStep3 = new TextWatcherEventInsertText.Builder();
        TextWatcherEventInsertText step3 = builderStep3.build();
        TextWatcherEventInsertText.Builder builderStep4 = new TextWatcherEventInsertText.Builder();
        TextWatcherEventInsertText step4 = builderStep4.build();
        this.clear();
        this.addSequenceStep(step1);
        this.addSequenceStep(step2);
        this.addSequenceStep(step3);
        this.addSequenceStep(step4);
    }
}

