/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.AztecListSpan;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJh\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lorg/wordpress/aztec/spans/AztecOrderedListSpan;", "Lorg/wordpress/aztec/spans/AztecListSpan;", "nestingLevel", "", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "listStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "(ILorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getAttributes", "()Lorg/wordpress/aztec/AztecAttributes;", "setAttributes", "(Lorg/wordpress/aztec/AztecAttributes;)V", "horizontalShift", "getListStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "setListStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;)V", "maxWidth", "", "getNestingLevel", "()I", "setNestingLevel", "(I)V", "drawLeadingMargin", "", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "x", "dir", "top", "baseline", "bottom", "text", "", "start", "end", "first", "", "l", "Landroid/text/Layout;", "getLeadingMargin", "aztec_release"})
public final class AztecOrderedListSpan
extends AztecListSpan {
    @NotNull
    private final String TAG = "ol";
    private int horizontalShift;
    private float maxWidth;
    private int nestingLevel;
    @NotNull
    private AztecAttributes attributes;
    @NotNull
    private BlockFormatter.ListStyle listStyle;

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    public int getLeadingMargin(boolean first) {
        return this.listStyle.getIndicatorMargin() + 2 * this.listStyle.getIndicatorWidth() + this.listStyle.getIndicatorPadding() + this.horizontalShift;
    }

    public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout l) {
        block8: {
            block7: {
                int spanEnd;
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
                if (!first) {
                    return;
                }
                int spanStart = ((Spanned)text).getSpanStart((Object)this);
                int n = start;
                if (spanStart > n || (spanEnd = ((Spanned)text).getSpanEnd((Object)this)) < n) break block7;
                int n2 = end;
                if (spanStart <= n2 && spanEnd >= n2) break block8;
            }
            return;
        }
        Paint.Style style2 = p.getStyle();
        int oldColor = p.getColor();
        p.setColor(this.listStyle.getIndicatorColor());
        p.setStyle(Paint.Style.FILL);
        int lineIndex = this.getIndexOfProcessedLine(text, end);
        String textToDraw = lineIndex > -1 ? (dir >= 0 ? String.valueOf(lineIndex) + "." : "." + String.valueOf(lineIndex)) : "";
        float width = p.measureText(textToDraw);
        this.maxWidth = Math.max(this.maxWidth, width);
        float textStart = (float)x + (float)(this.listStyle.getIndicatorMargin() * dir) * 1.0f;
        if (dir == 1) {
            textStart -= width;
        }
        if (textStart < 0.0f) {
            this.horizontalShift = -((int)textStart);
            textStart = 0.0f;
        }
        if (this.horizontalShift > 0 && width < this.maxWidth) {
            textStart += (float)this.horizontalShift;
        }
        c.drawText(textToDraw, textStart, (float)baseline, p);
        p.setColor(oldColor);
        p.setStyle(style2);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public AztecAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AztecAttributes aztecAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)aztecAttributes, (String)"<set-?>");
        this.attributes = aztecAttributes;
    }

    @NotNull
    public final BlockFormatter.ListStyle getListStyle() {
        return this.listStyle;
    }

    public final void setListStyle(@NotNull BlockFormatter.ListStyle listStyle) {
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"<set-?>");
        this.listStyle = listStyle;
    }

    public AztecOrderedListSpan(int nestingLevel, @NotNull AztecAttributes attributes, @NotNull BlockFormatter.ListStyle listStyle) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"listStyle");
        super(nestingLevel, listStyle.getVerticalPadding());
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.listStyle = listStyle;
        this.TAG = "ol";
    }

    public /* synthetic */ AztecOrderedListSpan(int n, AztecAttributes aztecAttributes, BlockFormatter.ListStyle listStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        if ((n2 & 4) != 0) {
            listStyle = new BlockFormatter.ListStyle(0, 0, 0, 0, 0);
        }
        this(n, aztecAttributes, listStyle);
    }
}

