/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.toolbar;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.PopupMenu;
import android.widget.Toast;
import android.widget.ToggleButton;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.R;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.source.SourceViewEditText;
import org.wordpress.aztec.toolbar.AztecToolbar$WhenMappings;
import org.wordpress.aztec.toolbar.AztecToolbarClickListener;
import org.wordpress.aztec.toolbar.ToolbarAction;
import org.wordpress.aztec.toolbar.ToolbarActionType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\b\u0010 \u001a\u0004\u0018\u00010!J\u0014\u0010\"\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0018\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002J\b\u0010'\u001a\u00020\u0019H\u0002J\b\u0010(\u001a\u00020\u0015H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u00020\u00152\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0012\u00100\u001a\u00020\u00192\b\u00101\u001a\u0004\u0018\u000102H\u0014J\b\u00103\u001a\u000202H\u0014J\u0010\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u001fH\u0002J\u0016\u00106\u001a\u00020\u00192\f\u00107\u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\u0016\u00108\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;H\u0002J\u000e\u0010<\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\rJ\b\u0010>\u001a\u00020\u0019H\u0002J\u001a\u0010?\u001a\u00020\u00192\b\u0010@\u001a\u0004\u0018\u00010;2\u0006\u0010A\u001a\u00020\u0015H\u0002J\u001a\u0010B\u001a\u00020\u00192\b\u0010@\u001a\u0004\u0018\u00010;2\u0006\u0010C\u001a\u00020\u0015H\u0002J\u0006\u0010D\u001a\u00020\u0019J\u0010\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u0015H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/wordpress/aztec/toolbar/AztecToolbar;", "Landroid/widget/FrameLayout;", "Landroid/widget/PopupMenu$OnMenuItemClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "aztecToolbarListener", "Lorg/wordpress/aztec/toolbar/AztecToolbarClickListener;", "dialogShortcuts", "Landroid/support/v7/app/AlertDialog;", "editor", "Lorg/wordpress/aztec/AztecText;", "headingMenu", "Landroid/widget/PopupMenu;", "isMediaModeEnabled", "", "sourceEditor", "Lorg/wordpress/aztec/source/SourceViewEditText;", "enableFormatButtons", "", "isEnabled", "enableMediaMode", "getHeadingMenu", "getSelectedActions", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/toolbar/ToolbarAction;", "getSelectedHeadingMenuItem", "Lorg/wordpress/aztec/TextFormat;", "highlightActionButtons", "toolbarActions", "highlightAppliedStyles", "selStart", "selEnd", "initView", "isEditorAttached", "onKeyUp", "keyCode", "event", "Landroid/view/KeyEvent;", "onMenuItemClick", "item", "Landroid/view/MenuItem;", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onToolbarAction", "action", "selectHeadingMenuItem", "textFormats", "setEditor", "setHeadingMenu", "view", "Landroid/view/View;", "setToolbarListener", "listener", "showDialogShortcuts", "toggleButton", "button", "checked", "toggleButtonState", "enabled", "toggleEditorMode", "toggleHtmlMode", "isHtmlMode", "aztec_release"})
public final class AztecToolbar
extends FrameLayout
implements PopupMenu.OnMenuItemClickListener {
    private AztecToolbarClickListener aztecToolbarListener;
    private AztecText editor;
    private PopupMenu headingMenu;
    private SourceViewEditText sourceEditor;
    private AlertDialog dialogShortcuts;
    private boolean isMediaModeEnabled;

    public final void setToolbarListener(@NotNull AztecToolbarClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.aztecToolbarListener = listener;
    }

    public boolean onKeyUp(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (keyCode) {
            case 8: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_1);
                }
                return true;
            }
            case 9: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_2);
                }
                return true;
            }
            case 10: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_3);
                }
                return true;
            }
            case 11: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_4);
                }
                return true;
            }
            case 12: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_5);
                }
                return true;
            }
            case 13: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_6);
                }
                return true;
            }
            case 14: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_PARAGRAPH);
                }
                return true;
            }
            case 15: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                return true;
            }
            case 30: {
                if (!event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.BOLD.getButtonId()).performClick();
                return true;
            }
            case 32: {
                if (!event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.STRIKETHROUGH.getButtonId()).performClick();
                return true;
            }
            case 36: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                this.showDialogShortcuts();
                return true;
            }
            case 37: {
                if (!event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.ITALIC.getButtonId()).performClick();
                return true;
            }
            case 39: {
                if (!event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.LINK.getButtonId()).performClick();
                return true;
            }
            case 41: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.ADD_MEDIA.getButtonId()).performClick();
                return true;
            }
            case 43: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.ORDERED_LIST.getButtonId()).performClick();
                return true;
            }
            case 44: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.PAGE.getButtonId()).performClick();
                return true;
            }
            case 45: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.QUOTE.getButtonId()).performClick();
                return true;
            }
            case 48: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.MORE.getButtonId()).performClick();
                return true;
            }
            case 49: {
                if (event.isAltPressed() && event.isCtrlPressed()) {
                    this.findViewById(ToolbarAction.UNORDERED_LIST.getButtonId()).performClick();
                    return true;
                }
                if (!event.isCtrlPressed()) break;
                this.findViewById(ToolbarAction.UNDERLINE.getButtonId()).performClick();
                return true;
            }
            case 52: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                return true;
            }
            case 53: {
                if (!event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.redo();
                }
                return true;
            }
            case 54: {
                if (!event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.undo();
                }
                return true;
            }
        }
        return false;
    }

    public boolean onMenuItemClick(@Nullable MenuItem item) {
        Integer n;
        MenuItem menuItem = item;
        if (menuItem != null) {
            MenuItem menuItem2 = item;
            menuItem.setChecked(Intrinsics.areEqual((Object)(menuItem2 != null ? Boolean.valueOf(menuItem2.isChecked()) : null), (Object)false));
        }
        MenuItem menuItem3 = item;
        Integer n2 = n = menuItem3 != null ? Integer.valueOf(menuItem3.getItemId()) : null;
        if (Intrinsics.areEqual((Object)n, (Object)R.id.paragraph)) {
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_PARAGRAPH);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_1)) {
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_1);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_2)) {
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_2);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_3)) {
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_3);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_4)) {
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_4);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_5)) {
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_5);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_6)) {
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_6);
            }
            return true;
        }
        return false;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable parcelable = state;
        if (parcelable == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.source.SourceViewEditText.SavedState");
        }
        SourceViewEditText.SavedState savedState = (SourceViewEditText.SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        Bundle restoredState = savedState.getState();
        this.toggleHtmlMode(restoredState.getBoolean("isSourceVisible"));
        this.enableMediaMode(restoredState.getBoolean("isMediaMode"));
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        SourceViewEditText.SavedState savedState = new SourceViewEditText.SavedState(parcelable);
        Bundle bundle = new Bundle();
        SourceViewEditText sourceViewEditText = this.sourceEditor;
        bundle.putBoolean("isSourceVisible", Intrinsics.areEqual((Object)(sourceViewEditText != null ? Integer.valueOf(sourceViewEditText.getVisibility()) : null), (Object)0));
        bundle.putBoolean("isMediaMode", this.isMediaModeEnabled);
        savedState.setState(bundle);
        return (Parcelable)savedState;
    }

    private final boolean isEditorAttached() {
        return this.editor != null && this.editor instanceof AztecText;
    }

    public final void setEditor(@NotNull AztecText editor, @NotNull SourceViewEditText sourceEditor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sourceEditor), (String)"sourceEditor");
        this.sourceEditor = sourceEditor;
        AztecText aztecText = this.editor = editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        aztecText.setOnSelectionChangedListener(new AztecText.OnSelectionChangedListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onSelectionChanged(int selStart, int selEnd) {
                AztecToolbar.access$highlightAppliedStyles(this.this$0, selStart, selEnd);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.aztec_format_bar, (ViewGroup)((ViewGroup)this));
        ToolbarAction[] toolbarActionArray = ToolbarAction.values();
        for (int i = 0; i < toolbarActionArray.length; ++i) {
            View button;
            ToolbarAction toolbarAction = toolbarActionArray[i];
            View view = button = this.findViewById(toolbarAction.getButtonId());
            if (view != null) {
                view.setOnClickListener(new View.OnClickListener(this, toolbarAction){
                    final /* synthetic */ AztecToolbar this$0;
                    final /* synthetic */ ToolbarAction $toolbarAction;

                    public final void onClick(View it) {
                        AztecToolbar.access$onToolbarAction(this.this$0, this.$toolbarAction);
                    }
                    {
                        this.this$0 = aztecToolbar;
                        this.$toolbarAction = toolbarAction;
                    }
                });
            }
            if (!Intrinsics.areEqual((Object)((Object)toolbarAction), (Object)((Object)ToolbarAction.HEADING))) continue;
            View view2 = this.findViewById(toolbarAction.getButtonId());
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(toolbarAction.buttonId)");
            this.setHeadingMenu(view2);
        }
    }

    public final void highlightActionButtons(@NotNull ArrayList<ToolbarAction> toolbarActions) {
        Intrinsics.checkParameterIsNotNull(toolbarActions, (String)"toolbarActions");
        Object[] $receiver$iv = (Object[])ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)((Object)element$iv);
            if (toolbarActions.contains((Object)action)) {
                this.toggleButton(this.findViewById(action.getButtonId()), true);
                continue;
            }
            this.toggleButton(this.findViewById(action.getButtonId()), false);
        }
    }

    private final ArrayList<ToolbarAction> getSelectedActions() {
        ArrayList<ToolbarAction> actions = new ArrayList<ToolbarAction>();
        ToolbarAction[] toolbarActionArray = ToolbarAction.values();
        for (int i = 0; i < toolbarActionArray.length; ++i) {
            ToolbarAction action = toolbarActionArray[i];
            View view = this.findViewById(action.getButtonId());
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.ToggleButton");
            }
            ToggleButton view2 = (ToggleButton)view;
            if (!view2.isChecked()) continue;
            actions.add(action);
        }
        return actions;
    }

    private final void toggleButton(View button, boolean checked) {
        if (button != null && button instanceof ToggleButton) {
            ((ToggleButton)button).setChecked(checked);
        }
    }

    private final void toggleButtonState(View button, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    private final void highlightAppliedStyles(int selStart, int selEnd) {
        if (!this.isEditorAttached()) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<TextFormat> appliedStyles = aztecText.getAppliedStyles(selStart, selEnd);
        this.highlightActionButtons(ToolbarAction.Companion.getToolbarActionsForStyles(appliedStyles));
        this.selectHeadingMenuItem(appliedStyles);
    }

    private final void onToolbarAction(ToolbarAction action) {
        if (!this.isEditorAttached()) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        if (!aztecText.isTextSelected() && Intrinsics.areEqual((Object)((Object)action.getActionType()), (Object)((Object)ToolbarActionType.INLINE_STYLE))) {
            ArrayList<ToolbarAction> actions = this.getSelectedActions();
            ArrayList<TextFormat> textFormats = new ArrayList<TextFormat>();
            Iterable $receiver$iv = actions;
            for (Object element$iv : $receiver$iv) {
                ToolbarAction it = (ToolbarAction)((Object)element$iv);
                if (!it.isStylingAction() || it.getTextFormat() == null) continue;
                textFormats.add(it.getTextFormat());
            }
            if (this.getSelectedHeadingMenuItem() != null) {
                TextFormat textFormat = this.getSelectedHeadingMenuItem();
                if (textFormat == null) {
                    Intrinsics.throwNpe();
                }
                textFormats.add(textFormat);
            }
            AztecText aztecText2 = this.editor;
            if (aztecText2 == null) {
                Intrinsics.throwNpe();
            }
            aztecText2.setSelectedStyles(textFormats);
            return;
        }
        if (action.isStylingAction() && Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.HEADING)) ^ true) {
            AztecText aztecText3 = this.editor;
            if (aztecText3 == null) {
                Intrinsics.throwNpe();
            }
            TextFormat textFormat = action.getTextFormat();
            if (textFormat == null) {
                Intrinsics.throwNpe();
            }
            aztecText3.toggleFormatting(textFormat);
            return;
        }
        switch (AztecToolbar$WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarAddMediaClicked();
                }
                break;
            }
            case 2: {
                PopupMenu popupMenu = this.headingMenu;
                if (popupMenu != null) {
                    popupMenu.show();
                }
                break;
            }
            case 3: {
                AztecText aztecText4 = this.editor;
                if (aztecText4 == null) {
                    Intrinsics.throwNpe();
                }
                AztecText.showLinkDialog$default(aztecText4, null, null, 3, null);
                break;
            }
            case 4: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarHtmlModeClicked();
                }
                break;
            }
            default: {
                Toast.makeText((Context)this.getContext(), (CharSequence)"Unsupported action", (int)0).show();
            }
        }
    }

    public final void toggleEditorMode() {
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        if (aztecText.getVisibility() == 0) {
            SourceViewEditText sourceViewEditText = this.sourceEditor;
            if (sourceViewEditText == null) {
                Intrinsics.throwNpe();
            }
            AztecText aztecText2 = this.editor;
            if (aztecText2 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText.displayStyledAndFormattedHtml(aztecText2.toPlainHtml(true));
            AztecText aztecText3 = this.editor;
            if (aztecText3 == null) {
                Intrinsics.throwNpe();
            }
            aztecText3.setVisibility(8);
            SourceViewEditText sourceViewEditText2 = this.sourceEditor;
            if (sourceViewEditText2 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText2.setVisibility(0);
            this.toggleHtmlMode(true);
        } else {
            AztecText aztecText4 = this.editor;
            if (aztecText4 == null) {
                Intrinsics.throwNpe();
            }
            SourceViewEditText sourceViewEditText = this.sourceEditor;
            if (sourceViewEditText == null) {
                Intrinsics.throwNpe();
            }
            aztecText4.fromHtml(sourceViewEditText.getPureHtml(true));
            AztecText aztecText5 = this.editor;
            if (aztecText5 == null) {
                Intrinsics.throwNpe();
            }
            aztecText5.setVisibility(0);
            SourceViewEditText sourceViewEditText3 = this.sourceEditor;
            if (sourceViewEditText3 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText3.setVisibility(8);
            this.toggleHtmlMode(false);
        }
    }

    private final void selectHeadingMenuItem(ArrayList<TextFormat> textFormats) {
        if (textFormats.size() == 0) {
            PopupMenu popupMenu = this.headingMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.getItem(0)) != null) {
                popupMenu.setChecked(true);
            }
        } else {
            Iterable $receiver$iv = textFormats;
            Iterator iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                TextFormat it = (TextFormat)((Object)element$iv);
                switch (AztecToolbar$WhenMappings.$EnumSwitchMapping$1[it.ordinal()]) {
                    case 1: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.getItem(1)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 2: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.getItem(2)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 3: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.getItem(3)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 4: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.getItem(4)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 5: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.getItem(5)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 6: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.getItem(6)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    default: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu == null || (popupMenu = popupMenu.getMenu()) == null || (popupMenu = popupMenu.getItem(0)) == null) break;
                        popupMenu.setChecked(true);
                        break;
                    }
                }
                return;
            }
        }
    }

    @Nullable
    public final PopupMenu getHeadingMenu() {
        return this.headingMenu;
    }

    private final void setHeadingMenu(View view) {
        block1: {
            PopupMenu popupMenu = this.headingMenu = new PopupMenu(this.getContext(), view);
            if (popupMenu != null) {
                popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
            }
            PopupMenu popupMenu2 = this.headingMenu;
            if (popupMenu2 == null) break block1;
            popupMenu2.inflate(R.menu.heading);
        }
    }

    @Nullable
    public final TextFormat getSelectedHeadingMenuItem() {
        PopupMenu popupMenu = this.headingMenu;
        Boolean bl = popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.getItem(0)) != null ? Boolean.valueOf(popupMenu.isChecked()) : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            return TextFormat.FORMAT_PARAGRAPH;
        }
        PopupMenu popupMenu2 = this.headingMenu;
        Boolean bl2 = popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.getItem(1)) != null ? Boolean.valueOf(popupMenu2.isChecked()) : null;
        if (bl2 == null) {
            Intrinsics.throwNpe();
        }
        if (bl2.booleanValue()) {
            return TextFormat.FORMAT_HEADING_1;
        }
        PopupMenu popupMenu3 = this.headingMenu;
        Boolean bl3 = popupMenu3 != null && (popupMenu3 = popupMenu3.getMenu()) != null && (popupMenu3 = popupMenu3.getItem(2)) != null ? Boolean.valueOf(popupMenu3.isChecked()) : null;
        if (bl3 == null) {
            Intrinsics.throwNpe();
        }
        if (bl3.booleanValue()) {
            return TextFormat.FORMAT_HEADING_2;
        }
        PopupMenu popupMenu4 = this.headingMenu;
        Boolean bl4 = popupMenu4 != null && (popupMenu4 = popupMenu4.getMenu()) != null && (popupMenu4 = popupMenu4.getItem(3)) != null ? Boolean.valueOf(popupMenu4.isChecked()) : null;
        if (bl4 == null) {
            Intrinsics.throwNpe();
        }
        if (bl4.booleanValue()) {
            return TextFormat.FORMAT_HEADING_3;
        }
        PopupMenu popupMenu5 = this.headingMenu;
        Boolean bl5 = popupMenu5 != null && (popupMenu5 = popupMenu5.getMenu()) != null && (popupMenu5 = popupMenu5.getItem(4)) != null ? Boolean.valueOf(popupMenu5.isChecked()) : null;
        if (bl5 == null) {
            Intrinsics.throwNpe();
        }
        if (bl5.booleanValue()) {
            return TextFormat.FORMAT_HEADING_4;
        }
        PopupMenu popupMenu6 = this.headingMenu;
        Boolean bl6 = popupMenu6 != null && (popupMenu6 = popupMenu6.getMenu()) != null && (popupMenu6 = popupMenu6.getItem(5)) != null ? Boolean.valueOf(popupMenu6.isChecked()) : null;
        if (bl6 == null) {
            Intrinsics.throwNpe();
        }
        if (bl6.booleanValue()) {
            return TextFormat.FORMAT_HEADING_5;
        }
        PopupMenu popupMenu7 = this.headingMenu;
        Boolean bl7 = popupMenu7 != null && (popupMenu7 = popupMenu7.getMenu()) != null && (popupMenu7 = popupMenu7.getItem(6)) != null ? Boolean.valueOf(popupMenu7.isChecked()) : null;
        if (bl7 == null) {
            Intrinsics.throwNpe();
        }
        if (bl7.booleanValue()) {
            return TextFormat.FORMAT_HEADING_6;
        }
        return null;
    }

    private final void toggleHtmlMode(boolean isHtmlMode) {
        Object[] $receiver$iv = (Object[])ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)((Object)element$iv);
            if (Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.HTML))) {
                this.toggleButton(this.findViewById(action.getButtonId()), isHtmlMode);
                continue;
            }
            this.toggleButtonState(this.findViewById(action.getButtonId()), !isHtmlMode);
        }
    }

    public final void enableFormatButtons(boolean isEnabled) {
        Object[] $receiver$iv = (Object[])ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)((Object)element$iv);
            if (!(Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.HTML)) ^ true)) continue;
            this.toggleButtonState(this.findViewById(action.getButtonId()), isEnabled);
        }
    }

    public final boolean isMediaModeEnabled() {
        return this.isMediaModeEnabled;
    }

    public final void enableMediaMode(boolean isEnabled) {
        this.isMediaModeEnabled = isEnabled;
        Object[] $receiver$iv = (Object[])ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)((Object)element$iv);
            if (Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.ADD_MEDIA))) {
                this.toggleButton(this.findViewById(action.getButtonId()), isEnabled);
                continue;
            }
            this.toggleButtonState(this.findViewById(action.getButtonId()), !isEnabled);
        }
    }

    private final void showDialogShortcuts() {
        View layout2 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dialog_shortcuts, null);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setView(layout2);
        AlertDialog alertDialog = this.dialogShortcuts = builder.create();
        if (alertDialog == null) {
            Intrinsics.throwNpe();
        }
        alertDialog.show();
    }

    public AztecToolbar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.initView();
    }

    public AztecToolbar(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.initView();
    }

    public AztecToolbar(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public static final /* synthetic */ void access$highlightAppliedStyles(AztecToolbar $this, int selStart, int selEnd) {
        $this.highlightAppliedStyles(selStart, selEnd);
    }

    public static final /* synthetic */ void access$onToolbarAction(AztecToolbar $this, @NotNull ToolbarAction action) {
        $this.onToolbarAction(action);
    }
}

