/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.text.style.StyleSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecPart;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.formatting.InlineFormatter$WhenMappings;
import org.wordpress.aztec.spans.AztecCodeSpan;
import org.wordpress.aztec.spans.AztecInlineSpan;
import org.wordpress.aztec.spans.AztecStrikethroughSpan;
import org.wordpress.aztec.spans.AztecStyleBoldSpan;
import org.wordpress.aztec.spans.AztecStyleItalicSpan;
import org.wordpress.aztec.spans.AztecStyleSpan;
import org.wordpress.aztec.spans.AztecUnderlineSpan;
import org.wordpress.aztec.watchers.TextChangedEvent;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u000212B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u0016\u0010#\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u001e\u0010$\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020!0&2\b\b\u0002\u0010'\u001a\u00020(J\u000e\u0010$\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010)\u001a\u00020\u000fJ\"\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u0006\u0010+\u001a\u00020\u000fJ\u0006\u0010,\u001a\u00020\u000fJ\u0006\u0010-\u001a\u00020\u000fJ\u0006\u0010.\u001a\u00020\u000fJ\u0006\u0010/\u001a\u00020\u000fJ\u0006\u00100\u001a\u00020\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00063"}, d2={"Lorg/wordpress/aztec/formatting/InlineFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "codeStyle", "Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;)V", "carryOverSpans", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/formatting/InlineFormatter$CarryOverSpan;", "getCarryOverSpans", "()Ljava/util/ArrayList;", "getCodeStyle", "()Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "applyInlineStyle", "", "textFormat", "Lorg/wordpress/aztec/TextFormat;", "start", "", "end", "carryOverInlineSpans", "count", "after", "clearInlineStyles", "ignoreSelectedStyles", "", "containsInlineStyle", "handleInlineStyling", "textChangedEvent", "Lorg/wordpress/aztec/watchers/TextChangedEvent;", "isSameInlineSpanType", "firstSpan", "Lorg/wordpress/aztec/spans/AztecInlineSpan;", "secondSpan", "joinStyleSpans", "makeInlineSpan", "spanType", "Ljava/lang/Class;", "attrs", "Lorg/wordpress/aztec/AztecAttributes;", "reapplyCarriedOverInlineSpans", "removeInlineStyle", "toggleBold", "toggleCode", "toggleItalic", "toggleStrikethrough", "toggleUnderline", "tryRemoveLeadingInlineStyle", "CarryOverSpan", "CodeStyle", "aztec_release"})
public final class InlineFormatter
extends AztecFormatter {
    @NotNull
    private final ArrayList<CarryOverSpan> carryOverSpans;
    @NotNull
    private final CodeStyle codeStyle;

    @NotNull
    public final ArrayList<CarryOverSpan> getCarryOverSpans() {
        return this.carryOverSpans;
    }

    public final void toggleBold() {
        if (!InlineFormatter.containsInlineStyle$default(this, TextFormat.FORMAT_BOLD, 0, 0, 6, null)) {
            InlineFormatter.applyInlineStyle$default(this, TextFormat.FORMAT_BOLD, 0, 0, 6, null);
        } else {
            InlineFormatter.removeInlineStyle$default(this, TextFormat.FORMAT_BOLD, 0, 0, 6, null);
        }
    }

    public final void toggleItalic() {
        if (!InlineFormatter.containsInlineStyle$default(this, TextFormat.FORMAT_ITALIC, 0, 0, 6, null)) {
            InlineFormatter.applyInlineStyle$default(this, TextFormat.FORMAT_ITALIC, 0, 0, 6, null);
        } else {
            InlineFormatter.removeInlineStyle$default(this, TextFormat.FORMAT_ITALIC, 0, 0, 6, null);
        }
    }

    public final void toggleStrikethrough() {
        if (!InlineFormatter.containsInlineStyle$default(this, TextFormat.FORMAT_STRIKETHROUGH, 0, 0, 6, null)) {
            InlineFormatter.applyInlineStyle$default(this, TextFormat.FORMAT_STRIKETHROUGH, 0, 0, 6, null);
        } else {
            InlineFormatter.removeInlineStyle$default(this, TextFormat.FORMAT_STRIKETHROUGH, 0, 0, 6, null);
        }
    }

    public final void toggleUnderline() {
        if (!InlineFormatter.containsInlineStyle$default(this, TextFormat.FORMAT_UNDERLINE, 0, 0, 6, null)) {
            InlineFormatter.applyInlineStyle$default(this, TextFormat.FORMAT_UNDERLINE, 0, 0, 6, null);
        } else {
            InlineFormatter.removeInlineStyle$default(this, TextFormat.FORMAT_UNDERLINE, 0, 0, 6, null);
        }
    }

    public final void toggleCode() {
        if (!InlineFormatter.containsInlineStyle$default(this, TextFormat.FORMAT_CODE, 0, 0, 6, null)) {
            InlineFormatter.applyInlineStyle$default(this, TextFormat.FORMAT_CODE, 0, 0, 6, null);
        } else {
            InlineFormatter.removeInlineStyle$default(this, TextFormat.FORMAT_CODE, 0, 0, 6, null);
        }
    }

    public final void carryOverInlineSpans(int start, int count, int after) {
        this.carryOverSpans.clear();
        int charsAdded = after - count;
        if (charsAdded > 0 && count > 0) {
            Object[] $receiver$iv = this.getEditableText().getSpans(start, start + count, AztecInlineSpan.class);
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                AztecInlineSpan it = (AztecInlineSpan)element$iv;
                int spanStart = this.getEditableText().getSpanStart((Object)it);
                int spanEnd = this.getEditableText().getSpanEnd((Object)it);
                if (spanStart != start && spanEnd != count + start || spanEnd >= after) continue;
                this.getEditableText().removeSpan((Object)it);
                AztecInlineSpan aztecInlineSpan = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"it");
                this.carryOverSpans.add(new CarryOverSpan(aztecInlineSpan, spanStart, spanEnd));
            }
        }
    }

    public final void reapplyCarriedOverInlineSpans() {
        Iterable $receiver$iv = this.carryOverSpans;
        for (Object element$iv : $receiver$iv) {
            CarryOverSpan it = (CarryOverSpan)element$iv;
            this.getEditableText().setSpan((Object)it.getSpan(), it.getStart(), it.getEnd(), 33);
        }
        this.carryOverSpans.clear();
    }

    public final void handleInlineStyling(@NotNull TextChangedEvent textChangedEvent) {
        Intrinsics.checkParameterIsNotNull((Object)textChangedEvent, (String)"textChangedEvent");
        if (!this.getEditor().formattingHasChanged() || textChangedEvent.isNewLineButNotAtTheBeginning()) {
            return;
        }
        this.clearInlineStyles(textChangedEvent.getInputStart(), textChangedEvent.getInputEnd(), textChangedEvent.isNewLineButNotAtTheBeginning());
        if (this.getEditor().formattingIsApplied()) {
            for (TextFormat item : this.getEditor().getSelectedStyles()) {
                switch (InlineFormatter$WhenMappings.$EnumSwitchMapping$0[item.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        AztecText aztecText = this.getEditor();
                        TextFormat textFormat = item;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)textFormat), (String)"item");
                        if (aztecText.contains(textFormat, textChangedEvent.getInputStart(), textChangedEvent.getInputEnd())) break;
                        TextFormat textFormat2 = item;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)textFormat2), (String)"item");
                        this.applyInlineStyle(textFormat2, textChangedEvent.getInputStart(), textChangedEvent.getInputEnd());
                    }
                }
            }
        }
        this.getEditor().setFormattingChangesApplied();
    }

    private final void clearInlineStyles(int start, int end, boolean ignoreSelectedStyles) {
        int newStart = start > end ? end : start;
        Iterable $receiver$iv = this.getEditor().getAppliedStyles(start, end);
        for (Object element$iv : $receiver$iv) {
            TextFormat it = (TextFormat)((Object)element$iv);
            if (this.getEditor().getSelectedStyles().contains((Object)it) && !ignoreSelectedStyles && (start != 0 || end != 0) && (start <= end || this.getEditableText().length() <= end || this.getEditableText().charAt(end) != '\n')) continue;
            switch (InlineFormatter$WhenMappings.$EnumSwitchMapping$1[it.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.removeInlineStyle(it, newStart, end);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void applyInlineStyle(@NotNull TextFormat textFormat, int start, int end) {
        Object followingSpan;
        Ref.ObjectRef nextSpans;
        int spanEnd;
        Object precedingSpan;
        AztecInlineSpan it;
        Object element$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        AztecInlineSpan spanToApply = this.makeInlineSpan(textFormat);
        if (start >= end) {
            return;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        if (start >= 1) {
            AztecInlineSpan[] previousSpans = (AztecInlineSpan[])this.getEditableText().getSpans(start - 1, start, AztecInlineSpan.class);
            $receiver$iv = previousSpans;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                element$iv = $receiver$iv[i];
                AztecInlineSpan aztecInlineSpan = it = (AztecInlineSpan)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(aztecInlineSpan, spanToApply)) continue;
                precedingSpan.element = it;
            }
            if ((AztecInlineSpan)precedingSpan.element != null) {
                int spanStart = this.getEditableText().getSpanStart((Object)((AztecInlineSpan)precedingSpan.element));
                spanEnd = this.getEditableText().getSpanEnd((Object)((AztecInlineSpan)precedingSpan.element));
                if (spanEnd > start) {
                    return;
                }
                this.getEditableText().setSpan((Object)((AztecInlineSpan)precedingSpan.element), spanStart, end, 34);
            }
        }
        if (this.getEditor().length() > end) {
            nextSpans = (Ref.ObjectRef)this.getEditableText().getSpans(end, end + 1, AztecInlineSpan.class);
            $receiver$iv = (Object[])nextSpans;
            for (spanEnd = 0; spanEnd < $receiver$iv.length; ++spanEnd) {
                element$iv = $receiver$iv[spanEnd];
                AztecInlineSpan aztecInlineSpan = it = (AztecInlineSpan)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(aztecInlineSpan, spanToApply)) continue;
                followingSpan.element = it;
            }
            if ((AztecInlineSpan)followingSpan.element != null) {
                int spanEnd2 = this.getEditableText().getSpanEnd((Object)((AztecInlineSpan)followingSpan.element));
                this.getEditableText().setSpan((Object)((AztecInlineSpan)followingSpan.element), start, spanEnd2, 34);
            }
        }
        if ((AztecInlineSpan)precedingSpan.element == null && (AztecInlineSpan)followingSpan.element == null) {
            void existingSpanOfSameStyle;
            nextSpans = new Ref.ObjectRef();
            nextSpans.element = null;
            AztecInlineSpan[] spans = (AztecInlineSpan[])this.getEditableText().getSpans(start, end, AztecInlineSpan.class);
            Object[] $receiver$iv2 = spans;
            for (int i = 0; i < $receiver$iv2.length; ++i) {
                AztecInlineSpan it2;
                Object element$iv2 = $receiver$iv2[i];
                AztecInlineSpan aztecInlineSpan = it2 = (AztecInlineSpan)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(aztecInlineSpan, spanToApply)) continue;
                existingSpanOfSameStyle.element = it2;
            }
            if ((AztecInlineSpan)existingSpanOfSameStyle.element != null) {
                this.getEditableText().removeSpan((Object)((AztecInlineSpan)existingSpanOfSameStyle.element));
                this.getEditableText().setSpan((Object)((AztecInlineSpan)existingSpanOfSameStyle.element), start, end, 34);
            } else {
                this.getEditableText().setSpan((Object)spanToApply, start, end, 34);
            }
            Object var7_7 = null;
        }
        this.joinStyleSpans(start, end);
        followingSpan = null;
        precedingSpan = null;
    }

    public static /* bridge */ /* synthetic */ void applyInlineStyle$default(InlineFormatter inlineFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        inlineFormatter.applyInlineStyle(textFormat, n, n2);
    }

    public final void removeInlineStyle(@NotNull TextFormat textFormat, int start, int end) {
        Object it;
        Object element$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        AztecInlineSpan spanToRemove = this.makeInlineSpan(textFormat);
        AztecInlineSpan[] spans = (AztecInlineSpan[])this.getEditableText().getSpans(start, end, AztecInlineSpan.class);
        ArrayList<AztecPart> list = new ArrayList<AztecPart>();
        Object $receiver$iv = spans;
        for (int i = 0; i < ((Object[])$receiver$iv).length; ++i) {
            element$iv = $receiver$iv[i];
            it = (AztecInlineSpan)element$iv;
            AztecInlineSpan aztecInlineSpan = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"it");
            if (!this.isSameInlineSpanType(aztecInlineSpan, spanToRemove)) continue;
            list.add(new AztecPart(this.getEditableText().getSpanStart(it), this.getEditableText().getSpanEnd(it)));
            this.getEditableText().removeSpan(it);
        }
        $receiver$iv = list;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (AztecPart)element$iv;
            if (!((AztecPart)it).isValid()) continue;
            if (((AztecPart)it).getStart() < start) {
                this.applyInlineStyle(textFormat, ((AztecPart)it).getStart(), start);
            }
            if (((AztecPart)it).getEnd() <= end) continue;
            this.applyInlineStyle(textFormat, end, ((AztecPart)it).getEnd());
        }
        this.joinStyleSpans(start, end);
    }

    public static /* bridge */ /* synthetic */ void removeInlineStyle$default(InlineFormatter inlineFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        inlineFormatter.removeInlineStyle(textFormat, n, n2);
    }

    public final boolean isSameInlineSpanType(@NotNull AztecInlineSpan firstSpan, @NotNull AztecInlineSpan secondSpan) {
        Intrinsics.checkParameterIsNotNull((Object)firstSpan, (String)"firstSpan");
        Intrinsics.checkParameterIsNotNull((Object)secondSpan, (String)"secondSpan");
        if (Intrinsics.areEqual(firstSpan.getClass(), secondSpan.getClass())) {
            if (firstSpan instanceof StyleSpan && secondSpan instanceof StyleSpan) {
                return ((StyleSpan)firstSpan).getStyle() == ((StyleSpan)secondSpan).getStyle();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void joinStyleSpans(int start, int end) {
        AztecInlineSpan outerSpan;
        Object element$iv;
        int n;
        Object[] $receiver$iv;
        AztecInlineSpan innerSpan;
        Object element$iv2;
        int n2;
        Object[] $receiver$iv2;
        AztecInlineSpan[] spansInSelection;
        if (start > 1) {
            spansInSelection = (AztecInlineSpan[])this.getEditableText().getSpans(start, end, AztecInlineSpan.class);
            AztecInlineSpan[] spansBeforeSelection = (AztecInlineSpan[])this.getEditableText().getSpans(start - 1, start, AztecInlineSpan.class);
            $receiver$iv2 = spansInSelection;
            for (n2 = 0; n2 < $receiver$iv2.length; ++n2) {
                element$iv2 = $receiver$iv2[n2];
                innerSpan = (AztecInlineSpan)element$iv2;
                int inSelectionSpanEnd = this.getEditableText().getSpanEnd((Object)innerSpan);
                if (inSelectionSpanEnd == -1) continue;
                $receiver$iv = spansBeforeSelection;
                for (n = 0; n < $receiver$iv.length; ++n) {
                    element$iv = $receiver$iv[n];
                    outerSpan = (AztecInlineSpan)element$iv;
                    int outerSpanStart = this.getEditableText().getSpanStart((Object)outerSpan);
                    AztecInlineSpan aztecInlineSpan = innerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"innerSpan");
                    AztecInlineSpan aztecInlineSpan2 = outerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan2, (String)"outerSpan");
                    if (!this.isSameInlineSpanType(aztecInlineSpan, aztecInlineSpan2)) continue;
                    this.getEditableText().removeSpan((Object)outerSpan);
                    this.getEditableText().setSpan((Object)innerSpan, outerSpanStart, inSelectionSpanEnd, 34);
                }
            }
        }
        if (this.getEditor().length() > end) {
            spansInSelection = (AztecInlineSpan[])this.getEditableText().getSpans(start, end, AztecInlineSpan.class);
            AztecInlineSpan[] spansAfterSelection = (AztecInlineSpan[])this.getEditableText().getSpans(end, end + 1, AztecInlineSpan.class);
            $receiver$iv2 = spansInSelection;
            for (n2 = 0; n2 < $receiver$iv2.length; ++n2) {
                element$iv2 = $receiver$iv2[n2];
                innerSpan = (AztecInlineSpan)element$iv2;
                int inSelectionSpanStart = this.getEditableText().getSpanStart((Object)innerSpan);
                if (inSelectionSpanStart == -1) continue;
                $receiver$iv = spansAfterSelection;
                for (n = 0; n < $receiver$iv.length; ++n) {
                    element$iv = $receiver$iv[n];
                    outerSpan = (AztecInlineSpan)element$iv;
                    int outerSpanEnd = this.getEditableText().getSpanEnd((Object)outerSpan);
                    AztecInlineSpan aztecInlineSpan = innerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"innerSpan");
                    AztecInlineSpan aztecInlineSpan3 = outerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan3, (String)"outerSpan");
                    if (!this.isSameInlineSpanType(aztecInlineSpan, aztecInlineSpan3)) continue;
                    this.getEditableText().removeSpan((Object)outerSpan);
                    this.getEditableText().setSpan((Object)innerSpan, inSelectionSpanStart, outerSpanEnd, 34);
                }
            }
        }
        spansInSelection = (AztecInlineSpan[])this.getEditableText().getSpans(start, end, AztecInlineSpan.class);
        AztecInlineSpan[] spansToUse = (AztecInlineSpan[])this.getEditableText().getSpans(start, end, AztecInlineSpan.class);
        $receiver$iv2 = spansInSelection;
        for (n2 = 0; n2 < $receiver$iv2.length; ++n2) {
            void neighbourSpan;
            element$iv2 = $receiver$iv2[n2];
            AztecInlineSpan appliedSpan = (AztecInlineSpan)element$iv2;
            int spanStart = this.getEditableText().getSpanStart((Object)appliedSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)appliedSpan);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Object[] $receiver$iv3 = spansToUse;
            for (int outerSpan2 = 0; outerSpan2 < $receiver$iv3.length; ++outerSpan2) {
                Object element$iv3 = $receiver$iv3[outerSpan2];
                AztecInlineSpan it = (AztecInlineSpan)element$iv3;
                int aSpanStart = this.getEditableText().getSpanStart((Object)it);
                int aSpanEnd = this.getEditableText().getSpanEnd((Object)it);
                AztecInlineSpan aztecInlineSpan = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"it");
                AztecInlineSpan aztecInlineSpan4 = appliedSpan;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan4, (String)"appliedSpan");
                if (!this.isSameInlineSpanType(aztecInlineSpan, aztecInlineSpan4) || aSpanStart != spanEnd && aSpanEnd != spanStart) continue;
                neighbourSpan.element = it;
            }
            if ((AztecInlineSpan)neighbourSpan.element != null) {
                int neighbourSpanStart = this.getEditableText().getSpanStart((Object)((AztecInlineSpan)neighbourSpan.element));
                int neighbourSpanEnd = this.getEditableText().getSpanEnd((Object)((AztecInlineSpan)neighbourSpan.element));
                if (neighbourSpanStart == -1 || neighbourSpanEnd == -1) continue;
                if (spanStart == neighbourSpanEnd) {
                    this.getEditableText().setSpan((Object)appliedSpan, neighbourSpanStart, spanEnd, 34);
                } else if (spanEnd == neighbourSpanStart) {
                    this.getEditableText().setSpan((Object)appliedSpan, spanStart, neighbourSpanEnd, 34);
                }
                this.getEditableText().removeSpan((Object)((AztecInlineSpan)neighbourSpan.element));
            }
            objectRef = null;
        }
    }

    @NotNull
    public final AztecInlineSpan makeInlineSpan(@NotNull TextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        switch (InlineFormatter$WhenMappings.$EnumSwitchMapping$2[textFormat.ordinal()]) {
            case 1: {
                return new AztecStyleBoldSpan(null, 1, null);
            }
            case 2: {
                return new AztecStyleItalicSpan(null, 1, null);
            }
            case 3: {
                return new AztecStrikethroughSpan();
            }
            case 4: {
                return new AztecUnderlineSpan(null, 1, null);
            }
            case 5: {
                return new AztecCodeSpan(this.codeStyle, null, 2, null);
            }
        }
        return new AztecStyleSpan(0, null, 2, null);
    }

    @NotNull
    public final AztecInlineSpan makeInlineSpan(@NotNull Class<AztecInlineSpan> spanType, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull(spanType, (String)"spanType");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Class<AztecInlineSpan> clazz = spanType;
        if (Intrinsics.areEqual(clazz, AztecCodeSpan.class)) {
            return new AztecCodeSpan(this.codeStyle, attrs);
        }
        return new AztecStyleSpan(0, null, 2, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AztecInlineSpan makeInlineSpan$default(InlineFormatter inlineFormatter, Class clazz, AztecAttributes aztecAttributes, int n, Object object) {
        if ((n & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return inlineFormatter.makeInlineSpan(clazz, aztecAttributes);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsInlineStyle(@NotNull TextFormat textFormat, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        AztecInlineSpan spanToCheck = this.makeInlineSpan(textFormat);
        if (start > end) {
            return false;
        }
        if (start == end) {
            void $receiver$iv$iv;
            void $receiver$iv22;
            Object[] $receiver$iv$iv2;
            void $receiver$iv;
            if (start - 1 < 0 || start + 1 > this.getEditableText().length()) {
                return false;
            }
            Object[] objectArray = this.getEditableText().getSpans(start - 1, start, AztecInlineSpan.class);
            void var7_8 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < $receiver$iv$iv2.length; ++i) {
                AztecInlineSpan it;
                void element$iv$iv = $receiver$iv$iv2[i];
                AztecInlineSpan aztecInlineSpan = it = (AztecInlineSpan)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(aztecInlineSpan, spanToCheck)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            AztecInlineSpan before = (AztecInlineSpan)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            $receiver$iv$iv2 = this.getEditableText().getSpans(start, start + 1, AztecInlineSpan.class);
            destination$iv$iv = $receiver$iv22;
            Collection destination$iv$iv2 = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                AztecInlineSpan it;
                void element$iv$iv = $receiver$iv$iv[i];
                AztecInlineSpan aztecInlineSpan = it = (AztecInlineSpan)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(aztecInlineSpan, spanToCheck)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            AztecInlineSpan after = (AztecInlineSpan)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
            return before != null && after != null && this.isSameInlineSpanType(before, after);
        }
        StringBuilder builder = new StringBuilder();
        int after = start;
        int $receiver$iv22 = end - 1;
        if (after <= $receiver$iv22) {
            while (true) {
                void i;
                AztecInlineSpan[] spans = (AztecInlineSpan[])this.getEditableText().getSpans((int)i, (int)(i + true), AztecInlineSpan.class);
                for (int j = 0; j < spans.length; ++j) {
                    AztecInlineSpan span;
                    AztecInlineSpan aztecInlineSpan = span = spans[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)aztecInlineSpan, (String)"span");
                    if (!this.isSameInlineSpanType(aztecInlineSpan, spanToCheck)) continue;
                    builder.append(((Object)this.getEditableText().subSequence((int)i, (int)(i + true))).toString());
                    break;
                }
                if (i == $receiver$iv22) break;
                ++i;
            }
        }
        CharSequence $receiver$iv22 = this.getEditableText().subSequence(start, end);
        CharSequence charSequence = "\n";
        charSequence = new Regex((String)charSequence);
        String string2 = "";
        String originalText = charSequence.replace($receiver$iv22, string2);
        charSequence = builder.toString();
        string2 = "\n";
        string2 = new Regex(string2);
        String string3 = "";
        String textOfCombinedSpans = string2.replace(charSequence, string3);
        charSequence = originalText;
        return charSequence.length() > 0 && Intrinsics.areEqual((Object)originalText, (Object)textOfCombinedSpans);
    }

    public static /* bridge */ /* synthetic */ boolean containsInlineStyle$default(InlineFormatter inlineFormatter, TextFormat textFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        return inlineFormatter.containsInlineStyle(textFormat, n, n2);
    }

    public final void tryRemoveLeadingInlineStyle() {
        int selectionStart = this.getEditor().getSelectionStart();
        int selectionEnd = this.getEditor().getSelectionEnd();
        if (selectionStart == 1 && selectionEnd == selectionStart) {
            Object[] $receiver$iv = this.getEditableText().getSpans(0, 0, AztecInlineSpan.class);
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                AztecInlineSpan it = (AztecInlineSpan)element$iv;
                if (this.getEditableText().getSpanEnd((Object)it) != selectionEnd || this.getEditableText().getSpanEnd((Object)it) != selectionStart) continue;
                this.getEditableText().removeSpan((Object)it);
            }
        }
    }

    @NotNull
    public final CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    public InlineFormatter(@NotNull AztecText editor, @NotNull CodeStyle codeStyle) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)codeStyle, (String)"codeStyle");
        super(editor);
        this.codeStyle = codeStyle;
        this.carryOverSpans = new ArrayList();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/wordpress/aztec/formatting/InlineFormatter$CarryOverSpan;", "", "span", "Lorg/wordpress/aztec/spans/AztecInlineSpan;", "start", "", "end", "(Lorg/wordpress/aztec/spans/AztecInlineSpan;II)V", "getEnd", "()I", "getSpan", "()Lorg/wordpress/aztec/spans/AztecInlineSpan;", "getStart", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class CarryOverSpan {
        @NotNull
        private final AztecInlineSpan span;
        private final int start;
        private final int end;

        @NotNull
        public final AztecInlineSpan getSpan() {
            return this.span;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public CarryOverSpan(@NotNull AztecInlineSpan span, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
            this.span = span;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public final AztecInlineSpan component1() {
            return this.span;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final CarryOverSpan copy(@NotNull AztecInlineSpan span, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
            return new CarryOverSpan(span, start, end);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CarryOverSpan copy$default(CarryOverSpan carryOverSpan, AztecInlineSpan aztecInlineSpan, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                aztecInlineSpan = carryOverSpan.span;
            }
            if ((n3 & 2) != 0) {
                n = carryOverSpan.start;
            }
            if ((n3 & 4) != 0) {
                n2 = carryOverSpan.end;
            }
            return carryOverSpan.copy(aztecInlineSpan, n, n2);
        }

        public String toString() {
            return "CarryOverSpan(span=" + this.span + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            AztecInlineSpan aztecInlineSpan = this.span;
            return ((aztecInlineSpan != null ? aztecInlineSpan.hashCode() : 0) * 31 + this.start) * 31 + this.end;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CarryOverSpan)) break block3;
                    CarryOverSpan carryOverSpan = (CarryOverSpan)object;
                    if (!Intrinsics.areEqual((Object)this.span, (Object)carryOverSpan.span) || !(this.start == carryOverSpan.start) || !(this.end == carryOverSpan.end)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "", "codeBackground", "", "codeBackgroundAlpha", "", "codeColor", "(IFI)V", "getCodeBackground", "()I", "getCodeBackgroundAlpha", "()F", "getCodeColor", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class CodeStyle {
        private final int codeBackground;
        private final float codeBackgroundAlpha;
        private final int codeColor;

        public final int getCodeBackground() {
            return this.codeBackground;
        }

        public final float getCodeBackgroundAlpha() {
            return this.codeBackgroundAlpha;
        }

        public final int getCodeColor() {
            return this.codeColor;
        }

        public CodeStyle(int codeBackground, float codeBackgroundAlpha, int codeColor) {
            this.codeBackground = codeBackground;
            this.codeBackgroundAlpha = codeBackgroundAlpha;
            this.codeColor = codeColor;
        }

        public final int component1() {
            return this.codeBackground;
        }

        public final float component2() {
            return this.codeBackgroundAlpha;
        }

        public final int component3() {
            return this.codeColor;
        }

        @NotNull
        public final CodeStyle copy(int codeBackground, float codeBackgroundAlpha, int codeColor) {
            return new CodeStyle(codeBackground, codeBackgroundAlpha, codeColor);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CodeStyle copy$default(CodeStyle codeStyle, int n, float f, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = codeStyle.codeBackground;
            }
            if ((n3 & 2) != 0) {
                f = codeStyle.codeBackgroundAlpha;
            }
            if ((n3 & 4) != 0) {
                n2 = codeStyle.codeColor;
            }
            return codeStyle.copy(n, f, n2);
        }

        public String toString() {
            return "CodeStyle(codeBackground=" + this.codeBackground + ", codeBackgroundAlpha=" + this.codeBackgroundAlpha + ", codeColor=" + this.codeColor + ")";
        }

        public int hashCode() {
            return (this.codeBackground * 31 + Float.floatToIntBits(this.codeBackgroundAlpha)) * 31 + this.codeColor;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CodeStyle)) break block3;
                    CodeStyle codeStyle = (CodeStyle)object;
                    if (!(this.codeBackground == codeStyle.codeBackground) || Float.compare(this.codeBackgroundAlpha, codeStyle.codeBackgroundAlpha) != 0 || !(this.codeColor == codeStyle.codeColor)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

