/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextWatcher;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.spans.MarkForReplay;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003J(\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/wordpress/aztec/watchers/BlockElementWatcher;", "Landroid/text/TextWatcher;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "(Lorg/wordpress/aztec/AztecText;)V", "aztecTextRef", "Ljava/lang/ref/WeakReference;", "handlers", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/watchers/BlockElementWatcher$TextChangeHandler;", "getHandlers", "()Ljava/util/ArrayList;", "add", "textChangeHandler", "afterTextChanged", "", "text", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "", "count", "after", "install", "onTextChanged", "s", "before", "Companion", "TextChangeHandler", "aztec_release"})
public final class BlockElementWatcher
implements TextWatcher {
    @NotNull
    private final ArrayList<TextChangeHandler> handlers;
    private final WeakReference<AztecText> aztecTextRef;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ArrayList<TextChangeHandler> getHandlers() {
        return this.handlers;
    }

    public void beforeTextChanged(@NotNull CharSequence text, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
    }

    public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
        boolean bl;
        boolean hasReplay;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        if (aztecText != null ? aztecText.isTextChangedListenerDisabled() : true) {
            return;
        }
        if (count == 0) {
            return;
        }
        int startIndex = start;
        int charCount = count;
        do {
            int nestingLevelToProcess = IAztecNestable.Companion.getNestingLevelAt((Spanned)s, startIndex, startIndex + charCount);
            Iterable $receiver$iv = this.handlers;
            for (Object element$iv : $receiver$iv) {
                TextChangeHandler textChangeHandler = (TextChangeHandler)element$iv;
                textChangeHandler.handleTextChanged((Spannable)s, startIndex, charCount, nestingLevelToProcess);
            }
            AztecText aztecText2 = (AztecText)this.aztecTextRef.get();
            if (aztecText2 != null && (aztecText2 = aztecText2.getText()) != null) {
                int n = 0;
                AztecText aztecText3 = aztecText2;
                Object text = aztecText3;
                Object[] $receiver$iv2 = text.getSpans(0, s.length(), MarkForReplay.class);
                if (n < $receiver$iv2.length) {
                    Object element$iv = $receiver$iv2[n];
                    MarkForReplay mark = (MarkForReplay)element$iv;
                    if (mark != null) {
                        startIndex = text.getSpanStart((Object)mark);
                        charCount = text.getSpanEnd((Object)mark) - startIndex;
                        text.removeSpan((Object)mark);
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (hasReplay = bl);
    }

    public void afterTextChanged(@NotNull Editable text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
    }

    @NotNull
    public final BlockElementWatcher add(@NotNull TextChangeHandler textChangeHandler) {
        Intrinsics.checkParameterIsNotNull((Object)textChangeHandler, (String)"textChangeHandler");
        this.handlers.add(textChangeHandler);
        return this;
    }

    @NotNull
    public final BlockElementWatcher install(@NotNull AztecText text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        text.addTextChangedListener(this);
        return this;
    }

    public BlockElementWatcher(@NotNull AztecText aztecText) {
        Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
        this.handlers = new ArrayList();
        this.aztecTextRef = new WeakReference<AztecText>(aztecText);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H&\u00a8\u0006\n"}, d2={"Lorg/wordpress/aztec/watchers/BlockElementWatcher$TextChangeHandler;", "", "handleTextChanged", "", "text", "Landroid/text/Spannable;", "inputStart", "", "count", "nestingLevel", "aztec_release"})
    public static interface TextChangeHandler {
        public void handleTextChanged(@NotNull Spannable var1, int var2, int var3, int var4);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/watchers/BlockElementWatcher$Companion;", "", "()V", "replay", "", "text", "Landroid/text/Spannable;", "index", "", "aztec_release"})
    public static final class Companion {
        public final void replay(@NotNull Spannable text, int index) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            text.setSpan((Object)new MarkForReplay(), index, index + 1, 33);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

