/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.handlers;

import android.text.Spannable;
import android.text.Spanned;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.handlers.BlockHandler$WhenMappings;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.util.SpanWrapper;
import org.wordpress.aztec.watchers.BlockElementWatcher;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 /*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002/0B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0016J\b\u0010'\u001a\u00020$H\u0016J\b\u0010(\u001a\u00020$H\u0016J\b\u0010)\u001a\u00020$H\u0016J(\u0010*\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010-\u001a\u00020.H\u0016R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00061"}, d2={"Lorg/wordpress/aztec/handlers/BlockHandler;", "SpanType", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "Lorg/wordpress/aztec/watchers/BlockElementWatcher$TextChangeHandler;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "block", "Lorg/wordpress/aztec/util/SpanWrapper;", "getBlock", "()Lorg/wordpress/aztec/util/SpanWrapper;", "setBlock", "(Lorg/wordpress/aztec/util/SpanWrapper;)V", "getClazz", "()Ljava/lang/Class;", "markerIndex", "", "getMarkerIndex", "()I", "setMarkerIndex", "(I)V", "nestingLevel", "getNestingLevel", "setNestingLevel", "newlineIndex", "getNewlineIndex", "setNewlineIndex", "text", "Landroid/text/Spannable;", "getText", "()Landroid/text/Spannable;", "setText", "(Landroid/text/Spannable;)V", "getNewlinePositionType", "Lorg/wordpress/aztec/handlers/BlockHandler$PositionType;", "handleEndOfBufferMarker", "", "handleNewlineAtEmptyBody", "handleNewlineAtEmptyLineAtBlockEnd", "handleNewlineAtStartOfBlock", "handleNewlineAtTextEnd", "handleNewlineInBody", "handleTextChanged", "inputStart", "count", "shouldHandle", "", "Companion", "PositionType", "aztec_release"})
public abstract class BlockHandler<SpanType extends IAztecBlockSpan>
implements BlockElementWatcher.TextChangeHandler {
    @NotNull
    public Spannable text;
    @NotNull
    public SpanWrapper<SpanType> block;
    private int newlineIndex;
    private int nestingLevel;
    private int markerIndex;
    @NotNull
    private final Class<SpanType> clazz;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Spannable getText() {
        Spannable spannable = this.text;
        if (spannable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        return spannable;
    }

    public final void setText(@NotNull Spannable spannable) {
        Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"<set-?>");
        this.text = spannable;
    }

    @NotNull
    public final SpanWrapper<SpanType> getBlock() {
        SpanWrapper<SpanType> spanWrapper = this.block;
        if (spanWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"block");
        }
        return spanWrapper;
    }

    public final void setBlock(@NotNull SpanWrapper<SpanType> spanWrapper) {
        Intrinsics.checkParameterIsNotNull(spanWrapper, (String)"<set-?>");
        this.block = spanWrapper;
    }

    public final int getNewlineIndex() {
        return this.newlineIndex;
    }

    public final void setNewlineIndex(int n) {
        this.newlineIndex = n;
    }

    public final int getNestingLevel() {
        return this.nestingLevel;
    }

    public final void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    public final int getMarkerIndex() {
        return this.markerIndex;
    }

    public final void setMarkerIndex(int n) {
        this.markerIndex = n;
    }

    @Override
    public void handleTextChanged(@NotNull Spannable text, int inputStart, int count, int nestingLevel) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.nestingLevel = nestingLevel;
        CharSequence charSequence = text.subSequence(inputStart, inputStart + count);
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        Spanned charsNew = (Spanned)charSequence;
        Object[] objectArray = charsNew.getSpans(0, 0, this.clazz);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"charsNew.getSpans<SpanType>(0, 0, clazz)");
        Iterable $receiver$iv = SpanWrapper.Companion.getSpans(text, objectArray);
        for (Object element$iv : $receiver$iv) {
            boolean gotEndOfBufferMarker;
            SpanWrapper it;
            this.block = it = (SpanWrapper)element$iv;
            boolean bl = gotEndOfBufferMarker = charsNew.length() == 1 && charsNew.charAt(0) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER();
            if (gotEndOfBufferMarker) {
                this.markerIndex = inputStart;
            }
            String charsNewString = charsNew.toString();
            int newlineOffset = StringsKt.indexOf$default((CharSequence)charsNewString, (char)Constants.INSTANCE.getNEWLINE(), (int)0, (boolean)false, (int)6, null);
            while (newlineOffset > -1 && newlineOffset < charsNew.length()) {
                this.newlineIndex = inputStart + newlineOffset;
                newlineOffset = StringsKt.indexOf$default((CharSequence)charsNewString, (char)Constants.INSTANCE.getNEWLINE(), (int)(newlineOffset + 1), (boolean)false, (int)4, null);
                if (!this.shouldHandle()) continue;
                CharSequence charSequence2 = text.subSequence(inputStart, inputStart + count);
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
                }
                charsNew = (Spanned)charSequence2;
                SpanWrapper<SpanType> spanWrapper = this.block;
                if (spanWrapper == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"block");
                }
                switch (BlockHandler$WhenMappings.$EnumSwitchMapping$0[this.getNewlinePositionType(text, spanWrapper, this.newlineIndex).ordinal()]) {
                    case 1: {
                        this.handleNewlineAtStartOfBlock();
                        break;
                    }
                    case 2: {
                        this.handleNewlineAtEmptyLineAtBlockEnd();
                        break;
                    }
                    case 3: {
                        this.handleNewlineAtEmptyBody();
                        break;
                    }
                    case 4: {
                        this.handleNewlineAtTextEnd();
                        break;
                    }
                    case 5: {
                        this.handleNewlineInBody();
                    }
                }
            }
            if (!gotEndOfBufferMarker || !this.shouldHandle()) continue;
            this.handleEndOfBufferMarker();
        }
    }

    private final PositionType getNewlinePositionType(Spannable text, SpanWrapper<SpanType> block, int newlineIndex) {
        boolean atEndOfblock;
        boolean isEmptyBody;
        boolean bl = isEmptyBody = block.getEnd() - block.getStart() == 1 || block.getEnd() - block.getStart() == 2 && text.charAt(block.getEnd() - 1) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER();
        if (newlineIndex == block.getStart() && isEmptyBody) {
            return PositionType.EMPTY_LINE_AT_EMPTY_BODY;
        }
        boolean bl2 = atEndOfblock = newlineIndex == block.getEnd() - 2 || newlineIndex == text.length() - 1;
        if (newlineIndex == block.getStart() && !atEndOfblock) {
            return PositionType.START_OF_BLOCK;
        }
        if (newlineIndex == block.getStart() && atEndOfblock) {
            return PositionType.EMPTY_LINE_AT_BLOCK_END;
        }
        if (text.charAt(newlineIndex - 1) == Constants.INSTANCE.getNEWLINE() && IAztecNestable.Companion.getNestingLevelAt((Spanned)text, newlineIndex - 1, newlineIndex) == IAztecNestable.Companion.getNestingLevelAt((Spanned)text, newlineIndex, newlineIndex + 1) && atEndOfblock) {
            return PositionType.EMPTY_LINE_AT_BLOCK_END;
        }
        if (newlineIndex == text.length() - 1) {
            return PositionType.BUFFER_END;
        }
        return PositionType.BODY;
    }

    public boolean shouldHandle() {
        SpanWrapper<SpanType> spanWrapper = this.block;
        if (spanWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"block");
        }
        return this.nestingLevel == ((IAztecBlockSpan)spanWrapper.getSpan()).getNestingLevel();
    }

    public void handleNewlineAtStartOfBlock() {
    }

    public void handleNewlineAtEmptyLineAtBlockEnd() {
    }

    public void handleNewlineAtEmptyBody() {
    }

    public void handleNewlineAtTextEnd() {
    }

    public void handleNewlineInBody() {
    }

    public void handleEndOfBufferMarker() {
    }

    @NotNull
    public final Class<SpanType> getClazz() {
        return this.clazz;
    }

    public BlockHandler(@NotNull Class<SpanType> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        this.clazz = clazz;
        this.newlineIndex = -1;
        this.markerIndex = -1;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/wordpress/aztec/handlers/BlockHandler$PositionType;", "", "(Ljava/lang/String;I)V", "START_OF_BLOCK", "EMPTY_LINE_AT_BLOCK_END", "EMPTY_LINE_AT_EMPTY_BODY", "BUFFER_END", "BODY", "aztec_release"})
    private static final class PositionType
    extends Enum<PositionType> {
        public static final /* enum */ PositionType START_OF_BLOCK;
        public static final /* enum */ PositionType EMPTY_LINE_AT_BLOCK_END;
        public static final /* enum */ PositionType EMPTY_LINE_AT_EMPTY_BODY;
        public static final /* enum */ PositionType BUFFER_END;
        public static final /* enum */ PositionType BODY;
        private static final /* synthetic */ PositionType[] $VALUES;

        static {
            PositionType[] positionTypeArray = new PositionType[5];
            PositionType[] positionTypeArray2 = positionTypeArray;
            positionTypeArray[0] = START_OF_BLOCK = new PositionType();
            positionTypeArray[1] = EMPTY_LINE_AT_BLOCK_END = new PositionType();
            positionTypeArray[2] = EMPTY_LINE_AT_EMPTY_BODY = new PositionType();
            positionTypeArray[3] = BUFFER_END = new PositionType();
            positionTypeArray[4] = BODY = new PositionType();
            $VALUES = positionTypeArray;
        }

        public static PositionType[] values() {
            return (PositionType[])$VALUES.clone();
        }

        public static PositionType valueOf(String string2) {
            return Enum.valueOf(PositionType.class, string2);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/wordpress/aztec/handlers/BlockHandler$Companion;", "", "()V", "set", "", "text", "Landroid/text/Spannable;", "block", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "start", "", "end", "aztec_release"})
    public static final class Companion {
        public final void set(@NotNull Spannable text, @NotNull IAztecBlockSpan block, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            try {
                text.setSpan((Object)block, start, end, 51);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

