/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.text.style.StyleSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecPart;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.ITextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.spans.AztecCodeSpan;
import org.wordpress.aztec.spans.AztecStrikethroughSpan;
import org.wordpress.aztec.spans.AztecStyleBoldSpan;
import org.wordpress.aztec.spans.AztecStyleItalicSpan;
import org.wordpress.aztec.spans.AztecStyleSpan;
import org.wordpress.aztec.spans.AztecUnderlineSpan;
import org.wordpress.aztec.spans.IAztecInlineSpan;
import org.wordpress.aztec.watchers.TextChangedEvent;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u000201B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u0016\u0010#\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u001e\u0010$\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020!0&2\b\b\u0002\u0010'\u001a\u00020(J\u000e\u0010$\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010)\u001a\u00020\u000fJ\"\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\"\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020!2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u0010\u0010,\u001a\u0004\u0018\u00010\u00112\u0006\u0010-\u001a\u00020!J\u000e\u0010.\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010/\u001a\u00020\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00062"}, d2={"Lorg/wordpress/aztec/formatting/InlineFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "codeStyle", "Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;)V", "carryOverSpans", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/formatting/InlineFormatter$CarryOverSpan;", "getCarryOverSpans", "()Ljava/util/ArrayList;", "getCodeStyle", "()Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "applyInlineStyle", "", "textFormat", "Lorg/wordpress/aztec/ITextFormat;", "start", "", "end", "carryOverInlineSpans", "count", "after", "clearInlineStyles", "ignoreSelectedStyles", "", "containsInlineStyle", "handleInlineStyling", "textChangedEvent", "Lorg/wordpress/aztec/watchers/TextChangedEvent;", "isSameInlineSpanType", "firstSpan", "Lorg/wordpress/aztec/spans/IAztecInlineSpan;", "secondSpan", "joinStyleSpans", "makeInlineSpan", "spanType", "Ljava/lang/Class;", "attrs", "Lorg/wordpress/aztec/AztecAttributes;", "reapplyCarriedOverInlineSpans", "removeInlineStyle", "spanToRemove", "spanToTextFormat", "span", "toggle", "tryRemoveLeadingInlineStyle", "CarryOverSpan", "CodeStyle", "aztec_release"})
public final class InlineFormatter
extends AztecFormatter {
    @NotNull
    private final ArrayList<CarryOverSpan> carryOverSpans;
    @NotNull
    private final CodeStyle codeStyle;

    @NotNull
    public final ArrayList<CarryOverSpan> getCarryOverSpans() {
        return this.carryOverSpans;
    }

    public final void toggle(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        if (!InlineFormatter.containsInlineStyle$default(this, textFormat, 0, 0, 6, null)) {
            InlineFormatter.applyInlineStyle$default(this, textFormat, 0, 0, 6, null);
        } else {
            InlineFormatter.removeInlineStyle$default(this, textFormat, 0, 0, 6, null);
        }
    }

    public final void carryOverInlineSpans(int start, int count, int after) {
        this.carryOverSpans.clear();
        int charsAdded = after - count;
        if (charsAdded > 0 && count > 0) {
            Object[] $receiver$iv = this.getEditableText().getSpans(start, start + count, IAztecInlineSpan.class);
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                int spanStart = this.getEditableText().getSpanStart((Object)it);
                int spanEnd = this.getEditableText().getSpanEnd((Object)it);
                if (spanStart != start && spanEnd != count + start || spanEnd - spanStart >= after) continue;
                this.getEditableText().removeSpan((Object)it);
                IAztecInlineSpan iAztecInlineSpan = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                this.carryOverSpans.add(new CarryOverSpan(iAztecInlineSpan, spanStart, spanEnd));
            }
        }
    }

    public final void reapplyCarriedOverInlineSpans() {
        Iterable $receiver$iv = this.carryOverSpans;
        for (Object element$iv : $receiver$iv) {
            CarryOverSpan it = (CarryOverSpan)element$iv;
            this.getEditableText().setSpan((Object)it.getSpan(), it.getStart(), it.getEnd(), 33);
        }
        this.carryOverSpans.clear();
    }

    public final void handleInlineStyling(@NotNull TextChangedEvent textChangedEvent) {
        Intrinsics.checkParameterIsNotNull((Object)textChangedEvent, (String)"textChangedEvent");
        if (textChangedEvent.isEndOfBufferMarker()) {
            return;
        }
        this.clearInlineStyles(textChangedEvent.getInputStart(), textChangedEvent.getInputEnd(), textChangedEvent.isNewLine());
        if (textChangedEvent.isNewLine()) {
            return;
        }
        if (this.getEditor().formattingIsApplied()) {
            for (ITextFormat item : this.getEditor().getSelectedStyles()) {
                ITextFormat iTextFormat = item;
                if (!Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_BOLD) && !Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ITALIC) && !Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_STRIKETHROUGH) && !Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNDERLINE) && !Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_CODE)) continue;
                ITextFormat iTextFormat2 = item;
                Intrinsics.checkExpressionValueIsNotNull((Object)iTextFormat2, (String)"item");
                this.applyInlineStyle(iTextFormat2, textChangedEvent.getInputStart(), textChangedEvent.getInputEnd());
            }
        }
        this.getEditor().setFormattingChangesApplied();
    }

    /*
     * WARNING - void declaration
     */
    private final void clearInlineStyles(int start, int end, boolean ignoreSelectedStyles) {
        int newStart;
        int n = newStart = start > end ? end : start;
        if (start > end) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object[] objectArray = this.getEditableText().getSpans(newStart, end, IAztecInlineSpan.class);
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv$iv;
                if (!(this.getEditableText().getSpanStart((Object)it) == this.getEditableText().getSpanEnd((Object)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                this.getEditableText().removeSpan((Object)it);
            }
            return;
        }
        Object[] $receiver$iv = this.getEditableText().getSpans(newStart, end, IAztecInlineSpan.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
            Iterable iterable = this.getEditor().getSelectedStyles();
            IAztecInlineSpan iAztecInlineSpan = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
            if (CollectionsKt.contains((Iterable)iterable, (Object)this.spanToTextFormat(iAztecInlineSpan)) && !ignoreSelectedStyles && (newStart != 0 || end != 0) && (newStart <= end || this.getEditableText().length() <= end || this.getEditableText().charAt(end) != '\n')) continue;
            IAztecInlineSpan iAztecInlineSpan2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan2, (String)"it");
            this.removeInlineStyle(iAztecInlineSpan2, newStart, end);
        }
    }

    public final void applyInlineStyle(@NotNull ITextFormat textFormat, int start, int end) {
        int spanEnd;
        IAztecInlineSpan it;
        Object element$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        IAztecInlineSpan spanToApply = this.makeInlineSpan(textFormat);
        if (start >= end) {
            return;
        }
        IAztecInlineSpan precedingSpan = null;
        IAztecInlineSpan followingSpan = null;
        if (start >= 1) {
            IAztecInlineSpan[] previousSpans = (IAztecInlineSpan[])this.getEditableText().getSpans(start - 1, start, IAztecInlineSpan.class);
            $receiver$iv = previousSpans;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                element$iv = $receiver$iv[i];
                IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToApply)) continue;
                precedingSpan = it;
            }
            if (precedingSpan != null) {
                int spanStart = this.getEditableText().getSpanStart((Object)precedingSpan);
                spanEnd = this.getEditableText().getSpanEnd((Object)precedingSpan);
                if (spanEnd > start) {
                    return;
                }
                this.getEditableText().setSpan((Object)precedingSpan, spanStart, end, 34);
            }
        }
        if (this.getEditor().length() > end) {
            IAztecInlineSpan[] nextSpans = (IAztecInlineSpan[])this.getEditableText().getSpans(end, end + 1, IAztecInlineSpan.class);
            $receiver$iv = nextSpans;
            for (spanEnd = 0; spanEnd < $receiver$iv.length; ++spanEnd) {
                element$iv = $receiver$iv[spanEnd];
                IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToApply)) continue;
                followingSpan = it;
            }
            if (followingSpan != null) {
                int spanEnd2 = this.getEditableText().getSpanEnd((Object)followingSpan);
                this.getEditableText().setSpan((Object)followingSpan, start, spanEnd2, 34);
            }
        }
        if (precedingSpan == null && followingSpan == null) {
            IAztecInlineSpan existingSpanOfSameStyle = null;
            IAztecInlineSpan[] spans = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
            Object[] $receiver$iv2 = spans;
            for (int i = 0; i < $receiver$iv2.length; ++i) {
                IAztecInlineSpan it2;
                Object element$iv2 = $receiver$iv2[i];
                IAztecInlineSpan iAztecInlineSpan = it2 = (IAztecInlineSpan)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToApply)) continue;
                existingSpanOfSameStyle = it2;
            }
            if (existingSpanOfSameStyle != null) {
                this.getEditableText().removeSpan((Object)existingSpanOfSameStyle);
                this.getEditableText().setSpan((Object)existingSpanOfSameStyle, start, end, 34);
            } else {
                this.getEditableText().setSpan((Object)spanToApply, start, end, 34);
            }
            Object var7_7 = null;
        }
        this.joinStyleSpans(start, end);
    }

    public static /* bridge */ /* synthetic */ void applyInlineStyle$default(InlineFormatter inlineFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        inlineFormatter.applyInlineStyle(iTextFormat, n, n2);
    }

    @Nullable
    public final ITextFormat spanToTextFormat(@NotNull IAztecInlineSpan span) {
        Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
        Class<?> clazz = span.getClass();
        if (Intrinsics.areEqual(clazz, AztecStyleBoldSpan.class)) {
            return AztecTextFormat.FORMAT_BOLD;
        }
        if (Intrinsics.areEqual(clazz, AztecStyleItalicSpan.class)) {
            return AztecTextFormat.FORMAT_ITALIC;
        }
        if (Intrinsics.areEqual(clazz, AztecStrikethroughSpan.class)) {
            return AztecTextFormat.FORMAT_STRIKETHROUGH;
        }
        if (Intrinsics.areEqual(clazz, AztecUnderlineSpan.class)) {
            return AztecTextFormat.FORMAT_UNDERLINE;
        }
        if (Intrinsics.areEqual(clazz, AztecCodeSpan.class)) {
            return AztecTextFormat.FORMAT_CODE;
        }
        return null;
    }

    public final void removeInlineStyle(@NotNull IAztecInlineSpan spanToRemove, int start, int end) {
        Object it;
        Object element$iv;
        Intrinsics.checkParameterIsNotNull((Object)spanToRemove, (String)"spanToRemove");
        ITextFormat iTextFormat = this.spanToTextFormat(spanToRemove);
        if (iTextFormat == null) {
            return;
        }
        ITextFormat textFormat = iTextFormat;
        IAztecInlineSpan[] spans = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
        ArrayList<AztecPart> list = new ArrayList<AztecPart>();
        Object $receiver$iv = spans;
        for (int i = 0; i < ((Object[])$receiver$iv).length; ++i) {
            element$iv = $receiver$iv[i];
            it = (IAztecInlineSpan)element$iv;
            IAztecInlineSpan iAztecInlineSpan = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
            if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToRemove)) continue;
            list.add(new AztecPart(this.getEditableText().getSpanStart(it), this.getEditableText().getSpanEnd(it)));
            this.getEditableText().removeSpan(it);
        }
        $receiver$iv = list;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (AztecPart)element$iv;
            if (!((AztecPart)it).isValid()) continue;
            if (((AztecPart)it).getStart() < start) {
                this.applyInlineStyle(textFormat, ((AztecPart)it).getStart(), start);
            }
            if (((AztecPart)it).getEnd() <= end) continue;
            this.applyInlineStyle(textFormat, end, ((AztecPart)it).getEnd());
        }
        this.joinStyleSpans(start, end);
    }

    public static /* bridge */ /* synthetic */ void removeInlineStyle$default(InlineFormatter inlineFormatter, IAztecInlineSpan iAztecInlineSpan, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        inlineFormatter.removeInlineStyle(iAztecInlineSpan, n, n2);
    }

    public final void removeInlineStyle(@NotNull ITextFormat textFormat, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        this.removeInlineStyle(this.makeInlineSpan(textFormat), start, end);
    }

    public static /* bridge */ /* synthetic */ void removeInlineStyle$default(InlineFormatter inlineFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        inlineFormatter.removeInlineStyle(iTextFormat, n, n2);
    }

    public final boolean isSameInlineSpanType(@NotNull IAztecInlineSpan firstSpan, @NotNull IAztecInlineSpan secondSpan) {
        Intrinsics.checkParameterIsNotNull((Object)firstSpan, (String)"firstSpan");
        Intrinsics.checkParameterIsNotNull((Object)secondSpan, (String)"secondSpan");
        if (Intrinsics.areEqual(firstSpan.getClass(), secondSpan.getClass())) {
            if (firstSpan instanceof StyleSpan && secondSpan instanceof StyleSpan) {
                return ((StyleSpan)firstSpan).getStyle() == ((StyleSpan)secondSpan).getStyle();
            }
            return true;
        }
        return false;
    }

    public final void joinStyleSpans(int start, int end) {
        IAztecInlineSpan outerSpan;
        Object element$iv;
        int n;
        Object[] $receiver$iv;
        IAztecInlineSpan innerSpan;
        Object element$iv2;
        int n2;
        Object[] $receiver$iv2;
        IAztecInlineSpan[] spansInSelection;
        if (start > 1) {
            spansInSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
            IAztecInlineSpan[] spansBeforeSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(start - 1, start, IAztecInlineSpan.class);
            $receiver$iv2 = spansInSelection;
            for (n2 = 0; n2 < $receiver$iv2.length; ++n2) {
                element$iv2 = $receiver$iv2[n2];
                innerSpan = (IAztecInlineSpan)element$iv2;
                int inSelectionSpanEnd = this.getEditableText().getSpanEnd((Object)innerSpan);
                if (inSelectionSpanEnd == -1) continue;
                $receiver$iv = spansBeforeSelection;
                for (n = 0; n < $receiver$iv.length; ++n) {
                    element$iv = $receiver$iv[n];
                    outerSpan = (IAztecInlineSpan)element$iv;
                    int outerSpanStart = this.getEditableText().getSpanStart((Object)outerSpan);
                    IAztecInlineSpan iAztecInlineSpan = innerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"innerSpan");
                    IAztecInlineSpan iAztecInlineSpan2 = outerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan2, (String)"outerSpan");
                    if (!this.isSameInlineSpanType(iAztecInlineSpan, iAztecInlineSpan2)) continue;
                    this.getEditableText().removeSpan((Object)outerSpan);
                    this.getEditableText().setSpan((Object)innerSpan, outerSpanStart, inSelectionSpanEnd, 34);
                }
            }
        }
        if (this.getEditor().length() > end) {
            spansInSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
            IAztecInlineSpan[] spansAfterSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(end, end + 1, IAztecInlineSpan.class);
            $receiver$iv2 = spansInSelection;
            for (n2 = 0; n2 < $receiver$iv2.length; ++n2) {
                element$iv2 = $receiver$iv2[n2];
                innerSpan = (IAztecInlineSpan)element$iv2;
                int inSelectionSpanStart = this.getEditableText().getSpanStart((Object)innerSpan);
                if (inSelectionSpanStart == -1) continue;
                $receiver$iv = spansAfterSelection;
                for (n = 0; n < $receiver$iv.length; ++n) {
                    element$iv = $receiver$iv[n];
                    outerSpan = (IAztecInlineSpan)element$iv;
                    int outerSpanEnd = this.getEditableText().getSpanEnd((Object)outerSpan);
                    IAztecInlineSpan iAztecInlineSpan = innerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"innerSpan");
                    IAztecInlineSpan iAztecInlineSpan3 = outerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan3, (String)"outerSpan");
                    if (!this.isSameInlineSpanType(iAztecInlineSpan, iAztecInlineSpan3)) continue;
                    this.getEditableText().removeSpan((Object)outerSpan);
                    this.getEditableText().setSpan((Object)innerSpan, inSelectionSpanStart, outerSpanEnd, 34);
                }
            }
        }
        spansInSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
        IAztecInlineSpan[] spansToUse = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
        $receiver$iv2 = spansInSelection;
        for (n2 = 0; n2 < $receiver$iv2.length; ++n2) {
            element$iv2 = $receiver$iv2[n2];
            IAztecInlineSpan appliedSpan = (IAztecInlineSpan)element$iv2;
            int spanStart = this.getEditableText().getSpanStart((Object)appliedSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)appliedSpan);
            IAztecInlineSpan neighbourSpan = null;
            Object[] $receiver$iv3 = spansToUse;
            for (int outerSpan2 = 0; outerSpan2 < $receiver$iv3.length; ++outerSpan2) {
                Object element$iv3 = $receiver$iv3[outerSpan2];
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv3;
                int aSpanStart = this.getEditableText().getSpanStart((Object)it);
                int aSpanEnd = this.getEditableText().getSpanEnd((Object)it);
                IAztecInlineSpan iAztecInlineSpan = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                IAztecInlineSpan iAztecInlineSpan4 = appliedSpan;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan4, (String)"appliedSpan");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, iAztecInlineSpan4) || aSpanStart != spanEnd && aSpanEnd != spanStart) continue;
                neighbourSpan = it;
            }
            if (neighbourSpan != null) {
                int neighbourSpanStart = this.getEditableText().getSpanStart((Object)neighbourSpan);
                int neighbourSpanEnd = this.getEditableText().getSpanEnd((Object)neighbourSpan);
                if (neighbourSpanStart == -1 || neighbourSpanEnd == -1) continue;
                if (spanStart == neighbourSpanEnd) {
                    this.getEditableText().setSpan((Object)appliedSpan, neighbourSpanStart, spanEnd, 34);
                } else if (spanEnd == neighbourSpanStart) {
                    this.getEditableText().setSpan((Object)appliedSpan, spanStart, neighbourSpanEnd, 34);
                }
                this.getEditableText().removeSpan((Object)neighbourSpan);
            }
            Object var11_14 = null;
        }
    }

    @NotNull
    public final IAztecInlineSpan makeInlineSpan(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_BOLD)) {
            return new AztecStyleBoldSpan(null, 1, null);
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ITALIC)) {
            return new AztecStyleItalicSpan(null, 1, null);
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_STRIKETHROUGH)) {
            return new AztecStrikethroughSpan(null, null, 3, null);
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNDERLINE)) {
            return new AztecUnderlineSpan(null, 1, null);
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_CODE)) {
            return new AztecCodeSpan(this.codeStyle, null, 2, null);
        }
        return new AztecStyleSpan(0, null, 2, null);
    }

    @NotNull
    public final IAztecInlineSpan makeInlineSpan(@NotNull Class<IAztecInlineSpan> spanType, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull(spanType, (String)"spanType");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Class<IAztecInlineSpan> clazz = spanType;
        if (Intrinsics.areEqual(clazz, AztecCodeSpan.class)) {
            return new AztecCodeSpan(this.codeStyle, attrs);
        }
        return new AztecStyleSpan(0, null, 2, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IAztecInlineSpan makeInlineSpan$default(InlineFormatter inlineFormatter, Class clazz, AztecAttributes aztecAttributes, int n, Object object) {
        if ((n & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return inlineFormatter.makeInlineSpan(clazz, aztecAttributes);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsInlineStyle(@NotNull ITextFormat textFormat, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        IAztecInlineSpan spanToCheck = this.makeInlineSpan(textFormat);
        if (start > end) {
            return false;
        }
        if (start == end) {
            void $receiver$iv$iv;
            void $receiver$iv22;
            Object[] $receiver$iv$iv2;
            void $receiver$iv;
            if (start - 1 < 0 || start + 1 > this.getEditableText().length()) {
                return false;
            }
            Object[] objectArray = this.getEditableText().getSpans(start - 1, start, IAztecInlineSpan.class);
            void var7_8 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < $receiver$iv$iv2.length; ++i) {
                IAztecInlineSpan it;
                void element$iv$iv = $receiver$iv$iv2[i];
                IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToCheck)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IAztecInlineSpan before = (IAztecInlineSpan)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            $receiver$iv$iv2 = this.getEditableText().getSpans(start, start + 1, IAztecInlineSpan.class);
            destination$iv$iv = $receiver$iv22;
            Collection destination$iv$iv2 = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                IAztecInlineSpan it;
                void element$iv$iv = $receiver$iv$iv[i];
                IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToCheck)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            IAztecInlineSpan after = (IAztecInlineSpan)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
            return before != null && after != null && this.isSameInlineSpanType(before, after);
        }
        StringBuilder builder = new StringBuilder();
        int after = start;
        int $receiver$iv22 = end - 1;
        if (after <= $receiver$iv22) {
            while (true) {
                void i;
                IAztecInlineSpan[] spans = (IAztecInlineSpan[])this.getEditableText().getSpans((int)i, (int)(i + true), IAztecInlineSpan.class);
                for (int j = 0; j < spans.length; ++j) {
                    IAztecInlineSpan span;
                    IAztecInlineSpan iAztecInlineSpan = span = spans[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"span");
                    if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToCheck)) continue;
                    builder.append(((Object)this.getEditableText().subSequence((int)i, (int)(i + true))).toString());
                    break;
                }
                if (i == $receiver$iv22) break;
                ++i;
            }
        }
        CharSequence $receiver$iv22 = this.getEditableText().subSequence(start, end);
        CharSequence charSequence = "\n";
        charSequence = new Regex((String)charSequence);
        String string2 = "";
        String originalText = charSequence.replace($receiver$iv22, string2);
        charSequence = builder.toString();
        string2 = "\n";
        string2 = new Regex(string2);
        String string3 = "";
        String textOfCombinedSpans = string2.replace(charSequence, string3);
        charSequence = originalText;
        return charSequence.length() > 0 && Intrinsics.areEqual((Object)originalText, (Object)textOfCombinedSpans);
    }

    public static /* bridge */ /* synthetic */ boolean containsInlineStyle$default(InlineFormatter inlineFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        return inlineFormatter.containsInlineStyle(iTextFormat, n, n2);
    }

    public final void tryRemoveLeadingInlineStyle() {
        block3: {
            block2: {
                int selectionStart = this.getEditor().getSelectionStart();
                int selectionEnd = this.getEditor().getSelectionEnd();
                if (selectionStart != 1 || selectionEnd != selectionStart) break block2;
                Object[] $receiver$iv = this.getEditableText().getSpans(0, 0, IAztecInlineSpan.class);
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                    if (this.getEditableText().getSpanEnd((Object)it) != selectionEnd || this.getEditableText().getSpanEnd((Object)it) != selectionStart) continue;
                    this.getEditableText().removeSpan((Object)it);
                }
                break block3;
            }
            if (this.getEditor().length() != 1 || this.getEditor().getText().charAt(0) != Constants.INSTANCE.getEND_OF_BUFFER_MARKER()) break block3;
            Object[] $receiver$iv = this.getEditableText().getSpans(0, 1, IAztecInlineSpan.class);
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                if (this.getEditableText().getSpanStart((Object)it) != 1 || this.getEditableText().getSpanEnd((Object)it) != 1) continue;
                this.getEditableText().removeSpan((Object)it);
            }
        }
    }

    @NotNull
    public final CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    public InlineFormatter(@NotNull AztecText editor, @NotNull CodeStyle codeStyle) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)codeStyle, (String)"codeStyle");
        super(editor);
        this.codeStyle = codeStyle;
        this.carryOverSpans = new ArrayList();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/wordpress/aztec/formatting/InlineFormatter$CarryOverSpan;", "", "span", "Lorg/wordpress/aztec/spans/IAztecInlineSpan;", "start", "", "end", "(Lorg/wordpress/aztec/spans/IAztecInlineSpan;II)V", "getEnd", "()I", "getSpan", "()Lorg/wordpress/aztec/spans/IAztecInlineSpan;", "getStart", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class CarryOverSpan {
        @NotNull
        private final IAztecInlineSpan span;
        private final int start;
        private final int end;

        @NotNull
        public final IAztecInlineSpan getSpan() {
            return this.span;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public CarryOverSpan(@NotNull IAztecInlineSpan span, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
            this.span = span;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public final IAztecInlineSpan component1() {
            return this.span;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final CarryOverSpan copy(@NotNull IAztecInlineSpan span, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
            return new CarryOverSpan(span, start, end);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CarryOverSpan copy$default(CarryOverSpan carryOverSpan, IAztecInlineSpan iAztecInlineSpan, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                iAztecInlineSpan = carryOverSpan.span;
            }
            if ((n3 & 2) != 0) {
                n = carryOverSpan.start;
            }
            if ((n3 & 4) != 0) {
                n2 = carryOverSpan.end;
            }
            return carryOverSpan.copy(iAztecInlineSpan, n, n2);
        }

        public String toString() {
            return "CarryOverSpan(span=" + this.span + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            IAztecInlineSpan iAztecInlineSpan = this.span;
            return ((iAztecInlineSpan != null ? iAztecInlineSpan.hashCode() : 0) * 31 + this.start) * 31 + this.end;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CarryOverSpan)) break block3;
                    CarryOverSpan carryOverSpan = (CarryOverSpan)object;
                    if (!Intrinsics.areEqual((Object)this.span, (Object)carryOverSpan.span) || !(this.start == carryOverSpan.start) || !(this.end == carryOverSpan.end)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "", "codeBackground", "", "codeBackgroundAlpha", "", "codeColor", "(IFI)V", "getCodeBackground", "()I", "getCodeBackgroundAlpha", "()F", "getCodeColor", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class CodeStyle {
        private final int codeBackground;
        private final float codeBackgroundAlpha;
        private final int codeColor;

        public final int getCodeBackground() {
            return this.codeBackground;
        }

        public final float getCodeBackgroundAlpha() {
            return this.codeBackgroundAlpha;
        }

        public final int getCodeColor() {
            return this.codeColor;
        }

        public CodeStyle(int codeBackground, float codeBackgroundAlpha, int codeColor) {
            this.codeBackground = codeBackground;
            this.codeBackgroundAlpha = codeBackgroundAlpha;
            this.codeColor = codeColor;
        }

        public final int component1() {
            return this.codeBackground;
        }

        public final float component2() {
            return this.codeBackgroundAlpha;
        }

        public final int component3() {
            return this.codeColor;
        }

        @NotNull
        public final CodeStyle copy(int codeBackground, float codeBackgroundAlpha, int codeColor) {
            return new CodeStyle(codeBackground, codeBackgroundAlpha, codeColor);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CodeStyle copy$default(CodeStyle codeStyle, int n, float f, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = codeStyle.codeBackground;
            }
            if ((n3 & 2) != 0) {
                f = codeStyle.codeBackgroundAlpha;
            }
            if ((n3 & 4) != 0) {
                n2 = codeStyle.codeColor;
            }
            return codeStyle.copy(n, f, n2);
        }

        public String toString() {
            return "CodeStyle(codeBackground=" + this.codeBackground + ", codeBackgroundAlpha=" + this.codeBackgroundAlpha + ", codeColor=" + this.codeColor + ")";
        }

        public int hashCode() {
            return (this.codeBackground * 31 + Float.floatToIntBits(this.codeBackgroundAlpha)) * 31 + this.codeColor;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CodeStyle)) break block3;
                    CodeStyle codeStyle = (CodeStyle)object;
                    if (!(this.codeBackground == codeStyle.codeBackground) || Float.compare(this.codeBackgroundAlpha, codeStyle.codeBackgroundAlpha) != 0 || !(this.codeColor == codeStyle.codeColor)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

