/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.toolbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.Toast;
import android.widget.ToggleButton;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.R;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.source.SourceViewEditText;
import org.wordpress.aztec.toolbar.AztecToolbar$WhenMappings;
import org.wordpress.aztec.toolbar.AztecToolbarClickListener;
import org.wordpress.aztec.toolbar.RippleToggleButton;
import org.wordpress.aztec.toolbar.ToolbarAction;
import org.wordpress.aztec.toolbar.ToolbarActionType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\u000e\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001dJ\u000e\u0010,\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001dJ\b\u0010-\u001a\u0004\u0018\u00010\u001bJ\b\u0010.\u001a\u0004\u0018\u00010\u001bJ\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002J\b\u00102\u001a\u0004\u0018\u000103J\b\u00104\u001a\u0004\u0018\u000103J\u0014\u00105\u001a\u00020(2\f\u00106\u001a\b\u0012\u0004\u0012\u00020100J\u0018\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\nH\u0002J\u0012\u0010:\u001a\u00020(2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010;\u001a\u00020\u001dH\u0002J\u0006\u0010\u001f\u001a\u00020\u001dJ\u0018\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020?H\u0016J\u0012\u0010@\u001a\u00020\u001d2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\u0012\u0010C\u001a\u00020(2\b\u0010D\u001a\u0004\u0018\u00010EH\u0014J\b\u0010F\u001a\u00020EH\u0014J\u0010\u0010G\u001a\u00020(2\u0006\u0010H\u001a\u000201H\u0002J\u0016\u0010I\u001a\u00020(2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020300H\u0002J\u0016\u0010K\u001a\u00020(2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020300H\u0002J\b\u0010L\u001a\u00020(H\u0002J\b\u0010M\u001a\u00020(H\u0002J\b\u0010N\u001a\u00020(H\u0002J\u0016\u0010O\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&J\u000e\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020\u001dJ\u0010\u0010R\u001a\u00020(2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020(2\u0006\u0010V\u001a\u000203H\u0002J\u0010\u0010W\u001a\u00020(2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010X\u001a\u00020(2\u0006\u0010V\u001a\u000203H\u0002J\u000e\u0010Y\u001a\u00020(2\u0006\u0010Z\u001a\u00020\rJ\b\u0010[\u001a\u00020(H\u0002J\b\u0010\\\u001a\u00020(H\u0002J\b\u0010]\u001a\u00020(H\u0002J\u001a\u0010^\u001a\u00020(2\b\u0010_\u001a\u0004\u0018\u00010T2\u0006\u0010`\u001a\u00020\u001dH\u0002J\u001a\u0010a\u001a\u00020(2\b\u0010_\u001a\u0004\u0018\u00010T2\u0006\u0010b\u001a\u00020\u001dH\u0002J\u0006\u0010c\u001a\u00020(J\u0010\u0010d\u001a\u00020(2\u0006\u0010e\u001a\u00020\u001dH\u0002J\u0018\u0010f\u001a\u00020(2\u0006\u0010g\u001a\u00020\n2\u0006\u0010h\u001a\u00020\u001dH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lorg/wordpress/aztec/toolbar/AztecToolbar;", "Landroid/widget/FrameLayout;", "Landroid/widget/PopupMenu$OnMenuItemClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "aztecToolbarListener", "Lorg/wordpress/aztec/toolbar/AztecToolbarClickListener;", "buttonEllipsisCollapse", "Lorg/wordpress/aztec/toolbar/RippleToggleButton;", "buttonEllipsisExpand", "buttonScroll", "Landroid/widget/HorizontalScrollView;", "dialogShortcuts", "Landroid/support/v7/app/AlertDialog;", "editor", "Lorg/wordpress/aztec/AztecText;", "ellipsisSpinLeft", "Landroid/view/animation/Animation;", "ellipsisSpinRight", "headingMenu", "Landroid/widget/PopupMenu;", "isAdvanced", "", "isExpanded", "isMediaModeEnabled", "layoutExpanded", "Landroid/widget/LinearLayout;", "layoutExpandedTranslateInRight", "layoutExpandedTranslateOutLeft", "listMenu", "sourceEditor", "Lorg/wordpress/aztec/source/SourceViewEditText;", "animateToolbarCollapse", "", "animateToolbarExpand", "enableFormatButtons", "isEnabled", "enableMediaMode", "getHeadingMenu", "getListMenu", "getSelectedActions", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/toolbar/ToolbarAction;", "getSelectedHeadingMenuItem", "Lorg/wordpress/aztec/TextFormat;", "getSelectedListMenuItem", "highlightActionButtons", "toolbarActions", "highlightAppliedStyles", "selStart", "selEnd", "initView", "isEditorAttached", "onKeyUp", "keyCode", "event", "Landroid/view/KeyEvent;", "onMenuItemClick", "item", "Landroid/view/MenuItem;", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onToolbarAction", "action", "selectHeadingMenuItem", "textFormats", "selectListMenuItem", "setAdvancedState", "setAnimations", "setButtonViews", "setEditor", "setExpanded", "expanded", "setHeadingMenu", "view", "Landroid/view/View;", "setHeadingMenuSelector", "textFormat", "setListMenu", "setListMenuSelector", "setToolbarListener", "listener", "showCollapsedToolbar", "showDialogShortcuts", "showExpandedToolbar", "toggleButton", "button", "checked", "toggleButtonState", "enabled", "toggleEditorMode", "toggleHtmlMode", "isHtmlMode", "toggleListMenuSelection", "listMenuItemId", "isChecked", "aztec_release"})
public final class AztecToolbar
extends FrameLayout
implements PopupMenu.OnMenuItemClickListener {
    private AztecToolbarClickListener aztecToolbarListener;
    private AztecText editor;
    private PopupMenu headingMenu;
    private PopupMenu listMenu;
    private SourceViewEditText sourceEditor;
    private AlertDialog dialogShortcuts;
    private boolean isAdvanced;
    private boolean isExpanded;
    private boolean isMediaModeEnabled;
    private HorizontalScrollView buttonScroll;
    private RippleToggleButton buttonEllipsisCollapse;
    private RippleToggleButton buttonEllipsisExpand;
    private Animation layoutExpandedTranslateInRight;
    private Animation layoutExpandedTranslateOutLeft;
    private Animation ellipsisSpinLeft;
    private Animation ellipsisSpinRight;
    private LinearLayout layoutExpanded;

    public final void setToolbarListener(@NotNull AztecToolbarClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.aztecToolbarListener = listener;
    }

    public boolean onKeyUp(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (keyCode) {
            case 8: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_1, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_1);
                }
                return true;
            }
            case 9: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_2, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_2);
                }
                return true;
            }
            case 10: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_3, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_3);
                }
                return true;
            }
            case 11: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_4, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_4);
                }
                return true;
            }
            case 12: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_5, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_5);
                }
                return true;
            }
            case 13: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_6, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_6);
                }
                return true;
            }
            case 14: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_PARAGRAPH, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_PARAGRAPH);
                }
                return true;
            }
            case 15: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_PREFORMAT, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_PREFORMAT);
                }
                return true;
            }
            case 30: {
                if (!event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_BOLD, true);
                }
                this.findViewById(ToolbarAction.BOLD.getButtonId()).performClick();
                return true;
            }
            case 32: {
                if (!event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_STRIKETHROUGH, true);
                }
                this.findViewById(ToolbarAction.STRIKETHROUGH.getButtonId()).performClick();
                return true;
            }
            case 36: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                this.showDialogShortcuts();
                return true;
            }
            case 37: {
                if (!event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_ITALIC, true);
                }
                this.findViewById(ToolbarAction.ITALIC.getButtonId()).performClick();
                return true;
            }
            case 39: {
                if (!event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_LINK, true);
                }
                this.findViewById(ToolbarAction.LINK.getButtonId()).performClick();
                return true;
            }
            case 41: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarMediaButtonClicked();
                }
                this.findViewById(ToolbarAction.ADD_MEDIA.getButtonId()).performClick();
                return true;
            }
            case 43: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_ORDERED_LIST, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(TextFormat.FORMAT_ORDERED_LIST);
                }
                return true;
            }
            case 44: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_PAGE, true);
                }
                this.findViewById(ToolbarAction.PAGE.getButtonId()).performClick();
                return true;
            }
            case 45: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_QUOTE, true);
                }
                this.findViewById(ToolbarAction.QUOTE.getButtonId()).performClick();
                return true;
            }
            case 48: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_MORE, true);
                }
                this.findViewById(ToolbarAction.MORE.getButtonId()).performClick();
                return true;
            }
            case 49: {
                if (event.isAltPressed() && event.isCtrlPressed()) {
                    AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                    if (aztecToolbarClickListener != null) {
                        aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_UNORDERED_LIST, true);
                    }
                    AztecText aztecText = this.editor;
                    if (aztecText != null) {
                        aztecText.toggleFormatting(TextFormat.FORMAT_UNORDERED_LIST);
                    }
                    return true;
                }
                if (!event.isCtrlPressed()) break;
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_UNDERLINE, true);
                }
                this.findViewById(ToolbarAction.UNDERLINE.getButtonId()).performClick();
                return true;
            }
            case 52: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                return true;
            }
            case 53: {
                if (!event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.redo();
                }
                return true;
            }
            case 54: {
                if (!event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.undo();
                }
                return true;
            }
        }
        return false;
    }

    public boolean onMenuItemClick(@Nullable MenuItem item) {
        Integer n;
        MenuItem menuItem = item;
        boolean checked = Intrinsics.areEqual((Object)(menuItem != null ? Boolean.valueOf(menuItem.isChecked()) : null), (Object)false);
        MenuItem menuItem2 = item;
        if (menuItem2 != null) {
            menuItem2.setChecked(checked);
        }
        MenuItem menuItem3 = item;
        Integer n2 = n = menuItem3 != null ? Integer.valueOf(menuItem3.getItemId()) : null;
        if (Intrinsics.areEqual((Object)n, (Object)R.id.paragraph)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_PARAGRAPH, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_PARAGRAPH);
            }
            this.setHeadingMenuSelector(TextFormat.FORMAT_PARAGRAPH);
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_1)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_1, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_1);
            }
            this.setHeadingMenuSelector(TextFormat.FORMAT_HEADING_1);
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_2)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_2, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_2);
            }
            this.setHeadingMenuSelector(TextFormat.FORMAT_HEADING_2);
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_3)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_3, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_3);
            }
            this.setHeadingMenuSelector(TextFormat.FORMAT_HEADING_3);
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_4)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_4, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_4);
            }
            this.setHeadingMenuSelector(TextFormat.FORMAT_HEADING_4);
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_5)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_5, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_5);
            }
            this.setHeadingMenuSelector(TextFormat.FORMAT_HEADING_5);
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.heading_6)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_HEADING_6, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_HEADING_6);
            }
            this.setHeadingMenuSelector(TextFormat.FORMAT_HEADING_6);
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.list_ordered)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_ORDERED_LIST, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_ORDERED_LIST);
            }
            this.toggleListMenuSelection(item.getItemId(), checked);
            return true;
        }
        if (Intrinsics.areEqual((Object)n, (Object)R.id.list_unordered)) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_UNORDERED_LIST, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(TextFormat.FORMAT_UNORDERED_LIST);
            }
            this.toggleListMenuSelection(item.getItemId(), checked);
            return true;
        }
        return false;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable parcelable = state;
        if (parcelable == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.source.SourceViewEditText.SavedState");
        }
        SourceViewEditText.SavedState savedState = (SourceViewEditText.SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        Bundle restoredState = savedState.getState();
        this.toggleHtmlMode(restoredState.getBoolean("isSourceVisible"));
        this.enableMediaMode(restoredState.getBoolean("isMediaMode"));
        this.isExpanded = restoredState.getBoolean("isExpanded");
        this.setAdvancedState();
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        SourceViewEditText.SavedState savedState = new SourceViewEditText.SavedState(parcelable);
        Bundle bundle = new Bundle();
        SourceViewEditText sourceViewEditText = this.sourceEditor;
        bundle.putBoolean("isSourceVisible", Intrinsics.areEqual((Object)(sourceViewEditText != null ? Integer.valueOf(sourceViewEditText.getVisibility()) : null), (Object)0));
        bundle.putBoolean("isMediaMode", this.isMediaModeEnabled);
        bundle.putBoolean("isExpanded", this.isExpanded);
        savedState.setState(bundle);
        return (Parcelable)savedState;
    }

    private final boolean isEditorAttached() {
        return this.editor != null && this.editor instanceof AztecText;
    }

    public final void setEditor(@NotNull AztecText editor, @NotNull SourceViewEditText sourceEditor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sourceEditor), (String)"sourceEditor");
        this.sourceEditor = sourceEditor;
        AztecText aztecText = this.editor = editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        aztecText.setOnSelectionChangedListener(new AztecText.OnSelectionChangedListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onSelectionChanged(int selStart, int selEnd) {
                AztecToolbar.access$highlightAppliedStyles(this.this$0, selStart, selEnd);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void initView(AttributeSet attrs) {
        TypedArray styles = this.getContext().obtainStyledAttributes(attrs, R.styleable.AztecToolbar, 0, R.style.AztecToolbarStyle);
        this.isAdvanced = styles.getBoolean(R.styleable.AztecToolbar_advanced, false);
        styles.recycle();
        int layout2 = this.isAdvanced ? R.layout.aztec_format_bar_advanced : R.layout.aztec_format_bar_basic;
        View.inflate((Context)this.getContext(), (int)layout2, (ViewGroup)((ViewGroup)this));
        this.setAdvancedState();
        ToolbarAction[] toolbarActionArray = ToolbarAction.values();
        for (int i = 0; i < toolbarActionArray.length; ++i) {
            View button;
            ToolbarAction toolbarAction = toolbarActionArray[i];
            View view = button = this.findViewById(toolbarAction.getButtonId());
            if (view != null) {
                view.setOnClickListener(new View.OnClickListener(this, toolbarAction){
                    final /* synthetic */ AztecToolbar this$0;
                    final /* synthetic */ ToolbarAction $toolbarAction;

                    public final void onClick(View it) {
                        AztecToolbar.access$onToolbarAction(this.this$0, this.$toolbarAction);
                    }
                    {
                        this.this$0 = aztecToolbar;
                        this.$toolbarAction = toolbarAction;
                    }
                });
            }
            if (Intrinsics.areEqual((Object)((Object)toolbarAction), (Object)((Object)ToolbarAction.HEADING))) {
                View view2 = this.findViewById(toolbarAction.getButtonId());
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(toolbarAction.buttonId)");
                this.setHeadingMenu(view2);
            }
            if (!Intrinsics.areEqual((Object)((Object)toolbarAction), (Object)((Object)ToolbarAction.LIST))) continue;
            View view3 = this.findViewById(toolbarAction.getButtonId());
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(toolbarAction.buttonId)");
            this.setListMenu(view3);
        }
    }

    public final void highlightActionButtons(@NotNull ArrayList<ToolbarAction> toolbarActions) {
        Intrinsics.checkParameterIsNotNull(toolbarActions, (String)"toolbarActions");
        Object[] $receiver$iv = (Object[])ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)((Object)element$iv);
            if (toolbarActions.contains((Object)action)) {
                this.toggleButton(this.findViewById(action.getButtonId()), true);
                continue;
            }
            this.toggleButton(this.findViewById(action.getButtonId()), false);
        }
    }

    private final ArrayList<ToolbarAction> getSelectedActions() {
        ArrayList<ToolbarAction> actions = new ArrayList<ToolbarAction>();
        ToolbarAction[] toolbarActionArray = ToolbarAction.values();
        for (int i = 0; i < toolbarActionArray.length; ++i) {
            ToolbarAction action = toolbarActionArray[i];
            if (!(Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.ELLIPSIS_COLLAPSE)) ^ true) || !(Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.ELLIPSIS_EXPAND)) ^ true)) continue;
            View view = this.findViewById(action.getButtonId());
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.ToggleButton");
            }
            ToggleButton view2 = (ToggleButton)view;
            if (!view2.isChecked()) continue;
            actions.add(action);
        }
        return actions;
    }

    private final void toggleButton(View button, boolean checked) {
        if (button != null && button instanceof ToggleButton) {
            ((ToggleButton)button).setChecked(checked);
        }
    }

    private final void toggleButtonState(View button, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    private final void highlightAppliedStyles(int selStart, int selEnd) {
        if (!this.isEditorAttached()) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<TextFormat> appliedStyles = aztecText.getAppliedStyles(selStart, selEnd);
        this.highlightActionButtons(ToolbarAction.Companion.getToolbarActionsForStyles(appliedStyles));
        this.selectHeadingMenuItem(appliedStyles);
        this.selectListMenuItem(appliedStyles);
    }

    private final void onToolbarAction(ToolbarAction action) {
        if (!this.isEditorAttached()) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        if (!aztecText.isTextSelected() && Intrinsics.areEqual((Object)((Object)action.getActionType()), (Object)((Object)ToolbarActionType.INLINE_STYLE))) {
            ArrayList<ToolbarAction> actions = this.getSelectedActions();
            ArrayList<TextFormat> textFormats = new ArrayList<TextFormat>();
            Iterable $receiver$iv = actions;
            for (Object element$iv : $receiver$iv) {
                ToolbarAction it = (ToolbarAction)((Object)element$iv);
                if (!it.isStylingAction() || it.getTextFormat() == null) continue;
                textFormats.add(it.getTextFormat());
            }
            if (this.getSelectedHeadingMenuItem() != null) {
                TextFormat textFormat = this.getSelectedHeadingMenuItem();
                if (textFormat == null) {
                    Intrinsics.throwNpe();
                }
                textFormats.add(textFormat);
            }
            if (this.getSelectedListMenuItem() != null) {
                TextFormat textFormat = this.getSelectedListMenuItem();
                if (textFormat == null) {
                    Intrinsics.throwNpe();
                }
                textFormats.add(textFormat);
            }
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                TextFormat textFormat = action.getTextFormat();
                if (textFormat == null) {
                    Intrinsics.throwNpe();
                }
                aztecToolbarClickListener.onToolbarFormatButtonClicked(textFormat, false);
            }
            AztecText aztecText2 = this.editor;
            if (aztecText2 == null) {
                Intrinsics.throwNpe();
            }
            aztecText2.setSelectedStyles(textFormats);
            return;
        }
        if (action.isStylingAction() && Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.HEADING)) ^ true && Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.LIST)) ^ true) {
            AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
            if (aztecToolbarClickListener != null) {
                TextFormat textFormat = action.getTextFormat();
                if (textFormat == null) {
                    Intrinsics.throwNpe();
                }
                aztecToolbarClickListener.onToolbarFormatButtonClicked(textFormat, false);
            }
            AztecText aztecText3 = this.editor;
            if (aztecText3 == null) {
                Intrinsics.throwNpe();
            }
            TextFormat textFormat = action.getTextFormat();
            if (textFormat == null) {
                Intrinsics.throwNpe();
            }
            aztecText3.toggleFormatting(textFormat);
            return;
        }
        switch (AztecToolbar$WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarMediaButtonClicked();
                }
                break;
            }
            case 2: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarHeadingButtonClicked();
                }
                PopupMenu popupMenu = this.headingMenu;
                if (popupMenu != null) {
                    popupMenu.show();
                }
                break;
            }
            case 3: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarListButtonClicked();
                }
                PopupMenu popupMenu = this.listMenu;
                if (popupMenu != null) {
                    popupMenu.show();
                }
                break;
            }
            case 4: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarFormatButtonClicked(TextFormat.FORMAT_LINK, false);
                }
                AztecText aztecText4 = this.editor;
                if (aztecText4 == null) {
                    Intrinsics.throwNpe();
                }
                AztecText.showLinkDialog$default(aztecText4, null, null, 3, null);
                break;
            }
            case 5: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarHtmlButtonClicked();
                }
                break;
            }
            case 6: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarCollapseButtonClicked();
                }
                this.animateToolbarCollapse();
                break;
            }
            case 7: {
                AztecToolbarClickListener aztecToolbarClickListener = this.aztecToolbarListener;
                if (aztecToolbarClickListener != null) {
                    aztecToolbarClickListener.onToolbarExpandButtonClicked();
                }
                this.animateToolbarExpand();
                break;
            }
            default: {
                Toast.makeText((Context)this.getContext(), (CharSequence)"Unsupported action", (int)0).show();
            }
        }
    }

    public final void toggleEditorMode() {
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        if (aztecText.getVisibility() == 0) {
            SourceViewEditText sourceViewEditText = this.sourceEditor;
            if (sourceViewEditText == null) {
                Intrinsics.throwNpe();
            }
            AztecText aztecText2 = this.editor;
            if (aztecText2 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText.displayStyledAndFormattedHtml(aztecText2.toPlainHtml(true));
            AztecText aztecText3 = this.editor;
            if (aztecText3 == null) {
                Intrinsics.throwNpe();
            }
            aztecText3.setVisibility(8);
            SourceViewEditText sourceViewEditText2 = this.sourceEditor;
            if (sourceViewEditText2 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText2.setVisibility(0);
            this.toggleHtmlMode(true);
        } else {
            AztecText aztecText4 = this.editor;
            if (aztecText4 == null) {
                Intrinsics.throwNpe();
            }
            SourceViewEditText sourceViewEditText = this.sourceEditor;
            if (sourceViewEditText == null) {
                Intrinsics.throwNpe();
            }
            aztecText4.fromHtml(sourceViewEditText.getPureHtml(true));
            AztecText aztecText5 = this.editor;
            if (aztecText5 == null) {
                Intrinsics.throwNpe();
            }
            aztecText5.setVisibility(0);
            SourceViewEditText sourceViewEditText3 = this.sourceEditor;
            if (sourceViewEditText3 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText3.setVisibility(8);
            this.toggleHtmlMode(false);
        }
    }

    @Nullable
    public final PopupMenu getHeadingMenu() {
        return this.headingMenu;
    }

    @Nullable
    public final PopupMenu getListMenu() {
        return this.listMenu;
    }

    @Nullable
    public final TextFormat getSelectedHeadingMenuItem() {
        PopupMenu popupMenu = this.headingMenu;
        Boolean bl = popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.paragraph)) != null ? Boolean.valueOf(popupMenu.isChecked()) : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            return TextFormat.FORMAT_PARAGRAPH;
        }
        PopupMenu popupMenu2 = this.headingMenu;
        Boolean bl2 = popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.findItem(R.id.heading_1)) != null ? Boolean.valueOf(popupMenu2.isChecked()) : null;
        if (bl2 == null) {
            Intrinsics.throwNpe();
        }
        if (bl2.booleanValue()) {
            return TextFormat.FORMAT_HEADING_1;
        }
        PopupMenu popupMenu3 = this.headingMenu;
        Boolean bl3 = popupMenu3 != null && (popupMenu3 = popupMenu3.getMenu()) != null && (popupMenu3 = popupMenu3.findItem(R.id.heading_2)) != null ? Boolean.valueOf(popupMenu3.isChecked()) : null;
        if (bl3 == null) {
            Intrinsics.throwNpe();
        }
        if (bl3.booleanValue()) {
            return TextFormat.FORMAT_HEADING_2;
        }
        PopupMenu popupMenu4 = this.headingMenu;
        Boolean bl4 = popupMenu4 != null && (popupMenu4 = popupMenu4.getMenu()) != null && (popupMenu4 = popupMenu4.findItem(R.id.heading_3)) != null ? Boolean.valueOf(popupMenu4.isChecked()) : null;
        if (bl4 == null) {
            Intrinsics.throwNpe();
        }
        if (bl4.booleanValue()) {
            return TextFormat.FORMAT_HEADING_3;
        }
        PopupMenu popupMenu5 = this.headingMenu;
        Boolean bl5 = popupMenu5 != null && (popupMenu5 = popupMenu5.getMenu()) != null && (popupMenu5 = popupMenu5.findItem(R.id.heading_4)) != null ? Boolean.valueOf(popupMenu5.isChecked()) : null;
        if (bl5 == null) {
            Intrinsics.throwNpe();
        }
        if (bl5.booleanValue()) {
            return TextFormat.FORMAT_HEADING_4;
        }
        PopupMenu popupMenu6 = this.headingMenu;
        Boolean bl6 = popupMenu6 != null && (popupMenu6 = popupMenu6.getMenu()) != null && (popupMenu6 = popupMenu6.findItem(R.id.heading_5)) != null ? Boolean.valueOf(popupMenu6.isChecked()) : null;
        if (bl6 == null) {
            Intrinsics.throwNpe();
        }
        if (bl6.booleanValue()) {
            return TextFormat.FORMAT_HEADING_5;
        }
        PopupMenu popupMenu7 = this.headingMenu;
        Boolean bl7 = popupMenu7 != null && (popupMenu7 = popupMenu7.getMenu()) != null && (popupMenu7 = popupMenu7.findItem(R.id.heading_6)) != null ? Boolean.valueOf(popupMenu7.isChecked()) : null;
        if (bl7 == null) {
            Intrinsics.throwNpe();
        }
        if (bl7.booleanValue()) {
            return TextFormat.FORMAT_HEADING_6;
        }
        return null;
    }

    @Nullable
    public final TextFormat getSelectedListMenuItem() {
        PopupMenu popupMenu = this.listMenu;
        Boolean bl = popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_unordered)) != null ? Boolean.valueOf(popupMenu.isChecked()) : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            return TextFormat.FORMAT_UNORDERED_LIST;
        }
        PopupMenu popupMenu2 = this.listMenu;
        Boolean bl2 = popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.findItem(R.id.list_ordered)) != null ? Boolean.valueOf(popupMenu2.isChecked()) : null;
        if (bl2 == null) {
            Intrinsics.throwNpe();
        }
        if (bl2.booleanValue()) {
            return TextFormat.FORMAT_ORDERED_LIST;
        }
        return null;
    }

    public final void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        this.setAdvancedState();
    }

    private final void animateToolbarCollapse() {
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapse;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapse");
        }
        Animation animation = this.ellipsisSpinLeft;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinLeft");
        }
        rippleToggleButton.startAnimation(animation);
        this.isExpanded = false;
    }

    private final void animateToolbarExpand() {
        RippleToggleButton rippleToggleButton = this.buttonEllipsisExpand;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpand");
        }
        Animation animation = this.ellipsisSpinRight;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinRight");
        }
        rippleToggleButton.startAnimation(animation);
        this.isExpanded = true;
    }

    private final void setAdvancedState() {
        if (this.isAdvanced) {
            this.setButtonViews();
            this.setAnimations();
            if (this.isExpanded) {
                this.showExpandedToolbar();
            } else {
                this.showCollapsedToolbar();
            }
        }
    }

    private final void selectHeadingMenuItem(ArrayList<TextFormat> textFormats) {
        if (textFormats.size() == 0) {
            PopupMenu popupMenu = this.headingMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.paragraph)) != null) {
                popupMenu.setChecked(true);
            }
            this.setHeadingMenuSelector(TextFormat.FORMAT_PARAGRAPH);
        } else {
            Iterable $receiver$iv = textFormats;
            Iterator iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                TextFormat it = (TextFormat)((Object)element$iv);
                switch (AztecToolbar$WhenMappings.$EnumSwitchMapping$1[it.ordinal()]) {
                    case 1: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_1)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 2: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_2)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 3: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_3)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 4: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_4)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 5: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_5)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 6: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_6)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    default: {
                        PopupMenu popupMenu = this.headingMenu;
                        if (popupMenu == null || (popupMenu = popupMenu.getMenu()) == null || (popupMenu = popupMenu.findItem(R.id.paragraph)) == null) break;
                        popupMenu.setChecked(true);
                        break;
                    }
                }
                this.setHeadingMenuSelector(it);
                return;
            }
        }
    }

    private final void selectListMenuItem(ArrayList<TextFormat> textFormats) {
        if (textFormats.size() == 0) {
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_none)) != null) {
                popupMenu.setChecked(true);
            }
            this.setListMenuSelector(TextFormat.FORMAT_UNORDERED_LIST);
        } else {
            Iterable $receiver$iv = textFormats;
            Iterator iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                TextFormat it = (TextFormat)((Object)element$iv);
                switch (AztecToolbar$WhenMappings.$EnumSwitchMapping$2[it.ordinal()]) {
                    case 1: {
                        PopupMenu popupMenu = this.listMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_unordered)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    case 2: {
                        PopupMenu popupMenu = this.listMenu;
                        if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_ordered)) != null) {
                            popupMenu.setChecked(true);
                        }
                        break;
                    }
                    default: {
                        PopupMenu popupMenu = this.listMenu;
                        if (popupMenu == null || (popupMenu = popupMenu.getMenu()) == null || (popupMenu = popupMenu.findItem(R.id.list_none)) == null) break;
                        popupMenu.setChecked(true);
                        break;
                    }
                }
                this.setListMenuSelector(it);
                return;
            }
        }
    }

    private final void setAnimations() {
        Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_in_right);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation, (String)"AnimationUtils.loadAnima\u2026.anim.translate_in_right)");
        this.layoutExpandedTranslateInRight = animation;
        Animation animation2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_out_left);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation2, (String)"AnimationUtils.loadAnima\u2026.anim.translate_out_left)");
        Animation animation3 = this.layoutExpandedTranslateOutLeft = animation2;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateOutLeft");
        }
        animation3.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).setVisibility(8);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation4 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.spin_left_90);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation4, (String)"AnimationUtils.loadAnima\u2026ext, R.anim.spin_left_90)");
        Animation animation5 = this.ellipsisSpinLeft = animation4;
        if (animation5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinLeft");
        }
        animation5.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonEllipsisCollapse$p(this.this$0).setVisibility(8);
                AztecToolbar.access$getButtonEllipsisExpand$p(this.this$0).setVisibility(0);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonScroll$p(this.this$0).smoothScrollTo(0, 0);
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).startAnimation(AztecToolbar.access$getLayoutExpandedTranslateOutLeft$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation6 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.spin_right_90);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation6, (String)"AnimationUtils.loadAnima\u2026xt, R.anim.spin_right_90)");
        Animation animation7 = this.ellipsisSpinRight = animation6;
        if (animation7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinRight");
        }
        animation7.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonEllipsisCollapse$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getButtonEllipsisExpand$p(this.this$0).setVisibility(8);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).startAnimation(AztecToolbar.access$getLayoutExpandedTranslateInRight$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void setButtonViews() {
        View view = this.findViewById(R.id.format_bar_button_layout_expanded);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
        }
        this.layoutExpanded = (LinearLayout)view;
        View view2 = this.findViewById(R.id.format_bar_button_scroll);
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.HorizontalScrollView");
        }
        this.buttonScroll = (HorizontalScrollView)view2;
        View view3 = this.findViewById(R.id.format_bar_button_ellipsis_collapse);
        if (view3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.toolbar.RippleToggleButton");
        }
        this.buttonEllipsisCollapse = (RippleToggleButton)view3;
        View view4 = this.findViewById(R.id.format_bar_button_ellipsis_expand);
        if (view4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.toolbar.RippleToggleButton");
        }
        this.buttonEllipsisExpand = (RippleToggleButton)view4;
    }

    private final void setHeadingMenu(View view) {
        block1: {
            PopupMenu popupMenu = this.headingMenu = new PopupMenu(this.getContext(), view);
            if (popupMenu != null) {
                popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
            }
            PopupMenu popupMenu2 = this.headingMenu;
            if (popupMenu2 == null) break block1;
            popupMenu2.inflate(R.menu.heading);
        }
    }

    private final void setListMenu(View view) {
        block1: {
            PopupMenu popupMenu = this.listMenu = new PopupMenu(this.getContext(), view);
            if (popupMenu != null) {
                popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
            }
            PopupMenu popupMenu2 = this.listMenu;
            if (popupMenu2 == null) break block1;
            popupMenu2.inflate(R.menu.list);
        }
    }

    private final void setListMenuSelector(TextFormat textFormat) {
        switch (AztecToolbar$WhenMappings.$EnumSwitchMapping$3[textFormat.ordinal()]) {
            case 1: {
                this.findViewById(R.id.format_bar_button_list).setBackgroundResource(R.drawable.format_bar_button_ul_selector);
                break;
            }
            case 2: {
                this.findViewById(R.id.format_bar_button_list).setBackgroundResource(R.drawable.format_bar_button_ol_selector);
                break;
            }
            default: {
                this.findViewById(R.id.format_bar_button_list).setBackgroundResource(R.drawable.format_bar_button_ul_selector);
            }
        }
    }

    private final void setHeadingMenuSelector(TextFormat textFormat) {
        switch (AztecToolbar$WhenMappings.$EnumSwitchMapping$4[textFormat.ordinal()]) {
            case 1: {
                this.findViewById(R.id.format_bar_button_heading).setBackgroundResource(R.drawable.format_bar_button_heading_1_selector);
                break;
            }
            case 2: {
                this.findViewById(R.id.format_bar_button_heading).setBackgroundResource(R.drawable.format_bar_button_heading_2_selector);
                break;
            }
            case 3: {
                this.findViewById(R.id.format_bar_button_heading).setBackgroundResource(R.drawable.format_bar_button_heading_3_selector);
                break;
            }
            case 4: {
                this.findViewById(R.id.format_bar_button_heading).setBackgroundResource(R.drawable.format_bar_button_heading_4_selector);
                break;
            }
            case 5: {
                this.findViewById(R.id.format_bar_button_heading).setBackgroundResource(R.drawable.format_bar_button_heading_5_selector);
                break;
            }
            case 6: {
                this.findViewById(R.id.format_bar_button_heading).setBackgroundResource(R.drawable.format_bar_button_heading_6_selector);
                break;
            }
            case 7: {
                this.findViewById(R.id.format_bar_button_heading).setBackgroundResource(R.drawable.format_bar_button_heading_selector);
                break;
            }
            default: {
                this.findViewById(R.id.format_bar_button_heading).setBackgroundResource(R.drawable.format_bar_button_heading_selector);
            }
        }
    }

    private final void showCollapsedToolbar() {
        LinearLayout linearLayout = this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        linearLayout.setVisibility(8);
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapse;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapse");
        }
        rippleToggleButton.setVisibility(8);
        RippleToggleButton rippleToggleButton2 = this.buttonEllipsisExpand;
        if (rippleToggleButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpand");
        }
        rippleToggleButton2.setVisibility(0);
    }

    private final void showExpandedToolbar() {
        LinearLayout linearLayout = this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        linearLayout.setVisibility(0);
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapse;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapse");
        }
        rippleToggleButton.setVisibility(0);
        RippleToggleButton rippleToggleButton2 = this.buttonEllipsisExpand;
        if (rippleToggleButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpand");
        }
        rippleToggleButton2.setVisibility(8);
    }

    private final void toggleHtmlMode(boolean isHtmlMode) {
        Object[] $receiver$iv = (Object[])ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)((Object)element$iv);
            if (Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.HTML))) {
                this.toggleButton(this.findViewById(action.getButtonId()), isHtmlMode);
                continue;
            }
            this.toggleButtonState(this.findViewById(action.getButtonId()), !isHtmlMode);
        }
    }

    private final void toggleListMenuSelection(int listMenuItemId, boolean isChecked) {
        if (isChecked) {
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(listMenuItemId)) != null) {
                popupMenu.setChecked(true);
            }
            int n = listMenuItemId;
            if (n == R.id.list_ordered) {
                this.setListMenuSelector(TextFormat.FORMAT_ORDERED_LIST);
            } else if (n == R.id.list_unordered) {
                this.setListMenuSelector(TextFormat.FORMAT_UNORDERED_LIST);
            } else {
                this.setListMenuSelector(TextFormat.FORMAT_UNORDERED_LIST);
            }
        } else {
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_none)) != null) {
                popupMenu.setChecked(true);
            }
            this.setListMenuSelector(TextFormat.FORMAT_UNORDERED_LIST);
        }
    }

    public final void enableFormatButtons(boolean isEnabled) {
        Object[] $receiver$iv = (Object[])ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)((Object)element$iv);
            if (!(Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.HTML)) ^ true)) continue;
            this.toggleButtonState(this.findViewById(action.getButtonId()), isEnabled);
        }
    }

    public final boolean isMediaModeEnabled() {
        return this.isMediaModeEnabled;
    }

    public final void enableMediaMode(boolean isEnabled) {
        this.isMediaModeEnabled = isEnabled;
        Object[] $receiver$iv = (Object[])ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)((Object)element$iv);
            if (Intrinsics.areEqual((Object)((Object)action), (Object)((Object)ToolbarAction.ADD_MEDIA))) {
                this.toggleButton(this.findViewById(action.getButtonId()), isEnabled);
                continue;
            }
            this.toggleButtonState(this.findViewById(action.getButtonId()), !isEnabled);
        }
    }

    private final void showDialogShortcuts() {
        View layout2 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dialog_shortcuts, null);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setView(layout2);
        AlertDialog alertDialog = this.dialogShortcuts = builder.create();
        if (alertDialog == null) {
            Intrinsics.throwNpe();
        }
        alertDialog.show();
    }

    public AztecToolbar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.initView(null);
    }

    public AztecToolbar(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.initView(attrs);
    }

    public AztecToolbar(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.initView(attrs);
    }

    public static final /* synthetic */ void access$highlightAppliedStyles(AztecToolbar $this, int selStart, int selEnd) {
        $this.highlightAppliedStyles(selStart, selEnd);
    }

    public static final /* synthetic */ void access$onToolbarAction(AztecToolbar $this, @NotNull ToolbarAction action) {
        $this.onToolbarAction(action);
    }

    @NotNull
    public static final /* synthetic */ LinearLayout access$getLayoutExpanded$p(AztecToolbar $this) {
        LinearLayout linearLayout = $this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        return linearLayout;
    }

    public static final /* synthetic */ void access$setLayoutExpanded$p(AztecToolbar $this, @NotNull LinearLayout linearLayout) {
        $this.layoutExpanded = linearLayout;
    }

    @NotNull
    public static final /* synthetic */ RippleToggleButton access$getButtonEllipsisCollapse$p(AztecToolbar $this) {
        RippleToggleButton rippleToggleButton = $this.buttonEllipsisCollapse;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapse");
        }
        return rippleToggleButton;
    }

    public static final /* synthetic */ void access$setButtonEllipsisCollapse$p(AztecToolbar $this, @NotNull RippleToggleButton rippleToggleButton) {
        $this.buttonEllipsisCollapse = rippleToggleButton;
    }

    @NotNull
    public static final /* synthetic */ RippleToggleButton access$getButtonEllipsisExpand$p(AztecToolbar $this) {
        RippleToggleButton rippleToggleButton = $this.buttonEllipsisExpand;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpand");
        }
        return rippleToggleButton;
    }

    public static final /* synthetic */ void access$setButtonEllipsisExpand$p(AztecToolbar $this, @NotNull RippleToggleButton rippleToggleButton) {
        $this.buttonEllipsisExpand = rippleToggleButton;
    }

    @NotNull
    public static final /* synthetic */ HorizontalScrollView access$getButtonScroll$p(AztecToolbar $this) {
        HorizontalScrollView horizontalScrollView = $this.buttonScroll;
        if (horizontalScrollView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonScroll");
        }
        return horizontalScrollView;
    }

    public static final /* synthetic */ void access$setButtonScroll$p(AztecToolbar $this, @NotNull HorizontalScrollView horizontalScrollView) {
        $this.buttonScroll = horizontalScrollView;
    }

    @NotNull
    public static final /* synthetic */ Animation access$getLayoutExpandedTranslateOutLeft$p(AztecToolbar $this) {
        Animation animation = $this.layoutExpandedTranslateOutLeft;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateOutLeft");
        }
        return animation;
    }

    public static final /* synthetic */ void access$setLayoutExpandedTranslateOutLeft$p(AztecToolbar $this, @NotNull Animation animation) {
        $this.layoutExpandedTranslateOutLeft = animation;
    }

    @NotNull
    public static final /* synthetic */ Animation access$getLayoutExpandedTranslateInRight$p(AztecToolbar $this) {
        Animation animation = $this.layoutExpandedTranslateInRight;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateInRight");
        }
        return animation;
    }

    public static final /* synthetic */ void access$setLayoutExpandedTranslateInRight$p(AztecToolbar $this, @NotNull Animation animation) {
        $this.layoutExpandedTranslateInRight = animation;
    }
}

