/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;
import android.text.style.LineHeightSpan;
import android.text.style.TypefaceSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.AztecBlockSpan;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B!\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ8\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u000201H\u0016Jb\u00102\u001a\u00020)2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0016Jh\u0010=\u001a\u00020)2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010@\u001a\u00020AH\u0016R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0018\"\u0004\b'\u0010\u001a\u00a8\u0006E"}, d2={"Lorg/wordpress/aztec/spans/AztecPreformatSpan;", "Lorg/wordpress/aztec/spans/AztecBlockSpan;", "Landroid/text/style/LeadingMarginSpan;", "Landroid/text/style/LineBackgroundSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/TypefaceSpan;", "nestingLevel", "", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "preformatStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "(ILorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;)V", "MARGIN", "TAG", "", "getTAG", "()Ljava/lang/String;", "getAttributes", "()Lorg/wordpress/aztec/AztecAttributes;", "setAttributes", "(Lorg/wordpress/aztec/AztecAttributes;)V", "endBeforeBleed", "getEndBeforeBleed", "()I", "setEndBeforeBleed", "(I)V", "getNestingLevel", "setNestingLevel", "getPreformatStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "setPreformatStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;)V", "rect", "Landroid/graphics/Rect;", "getRect", "()Landroid/graphics/Rect;", "startBeforeCollapse", "getStartBeforeCollapse", "setStartBeforeCollapse", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "drawBackground", "canvas", "Landroid/graphics/Canvas;", "paint", "Landroid/graphics/Paint;", "left", "right", "top", "baseline", "bottom", "lnum", "drawLeadingMargin", "x", "dir", "first", "", "layout", "Landroid/text/Layout;", "getLeadingMargin", "aztec_release"})
public final class AztecPreformatSpan
extends TypefaceSpan
implements AztecBlockSpan,
LeadingMarginSpan,
LineBackgroundSpan,
LineHeightSpan {
    @NotNull
    private final String TAG = "pre";
    private int endBeforeBleed;
    private int startBeforeCollapse;
    @NotNull
    private final Rect rect;
    private final int MARGIN = 16;
    private int nestingLevel;
    @NotNull
    private AztecAttributes attributes;
    @NotNull
    private BlockFormatter.PreformatStyle preformatStyle;

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    @Override
    public int getEndBeforeBleed() {
        return this.endBeforeBleed;
    }

    @Override
    public void setEndBeforeBleed(int n) {
        this.endBeforeBleed = n;
    }

    @Override
    public int getStartBeforeCollapse() {
        return this.startBeforeCollapse;
    }

    @Override
    public void setStartBeforeCollapse(int n) {
        this.startBeforeCollapse = n;
    }

    @NotNull
    public final Rect getRect() {
        return this.rect;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        Spanned spanned = (Spanned)text;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.preformatStyle.getVerticalPadding();
            fm.top -= this.preformatStyle.getVerticalPadding();
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.preformatStyle.getVerticalPadding();
            fm.bottom += this.preformatStyle.getVerticalPadding();
        }
    }

    public void drawBackground(@NotNull Canvas canvas, @NotNull Paint paint, int left, int right, int top, int baseline, int bottom, @Nullable CharSequence text, int start, int end, int lnum) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        int color2 = paint.getColor();
        int alpha = (int)(this.preformatStyle.getPreformatBackgroundAlpha() * (float)255);
        paint.setColor(Color.argb((int)alpha, (int)Color.red((int)this.preformatStyle.getPreformatBackground()), (int)Color.green((int)this.preformatStyle.getPreformatBackground()), (int)Color.blue((int)this.preformatStyle.getPreformatBackground())));
        this.rect.set(left, top, right, bottom);
        canvas.drawRect(this.rect, paint);
        paint.setColor(color2);
    }

    public void drawLeadingMargin(@NotNull Canvas canvas, @NotNull Paint paint, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout layout) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        Paint.Style style = paint.getStyle();
        int color2 = paint.getColor();
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(this.preformatStyle.getPreformatColor());
        canvas.drawRect((float)x + (float)this.MARGIN, (float)top, (float)(x + this.MARGIN), (float)bottom, paint);
        paint.setStyle(style);
        paint.setColor(color2);
    }

    public int getLeadingMargin(boolean first) {
        return this.MARGIN;
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public AztecAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AztecAttributes aztecAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)aztecAttributes, (String)"<set-?>");
        this.attributes = aztecAttributes;
    }

    @NotNull
    public final BlockFormatter.PreformatStyle getPreformatStyle() {
        return this.preformatStyle;
    }

    public final void setPreformatStyle(@NotNull BlockFormatter.PreformatStyle preformatStyle) {
        Intrinsics.checkParameterIsNotNull((Object)preformatStyle, (String)"<set-?>");
        this.preformatStyle = preformatStyle;
    }

    public AztecPreformatSpan(int nestingLevel, @NotNull AztecAttributes attributes, @NotNull BlockFormatter.PreformatStyle preformatStyle) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)preformatStyle, (String)"preformatStyle");
        super("monospace");
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.preformatStyle = preformatStyle;
        this.TAG = "pre";
        this.endBeforeBleed = -1;
        this.startBeforeCollapse = -1;
        this.rect = new Rect();
        this.MARGIN = 16;
    }

    public /* synthetic */ AztecPreformatSpan(int n, AztecAttributes aztecAttributes, BlockFormatter.PreformatStyle preformatStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        if ((n2 & 4) != 0) {
            preformatStyle = new BlockFormatter.PreformatStyle(0, 0.0f, 0, 0);
        }
        this(n, aztecAttributes, preformatStyle);
    }

    @Override
    @NotNull
    public String getStartTag() {
        return AztecBlockSpan.DefaultImpls.getStartTag(this);
    }

    @Override
    @NotNull
    public String getEndTag() {
        return AztecBlockSpan.DefaultImpls.getEndTag(this);
    }

    @Override
    public void clearStartBeforeCollapse() {
        AztecBlockSpan.DefaultImpls.clearStartBeforeCollapse(this);
    }

    @Override
    public boolean hasCollapsed() {
        return AztecBlockSpan.DefaultImpls.hasCollapsed(this);
    }

    @Override
    public void clearEndBeforeBleed() {
        AztecBlockSpan.DefaultImpls.clearEndBeforeBleed(this);
    }

    @Override
    public boolean hasBled() {
        return AztecBlockSpan.DefaultImpls.hasBled(this);
    }
}

