/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Spanned;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.wordpress.aztec.AztecHtmlSchema;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.HtmlToSpannedConverter;
import org.wordpress.aztec.spans.UnknownHtmlSpan;
import org.xml.sax.Attributes;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class Html {
    private Html() {
    }

    public static Spanned fromHtml(String source, AztecText.OnImageTappedListener onImageTappedListener, AztecText.OnVideoTappedListener onVideoTappedListener, UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener, Context context) {
        return Html.fromHtml(source, null, onUnknownHtmlClickListener, context);
    }

    public static Spanned fromHtml(String source, TagHandler tagHandler, UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener, Context context) {
        Parser parser = new Parser();
        try {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)HtmlParser.schema);
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/root-bogons", false);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        HtmlToSpannedConverter converter = new HtmlToSpannedConverter(source, tagHandler, parser, onUnknownHtmlClickListener, context);
        return converter.convert();
    }

    public static StringBuilder stringifyAttributes(Attributes attributes) {
        StringBuilder sb = new StringBuilder();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                sb.append(' ');
                sb.append(attributes.getLocalName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
            }
        }
        return sb;
    }

    private static class HtmlParser {
        private static final HTMLSchema schema = new AztecHtmlSchema();

        private HtmlParser() {
        }
    }

    public static interface TagHandler {
        public boolean handleTag(boolean var1, String var2, Editable var3, Context var4, Attributes var5, int var6);
    }

    public static interface VideoThumbnailGetter {
        public void loadVideoThumbnail(String var1, Callbacks var2, int var3);

        public static interface Callbacks {
            public void onThumbnailFailed();

            public void onThumbnailLoaded(Drawable var1);

            public void onThumbnailLoading(Drawable var1);
        }
    }

    public static interface ImageGetter {
        public void loadImage(String var1, Callbacks var2, int var3);

        public static interface Callbacks {
            public void onImageFailed();

            public void onImageLoaded(Drawable var1);

            public void onImageLoading(Drawable var1);
        }
    }
}

