/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.toolbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.Toast;
import android.widget.ToggleButton;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.ITextFormat;
import org.wordpress.aztec.R;
import org.wordpress.aztec.plugins.IToolbarButton;
import org.wordpress.aztec.source.SourceViewEditText;
import org.wordpress.aztec.toolbar.IAztecToolbarClickListener;
import org.wordpress.aztec.toolbar.IToolbarAction;
import org.wordpress.aztec.toolbar.RippleToggleButton;
import org.wordpress.aztec.toolbar.ToolbarAction;
import org.wordpress.aztec.toolbar.ToolbarActionType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020)J\b\u00101\u001a\u00020/H\u0002J\b\u00102\u001a\u00020/H\u0002J\u000e\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020\u001dJ\u000e\u00105\u001a\u00020/2\u0006\u00104\u001a\u00020\u001dJ\b\u00106\u001a\u0004\u0018\u00010\u001bJ\b\u00107\u001a\u0004\u0018\u00010\u001bJ\u000e\u00108\u001a\b\u0012\u0004\u0012\u0002090(H\u0002J\b\u0010:\u001a\u0004\u0018\u00010;J\b\u0010<\u001a\u0004\u0018\u00010;J\u0014\u0010=\u001a\u00020/2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002090(J\u0018\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020\n2\u0006\u0010A\u001a\u00020\nH\u0002J\u0012\u0010B\u001a\u00020/2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010C\u001a\u00020\u001dH\u0002J\u0006\u0010\u001f\u001a\u00020\u001dJ\u0018\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020GH\u0016J\u0012\u0010H\u001a\u00020\u001d2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u0012\u0010K\u001a\u00020/2\b\u0010L\u001a\u0004\u0018\u00010MH\u0014J\b\u0010N\u001a\u00020MH\u0014J\u0010\u0010O\u001a\u00020/2\u0006\u0010P\u001a\u000209H\u0002J\u0016\u0010Q\u001a\u00020/2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020;0(H\u0002J\u0016\u0010S\u001a\u00020/2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020;0(H\u0002J\b\u0010T\u001a\u00020/H\u0002J\b\u0010U\u001a\u00020/H\u0002J\b\u0010V\u001a\u00020/H\u0002J\u0018\u0010W\u001a\u00020/2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010&J\u000e\u0010X\u001a\u00020/2\u0006\u0010Y\u001a\u00020\u001dJ\u0010\u0010Z\u001a\u00020/2\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010]\u001a\u00020/2\u0006\u0010^\u001a\u00020;H\u0002J\u0010\u0010_\u001a\u00020/2\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010`\u001a\u00020/2\u0006\u0010^\u001a\u00020;H\u0002J\u000e\u0010a\u001a\u00020/2\u0006\u0010b\u001a\u00020\rJ\b\u0010c\u001a\u00020/H\u0002J\b\u0010d\u001a\u00020/H\u0002J\b\u0010e\u001a\u00020/H\u0002J\u001a\u0010f\u001a\u00020/2\b\u0010g\u001a\u0004\u0018\u00010\\2\u0006\u0010h\u001a\u00020\u001dH\u0002J\u001a\u0010i\u001a\u00020/2\b\u0010g\u001a\u0004\u0018\u00010\\2\u0006\u0010j\u001a\u00020\u001dH\u0002J\u0006\u0010k\u001a\u00020/J\u0010\u0010l\u001a\u00020/2\u0006\u0010m\u001a\u00020\u001dH\u0002J\u0018\u0010n\u001a\u00020/2\u0006\u0010o\u001a\u00020\n2\u0006\u0010p\u001a\u00020\u001dH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006q"}, d2={"Lorg/wordpress/aztec/toolbar/AztecToolbar;", "Landroid/widget/FrameLayout;", "Landroid/widget/PopupMenu$OnMenuItemClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "aztecToolbarListener", "Lorg/wordpress/aztec/toolbar/IAztecToolbarClickListener;", "buttonEllipsisCollapse", "Lorg/wordpress/aztec/toolbar/RippleToggleButton;", "buttonEllipsisExpand", "buttonScroll", "Landroid/widget/HorizontalScrollView;", "dialogShortcuts", "Landroid/support/v7/app/AlertDialog;", "editor", "Lorg/wordpress/aztec/AztecText;", "ellipsisSpinLeft", "Landroid/view/animation/Animation;", "ellipsisSpinRight", "headingMenu", "Landroid/widget/PopupMenu;", "isAdvanced", "", "isExpanded", "isMediaModeEnabled", "layoutExpanded", "Landroid/widget/LinearLayout;", "layoutExpandedTranslateInRight", "layoutExpandedTranslateOutLeft", "listMenu", "sourceEditor", "Lorg/wordpress/aztec/source/SourceViewEditText;", "toolbarButtonPlugins", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/plugins/IToolbarButton;", "getToolbarButtonPlugins", "()Ljava/util/ArrayList;", "setToolbarButtonPlugins", "(Ljava/util/ArrayList;)V", "addButton", "", "buttonPlugin", "animateToolbarCollapse", "animateToolbarExpand", "enableFormatButtons", "isEnabled", "enableMediaMode", "getHeadingMenu", "getListMenu", "getSelectedActions", "Lorg/wordpress/aztec/toolbar/IToolbarAction;", "getSelectedHeadingMenuItem", "Lorg/wordpress/aztec/ITextFormat;", "getSelectedListMenuItem", "highlightActionButtons", "toolbarActions", "highlightAppliedStyles", "selStart", "selEnd", "initView", "isEditorAttached", "onKeyUp", "keyCode", "event", "Landroid/view/KeyEvent;", "onMenuItemClick", "item", "Landroid/view/MenuItem;", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onToolbarAction", "action", "selectHeadingMenuItem", "textFormats", "selectListMenuItem", "setAdvancedState", "setAnimations", "setButtonViews", "setEditor", "setExpanded", "expanded", "setHeadingMenu", "view", "Landroid/view/View;", "setHeadingMenuSelector", "textFormat", "setListMenu", "setListMenuSelector", "setToolbarListener", "listener", "showCollapsedToolbar", "showDialogShortcuts", "showExpandedToolbar", "toggleButton", "button", "checked", "toggleButtonState", "enabled", "toggleEditorMode", "toggleHtmlMode", "isHtmlMode", "toggleListMenuSelection", "listMenuItemId", "isChecked", "aztec_release"})
public final class AztecToolbar
extends FrameLayout
implements PopupMenu.OnMenuItemClickListener {
    private IAztecToolbarClickListener aztecToolbarListener;
    private AztecText editor;
    private PopupMenu headingMenu;
    private PopupMenu listMenu;
    private SourceViewEditText sourceEditor;
    private AlertDialog dialogShortcuts;
    private boolean isAdvanced;
    private boolean isExpanded;
    private boolean isMediaModeEnabled;
    private HorizontalScrollView buttonScroll;
    private RippleToggleButton buttonEllipsisCollapse;
    private RippleToggleButton buttonEllipsisExpand;
    private Animation layoutExpandedTranslateInRight;
    private Animation layoutExpandedTranslateOutLeft;
    private Animation ellipsisSpinLeft;
    private Animation ellipsisSpinRight;
    private LinearLayout layoutExpanded;
    @NotNull
    private ArrayList<IToolbarButton> toolbarButtonPlugins;

    @NotNull
    public final ArrayList<IToolbarButton> getToolbarButtonPlugins() {
        return this.toolbarButtonPlugins;
    }

    public final void setToolbarButtonPlugins(@NotNull ArrayList<IToolbarButton> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.toolbarButtonPlugins = arrayList;
    }

    public final void setToolbarListener(@NotNull IAztecToolbarClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.aztecToolbarListener = listener;
    }

    public boolean onKeyUp(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (keyCode) {
            case 8: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_1, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_1);
                }
                return true;
            }
            case 9: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_2, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_2);
                }
                return true;
            }
            case 10: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_3, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_3);
                }
                return true;
            }
            case 11: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_4, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_4);
                }
                return true;
            }
            case 12: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_5, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_5);
                }
                return true;
            }
            case 13: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_6, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_6);
                }
                return true;
            }
            case 14: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_PARAGRAPH, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_PARAGRAPH);
                }
                return true;
            }
            case 15: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_PREFORMAT, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_PREFORMAT);
                }
                return true;
            }
            case 30: {
                if (!event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_BOLD, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.BOLD.getButtonId())).performClick();
                return true;
            }
            case 32: {
                if (!event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_STRIKETHROUGH, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.STRIKETHROUGH.getButtonId())).performClick();
                return true;
            }
            case 36: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                this.showDialogShortcuts();
                return true;
            }
            case 37: {
                if (!event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_ITALIC, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.ITALIC.getButtonId())).performClick();
                return true;
            }
            case 39: {
                if (!event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_LINK, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.LINK.getButtonId())).performClick();
                return true;
            }
            case 41: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarMediaButtonClicked();
                }
                ((ToggleButton)this.findViewById(ToolbarAction.ADD_MEDIA.getButtonId())).performClick();
                return true;
            }
            case 43: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_ORDERED_LIST, true);
                }
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.toggleFormatting(AztecTextFormat.FORMAT_ORDERED_LIST);
                }
                return true;
            }
            case 45: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_QUOTE, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.QUOTE.getButtonId())).performClick();
                return true;
            }
            case 49: {
                if (event.isAltPressed() && event.isCtrlPressed()) {
                    IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                    if (iAztecToolbarClickListener != null) {
                        iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_UNORDERED_LIST, true);
                    }
                    AztecText aztecText = this.editor;
                    if (aztecText != null) {
                        aztecText.toggleFormatting(AztecTextFormat.FORMAT_UNORDERED_LIST);
                    }
                    return true;
                }
                if (!event.isCtrlPressed()) break;
                IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                if (iAztecToolbarClickListener != null) {
                    iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_UNDERLINE, true);
                }
                ((ToggleButton)this.findViewById(ToolbarAction.UNDERLINE.getButtonId())).performClick();
                return true;
            }
            case 52: {
                if (!event.isAltPressed() || !event.isCtrlPressed()) break;
                return true;
            }
            case 53: {
                if (!event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.redo();
                }
                return true;
            }
            case 54: {
                if (!event.isCtrlPressed()) break;
                AztecText aztecText = this.editor;
                if (aztecText != null) {
                    aztecText.undo();
                }
                return true;
            }
            default: {
                Iterable $receiver$iv = this.toolbarButtonPlugins;
                for (Object element$iv : $receiver$iv) {
                    IToolbarButton it = (IToolbarButton)element$iv;
                    if (!it.matchesKeyShortcut(keyCode, event)) continue;
                    IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
                    if (iAztecToolbarClickListener != null) {
                        iAztecToolbarClickListener.onToolbarFormatButtonClicked(it.getAction().getTextFormat(), true);
                    }
                    it.toggle();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onMenuItemClick(@Nullable MenuItem item) {
        Integer n;
        MenuItem menuItem = item;
        boolean checked = menuItem != null && !menuItem.isChecked();
        MenuItem menuItem2 = item;
        if (menuItem2 != null) {
            menuItem2.setChecked(checked);
        }
        MenuItem menuItem3 = item;
        Integer n2 = n = menuItem3 != null ? Integer.valueOf(menuItem3.getItemId()) : null;
        int n3 = R.id.paragraph;
        if (n2 != null && n2 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_PARAGRAPH, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_PARAGRAPH);
            }
            this.setHeadingMenuSelector(AztecTextFormat.FORMAT_PARAGRAPH);
            return true;
        }
        Integer n4 = n;
        n3 = R.id.heading_1;
        if (n4 != null && n4 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_1, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_1);
            }
            this.setHeadingMenuSelector(AztecTextFormat.FORMAT_HEADING_1);
            return true;
        }
        Integer n5 = n;
        n3 = R.id.heading_2;
        if (n5 != null && n5 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_2, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_2);
            }
            this.setHeadingMenuSelector(AztecTextFormat.FORMAT_HEADING_2);
            return true;
        }
        Integer n6 = n;
        n3 = R.id.heading_3;
        if (n6 != null && n6 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_3, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_3);
            }
            this.setHeadingMenuSelector(AztecTextFormat.FORMAT_HEADING_3);
            return true;
        }
        Integer n7 = n;
        n3 = R.id.heading_4;
        if (n7 != null && n7 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_4, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_4);
            }
            this.setHeadingMenuSelector(AztecTextFormat.FORMAT_HEADING_4);
            return true;
        }
        Integer n8 = n;
        n3 = R.id.heading_5;
        if (n8 != null && n8 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_5, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_5);
            }
            this.setHeadingMenuSelector(AztecTextFormat.FORMAT_HEADING_5);
            return true;
        }
        Integer n9 = n;
        n3 = R.id.heading_6;
        if (n9 != null && n9 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_HEADING_6, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_HEADING_6);
            }
            this.setHeadingMenuSelector(AztecTextFormat.FORMAT_HEADING_6);
            return true;
        }
        Integer n10 = n;
        n3 = R.id.list_ordered;
        if (n10 != null && n10 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_ORDERED_LIST, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_ORDERED_LIST);
            }
            this.toggleListMenuSelection(item.getItemId(), checked);
            return true;
        }
        Integer n11 = n;
        n3 = R.id.list_unordered;
        if (n11 != null && n11 == n3) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_UNORDERED_LIST, false);
            }
            AztecText aztecText = this.editor;
            if (aztecText != null) {
                aztecText.toggleFormatting(AztecTextFormat.FORMAT_UNORDERED_LIST);
            }
            this.toggleListMenuSelection(item.getItemId(), checked);
            return true;
        }
        return false;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable parcelable = state;
        if (parcelable == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.source.SourceViewEditText.SavedState");
        }
        SourceViewEditText.SavedState savedState = (SourceViewEditText.SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        Bundle restoredState = savedState.getState();
        this.toggleHtmlMode(restoredState.getBoolean("isSourceVisible"));
        this.enableMediaMode(restoredState.getBoolean("isMediaMode"));
        this.isExpanded = restoredState.getBoolean("isExpanded");
        this.setAdvancedState();
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        SourceViewEditText.SavedState savedState = new SourceViewEditText.SavedState(parcelable);
        Bundle bundle = new Bundle();
        SourceViewEditText sourceViewEditText = this.sourceEditor;
        bundle.putBoolean("isSourceVisible", sourceViewEditText != null && sourceViewEditText.getVisibility() == 0);
        bundle.putBoolean("isMediaMode", this.isMediaModeEnabled);
        bundle.putBoolean("isExpanded", this.isExpanded);
        savedState.setState(bundle);
        return (Parcelable)savedState;
    }

    private final boolean isEditorAttached() {
        return this.editor != null && this.editor instanceof AztecText;
    }

    public final void setEditor(@NotNull AztecText editor, @Nullable SourceViewEditText sourceEditor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.sourceEditor = sourceEditor;
        AztecText aztecText = this.editor = editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        aztecText.setOnSelectionChangedListener(new AztecText.OnSelectionChangedListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onSelectionChanged(int selStart, int selEnd) {
                AztecToolbar.access$highlightAppliedStyles(this.this$0, selStart, selEnd);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void initView(AttributeSet attrs) {
        TypedArray styles = this.getContext().obtainStyledAttributes(attrs, R.styleable.AztecToolbar, 0, R.style.AztecToolbarStyle);
        this.isAdvanced = styles.getBoolean(R.styleable.AztecToolbar_advanced, false);
        styles.recycle();
        int layout2 = this.isAdvanced ? R.layout.aztec_format_bar_advanced : R.layout.aztec_format_bar_basic;
        View.inflate((Context)this.getContext(), (int)layout2, (ViewGroup)((ViewGroup)this));
        this.setAdvancedState();
        ToolbarAction[] toolbarActionArray = ToolbarAction.values();
        for (int i = 0; i < toolbarActionArray.length; ++i) {
            ToggleButton button;
            ToolbarAction toolbarAction = toolbarActionArray[i];
            ToggleButton toggleButton = button = (ToggleButton)this.findViewById(toolbarAction.getButtonId());
            if (toggleButton != null) {
                toggleButton.setOnClickListener(new View.OnClickListener(this, toolbarAction){
                    final /* synthetic */ AztecToolbar this$0;
                    final /* synthetic */ ToolbarAction $toolbarAction;

                    public final void onClick(View it) {
                        AztecToolbar.access$onToolbarAction(this.this$0, this.$toolbarAction);
                    }
                    {
                        this.this$0 = aztecToolbar;
                        this.$toolbarAction = toolbarAction;
                    }
                });
            }
            if (Intrinsics.areEqual((Object)toolbarAction, (Object)ToolbarAction.HEADING)) {
                View view = this.findViewById(toolbarAction.getButtonId());
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(toolbarAction.buttonId)");
                this.setHeadingMenu(view);
            }
            if (!Intrinsics.areEqual((Object)toolbarAction, (Object)ToolbarAction.LIST)) continue;
            View view = this.findViewById(toolbarAction.getButtonId());
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(toolbarAction.buttonId)");
            this.setListMenu(view);
        }
    }

    public final void addButton(@NotNull IToolbarButton buttonPlugin) {
        LinearLayout pluginContainer;
        Intrinsics.checkParameterIsNotNull((Object)buttonPlugin, (String)"buttonPlugin");
        LinearLayout linearLayout = pluginContainer = (LinearLayout)this.findViewById(R.id.plugin_buttons);
        Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"pluginContainer");
        buttonPlugin.inflateButton((ViewGroup)linearLayout);
        this.toolbarButtonPlugins.add(buttonPlugin);
        ToggleButton button = (ToggleButton)this.findViewById(buttonPlugin.getAction().getButtonId());
        button.setOnClickListener(new View.OnClickListener(buttonPlugin){
            final /* synthetic */ IToolbarButton $buttonPlugin;

            public final void onClick(@NotNull View $noName_0) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                this.$buttonPlugin.toggle();
            }
            {
                this.$buttonPlugin = iToolbarButton;
            }
        });
    }

    public final void highlightActionButtons(@NotNull ArrayList<IToolbarAction> toolbarActions) {
        Intrinsics.checkParameterIsNotNull(toolbarActions, (String)"toolbarActions");
        Object[] $receiver$iv = ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)element$iv;
            if (toolbarActions.contains(action)) {
                this.toggleButton(this.findViewById(action.getButtonId()), true);
                continue;
            }
            this.toggleButton(this.findViewById(action.getButtonId()), false);
        }
    }

    private final ArrayList<IToolbarAction> getSelectedActions() {
        ArrayList<IToolbarAction> actions = new ArrayList<IToolbarAction>();
        ToolbarAction[] toolbarActionArray = ToolbarAction.values();
        for (int i = 0; i < toolbarActionArray.length; ++i) {
            ToggleButton view;
            ToolbarAction action = toolbarActionArray[i];
            if (!(Intrinsics.areEqual((Object)action, (Object)ToolbarAction.ELLIPSIS_COLLAPSE) ^ true) || !(Intrinsics.areEqual((Object)action, (Object)ToolbarAction.ELLIPSIS_EXPAND) ^ true) || !(view = (ToggleButton)this.findViewById(action.getButtonId())).isChecked()) continue;
            actions.add(action);
        }
        return actions;
    }

    private final void toggleButton(View button, boolean checked) {
        if (button != null && button instanceof ToggleButton) {
            ((ToggleButton)button).setChecked(checked);
        }
    }

    private final void toggleButtonState(View button, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    private final void highlightAppliedStyles(int selStart, int selEnd) {
        if (!this.isEditorAttached()) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<ITextFormat> appliedStyles = aztecText.getAppliedStyles(selStart, selEnd);
        this.highlightActionButtons(ToolbarAction.Companion.getToolbarActionsForStyles(appliedStyles));
        this.selectHeadingMenuItem(appliedStyles);
        this.selectListMenuItem(appliedStyles);
    }

    private final void onToolbarAction(IToolbarAction action) {
        if (!this.isEditorAttached()) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        if (!aztecText.isTextSelected() && Intrinsics.areEqual((Object)((Object)action.getActionType()), (Object)((Object)ToolbarActionType.INLINE_STYLE))) {
            ArrayList<IToolbarAction> actions = this.getSelectedActions();
            ArrayList<ITextFormat> textFormats = new ArrayList<ITextFormat>();
            Iterable $receiver$iv = actions;
            for (Object element$iv : $receiver$iv) {
                IToolbarAction it = (IToolbarAction)element$iv;
                if (!it.isStylingAction()) continue;
                textFormats.add(it.getTextFormat());
            }
            if (this.getSelectedHeadingMenuItem() != null) {
                ITextFormat iTextFormat = this.getSelectedHeadingMenuItem();
                if (iTextFormat == null) {
                    Intrinsics.throwNpe();
                }
                textFormats.add(iTextFormat);
            }
            if (this.getSelectedListMenuItem() != null) {
                ITextFormat iTextFormat = this.getSelectedListMenuItem();
                if (iTextFormat == null) {
                    Intrinsics.throwNpe();
                }
                textFormats.add(iTextFormat);
            }
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(action.getTextFormat(), false);
            }
            AztecText aztecText2 = this.editor;
            if (aztecText2 == null) {
                Intrinsics.throwNpe();
            }
            aztecText2.setSelectedStyles(textFormats);
            return;
        }
        if (action.isStylingAction() && Intrinsics.areEqual((Object)action, (Object)ToolbarAction.HEADING) ^ true && Intrinsics.areEqual((Object)action, (Object)ToolbarAction.LIST) ^ true) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(action.getTextFormat(), false);
            }
            AztecText aztecText3 = this.editor;
            if (aztecText3 == null) {
                Intrinsics.throwNpe();
            }
            aztecText3.toggleFormatting(action.getTextFormat());
            return;
        }
        IToolbarAction iToolbarAction = action;
        if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.ADD_MEDIA)) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarMediaButtonClicked();
            }
        } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.HEADING)) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarHeadingButtonClicked();
            }
            PopupMenu popupMenu = this.headingMenu;
            if (popupMenu != null) {
                popupMenu.show();
            }
        } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.LIST)) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarListButtonClicked();
            }
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null) {
                popupMenu.show();
            }
        } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.LINK)) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarFormatButtonClicked(AztecTextFormat.FORMAT_LINK, false);
            }
            AztecText aztecText4 = this.editor;
            if (aztecText4 == null) {
                Intrinsics.throwNpe();
            }
            AztecText.showLinkDialog$default(aztecText4, null, null, 3, null);
        } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.HTML)) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarHtmlButtonClicked();
            }
        } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.ELLIPSIS_COLLAPSE)) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarCollapseButtonClicked();
            }
            this.animateToolbarCollapse();
        } else if (Intrinsics.areEqual((Object)iToolbarAction, (Object)ToolbarAction.ELLIPSIS_EXPAND)) {
            IAztecToolbarClickListener iAztecToolbarClickListener = this.aztecToolbarListener;
            if (iAztecToolbarClickListener != null) {
                iAztecToolbarClickListener.onToolbarExpandButtonClicked();
            }
            this.animateToolbarExpand();
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Unsupported action", (int)0).show();
        }
    }

    public final void toggleEditorMode() {
        if (this.sourceEditor == null) {
            return;
        }
        AztecText aztecText = this.editor;
        if (aztecText == null) {
            Intrinsics.throwNpe();
        }
        if (aztecText.getVisibility() == 0) {
            SourceViewEditText sourceViewEditText = this.sourceEditor;
            if (sourceViewEditText == null) {
                Intrinsics.throwNpe();
            }
            AztecText aztecText2 = this.editor;
            if (aztecText2 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText.displayStyledAndFormattedHtml(aztecText2.toPlainHtml(true));
            AztecText aztecText3 = this.editor;
            if (aztecText3 == null) {
                Intrinsics.throwNpe();
            }
            aztecText3.setVisibility(8);
            SourceViewEditText sourceViewEditText2 = this.sourceEditor;
            if (sourceViewEditText2 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText2.setVisibility(0);
            this.toggleHtmlMode(true);
        } else {
            AztecText aztecText4 = this.editor;
            if (aztecText4 == null) {
                Intrinsics.throwNpe();
            }
            SourceViewEditText sourceViewEditText = this.sourceEditor;
            if (sourceViewEditText == null) {
                Intrinsics.throwNpe();
            }
            aztecText4.fromHtml(sourceViewEditText.getPureHtml(true));
            AztecText aztecText5 = this.editor;
            if (aztecText5 == null) {
                Intrinsics.throwNpe();
            }
            aztecText5.setVisibility(0);
            SourceViewEditText sourceViewEditText3 = this.sourceEditor;
            if (sourceViewEditText3 == null) {
                Intrinsics.throwNpe();
            }
            sourceViewEditText3.setVisibility(8);
            this.toggleHtmlMode(false);
        }
    }

    @Nullable
    public final PopupMenu getHeadingMenu() {
        return this.headingMenu;
    }

    @Nullable
    public final PopupMenu getListMenu() {
        return this.listMenu;
    }

    @Nullable
    public final ITextFormat getSelectedHeadingMenuItem() {
        PopupMenu popupMenu = this.headingMenu;
        Boolean bl = popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.paragraph)) != null ? Boolean.valueOf(popupMenu.isChecked()) : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            return AztecTextFormat.FORMAT_PARAGRAPH;
        }
        PopupMenu popupMenu2 = this.headingMenu;
        Boolean bl2 = popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.findItem(R.id.heading_1)) != null ? Boolean.valueOf(popupMenu2.isChecked()) : null;
        if (bl2 == null) {
            Intrinsics.throwNpe();
        }
        if (bl2.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_1;
        }
        PopupMenu popupMenu3 = this.headingMenu;
        Boolean bl3 = popupMenu3 != null && (popupMenu3 = popupMenu3.getMenu()) != null && (popupMenu3 = popupMenu3.findItem(R.id.heading_2)) != null ? Boolean.valueOf(popupMenu3.isChecked()) : null;
        if (bl3 == null) {
            Intrinsics.throwNpe();
        }
        if (bl3.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_2;
        }
        PopupMenu popupMenu4 = this.headingMenu;
        Boolean bl4 = popupMenu4 != null && (popupMenu4 = popupMenu4.getMenu()) != null && (popupMenu4 = popupMenu4.findItem(R.id.heading_3)) != null ? Boolean.valueOf(popupMenu4.isChecked()) : null;
        if (bl4 == null) {
            Intrinsics.throwNpe();
        }
        if (bl4.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_3;
        }
        PopupMenu popupMenu5 = this.headingMenu;
        Boolean bl5 = popupMenu5 != null && (popupMenu5 = popupMenu5.getMenu()) != null && (popupMenu5 = popupMenu5.findItem(R.id.heading_4)) != null ? Boolean.valueOf(popupMenu5.isChecked()) : null;
        if (bl5 == null) {
            Intrinsics.throwNpe();
        }
        if (bl5.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_4;
        }
        PopupMenu popupMenu6 = this.headingMenu;
        Boolean bl6 = popupMenu6 != null && (popupMenu6 = popupMenu6.getMenu()) != null && (popupMenu6 = popupMenu6.findItem(R.id.heading_5)) != null ? Boolean.valueOf(popupMenu6.isChecked()) : null;
        if (bl6 == null) {
            Intrinsics.throwNpe();
        }
        if (bl6.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_5;
        }
        PopupMenu popupMenu7 = this.headingMenu;
        Boolean bl7 = popupMenu7 != null && (popupMenu7 = popupMenu7.getMenu()) != null && (popupMenu7 = popupMenu7.findItem(R.id.heading_6)) != null ? Boolean.valueOf(popupMenu7.isChecked()) : null;
        if (bl7 == null) {
            Intrinsics.throwNpe();
        }
        if (bl7.booleanValue()) {
            return AztecTextFormat.FORMAT_HEADING_6;
        }
        return null;
    }

    @Nullable
    public final ITextFormat getSelectedListMenuItem() {
        PopupMenu popupMenu = this.listMenu;
        Boolean bl = popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_unordered)) != null ? Boolean.valueOf(popupMenu.isChecked()) : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            return AztecTextFormat.FORMAT_UNORDERED_LIST;
        }
        PopupMenu popupMenu2 = this.listMenu;
        Boolean bl2 = popupMenu2 != null && (popupMenu2 = popupMenu2.getMenu()) != null && (popupMenu2 = popupMenu2.findItem(R.id.list_ordered)) != null ? Boolean.valueOf(popupMenu2.isChecked()) : null;
        if (bl2 == null) {
            Intrinsics.throwNpe();
        }
        if (bl2.booleanValue()) {
            return AztecTextFormat.FORMAT_ORDERED_LIST;
        }
        return null;
    }

    public final void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        this.setAdvancedState();
    }

    private final void animateToolbarCollapse() {
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapse;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapse");
        }
        Animation animation = this.ellipsisSpinLeft;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinLeft");
        }
        rippleToggleButton.startAnimation(animation);
        this.isExpanded = false;
    }

    private final void animateToolbarExpand() {
        RippleToggleButton rippleToggleButton = this.buttonEllipsisExpand;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpand");
        }
        Animation animation = this.ellipsisSpinRight;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinRight");
        }
        rippleToggleButton.startAnimation(animation);
        this.isExpanded = true;
    }

    private final void setAdvancedState() {
        if (this.isAdvanced) {
            this.setButtonViews();
            this.setAnimations();
            if (this.isExpanded) {
                this.showExpandedToolbar();
            } else {
                this.showCollapsedToolbar();
            }
        }
    }

    private final void selectHeadingMenuItem(ArrayList<ITextFormat> textFormats) {
        if (textFormats.size() == 0) {
            PopupMenu popupMenu = this.headingMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.paragraph)) != null) {
                popupMenu.setChecked(true);
            }
            this.setHeadingMenuSelector(AztecTextFormat.FORMAT_PARAGRAPH);
        } else {
            Iterable $receiver$iv = textFormats;
            Iterator iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                ITextFormat it = (ITextFormat)element$iv;
                ITextFormat iTextFormat = it;
                if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1)) {
                    PopupMenu popupMenu = this.headingMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_1)) != null) {
                        popupMenu.setChecked(true);
                    }
                } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2)) {
                    PopupMenu popupMenu = this.headingMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_2)) != null) {
                        popupMenu.setChecked(true);
                    }
                } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3)) {
                    PopupMenu popupMenu = this.headingMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_3)) != null) {
                        popupMenu.setChecked(true);
                    }
                } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4)) {
                    PopupMenu popupMenu = this.headingMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_4)) != null) {
                        popupMenu.setChecked(true);
                    }
                } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5)) {
                    PopupMenu popupMenu = this.headingMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_5)) != null) {
                        popupMenu.setChecked(true);
                    }
                } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6)) {
                    PopupMenu popupMenu = this.headingMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.heading_6)) != null) {
                        popupMenu.setChecked(true);
                    }
                } else {
                    PopupMenu popupMenu = this.headingMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.paragraph)) != null) {
                        popupMenu.setChecked(true);
                    }
                }
                this.setHeadingMenuSelector(it);
                return;
            }
        }
    }

    private final void selectListMenuItem(ArrayList<ITextFormat> textFormats) {
        if (textFormats.size() == 0) {
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_none)) != null) {
                popupMenu.setChecked(true);
            }
            this.setListMenuSelector(AztecTextFormat.FORMAT_UNORDERED_LIST);
        } else {
            Iterable $receiver$iv = textFormats;
            Iterator iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                ITextFormat it = (ITextFormat)element$iv;
                ITextFormat iTextFormat = it;
                if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNORDERED_LIST)) {
                    PopupMenu popupMenu = this.listMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_unordered)) != null) {
                        popupMenu.setChecked(true);
                    }
                } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ORDERED_LIST)) {
                    PopupMenu popupMenu = this.listMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_ordered)) != null) {
                        popupMenu.setChecked(true);
                    }
                } else {
                    PopupMenu popupMenu = this.listMenu;
                    if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_none)) != null) {
                        popupMenu.setChecked(true);
                    }
                }
                this.setListMenuSelector(it);
                return;
            }
        }
    }

    private final void setAnimations() {
        Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_in_right);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation, (String)"AnimationUtils.loadAnima\u2026.anim.translate_in_right)");
        this.layoutExpandedTranslateInRight = animation;
        Animation animation2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.translate_out_left);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation2, (String)"AnimationUtils.loadAnima\u2026.anim.translate_out_left)");
        Animation animation3 = this.layoutExpandedTranslateOutLeft = animation2;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateOutLeft");
        }
        animation3.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).setVisibility(8);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation4 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.spin_left_90);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation4, (String)"AnimationUtils.loadAnima\u2026ext, R.anim.spin_left_90)");
        Animation animation5 = this.ellipsisSpinLeft = animation4;
        if (animation5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinLeft");
        }
        animation5.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonEllipsisCollapse$p(this.this$0).setVisibility(8);
                AztecToolbar.access$getButtonEllipsisExpand$p(this.this$0).setVisibility(0);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonScroll$p(this.this$0).smoothScrollTo(0, 0);
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).startAnimation(AztecToolbar.access$getLayoutExpandedTranslateOutLeft$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
        Animation animation6 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.spin_right_90);
        Intrinsics.checkExpressionValueIsNotNull((Object)animation6, (String)"AnimationUtils.loadAnima\u2026xt, R.anim.spin_right_90)");
        Animation animation7 = this.ellipsisSpinRight = animation6;
        if (animation7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisSpinRight");
        }
        animation7.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AztecToolbar this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getButtonEllipsisCollapse$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getButtonEllipsisExpand$p(this.this$0).setVisibility(8);
            }

            public void onAnimationRepeat(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationStart(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).setVisibility(0);
                AztecToolbar.access$getLayoutExpanded$p(this.this$0).startAnimation(AztecToolbar.access$getLayoutExpandedTranslateInRight$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void setButtonViews() {
        View view = this.findViewById(R.id.format_bar_button_layout_expanded);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.format\u2026r_button_layout_expanded)");
        this.layoutExpanded = (LinearLayout)view;
        View view2 = this.findViewById(R.id.format_bar_button_scroll);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.format_bar_button_scroll)");
        this.buttonScroll = (HorizontalScrollView)view2;
        View view3 = this.findViewById(R.id.format_bar_button_ellipsis_collapse);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.format\u2026button_ellipsis_collapse)");
        this.buttonEllipsisCollapse = (RippleToggleButton)view3;
        View view4 = this.findViewById(R.id.format_bar_button_ellipsis_expand);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.format\u2026r_button_ellipsis_expand)");
        this.buttonEllipsisExpand = (RippleToggleButton)view4;
    }

    private final void setHeadingMenu(View view) {
        block1: {
            PopupMenu popupMenu = this.headingMenu = new PopupMenu(this.getContext(), view);
            if (popupMenu != null) {
                popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
            }
            PopupMenu popupMenu2 = this.headingMenu;
            if (popupMenu2 == null) break block1;
            popupMenu2.inflate(R.menu.heading);
        }
    }

    private final void setListMenu(View view) {
        block1: {
            PopupMenu popupMenu = this.listMenu = new PopupMenu(this.getContext(), view);
            if (popupMenu != null) {
                popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
            }
            PopupMenu popupMenu2 = this.listMenu;
            if (popupMenu2 == null) break block1;
            popupMenu2.inflate(R.menu.list);
        }
    }

    private final void setListMenuSelector(ITextFormat textFormat) {
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNORDERED_LIST)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_list)).setBackgroundResource(R.drawable.format_bar_button_ul_selector);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ORDERED_LIST)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_list)).setBackgroundResource(R.drawable.format_bar_button_ol_selector);
        } else {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_list)).setBackgroundResource(R.drawable.format_bar_button_ul_selector);
        }
    }

    private final void setHeadingMenuSelector(ITextFormat textFormat) {
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_1)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_heading)).setBackgroundResource(R.drawable.format_bar_button_heading_1_selector);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_2)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_heading)).setBackgroundResource(R.drawable.format_bar_button_heading_2_selector);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_3)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_heading)).setBackgroundResource(R.drawable.format_bar_button_heading_3_selector);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_4)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_heading)).setBackgroundResource(R.drawable.format_bar_button_heading_4_selector);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_5)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_heading)).setBackgroundResource(R.drawable.format_bar_button_heading_5_selector);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_HEADING_6)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_heading)).setBackgroundResource(R.drawable.format_bar_button_heading_6_selector);
        } else if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_PARAGRAPH)) {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_heading)).setBackgroundResource(R.drawable.format_bar_button_heading_selector);
        } else {
            ((ToggleButton)this.findViewById(R.id.format_bar_button_heading)).setBackgroundResource(R.drawable.format_bar_button_heading_selector);
        }
    }

    private final void showCollapsedToolbar() {
        LinearLayout linearLayout = this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        linearLayout.setVisibility(8);
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapse;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapse");
        }
        rippleToggleButton.setVisibility(8);
        RippleToggleButton rippleToggleButton2 = this.buttonEllipsisExpand;
        if (rippleToggleButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpand");
        }
        rippleToggleButton2.setVisibility(0);
    }

    private final void showExpandedToolbar() {
        LinearLayout linearLayout = this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        linearLayout.setVisibility(0);
        RippleToggleButton rippleToggleButton = this.buttonEllipsisCollapse;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapse");
        }
        rippleToggleButton.setVisibility(0);
        RippleToggleButton rippleToggleButton2 = this.buttonEllipsisExpand;
        if (rippleToggleButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpand");
        }
        rippleToggleButton2.setVisibility(8);
    }

    private final void toggleHtmlMode(boolean isHtmlMode) {
        Object element$iv;
        Object $receiver$iv = ToolbarAction.values();
        for (int i = 0; i < ((Object[])$receiver$iv).length; ++i) {
            element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)element$iv;
            if (Intrinsics.areEqual((Object)action, (Object)ToolbarAction.HTML)) {
                this.toggleButton(this.findViewById(action.getButtonId()), isHtmlMode);
                continue;
            }
            this.toggleButtonState(this.findViewById(action.getButtonId()), !isHtmlMode);
        }
        $receiver$iv = this.toolbarButtonPlugins;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            IToolbarButton it = (IToolbarButton)element$iv;
            this.toggleButtonState(this.findViewById(it.getAction().getButtonId()), !isHtmlMode);
        }
    }

    private final void toggleListMenuSelection(int listMenuItemId, boolean isChecked) {
        if (isChecked) {
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(listMenuItemId)) != null) {
                popupMenu.setChecked(true);
            }
            int n = listMenuItemId;
            if (n == R.id.list_ordered) {
                this.setListMenuSelector(AztecTextFormat.FORMAT_ORDERED_LIST);
            } else if (n == R.id.list_unordered) {
                this.setListMenuSelector(AztecTextFormat.FORMAT_UNORDERED_LIST);
            } else {
                this.setListMenuSelector(AztecTextFormat.FORMAT_UNORDERED_LIST);
            }
        } else {
            PopupMenu popupMenu = this.listMenu;
            if (popupMenu != null && (popupMenu = popupMenu.getMenu()) != null && (popupMenu = popupMenu.findItem(R.id.list_none)) != null) {
                popupMenu.setChecked(true);
            }
            this.setListMenuSelector(AztecTextFormat.FORMAT_UNORDERED_LIST);
        }
    }

    public final void enableFormatButtons(boolean isEnabled) {
        Object element$iv;
        Object $receiver$iv = ToolbarAction.values();
        for (int i = 0; i < ((Object[])$receiver$iv).length; ++i) {
            element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)element$iv;
            if (!(Intrinsics.areEqual((Object)action, (Object)ToolbarAction.HTML) ^ true)) continue;
            this.toggleButtonState(this.findViewById(action.getButtonId()), isEnabled);
        }
        $receiver$iv = this.toolbarButtonPlugins;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            IToolbarButton it = (IToolbarButton)element$iv;
            this.toggleButtonState(this.findViewById(it.getAction().getButtonId()), isEnabled);
        }
    }

    public final boolean isMediaModeEnabled() {
        return this.isMediaModeEnabled;
    }

    public final void enableMediaMode(boolean isEnabled) {
        this.isMediaModeEnabled = isEnabled;
        Object[] $receiver$iv = ToolbarAction.values();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            ToolbarAction action = (ToolbarAction)element$iv;
            if (Intrinsics.areEqual((Object)action, (Object)ToolbarAction.ADD_MEDIA)) {
                this.toggleButton(this.findViewById(action.getButtonId()), isEnabled);
                continue;
            }
            this.toggleButtonState(this.findViewById(action.getButtonId()), !isEnabled);
        }
    }

    private final void showDialogShortcuts() {
        View layout2 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dialog_shortcuts, null);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setView(layout2);
        AlertDialog alertDialog = this.dialogShortcuts = builder.create();
        if (alertDialog == null) {
            Intrinsics.throwNpe();
        }
        alertDialog.show();
    }

    public AztecToolbar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.toolbarButtonPlugins = new ArrayList();
        this.initView(null);
    }

    public AztecToolbar(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.toolbarButtonPlugins = new ArrayList();
        this.initView(attrs);
    }

    public AztecToolbar(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.toolbarButtonPlugins = new ArrayList();
        this.initView(attrs);
    }

    public static final /* synthetic */ void access$highlightAppliedStyles(AztecToolbar $this, int selStart, int selEnd) {
        $this.highlightAppliedStyles(selStart, selEnd);
    }

    public static final /* synthetic */ void access$onToolbarAction(AztecToolbar $this, @NotNull IToolbarAction action) {
        $this.onToolbarAction(action);
    }

    @NotNull
    public static final /* synthetic */ LinearLayout access$getLayoutExpanded$p(AztecToolbar $this) {
        LinearLayout linearLayout = $this.layoutExpanded;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpanded");
        }
        return linearLayout;
    }

    public static final /* synthetic */ void access$setLayoutExpanded$p(AztecToolbar $this, @NotNull LinearLayout linearLayout) {
        $this.layoutExpanded = linearLayout;
    }

    @NotNull
    public static final /* synthetic */ RippleToggleButton access$getButtonEllipsisCollapse$p(AztecToolbar $this) {
        RippleToggleButton rippleToggleButton = $this.buttonEllipsisCollapse;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisCollapse");
        }
        return rippleToggleButton;
    }

    public static final /* synthetic */ void access$setButtonEllipsisCollapse$p(AztecToolbar $this, @NotNull RippleToggleButton rippleToggleButton) {
        $this.buttonEllipsisCollapse = rippleToggleButton;
    }

    @NotNull
    public static final /* synthetic */ RippleToggleButton access$getButtonEllipsisExpand$p(AztecToolbar $this) {
        RippleToggleButton rippleToggleButton = $this.buttonEllipsisExpand;
        if (rippleToggleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonEllipsisExpand");
        }
        return rippleToggleButton;
    }

    public static final /* synthetic */ void access$setButtonEllipsisExpand$p(AztecToolbar $this, @NotNull RippleToggleButton rippleToggleButton) {
        $this.buttonEllipsisExpand = rippleToggleButton;
    }

    @NotNull
    public static final /* synthetic */ HorizontalScrollView access$getButtonScroll$p(AztecToolbar $this) {
        HorizontalScrollView horizontalScrollView = $this.buttonScroll;
        if (horizontalScrollView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buttonScroll");
        }
        return horizontalScrollView;
    }

    public static final /* synthetic */ void access$setButtonScroll$p(AztecToolbar $this, @NotNull HorizontalScrollView horizontalScrollView) {
        $this.buttonScroll = horizontalScrollView;
    }

    @NotNull
    public static final /* synthetic */ Animation access$getLayoutExpandedTranslateOutLeft$p(AztecToolbar $this) {
        Animation animation = $this.layoutExpandedTranslateOutLeft;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateOutLeft");
        }
        return animation;
    }

    public static final /* synthetic */ void access$setLayoutExpandedTranslateOutLeft$p(AztecToolbar $this, @NotNull Animation animation) {
        $this.layoutExpandedTranslateOutLeft = animation;
    }

    @NotNull
    public static final /* synthetic */ Animation access$getLayoutExpandedTranslateInRight$p(AztecToolbar $this) {
        Animation animation = $this.layoutExpandedTranslateInRight;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutExpandedTranslateInRight");
        }
        return animation;
    }

    public static final /* synthetic */ void access$setLayoutExpandedTranslateInRight$p(AztecToolbar $this, @NotNull Animation animation) {
        $this.layoutExpandedTranslateInRight = animation;
    }
}

