/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.source;

import android.support.annotation.ColorInt;
import android.text.Editable;
import android.text.Spannable;
import android.text.TextWatcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.source.HtmlStyleUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\"#B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J*\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J*\u0010\u001d\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/wordpress/aztec/source/HtmlStyleTextWatcher;", "Landroid/text/TextWatcher;", "tagColor", "", "attributeColor", "(II)V", "lastOperation", "Lorg/wordpress/aztec/source/HtmlStyleTextWatcher$Operation;", "modifiedText", "", "offset", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "start", "count", "after", "getMatchingSymbol", "", "symbol", "getRespanRangeForChangedClosingSymbol", "Lorg/wordpress/aztec/source/HtmlStyleTextWatcher$SpanRange;", "content", "closingSymbol", "getRespanRangeForChangedOpeningSymbol", "openingSymbol", "getRespanRangeForNormalText", "onTextChanged", "before", "updateSpans", "Landroid/text/Spannable;", "spanRange", "Operation", "SpanRange", "aztec_release"})
public final class HtmlStyleTextWatcher
implements TextWatcher {
    private int offset;
    private CharSequence modifiedText;
    private Operation lastOperation;
    private final int tagColor;
    private final int attributeColor;

    public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
        if (s == null) {
            return;
        }
        int lastCharacterLocation = start + count - 1;
        if (s.length() > lastCharacterLocation && lastCharacterLocation >= 0 && after < count) {
            this.lastOperation = after > 0 ? Operation.REPLACE : Operation.DELETE;
            this.offset = start;
            this.modifiedText = s.subSequence(start + after, start + count);
        }
    }

    public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
        if (s == null) {
            return;
        }
        int lastCharacterLocation = start + count - 1;
        if (s.length() > lastCharacterLocation && count > 0) {
            if (before > 0) {
                this.lastOperation = Operation.REPLACE;
                this.modifiedText = s.subSequence(start, start + count);
            } else {
                this.lastOperation = Operation.INSERT;
                this.offset = start;
                this.modifiedText = s.subSequence(start + before, start + count);
            }
        }
    }

    public void afterTextChanged(@Nullable Editable s) {
        SpanRange spanRange;
        if (this.modifiedText == null || s == null) {
            return;
        }
        CharSequence charSequence = this.modifiedText;
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.contains$default((CharSequence)((Object)charSequence).toString(), (CharSequence)"<", (boolean)false, (int)2, null)) {
            spanRange = this.getRespanRangeForChangedOpeningSymbol(s, "<");
        } else {
            CharSequence charSequence2 = this.modifiedText;
            if (charSequence2 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.contains$default((CharSequence)((Object)charSequence2).toString(), (CharSequence)">", (boolean)false, (int)2, null)) {
                spanRange = this.getRespanRangeForChangedClosingSymbol(s, ">");
            } else {
                CharSequence charSequence3 = this.modifiedText;
                if (charSequence3 == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.contains$default((CharSequence)((Object)charSequence3).toString(), (CharSequence)"&", (boolean)false, (int)2, null)) {
                    spanRange = this.getRespanRangeForChangedOpeningSymbol(s, "&");
                } else {
                    CharSequence charSequence4 = this.modifiedText;
                    if (charSequence4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (StringsKt.contains$default((CharSequence)((Object)charSequence4).toString(), (CharSequence)";", (boolean)false, (int)2, null)) {
                        spanRange = this.getRespanRangeForChangedClosingSymbol(s, ";");
                    } else {
                        spanRange = this.getRespanRangeForNormalText(s, "<");
                        if (spanRange == null) {
                            spanRange = this.getRespanRangeForNormalText(s, "&");
                        }
                    }
                }
            }
        }
        if (spanRange != null) {
            this.updateSpans((Spannable)s, spanRange);
        }
        this.modifiedText = null;
        this.lastOperation = Operation.NONE;
    }

    private final SpanRange getRespanRangeForChangedOpeningSymbol(Editable content, String openingSymbol) {
        int closingTagLoc;
        if (Intrinsics.areEqual((Object)((Object)this.lastOperation), (Object)((Object)Operation.REPLACE))) {
            return new SpanRange(0, content.length());
        }
        String closingSymbol = this.getMatchingSymbol(openingSymbol);
        CharSequence charSequence = this.modifiedText;
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        int firstOpeningTagLoc = this.offset + StringsKt.indexOf$default((CharSequence)((Object)charSequence).toString(), (String)openingSymbol, (int)0, (boolean)false, (int)6, null);
        if (Intrinsics.areEqual((Object)((Object)this.lastOperation), (Object)((Object)Operation.INSERT))) {
            CharSequence charSequence2 = this.modifiedText;
            if (charSequence2 == null) {
                Intrinsics.throwNpe();
            }
            int lastOpeningTagLoc = this.offset + StringsKt.lastIndexOf$default((CharSequence)((Object)charSequence2).toString(), (String)openingSymbol, (int)0, (boolean)false, (int)6, null);
            closingTagLoc = StringsKt.indexOf$default((CharSequence)content.toString(), (String)closingSymbol, (int)lastOpeningTagLoc, (boolean)false, (int)4, null);
        } else {
            closingTagLoc = StringsKt.indexOf$default((CharSequence)content.toString(), (String)closingSymbol, (int)this.offset, (boolean)false, (int)4, null);
        }
        if (closingTagLoc > 0) {
            return new SpanRange(firstOpeningTagLoc, closingTagLoc + 1);
        }
        return null;
    }

    private final SpanRange getRespanRangeForChangedClosingSymbol(Editable content, String closingSymbol) {
        if (Intrinsics.areEqual((Object)((Object)this.lastOperation), (Object)((Object)Operation.REPLACE))) {
            return new SpanRange(0, content.length());
        }
        String openingSymbol = this.getMatchingSymbol(closingSymbol);
        CharSequence charSequence = this.modifiedText;
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        int firstClosingTagInModLoc = this.offset + StringsKt.indexOf$default((CharSequence)((Object)charSequence).toString(), (String)closingSymbol, (int)0, (boolean)false, (int)6, null);
        CharSequence charSequence2 = content.toString();
        CharSequence charSequence3 = this.modifiedText;
        if (charSequence3 == null) {
            Intrinsics.throwNpe();
        }
        int firstClosingTagAfterModLoc = StringsKt.indexOf$default((CharSequence)charSequence2, (String)closingSymbol, (int)(this.offset + charSequence3.length()), (boolean)false, (int)4, null);
        int openingTagLoc = StringsKt.lastIndexOf$default((CharSequence)content.toString(), (String)openingSymbol, (int)(firstClosingTagInModLoc - 1), (boolean)false, (int)4, null);
        if (openingTagLoc >= 0) {
            if (firstClosingTagAfterModLoc >= 0) {
                return new SpanRange(openingTagLoc, firstClosingTagAfterModLoc + 1);
            }
            return new SpanRange(openingTagLoc, content.length());
        }
        return null;
    }

    private final SpanRange getRespanRangeForNormalText(Editable content, String openingSymbol) {
        int closingTagLoc;
        String closingSymbol = this.getMatchingSymbol(openingSymbol);
        int openingTagLoc = StringsKt.lastIndexOf$default((CharSequence)content.toString(), (String)openingSymbol, (int)this.offset, (boolean)false, (int)4, null);
        if (openingTagLoc >= 0 && (closingTagLoc = StringsKt.indexOf$default((CharSequence)content.toString(), (String)closingSymbol, (int)openingTagLoc, (boolean)false, (int)4, null)) >= this.offset) {
            return new SpanRange(openingTagLoc, closingTagLoc + 1);
        }
        return null;
    }

    private final void updateSpans(Spannable content, SpanRange spanRange) {
        int spanStart = spanRange.getOpeningTagLoc();
        int spanEnd = spanRange.getClosingTagLoc();
        if (spanStart > content.length() || spanEnd > content.length()) {
            return;
        }
        if (spanStart >= spanEnd) {
            spanStart = 0;
            spanEnd = content.length();
        }
        HtmlStyleUtils.INSTANCE.clearSpans(content, spanStart, spanEnd);
        HtmlStyleUtils.INSTANCE.styleHtmlForDisplay(content, spanStart, spanEnd, this.tagColor, this.attributeColor);
    }

    private final String getMatchingSymbol(String symbol) {
        switch (symbol) {
            case "<": {
                return ">";
            }
            case ">": {
                return "<";
            }
            case "&": {
                return ";";
            }
            case ";": {
                return "&";
            }
        }
        return "";
    }

    public HtmlStyleTextWatcher(@ColorInt int tagColor, @ColorInt int attributeColor) {
        this.tagColor = tagColor;
        this.attributeColor = attributeColor;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/wordpress/aztec/source/HtmlStyleTextWatcher$Operation;", "", "(Ljava/lang/String;I)V", "INSERT", "DELETE", "REPLACE", "NONE", "aztec_release"})
    private static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation INSERT;
        public static final /* enum */ Operation DELETE;
        public static final /* enum */ Operation REPLACE;
        public static final /* enum */ Operation NONE;
        private static final /* synthetic */ Operation[] $VALUES;

        static {
            Operation[] operationArray = new Operation[4];
            Operation[] operationArray2 = operationArray;
            operationArray[0] = INSERT = new Operation();
            operationArray[1] = DELETE = new Operation();
            operationArray[2] = REPLACE = new Operation();
            operationArray[3] = NONE = new Operation();
            $VALUES = operationArray;
        }

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String string2) {
            return Enum.valueOf(Operation.class, string2);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/source/HtmlStyleTextWatcher$SpanRange;", "", "openingTagLoc", "", "closingTagLoc", "(II)V", "getClosingTagLoc", "()I", "getOpeningTagLoc", "aztec_release"})
    private static final class SpanRange {
        private final int openingTagLoc;
        private final int closingTagLoc;

        public final int getOpeningTagLoc() {
            return this.openingTagLoc;
        }

        public final int getClosingTagLoc() {
            return this.closingTagLoc;
        }

        public SpanRange(int openingTagLoc, int closingTagLoc) {
            this.openingTagLoc = openingTagLoc;
            this.closingTagLoc = closingTagLoc;
        }
    }
}

