/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.DynamicDrawableSpan;
import android.view.Gravity;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.android.util.DisplayUtils;
import org.wordpress.aztec.AztecText;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 <2\u00020\u0001:\u0001<B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0006\u0010\u001d\u001a\u00020\u001aJP\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010\u0005H\u0016J\u0006\u0010-\u001a\u00020\fJ6\u0010.\u001a\u00020\u00182\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0006\u00101\u001a\u00020\fJ\u000e\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u00020\u001a2\b\u00106\u001a\u0004\u0018\u00010\u0005J\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\u0018J \u0010;\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00180\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/wordpress/aztec/spans/AztecMediaSpan;", "Landroid/text/style/DynamicDrawableSpan;", "context", "Landroid/content/Context;", "drawable", "Landroid/graphics/drawable/Drawable;", "attributes", "Lorg/xml/sax/Attributes;", "onMediaTappedListener", "Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;Lorg/xml/sax/Attributes;Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;)V", "TAG", "", "getAttributes", "()Lorg/xml/sax/Attributes;", "setAttributes", "(Lorg/xml/sax/Attributes;)V", "getContext", "()Landroid/content/Context;", "getOnMediaTappedListener", "()Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "overlays", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "applyOverlayGravity", "", "overlay", "gravity", "clearOverlays", "draw", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getDrawable", "getHtml", "getSize", "metrics", "Landroid/graphics/Paint$FontMetricsInt;", "getSource", "onClick", "view", "Landroid/view/View;", "setDrawable", "newDrawable", "setOverayLevel", "", "index", "level", "setOverlay", "Companion", "aztec_release"})
public final class AztecMediaSpan
extends DynamicDrawableSpan {
    private final String TAG = "img";
    private final ArrayList<Pair<Drawable, Integer>> overlays;
    @NotNull
    private final Context context;
    private Drawable drawable;
    @Nullable
    private Attributes attributes;
    @Nullable
    private final AztecText.OnMediaTappedListener onMediaTappedListener;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public int getSize(@Nullable Paint paint, @Nullable CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt metrics) {
        void width;
        block4: {
            void $receiver$iv;
            Drawable drawable2 = this.drawable;
            int width1 = drawable2 != null && (drawable2 = drawable2.getBounds()) != null ? drawable2.width() : 0;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = width1;
            Iterable iterable = this.overlays;
            for (Object element$iv : $receiver$iv) {
                Pair it = (Pair)element$iv;
                Drawable drawable3 = (Drawable)it.getFirst();
                int width2 = drawable3 != null && (drawable3 = drawable3.getBounds()) != null ? drawable3.width() : 0;
                width.element = width1 > width2 ? width1 : width2;
            }
            Drawable drawable4 = this.drawable;
            if (drawable4 == null) break block4;
            iterable = drawable4;
            Drawable it = (Drawable)iterable;
            if (metrics != null) {
                Drawable drawable5 = this.drawable;
                if (drawable5 == null) {
                    Intrinsics.throwNpe();
                }
                Rect rect = drawable5.getBounds();
                if (rect == null) {
                    Intrinsics.throwNpe();
                }
                metrics.ascent = -rect.height();
                metrics.descent = 0;
                metrics.top = metrics.ascent;
                metrics.bottom = 0;
            }
        }
        return width.element;
    }

    @Nullable
    public Drawable getDrawable() {
        return this.drawable;
    }

    public final void setDrawable(@Nullable Drawable newDrawable) {
        AztecMediaSpan.Companion.setBoundsToPx(this.context, newDrawable);
        this.drawable = newDrawable;
    }

    public final void setOverlay(int index, @Nullable Drawable newDrawable, int gravity) {
        if (CollectionsKt.getLastIndex((List)this.overlays) >= index) {
            this.overlays.remove(index);
        }
        if (newDrawable != null) {
            AztecMediaSpan.Companion.setBoundsToPx(this.context, newDrawable);
            this.applyOverlayGravity(newDrawable, gravity);
            this.overlays.ensureCapacity(index + 1);
            this.overlays.add(index, (Pair<Drawable, Integer>)new Pair((Object)newDrawable, (Object)gravity));
        }
    }

    public final void clearOverlays() {
        this.overlays.clear();
    }

    public final boolean setOverayLevel(int index, int level) {
        Drawable drawable2 = (Drawable)this.overlays.get(index).getFirst();
        return drawable2 != null ? drawable2.setLevel(level) : false;
    }

    private final void applyOverlayGravity(Drawable overlay, int gravity) {
        if (this.drawable != null && overlay != null) {
            Drawable drawable2 = this.drawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            int n = drawable2.getBounds().width();
            Drawable drawable3 = this.drawable;
            if (drawable3 == null) {
                Intrinsics.throwNpe();
            }
            Rect rect = new Rect(0, 0, n, drawable3.getBounds().height());
            Rect outRect = new Rect();
            Gravity.apply((int)gravity, (int)overlay.getBounds().width(), (int)overlay.getBounds().height(), (Rect)rect, (Rect)outRect);
            overlay.setBounds(outRect.left, outRect.top, outRect.right, outRect.bottom);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.save();
        if (this.drawable != null) {
            Drawable drawable2 = this.drawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            int transY = bottom - drawable2.getBounds().bottom;
            if (this.mVerticalAlignment == 1) {
                transY -= paint.getFontMetricsInt().descent;
            }
            canvas.translate(x, (float)transY);
            Drawable drawable3 = this.drawable;
            if (drawable3 == null) {
                Intrinsics.throwNpe();
            }
            drawable3.draw(canvas);
        }
        Iterable transY = this.overlays;
        for (Object element$iv : $receiver$iv) {
            Pair it = (Pair)element$iv;
            Drawable drawable4 = (Drawable)it.getFirst();
            if (drawable4 == null) continue;
            drawable4.draw(canvas);
        }
        canvas.restore();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.TAG);
        Attributes attributes = this.attributes;
        if (attributes != null) {
            int n;
            Attributes attributes2 = attributes;
            Attributes it = attributes2;
            int n2 = 0;
            Attributes attributes3 = this.attributes;
            if (attributes3 == null) {
                Intrinsics.throwNpe();
            }
            if (n2 <= (n = attributes3.getLength() - 1)) {
                while (true) {
                    void i;
                    sb.append(' ');
                    Attributes attributes4 = this.attributes;
                    if (attributes4 == null) {
                        Intrinsics.throwNpe();
                    }
                    sb.append(attributes4.getLocalName((int)i));
                    sb.append("=\"");
                    Attributes attributes5 = this.attributes;
                    if (attributes5 == null) {
                        Intrinsics.throwNpe();
                    }
                    sb.append(attributes5.getValue((int)i));
                    sb.append("\"");
                    if (i == n) break;
                    ++i;
                }
            }
        }
        sb.append("/>");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public final void onClick(@NotNull View view) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            AztecText.OnMediaTappedListener onMediaTappedListener = this.onMediaTappedListener;
            if (onMediaTappedListener == null) break block0;
            onMediaTappedListener.mediaTapped(this.attributes, AztecMediaSpan.Companion.getWidth(this.drawable), AztecMediaSpan.Companion.getHeight(this.drawable));
        }
    }

    @NotNull
    public final String getSource() {
        Object object = this.attributes;
        if (object == null || (object = object.getValue("src")) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@Nullable Attributes attributes) {
        this.attributes = attributes;
    }

    @Nullable
    public final AztecText.OnMediaTappedListener getOnMediaTappedListener() {
        return this.onMediaTappedListener;
    }

    public AztecMediaSpan(@NotNull Context context, @Nullable Drawable drawable2, @Nullable Attributes attributes, @Nullable AztecText.OnMediaTappedListener onMediaTappedListener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.drawable = drawable2;
        this.attributes = attributes;
        this.onMediaTappedListener = onMediaTappedListener;
        this.TAG = "img";
        this.overlays = new ArrayList();
        AztecMediaSpan.Companion.setBoundsToPx(this.context, this.drawable);
    }

    @JvmStatic
    private static final void setBoundsToPx(Context context, Drawable drawable2) {
        AztecMediaSpan.Companion.setBoundsToPx(context, drawable2);
    }

    @JvmStatic
    private static final int getWidth(Drawable drawable2) {
        return AztecMediaSpan.Companion.getWidth(drawable2);
    }

    @JvmStatic
    private static final int getHeight(Drawable drawable2) {
        return AztecMediaSpan.Companion.getHeight(drawable2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003\u00a8\u0006\f"}, d2={"Lorg/wordpress/aztec/spans/AztecMediaSpan$Companion;", "", "()V", "getHeight", "", "drawable", "Landroid/graphics/drawable/Drawable;", "getWidth", "setBoundsToPx", "", "context", "Landroid/content/Context;", "aztec_release"})
    public static final class Companion {
        @JvmStatic
        private final void setBoundsToPx(Context context, Drawable drawable2) {
            block3: {
                Drawable drawable3 = drawable2;
                if (drawable3 == null) break block3;
                Drawable drawable4 = drawable3;
                Drawable it = drawable4;
                if (it.getIntrinsicWidth() < 0 && it.getIntrinsicHeight() < 0) {
                    it.setBounds(0, 0, DisplayUtils.dpToPx((Context)context, (int)it.getBounds().width()), DisplayUtils.dpToPx((Context)context, (int)it.getBounds().height()));
                } else {
                    it.setBounds(0, 0, DisplayUtils.dpToPx((Context)context, (int)it.getIntrinsicWidth()), DisplayUtils.dpToPx((Context)context, (int)it.getIntrinsicHeight()));
                }
                int maxWidth = DisplayUtils.getDisplayPixelWidth((Context)context) - DisplayUtils.dpToPx((Context)context, (int)32);
                if (drawable2.getBounds().width() > maxWidth) {
                    drawable2.setBounds(0, 0, maxWidth, maxWidth * drawable2.getBounds().height() / drawable2.getBounds().width());
                }
            }
        }

        @JvmStatic
        private final int getWidth(Drawable drawable2) {
            Drawable drawable3 = drawable2;
            if (drawable3 != null) {
                Drawable drawable4 = drawable3;
                Drawable it = drawable4;
                if (it.getIntrinsicWidth() < 0) {
                    return it.getBounds().width();
                }
                return it.getIntrinsicWidth();
            }
            return 0;
        }

        @JvmStatic
        private final int getHeight(Drawable drawable2) {
            Drawable drawable3 = drawable2;
            if (drawable3 != null) {
                Drawable drawable4 = drawable3;
                Drawable it = drawable4;
                if (it.getIntrinsicHeight() < 0) {
                    return it.getBounds().height();
                }
                return it.getIntrinsicHeight();
            }
            return 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

