/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.AztecListSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJh\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0005H\u0016J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020\u0005H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/wordpress/aztec/spans/AztecOrderedListSpan;", "Lorg/wordpress/aztec/spans/AztecListSpan;", "nestingLevel", "", "attributes", "", "listStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "(ILjava/lang/String;Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;)V", "TAG", "getAttributes", "()Ljava/lang/String;", "setAttributes", "(Ljava/lang/String;)V", "getListStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "setListStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;)V", "getNestingLevel", "()I", "setNestingLevel", "(I)V", "drawLeadingMargin", "", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "x", "dir", "top", "baseline", "bottom", "text", "", "start", "end", "first", "", "l", "Landroid/text/Layout;", "getEndTag", "getLeadingMargin", "getStartTag", "aztec_release"})
public final class AztecOrderedListSpan
extends AztecListSpan {
    private final String TAG = "ol";
    private int nestingLevel;
    @NotNull
    private String attributes;
    @NotNull
    private BlockFormatter.ListStyle listStyle;

    @Override
    @NotNull
    public String getStartTag() {
        if (TextUtils.isEmpty((CharSequence)this.getAttributes())) {
            return this.TAG;
        }
        return this.TAG + this.getAttributes();
    }

    @Override
    @NotNull
    public String getEndTag() {
        return this.TAG;
    }

    public int getLeadingMargin(boolean first) {
        return this.listStyle.getIndicatorMargin() + 2 * this.listStyle.getIndicatorWidth() + this.listStyle.getIndicatorPadding();
    }

    public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout l) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        if (!first) {
            return;
        }
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        int spanStart = ((Spanned)charSequence).getSpanStart((Object)this);
        int spanEnd = ((Spanned)text).getSpanEnd((Object)this);
        int n = start;
        if (spanStart > n || n > spanEnd || spanStart > (n = end) || n > spanEnd) {
            return;
        }
        Paint.Style style = p.getStyle();
        int oldColor = p.getColor();
        p.setColor(this.listStyle.getIndicatorColor());
        p.setStyle(Paint.Style.FILL);
        int lineIndex = this.getIndexOfProcessedLine(text, end);
        String textToDraw = lineIndex > -1 ? String.valueOf(this.getIndexOfProcessedLine(text, end)) + "." : "";
        float width = p.measureText(textToDraw);
        c.drawText(textToDraw, ((float)(this.listStyle.getIndicatorMargin() + x + dir) - width) * (float)dir, (float)baseline, p);
        p.setColor(oldColor);
        p.setStyle(style);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.attributes = string;
    }

    @NotNull
    public final BlockFormatter.ListStyle getListStyle() {
        return this.listStyle;
    }

    public final void setListStyle(@NotNull BlockFormatter.ListStyle listStyle) {
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"<set-?>");
        this.listStyle = listStyle;
    }

    public AztecOrderedListSpan(int nestingLevel, @NotNull String attributes, @NotNull BlockFormatter.ListStyle listStyle) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"listStyle");
        super(nestingLevel, listStyle.getVerticalPadding());
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.listStyle = listStyle;
        this.TAG = "ol";
    }

    public /* synthetic */ AztecOrderedListSpan(int n, String string, BlockFormatter.ListStyle listStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            listStyle = new BlockFormatter.ListStyle(0, 0, 0, 0, 0);
        }
        this(n, string, listStyle);
    }
}

