/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.R;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.formatting.LineBlockFormatter$WhenMappings;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecCommentSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecMediaClickableSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.watchers.EndOfBufferMarkerAdder;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010J\"\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/wordpress/aztec/formatting/LineBlockFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "(Lorg/wordpress/aztec/AztecText;)V", "applyComment", "", "comment", "Lorg/wordpress/aztec/spans/AztecCommentSpan$Comment;", "applyMoreComment", "applyPageComment", "containHeadingType", "", "textFormat", "Lorg/wordpress/aztec/TextFormat;", "index", "", "containsHeading", "selStart", "selEnd", "insertMedia", "drawable", "Landroid/graphics/drawable/Drawable;", "attributes", "Lorg/xml/sax/Attributes;", "onMediaTappedListener", "Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "aztec_release"})
public final class LineBlockFormatter
extends AztecFormatter {
    public final void applyMoreComment() {
        this.applyComment(AztecCommentSpan.Comment.MORE);
    }

    public final void applyPageComment() {
        this.applyComment(AztecCommentSpan.Comment.PAGE);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsHeading(@NotNull TextFormat textFormat, int selStart, int selEnd) {
        boolean bl;
        block6: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            int n2 = lines.length - 1;
            if (n <= n2) {
                while (true) {
                    void $receiver$iv2;
                    void i;
                    Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                    int sum$iv = 0;
                    Iterator iterator = $receiver$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int element$iv;
                        int n3 = element$iv = ((IntIterator)iterator).nextInt();
                        int n4 = sum$iv;
                        int n5 = lines[it].length() + 1;
                        sum$iv = n4 + n5;
                    }
                    int lineStart = sum$iv;
                    int lineEnd = lineStart + lines[i].length();
                    if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                        list.add((int)i);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable i = list;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                if (!this.containHeadingType(textFormat, it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containHeadingType(TextFormat textFormat, int index) {
        void $receiver$iv;
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        Iterable iterable = (Iterable)new IntRange(0, index - 1);
        int sum$iv = 0;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator).nextInt();
            int n2 = sum$iv;
            int n3 = lines[it].length() + 1;
            sum$iv = n2 + n3;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        int n = 0;
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        if (n < spans.length) {
            AztecHeadingSpan span = spans[n];
            switch (LineBlockFormatter$WhenMappings.$EnumSwitchMapping$0[textFormat.ordinal()]) {
                case 1: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H1));
                }
                case 2: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H2));
                }
                case 3: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H3));
                }
                case 4: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H4));
                }
                case 5: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H5));
                }
                case 6: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H6));
                }
            }
            return false;
        }
        return false;
    }

    private final void applyComment(AztecCommentSpan.Comment comment) {
        Drawable drawable2;
        this.getEditor().removeInlineStylesFromRange(this.getSelectionStart(), this.getSelectionEnd());
        this.getEditor().removeBlockStylesFromRange(this.getSelectionStart(), this.getSelectionEnd(), true);
        Context context = this.getEditor().getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"editor.context");
        switch (LineBlockFormatter$WhenMappings.$EnumSwitchMapping$1[comment.ordinal()]) {
            case 1: {
                drawable2 = ContextCompat.getDrawable((Context)this.getEditor().getContext(), (int)R.drawable.img_more);
                break;
            }
            case 2: {
                drawable2 = ContextCompat.getDrawable((Context)this.getEditor().getContext(), (int)R.drawable.img_page);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"when (comment) {\n       \u2026g_page)\n                }");
        AztecCommentSpan span = new AztecCommentSpan(context, drawable2);
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)comment.getHtml());
        ssb.setSpan((Object)span, 0, comment.getHtml().length(), 33);
        this.getEditableText().replace(this.getSelectionStart(), this.getSelectionEnd(), (CharSequence)ssb);
        this.getEditor().setSelection(this.getSelectionEnd() < EndOfBufferMarkerAdder.Companion.safeLength((TextView)this.getEditor()) ? this.getSelectionEnd() + 1 : this.getSelectionEnd());
    }

    /*
     * WARNING - void declaration
     */
    public final void insertMedia(@Nullable Drawable drawable2, @NotNull Attributes attributes, @Nullable AztecText.OnMediaTappedListener onMediaTappedListener) {
        Object v2;
        AztecBlockSpan spanBeforeMedia;
        AztecMediaSpan span;
        block5: {
            void $receiver$iv;
            Object v1;
            block4: {
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
                Context context = this.getEditor().getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"editor.context");
                span = new AztecMediaSpan(context, drawable2, attributes, onMediaTappedListener);
                span.setTextView(this.getEditor());
                Object[] objectArray = this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecBlockSpan.class);
                for (int i = 0; i < ((void)$receiver$iv2).length; ++i) {
                    void element$iv = $receiver$iv2[i];
                    AztecBlockSpan it = (AztecBlockSpan)element$iv;
                    if (!(this.getSelectionStart() == this.getEditableText().getSpanEnd((Object)it))) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            spanBeforeMedia = v1;
            Object[] objectArray = this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecBlockSpan.class);
            for (int element$iv = 0; element$iv < ((void)$receiver$iv).length; ++element$iv) {
                void element$iv2 = $receiver$iv[element$iv];
                AztecBlockSpan it = (AztecBlockSpan)element$iv2;
                if (!(this.getSelectionStart() == this.getEditableText().getSpanStart((Object)it))) continue;
                v2 = element$iv2;
                break block5;
            }
            v2 = null;
        }
        AztecBlockSpan spanAfterMedia = v2;
        int mediaStartIndex = this.getSelectionStart();
        int mediaEndIndex = this.getSelectionStart() + 1;
        this.getEditor().disableTextChangedListener();
        this.getEditableText().replace(this.getSelectionStart(), this.getSelectionEnd(), (CharSequence)Constants.INSTANCE.getIMG_STRING());
        this.getEditor().enableTextChangedListener();
        if (spanAfterMedia != null) {
            this.getEditableText().setSpan((Object)spanAfterMedia, mediaStartIndex, this.getEditableText().getSpanEnd((Object)spanAfterMedia), 33);
        }
        if (spanBeforeMedia != null) {
            this.getEditableText().setSpan((Object)spanBeforeMedia, this.getEditableText().getSpanStart((Object)spanBeforeMedia), mediaEndIndex, 33);
        }
        this.getEditor().removeInlineStylesFromRange(mediaStartIndex, mediaEndIndex);
        this.getEditableText().setSpan((Object)span, mediaStartIndex, mediaEndIndex, 33);
        this.getEditableText().setSpan((Object)new AztecMediaClickableSpan(span), mediaStartIndex, mediaEndIndex, 33);
        this.getEditor().setSelection(mediaEndIndex);
        this.getEditor().setMediaAdded(true);
    }

    public LineBlockFormatter(@NotNull AztecText editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        super(editor);
    }
}

