/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.LineBackgroundSpan;
import android.text.style.LineHeightSpan;
import android.text.style.QuoteSpan;
import android.text.style.UpdateLayout;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.AztecBlockSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0016Jb\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0011H\u0016Jh\u00102\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u0007H\u0016J\u0010\u0010:\u001a\u00020\u00112\u0006\u00105\u001a\u000206H\u0016J\b\u0010;\u001a\u00020\u0007H\u0016R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/wordpress/aztec/spans/AztecQuoteSpan;", "Landroid/text/style/QuoteSpan;", "Landroid/text/style/LineBackgroundSpan;", "Lorg/wordpress/aztec/spans/AztecBlockSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "attributes", "", "(Ljava/lang/String;)V", "quoteStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "(Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;Ljava/lang/String;)V", "TAG", "getAttributes", "()Ljava/lang/String;", "setAttributes", "quoteBackground", "", "quoteBackgroundAlpha", "", "quoteColor", "quoteMargin", "quotePadding", "quoteWidth", "rect", "Landroid/graphics/Rect;", "getRect", "()Landroid/graphics/Rect;", "verticalPadding", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "drawBackground", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "left", "right", "top", "baseline", "bottom", "lnum", "drawLeadingMargin", "x", "dir", "first", "", "layout", "Landroid/text/Layout;", "getEndTag", "getLeadingMargin", "getStartTag", "aztec_release"})
public final class AztecQuoteSpan
extends QuoteSpan
implements LineBackgroundSpan,
AztecBlockSpan,
LineHeightSpan,
UpdateLayout {
    @NotNull
    private final Rect rect;
    private final String TAG = "blockquote";
    private int verticalPadding;
    private int quoteBackground;
    private int quoteColor;
    private int quoteMargin;
    private int quotePadding;
    private int quoteWidth;
    private float quoteBackgroundAlpha;
    @NotNull
    private String attributes;

    @NotNull
    public final Rect getRect() {
        return this.rect;
    }

    @Override
    @NotNull
    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.attributes = string;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        Spanned spanned = (Spanned)charSequence;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.verticalPadding;
            fm.top -= this.verticalPadding;
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.verticalPadding;
            fm.bottom += this.verticalPadding;
        }
    }

    @Override
    @NotNull
    public String getStartTag() {
        if (TextUtils.isEmpty((CharSequence)this.getAttributes())) {
            return this.TAG;
        }
        return this.TAG + this.getAttributes();
    }

    @Override
    @NotNull
    public String getEndTag() {
        return this.TAG;
    }

    public int getLeadingMargin(boolean first) {
        return this.quoteMargin + this.quoteWidth + this.quotePadding;
    }

    public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout layout) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        Paint.Style style = p.getStyle();
        int color2 = p.getColor();
        p.setStyle(Paint.Style.FILL);
        p.setColor(this.quoteColor);
        c.drawRect((float)x + (float)this.quoteMargin, (float)top, (float)(x + this.quoteMargin + dir * this.quoteWidth), (float)bottom, p);
        p.setStyle(style);
        p.setColor(color2);
    }

    public void drawBackground(@NotNull Canvas c, @NotNull Paint p, int left, int right, int top, int baseline, int bottom, @Nullable CharSequence text, int start, int end, int lnum) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        int alpha = (int)(this.quoteBackgroundAlpha * (float)255);
        int paintColor = p.getColor();
        p.setColor(Color.argb((int)alpha, (int)Color.red((int)this.quoteBackground), (int)Color.green((int)this.quoteBackground), (int)Color.blue((int)this.quoteBackground)));
        this.rect.set(left + this.quoteMargin, top, right, bottom);
        c.drawRect(this.rect, p);
        p.setColor(paintColor);
    }

    public AztecQuoteSpan(@NotNull String attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        this.rect = new Rect();
        this.TAG = "blockquote";
        this.attributes = "";
        this.setAttributes(attributes);
    }

    public /* synthetic */ AztecQuoteSpan(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    public AztecQuoteSpan(@NotNull BlockFormatter.QuoteStyle quoteStyle, @NotNull String attributes) {
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"quoteStyle");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        this(attributes);
        this.verticalPadding = quoteStyle.getVerticalPadding();
        this.quoteBackground = quoteStyle.getQuoteBackground();
        this.quoteColor = quoteStyle.getQuoteColor();
        this.quoteMargin = quoteStyle.getQuoteMargin();
        this.quoteWidth = quoteStyle.getQuoteWidth();
        this.quotePadding = quoteStyle.getQuotePadding();
        this.quoteBackgroundAlpha = quoteStyle.getQuoteBackgroundAlpha();
    }

    public /* synthetic */ AztecQuoteSpan(BlockFormatter.QuoteStyle quoteStyle, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(quoteStyle, string);
    }

    @Override
    @NotNull
    public Object clone() {
        return AztecBlockSpan.DefaultImpls.clone(this);
    }
}

