/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Paint;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.UpdateLayout;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0006R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/wordpress/aztec/spans/AztecListSpan;", "Landroid/text/style/LeadingMarginSpan$Standard;", "Lorg/wordpress/aztec/spans/AztecBlockSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "verticalPadding", "", "(I)V", "lastItem", "Lorg/wordpress/aztec/spans/AztecListItemSpan;", "getLastItem", "()Lorg/wordpress/aztec/spans/AztecListItemSpan;", "setLastItem", "(Lorg/wordpress/aztec/spans/AztecListItemSpan;)V", "getVerticalPadding", "()I", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "getIndexOfProcessedLine", "aztec_release"})
public abstract class AztecListSpan
extends LeadingMarginSpan.Standard
implements AztecBlockSpan,
LineHeightSpan,
UpdateLayout {
    private final int verticalPadding;

    @NotNull
    public abstract AztecListItemSpan getLastItem();

    public abstract void setLastItem(@NotNull AztecListItemSpan var1);

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        Spanned spanned = (Spanned)charSequence;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.verticalPadding;
            fm.top -= this.verticalPadding;
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.verticalPadding;
            fm.bottom += this.verticalPadding;
        }
    }

    public final int getIndexOfProcessedLine(@NotNull CharSequence text, int end) {
        CharSequence listText;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        int spanStart = ((Spanned)charSequence).getSpanStart((Object)this);
        int spanEnd = ((Spanned)text).getSpanEnd((Object)this);
        CharSequence charSequence2 = listText = text.subSequence(spanStart, spanEnd);
        int n = 0;
        int n2 = end - spanStart;
        String textBeforeBeforeEnd = ((Object)charSequence2.subSequence(n, n2)).toString();
        int lineIndex = textBeforeBeforeEnd.length() - StringsKt.replace$default((String)textBeforeBeforeEnd, (String)"\n", (String)"", (boolean)false, (int)4, null).length();
        return lineIndex + 1;
    }

    public final int getVerticalPadding() {
        return this.verticalPadding;
    }

    public AztecListSpan(int verticalPadding) {
        super(0);
        this.verticalPadding = verticalPadding;
    }

    @Override
    @NotNull
    public Object clone() {
        return AztecBlockSpan.DefaultImpls.clone(this);
    }
}

