/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.source;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/wordpress/aztec/source/Format;", "", "()V", "block", "", "iframePlaceholder", "addFormatting", "content", "clearFormatting", "html", "replaceAll", "pattern", "replacement", "aztec_release"})
public final class Format {
    private static final String block = "div|br|blockquote|ul|ol|li|p|h1|h2|h3|h4|h5|h6|iframe";
    private static final String iframePlaceholder = "iframe-replacement-0x0";
    public static final Format INSTANCE;

    @NotNull
    public final String addFormatting(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        String html = this.replaceAll(content, "iframe", iframePlaceholder);
        String string = Jsoup.parseBodyFragment((String)html).body().html();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Jsoup.parseBodyFragment(html).body().html()");
        html = string;
        html = this.replaceAll(html, iframePlaceholder, "iframe");
        String newlineToTheLeft = this.replaceAll(html, "(?<!</?(" + block + ")>)" + "\n" + "<((?!/?(" + block + ")).*?)>", "<$2>");
        String newlineToTheRight = this.replaceAll(newlineToTheLeft, "<(/?(?!" + block + ").)>" + "\n" + "(?!</?(" + block + ")>)", "<$1>");
        String fixBrNewlines = this.replaceAll(newlineToTheRight, "([\t ]*)(<br>)(?!\n)", "$1$2\n$1");
        String string2 = fixBrNewlines = this.replaceAll(fixBrNewlines, ">([\t ]*)(<br>)", ">\n$1$2");
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @NotNull
    public final String clearFormatting(@NotNull String html) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        return this.replaceAll(html, "\\" + "s*<(/?(" + block + ")(.*?))>" + "\\" + "s*", "<$1>");
    }

    private final String replaceAll(String content, String pattern, String replacement) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        String string = m.replaceAll(replacement);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.replaceAll(replacement)");
        return string;
    }

    private Format() {
        INSTANCE = this;
        block = block;
        iframePlaceholder = iframePlaceholder;
    }

    static {
        new Format();
    }
}

