/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.ParagraphStyle;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import java.io.IOException;
import java.io.StringReader;
import org.ccil.cowan.tagsoup.Parser;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.R;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecCodeSpan;
import org.wordpress.aztec.spans.AztecCommentSpan;
import org.wordpress.aztec.spans.AztecContentSpan;
import org.wordpress.aztec.spans.AztecCursorSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecRelativeSizeSpan;
import org.wordpress.aztec.spans.AztecStyleSpan;
import org.wordpress.aztec.spans.AztecSubscriptSpan;
import org.wordpress.aztec.spans.AztecSuperscriptSpan;
import org.wordpress.aztec.spans.AztecTypefaceSpan;
import org.wordpress.aztec.spans.AztecURLSpan;
import org.wordpress.aztec.spans.AztecUnderlineSpan;
import org.wordpress.aztec.spans.CommentSpan;
import org.wordpress.aztec.spans.FontSpan;
import org.wordpress.aztec.spans.ParagraphSpan;
import org.wordpress.aztec.spans.UnknownClickableSpan;
import org.wordpress.aztec.spans.UnknownHtmlSpan;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class HtmlToSpannedConverter
implements ContentHandler,
LexicalHandler {
    public int unknownTagLevel = 0;
    public Unknown unknown;
    private String mSource;
    private UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener;
    private XMLReader mReader;
    private SpannableStringBuilder spannableStringBuilder;
    private Html.TagHandler tagHandler;
    private Context context;
    private AztecText.OnMediaTappedListener onMediaTappedListener;

    public HtmlToSpannedConverter(String source, Html.TagHandler tagHandler, Parser parser, AztecText.OnMediaTappedListener onMediaTappedListener, UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener, Context context) {
        this.mSource = source;
        this.spannableStringBuilder = new SpannableStringBuilder();
        this.tagHandler = tagHandler;
        this.mReader = parser;
        this.context = context;
        this.onMediaTappedListener = onMediaTappedListener;
        this.onUnknownHtmlClickListener = onUnknownHtmlClickListener;
    }

    public Spanned convert() {
        Object[] paragraphs;
        this.mReader.setContentHandler(this);
        try {
            this.mReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.mReader.parse(new InputSource(new StringReader(this.mSource)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        for (Object paragraph : paragraphs = this.spannableStringBuilder.getSpans(0, this.spannableStringBuilder.length(), ParagraphStyle.class)) {
            if (paragraph instanceof UnknownHtmlSpan || paragraph instanceof AztecBlockSpan || paragraph instanceof AztecMediaSpan || paragraph instanceof AztecHeadingSpan) continue;
            int start = this.spannableStringBuilder.getSpanStart(paragraph);
            int end = this.spannableStringBuilder.getSpanEnd(paragraph);
            if (end - 2 >= 0 && this.spannableStringBuilder.charAt(end - 1) == '\n' && this.spannableStringBuilder.charAt(end - 2) == '\n') {
                --end;
            }
            if (end == start) {
                this.spannableStringBuilder.removeSpan(paragraph);
                continue;
            }
            this.spannableStringBuilder.setSpan(paragraph, start, end, 51);
        }
        return this.spannableStringBuilder;
    }

    private void handleStartTag(String tag, Attributes attributes) {
        if (this.unknownTagLevel != 0) {
            if (tag.equalsIgnoreCase("aztec_cursor")) {
                HtmlToSpannedConverter.handleCursor(this.spannableStringBuilder);
                return;
            }
            this.unknown.rawHtml.append('<').append(tag).append((CharSequence)Html.stringifyAttributes(attributes)).append('>');
            ++this.unknownTagLevel;
            return;
        }
        if (!tag.equalsIgnoreCase("br")) {
            if (tag.equalsIgnoreCase("aztec_cursor")) {
                HtmlToSpannedConverter.handleCursor(this.spannableStringBuilder);
            } else if (tag.equalsIgnoreCase("strong")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Bold(attributes));
            } else if (tag.equalsIgnoreCase("b")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Bold(attributes));
            } else if (tag.equalsIgnoreCase("em")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Italic(attributes));
            } else if (tag.equalsIgnoreCase("cite")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Italic(attributes));
            } else if (tag.equalsIgnoreCase("dfn")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Italic(attributes));
            } else if (tag.equalsIgnoreCase("i")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Italic(attributes));
            } else if (tag.equalsIgnoreCase("big")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Big(attributes));
            } else if (tag.equalsIgnoreCase("small")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Small(attributes));
            } else if (tag.equalsIgnoreCase("font")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Font(attributes));
            } else if (tag.equalsIgnoreCase("tt")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Monospace(attributes));
            } else if (tag.equalsIgnoreCase("a")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Href(attributes));
            } else if (tag.equalsIgnoreCase("u")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Underline(attributes));
            } else if (tag.equalsIgnoreCase("sup")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Super(attributes));
            } else if (tag.equalsIgnoreCase("sub")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Sub(attributes));
            } else if (tag.equalsIgnoreCase("code")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, new Code(attributes));
            } else {
                boolean tagHandled;
                if (this.tagHandler != null && (tagHandled = this.tagHandler.handleTag(true, tag, (Editable)this.spannableStringBuilder, this.onMediaTappedListener, this.context, attributes))) {
                    return;
                }
                if (!UnknownHtmlSpan.Companion.getKNOWN_TAGS().contains(tag.toLowerCase()) && this.unknownTagLevel == 0) {
                    this.unknownTagLevel = 1;
                    this.unknown = new Unknown();
                    this.unknown.rawHtml = new StringBuilder();
                    this.unknown.rawHtml.append('<').append(tag).append((CharSequence)Html.stringifyAttributes(attributes)).append('>');
                    HtmlToSpannedConverter.start(this.spannableStringBuilder, this.unknown);
                }
            }
        }
    }

    private void handleEndTag(String tag) {
        if (this.unknownTagLevel != 0) {
            if (tag.equalsIgnoreCase("aztec_cursor")) {
                return;
            }
            if (tag.equalsIgnoreCase("br")) {
                --this.unknownTagLevel;
                return;
            }
            this.unknown.rawHtml.append("</").append(tag).append(">");
            --this.unknownTagLevel;
            if (this.unknownTagLevel == 0) {
                this.spannableStringBuilder.append((CharSequence)"\ufffc");
                HtmlToSpannedConverter.endUnknown(this.spannableStringBuilder, this.unknown.rawHtml, this.context, this.onUnknownHtmlClickListener);
            }
            return;
        }
        if (tag.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr(this.spannableStringBuilder);
        } else if (tag.equalsIgnoreCase("strong")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_BOLD);
        } else if (tag.equalsIgnoreCase("b")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_BOLD);
        } else if (tag.equalsIgnoreCase("em")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_ITALIC);
        } else if (tag.equalsIgnoreCase("cite")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_ITALIC);
        } else if (tag.equalsIgnoreCase("dfn")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_ITALIC);
        } else if (tag.equalsIgnoreCase("i")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_ITALIC);
        } else if (tag.equalsIgnoreCase("big")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_BIG);
        } else if (tag.equalsIgnoreCase("small")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_SMALL);
        } else if (tag.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.endFont(this.spannableStringBuilder);
        } else if (tag.equalsIgnoreCase("tt")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_MONOSPACE);
        } else if (tag.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_LINK);
        } else if (tag.equalsIgnoreCase("u")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_UNDERLINE);
        } else if (tag.equalsIgnoreCase("sup")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_SUPERSCRIPT);
        } else if (tag.equalsIgnoreCase("sub")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_SUBSCRIPT);
        } else if (tag.equalsIgnoreCase("code")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, TextFormat.FORMAT_CODE);
        } else if (this.tagHandler != null) {
            this.tagHandler.handleTag(false, tag, (Editable)this.spannableStringBuilder, this.onMediaTappedListener, this.context, null);
        }
    }

    private static void handleCursor(SpannableStringBuilder text) {
        int start = text.length();
        Object[] unknownSpans = text.getSpans(start, start, Unknown.class);
        if (unknownSpans.length > 0) {
            start = text.getSpanStart(unknownSpans[0]);
        }
        text.setSpan((Object)new AztecCursorSpan(), start, start, 17);
    }

    private static void handleBr(SpannableStringBuilder text) {
        text.append((CharSequence)"\n");
    }

    private static Object getLast(Spanned text, Class kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        return objs[objs.length - 1];
    }

    private static void start(SpannableStringBuilder text, Object mark) {
        int len = text.length();
        text.setSpan(mark, len, len, 17);
    }

    private static void end(SpannableStringBuilder text, TextFormat textFormat) {
        AttributedMarker marker;
        int len = text.length();
        AztecContentSpan newSpan = null;
        switch (textFormat) {
            case FORMAT_BOLD: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Bold.class);
                if (marker == null) break;
                newSpan = new AztecStyleSpan(1, Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_ITALIC: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Italic.class);
                if (marker == null) break;
                newSpan = new AztecStyleSpan(2, Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_UNDERLINE: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Underline.class);
                if (marker == null) break;
                newSpan = new AztecUnderlineSpan(Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_LINK: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Href.class);
                if (marker == null) break;
                String url = marker.attributes.getValue("href") == null ? "" : marker.attributes.getValue("href");
                newSpan = new AztecURLSpan(url, Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_BIG: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Big.class);
                if (marker == null) break;
                newSpan = new AztecRelativeSizeSpan("big", 1.25f, Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_SMALL: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Small.class);
                if (marker == null) break;
                newSpan = new AztecRelativeSizeSpan("small", 0.8f, Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_SUPERSCRIPT: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Super.class);
                if (marker == null) break;
                newSpan = new AztecSuperscriptSpan(Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_SUBSCRIPT: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Sub.class);
                if (marker == null) break;
                newSpan = new AztecSubscriptSpan(Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_MONOSPACE: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Monospace.class);
                if (marker == null) break;
                newSpan = new AztecTypefaceSpan("tt", "monospace", Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_FONT: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Font.class);
                if (marker == null) break;
                newSpan = new FontSpan(Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_CODE: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Code.class);
                if (marker == null) break;
                newSpan = new AztecCodeSpan(Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            case FORMAT_PARAGRAPH: {
                marker = (AttributedMarker)HtmlToSpannedConverter.getLast((Spanned)text, Paragraph.class);
                if (marker == null) break;
                newSpan = new ParagraphSpan(Html.stringifyAttributes(marker.attributes).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Style not supported");
            }
        }
        int where = text.getSpanStart((Object)marker);
        text.removeSpan((Object)marker);
        if (where != len && newSpan != null) {
            text.setSpan((Object)newSpan, where, len, 33);
        }
    }

    private static void endFont(SpannableStringBuilder text) {
        int len = text.length();
        Font font = (Font)HtmlToSpannedConverter.getLast((Spanned)text, Font.class);
        int where = text.getSpanStart((Object)font);
        HtmlToSpannedConverter.end(text, TextFormat.FORMAT_FONT);
        if (font != null && where != len) {
            String face;
            String color = font.attributes.getValue("color");
            if (!TextUtils.isEmpty((CharSequence)color)) {
                if (color.startsWith("@")) {
                    String name;
                    Resources res = Resources.getSystem();
                    int colorRes = res.getIdentifier(name = color.substring(1), "color", "android");
                    if (colorRes != 0) {
                        ColorStateList colors = res.getColorStateList(colorRes);
                        text.setSpan((Object)new TextAppearanceSpan(null, 0, 0, colors, null), where, len, 33);
                    }
                } else {
                    try {
                        int c = Color.parseColor((String)color);
                        if (c != -1) {
                            text.setSpan((Object)new ForegroundColorSpan(c | 0xFF000000), where, len, 33);
                        }
                    }
                    catch (Exception c) {
                        // empty catch block
                    }
                }
            }
            if ((face = font.attributes.getValue("face")) != null) {
                text.setSpan((Object)new TypefaceSpan(face), where, len, 33);
            }
        }
    }

    private static void endUnknown(SpannableStringBuilder text, StringBuilder rawHtml, Context context, UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast((Spanned)text, Unknown.class);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        if (where != len) {
            UnknownHtmlSpan unknownHtmlSpan = new UnknownHtmlSpan(rawHtml, context, 17301568, onUnknownHtmlClickListener);
            text.setSpan((Object)unknownHtmlSpan, where, len, 33);
            UnknownClickableSpan unknownClickableSpan = new UnknownClickableSpan(unknownHtmlSpan);
            text.setSpan((Object)unknownClickableSpan, where, len, 33);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handleStartTag(localName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.unknownTagLevel != 0) {
            for (int i = 0; i < length; ++i) {
                this.unknown.rawHtml.append(ch[i + start]);
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.spannableStringBuilder.length()) == 0 ? 10 : (int)this.spannableStringBuilder.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.spannableStringBuilder.append((CharSequence)sb);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String s, String s1, String s2) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String s) throws SAXException {
    }

    @Override
    public void endEntity(String s) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] chars, int start, int length) throws SAXException {
        if (this.unknownTagLevel != 0) {
            this.unknown.rawHtml.append("<!--");
            for (int i = 0; i < length; ++i) {
                this.unknown.rawHtml.append(chars[i + start]);
            }
            this.unknown.rawHtml.append("-->");
            return;
        }
        String comment = new String(chars, start, length);
        int spanStart = this.spannableStringBuilder.length();
        this.spannableStringBuilder.append((CharSequence)comment);
        if (comment.equalsIgnoreCase(AztecCommentSpan.Comment.MORE.getHtml())) {
            this.spannableStringBuilder.setSpan((Object)new AztecCommentSpan(this.context, this.context.getResources().getDrawable(R.drawable.img_more)), spanStart, this.spannableStringBuilder.length(), 33);
        } else if (comment.equalsIgnoreCase(AztecCommentSpan.Comment.PAGE.getHtml())) {
            this.spannableStringBuilder.setSpan((Object)new AztecCommentSpan(this.context, this.context.getResources().getDrawable(R.drawable.img_page)), spanStart, this.spannableStringBuilder.length(), 33);
        } else {
            this.spannableStringBuilder.setSpan((Object)new CommentSpan(), spanStart, this.spannableStringBuilder.length(), 33);
        }
    }

    private static class Paragraph
    extends AttributedMarker {
        Paragraph(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Href
    extends AttributedMarker {
        Href(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Code
    extends AttributedMarker {
        Code(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Font
    extends AttributedMarker {
        Font(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Sub
    extends AttributedMarker {
        Sub(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Super
    extends AttributedMarker {
        Super(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Monospace
    extends AttributedMarker {
        Monospace(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Small
    extends AttributedMarker {
        Small(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Big
    extends AttributedMarker {
        Big(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Underline
    extends AttributedMarker {
        Underline(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Italic
    extends AttributedMarker {
        Italic(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class Bold
    extends AttributedMarker {
        Bold(Attributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class AttributedMarker {
        Attributes attributes;

        private AttributedMarker() {
        }
    }

    private static class Unknown {
        public StringBuilder rawHtml;

        private Unknown() {
        }
    }
}

