/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.Spannable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.R;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecLineBlockSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecMediaClickableSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecOrderedListSpan;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecStrikethroughSpan;
import org.wordpress.aztec.spans.AztecUnorderedListSpan;
import org.wordpress.aztec.spans.HiddenHtmlSpan;
import org.wordpress.aztec.spans.ParagraphSpan;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J<\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/wordpress/aztec/AztecTagHandler;", "Lorg/wordpress/aztec/Html$TagHandler;", "()V", "order", "", "createImageSpan", "Lorg/wordpress/aztec/spans/AztecMediaSpan;", "attributes", "Lorg/xml/sax/Attributes;", "onMediaTappedListener", "Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "context", "Landroid/content/Context;", "end", "", "output", "Landroid/text/Editable;", "kind", "Ljava/lang/Class;", "endHidden", "endList", "handleBlockElement", "opening", "", "span", "", "handleTag", "tag", "", "isNestedInBlockElement", "start", "mark", "Companion", "aztec_release"})
public final class AztecTagHandler
implements Html.TagHandler {
    private int order;
    private static final String LIST_LI = "li";
    private static final String LIST_UL = "ul";
    private static final String LIST_OL = "ol";
    private static final String STRIKETHROUGH_S = "s";
    private static final String STRIKETHROUGH_STRIKE = "strike";
    private static final String STRIKETHROUGH_DEL = "del";
    private static final String DIV = "div";
    private static final String SPAN = "span";
    private static final String BLOCKQUOTE = "blockquote";
    private static final String PARAGRAPH = "p";
    private static final String IMAGE = "img";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean handleTag(boolean opening, @NotNull String tag, @NotNull Editable output, @Nullable AztecText.OnMediaTappedListener onMediaTappedListener, @NotNull Context context, @Nullable Attributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String attributeString = Html.stringifyAttributes(attributes).toString();
        String string = tag;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        if (Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getLIST_LI())) {
            if (opening) {
                String string5 = attributeString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"attributeString");
                this.start(output, new AztecListItemSpan(string5));
            } else {
                this.endList(output);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getSTRIKETHROUGH_S()) || Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getSTRIKETHROUGH_STRIKE()) || Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getSTRIKETHROUGH_DEL())) {
            if (opening) {
                String string6 = attributeString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"attributeString");
                this.start(output, new AztecStrikethroughSpan(tag, string6));
            } else {
                this.end(output, AztecStrikethroughSpan.class);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getDIV()) || Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getSPAN())) {
            if (opening) {
                String string7 = attributeString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"attributeString");
                int n = this.order;
                this.order = n + 1;
                this.start(output, (Object)new HiddenHtmlSpan(tag, string7, n));
            } else {
                int n = this.order;
                this.order = n + 1;
                this.endHidden(output, n);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getLIST_UL())) {
            String string8 = attributeString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"attributeString");
            this.handleBlockElement(output, opening, new AztecUnorderedListSpan(string8));
            return true;
        }
        if (Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getLIST_OL())) {
            String string9 = attributeString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"attributeString");
            this.handleBlockElement(output, opening, new AztecOrderedListSpan(string9));
            return true;
        }
        if (Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getBLOCKQUOTE())) {
            String string10 = attributeString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"attributeString");
            this.handleBlockElement(output, opening, new AztecQuoteSpan(string10));
            return true;
        }
        if (Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getIMAGE())) {
            if (opening) {
                AztecMediaSpan mediaSpan = this.createImageSpan(attributes, onMediaTappedListener, context);
                this.start(output, (Object)mediaSpan);
                this.start(output, (Object)new AztecMediaClickableSpan(mediaSpan));
                output.append(Constants.INSTANCE.getIMG_CHAR());
            } else {
                this.end(output, AztecMediaSpan.class);
                this.end(output, AztecMediaClickableSpan.class);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string4, (Object)AztecTagHandler.Companion.getPARAGRAPH())) {
            String string11 = attributeString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"attributeString");
            this.handleBlockElement(output, opening, new ParagraphSpan(string11));
            return true;
        }
        if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            String string12 = attributeString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"attributeString");
            this.handleBlockElement(output, opening, new AztecHeadingSpan(tag, string12, 0, 4, null));
            return true;
        }
        return false;
    }

    private final AztecMediaSpan createImageSpan(Attributes attributes, AztecText.OnMediaTappedListener onMediaTappedListener, Context context) {
        Drawable loadingDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_image_loading);
        return new AztecMediaSpan(context, loadingDrawable, attributes, onMediaTappedListener);
    }

    /*
     * Unable to fully structure code
     */
    private final void handleBlockElement(Editable output, boolean opening, Object span) {
        block7: {
            var4_4 = (CharSequence)output;
            if (!(StringsKt.isBlank((CharSequence)var4_4) == false)) break block7;
            nestedInBlockElement = this.isNestedInBlockElement(output, opening);
            if (!opening || StringsKt.last((CharSequence)((CharSequence)output)) != '\n') ** GOTO lbl-1000
            var6_6 = output.getSpans(StringsKt.getLastIndex((CharSequence)((CharSequence)output)), StringsKt.getLastIndex((CharSequence)((CharSequence)output)), AztecLineBlockSpan.class);
            var7_7 = var6_6;
            if (var7_7.length == 0 == false) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = followingBlockElement = false;
            }
            if (!(followingBlockElement || nestedInBlockElement || StringsKt.last((CharSequence)((CharSequence)output)) == '\n' && !opening)) {
                output.append((CharSequence)"\n");
            } else if (!(span instanceof AztecListSpan) && !opening && nestedInBlockElement) {
                output.append((CharSequence)"\n");
            }
        }
        if (opening) {
            this.start(output, span);
        } else {
            this.end(output, span.getClass());
        }
    }

    public final boolean isNestedInBlockElement(@NotNull Editable output, boolean opening) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        int spanLookupIndex = opening ? output.length() : output.length() - 1;
        int minNumberOfSpans = opening ? 0 : 1;
        return output.getSpans(spanLookupIndex, spanLookupIndex, AztecLineBlockSpan.class).length > minNumberOfSpans;
    }

    private final void start(Editable output, Object mark) {
        output.setSpan(mark, output.length(), output.length(), 17);
    }

    private final void endHidden(Editable output, int order) {
        HiddenHtmlSpan last = AztecTagHandler.Companion.getLastOpenHidden(output);
        if (last != null) {
            last.close(order);
            int start = output.getSpanStart((Object)last);
            int end = output.length();
            if (start != end) {
                output.setSpan((Object)last, start, end, 33);
            } else {
                output.setSpan((Object)last, start, end, 17);
            }
        }
    }

    private final void endList(Editable output) {
        AztecListItemSpan last;
        block5: {
            block4: {
                Object object = AztecTagHandler.Companion.getLast(output, AztecListItemSpan.class);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecListItemSpan");
                }
                last = (AztecListItemSpan)object;
                Object[] objectArray = (Object[])output;
                if (objectArray.length() == 0 || StringsKt.last((CharSequence)((CharSequence)output)) != '\n') break block4;
                objectArray = output.getSpans(output.length(), output.length(), AztecListItemSpan.class);
                Object[] objectArray2 = objectArray;
                if (!(!(objectArray2.length == 0))) break block5;
            }
            output.append((CharSequence)"\n");
        }
        int end = output.length();
        output.setSpan((Object)last, end - 1, end, 33);
        AztecListSpan list = (AztecListSpan)ArraysKt.last((Object[])output.getSpans(0, output.length(), AztecListSpan.class));
        list.setLastItem(last);
    }

    private final void end(Editable output, Class<?> kind) {
        Object last = AztecTagHandler.Companion.getLast(output, kind);
        int start = output.getSpanStart(last);
        int end = output.length();
        output.removeSpan(last);
        if (start != end) {
            output.setSpan(last, start, end, 33);
        } else if (start == end && AztecBlockSpan.class.isAssignableFrom(kind)) {
            output.append((CharSequence)"\n");
            output.setSpan(last, start, output.length(), 33);
        }
    }

    static {
        LIST_LI = LIST_LI;
        LIST_UL = LIST_UL;
        LIST_OL = LIST_OL;
        STRIKETHROUGH_S = STRIKETHROUGH_S;
        STRIKETHROUGH_STRIKE = STRIKETHROUGH_STRIKE;
        STRIKETHROUGH_DEL = STRIKETHROUGH_DEL;
        DIV = DIV;
        SPAN = SPAN;
        BLOCKQUOTE = BLOCKQUOTE;
        PARAGRAPH = PARAGRAPH;
        IMAGE = IMAGE;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/wordpress/aztec/AztecTagHandler$Companion;", "", "()V", "BLOCKQUOTE", "", "getBLOCKQUOTE", "()Ljava/lang/String;", "DIV", "getDIV", "IMAGE", "getIMAGE", "LIST_LI", "getLIST_LI", "LIST_OL", "getLIST_OL", "LIST_UL", "getLIST_UL", "PARAGRAPH", "getPARAGRAPH", "SPAN", "getSPAN", "STRIKETHROUGH_DEL", "getSTRIKETHROUGH_DEL", "STRIKETHROUGH_S", "getSTRIKETHROUGH_S", "STRIKETHROUGH_STRIKE", "getSTRIKETHROUGH_STRIKE", "getLast", "text", "Landroid/text/Editable;", "kind", "Ljava/lang/Class;", "getLastOpenHidden", "Lorg/wordpress/aztec/spans/HiddenHtmlSpan;", "aztec_release"})
    public static final class Companion {
        private final String getLIST_LI() {
            return LIST_LI;
        }

        private final String getLIST_UL() {
            return LIST_UL;
        }

        private final String getLIST_OL() {
            return LIST_OL;
        }

        private final String getSTRIKETHROUGH_S() {
            return STRIKETHROUGH_S;
        }

        private final String getSTRIKETHROUGH_STRIKE() {
            return STRIKETHROUGH_STRIKE;
        }

        private final String getSTRIKETHROUGH_DEL() {
            return STRIKETHROUGH_DEL;
        }

        private final String getDIV() {
            return DIV;
        }

        private final String getSPAN() {
            return SPAN;
        }

        private final String getBLOCKQUOTE() {
            return BLOCKQUOTE;
        }

        private final String getPARAGRAPH() {
            return PARAGRAPH;
        }

        private final String getIMAGE() {
            return IMAGE;
        }

        /*
         * WARNING - void declaration
         */
        private final Object getLast(Editable text, Class<?> kind) {
            Object object;
            Object v0;
            Object object2;
            Object[] spans;
            block4: {
                void $receiver$iv;
                object2 = spans = text.getSpans(0, text.length(), kind);
                if (((Object[])object2).length == 0) {
                    return null;
                }
                object2 = (Iterable)RangesKt.downTo((int)spans.length, (int)1);
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!(text.getSpanFlags(spans[it - 1]) == Spannable.SPAN_MARK_MARK)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Integer n = v0;
            if (n != null) {
                object2 = n;
                int it = ((Number)object2).intValue();
                object = spans[it - 1];
            } else {
                object = null;
            }
            return object;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final HiddenHtmlSpan getLastOpenHidden(Editable text) {
            block7: {
                spans = (HiddenHtmlSpan[])text.getSpans(0, text.length(), HiddenHtmlSpan.class);
                var3_3 /* !! */  = (Object[])spans;
                if (var3_3 /* !! */ .length == 0) {
                    return null;
                }
                $receiver$iv = (Iterable)RangesKt.downTo((int)((Object[])spans).length, (int)1);
                for (T element$iv : $receiver$iv) {
                    it = ((Number)element$iv).intValue();
                    if (text.getSpanFlags((Object)spans[it - 1]) != Spannable.SPAN_MARK_MARK) ** GOTO lbl-1000
                    v0 = spans[it - 1];
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.HiddenHtmlSpan");
                    }
                    if (!v0.isClosed()) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            v3 = v2;
            if (v3 != null) {
                var3_3 /* !! */  = v3;
                it = ((Number)var3_3 /* !! */ ).intValue();
                v4 = spans[it - 1];
            } else {
                v4 = null;
            }
            return v4;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

