/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.R;
import org.wordpress.aztec.TextChangedEvent;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.formatting.LineBlockFormatter$WhenMappings;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecCommentSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecMediaClickableSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\nJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lorg/wordpress/aztec/formatting/LineBlockFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "headerStyle", "Lorg/wordpress/aztec/formatting/LineBlockFormatter$HeaderStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/LineBlockFormatter$HeaderStyle;)V", "getHeaderStyle", "()Lorg/wordpress/aztec/formatting/LineBlockFormatter$HeaderStyle;", "applyComment", "", "comment", "Lorg/wordpress/aztec/spans/AztecCommentSpan$Comment;", "applyHeading", "textFormat", "Lorg/wordpress/aztec/TextFormat;", "applyMoreComment", "applyPageComment", "containHeadingType", "", "index", "", "containsHeading", "selStart", "selEnd", "handleLineBlockStyling", "textChangedEvent", "Lorg/wordpress/aztec/TextChangedEvent;", "headingClear", "headingFormat", "insertMedia", "drawable", "Landroid/graphics/drawable/Drawable;", "attributes", "Lorg/xml/sax/Attributes;", "onMediaTappedListener", "Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "HeaderStyle", "aztec_release"})
public final class LineBlockFormatter
extends AztecFormatter {
    @NotNull
    private final HeaderStyle headerStyle;

    public final void applyHeading(@NotNull TextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        this.headingClear();
        if (Intrinsics.areEqual((Object)((Object)textFormat), (Object)((Object)TextFormat.FORMAT_PARAGRAPH)) ^ true) {
            this.headingFormat(textFormat);
        }
    }

    public final void applyMoreComment() {
        this.applyComment(AztecCommentSpan.Comment.MORE);
    }

    public final void applyPageComment() {
        this.applyComment(AztecCommentSpan.Comment.PAGE);
    }

    public final void handleLineBlockStyling(@NotNull TextChangedEvent textChangedEvent) {
        Intrinsics.checkParameterIsNotNull((Object)textChangedEvent, (String)"textChangedEvent");
        if (textChangedEvent.isAddingCharacters() && textChangedEvent.isNewLineButNotAtTheBeginning()) {
            AztecHeadingSpan spanAtNewLIne = (AztecHeadingSpan)ArraysKt.getOrNull((Object[])this.getEditableText().getSpans(textChangedEvent.getInputStart(), textChangedEvent.getInputStart(), AztecHeadingSpan.class), (int)0);
            if (spanAtNewLIne != null) {
                boolean isHeadingSplitRequired;
                int spanStart = this.getEditableText().getSpanStart((Object)spanAtNewLIne);
                int spanEnd = this.getEditableText().getSpanEnd((Object)spanAtNewLIne);
                boolean bl = isHeadingSplitRequired = spanStart <= textChangedEvent.getInputStart() && spanEnd > textChangedEvent.getInputEnd();
                if (isHeadingSplitRequired && this.getEditableText().charAt(textChangedEvent.getInputStart() - 1) != '\n') {
                    this.getEditableText().setSpan((Object)spanAtNewLIne, spanStart, textChangedEvent.getInputStart(), 33);
                    this.getEditableText().setSpan(spanAtNewLIne.clone(), textChangedEvent.getInputStart() + 1, spanEnd, 33);
                } else if (isHeadingSplitRequired && this.getEditableText().charAt(textChangedEvent.getInputStart() - 1) == '\n') {
                    this.getEditableText().setSpan((Object)spanAtNewLIne, spanStart + 1, spanEnd, 33);
                } else if (!isHeadingSplitRequired && this.getEditableText().length() > textChangedEvent.getInputStart() + 1 && this.getEditableText().charAt(textChangedEvent.getInputStart() + 1) == '\n') {
                    this.getEditableText().setSpan((Object)spanAtNewLIne, spanStart, spanEnd - 1, 33);
                } else if (!isHeadingSplitRequired && textChangedEvent.getInputStart() + 1 == spanEnd && this.getEditableText().charAt(textChangedEvent.getInputStart()) == '\n') {
                    this.getEditableText().setSpan((Object)spanAtNewLIne, spanStart, spanEnd - 1, 33);
                }
            }
        } else if (!textChangedEvent.isAddingCharacters() && this.getEditableText().length() > textChangedEvent.getInputEnd() && textChangedEvent.getInputEnd() > 0) {
            char charBeforeInputEnd = textChangedEvent.getText().charAt(textChangedEvent.getInputEnd() - 1);
            if (charBeforeInputEnd == '\n') {
                return;
            }
            AztecHeadingSpan spanOnTheLeft = (AztecHeadingSpan)ArraysKt.getOrNull((Object[])this.getEditableText().getSpans(textChangedEvent.getInputEnd() - 1, textChangedEvent.getInputEnd(), AztecHeadingSpan.class), (int)0);
            AztecHeadingSpan spanOnTheRight = (AztecHeadingSpan)ArraysKt.getOrNull((Object[])this.getEditableText().getSpans(textChangedEvent.getInputEnd(), textChangedEvent.getInputEnd() + 1, AztecHeadingSpan.class), (int)0);
            if (spanOnTheLeft == null && spanOnTheRight != null) {
                this.getEditableText().removeSpan((Object)spanOnTheRight);
            } else if (spanOnTheLeft != null && spanOnTheRight != null && Intrinsics.areEqual((Object)spanOnTheLeft, (Object)spanOnTheRight) ^ true) {
                int leftSpanStart = this.getEditableText().getSpanStart((Object)spanOnTheLeft);
                int rightSpanEnd = this.getEditableText().getSpanEnd((Object)spanOnTheRight);
                this.getEditableText().removeSpan((Object)spanOnTheRight);
                this.getEditableText().setSpan((Object)spanOnTheLeft, leftSpanStart, rightSpanEnd, 33);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void headingClear() {
        int n = 0;
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        int n2 = lines.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (this.containsHeading((int)i)) {
                    void $receiver$iv;
                    Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                    int sum$iv = 0;
                    Iterator iterator = $receiver$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int element$iv;
                        int n3 = element$iv = ((IntIterator)iterator).nextInt();
                        int n4 = sum$iv;
                        int n5 = lines[it].length() + 1;
                        sum$iv = n4 + n5;
                    }
                    int lineStart = sum$iv;
                    int lineEnd = lineStart + lines[i].length();
                    if (lineStart < lineEnd) {
                        int headingStart = 0;
                        int headingEnd = 0;
                        if (lineStart <= this.getSelectionStart() && this.getSelectionEnd() <= lineEnd || lineStart >= this.getSelectionStart() && this.getSelectionEnd() >= lineEnd || lineStart <= this.getSelectionStart() && this.getSelectionEnd() >= lineEnd && this.getSelectionStart() <= lineEnd || lineStart >= this.getSelectionStart() && this.getSelectionEnd() <= lineEnd && this.getSelectionEnd() >= lineStart) {
                            headingStart = lineStart;
                            headingEnd = lineEnd;
                        }
                        if (headingStart < headingEnd) {
                            AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(headingStart, headingEnd, AztecHeadingSpan.class);
                            for (int j = 0; j < spans.length; ++j) {
                                AztecHeadingSpan span = spans[j];
                                this.getEditableText().removeSpan((Object)span);
                            }
                        }
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        this.getEditor().refreshText();
    }

    /*
     * WARNING - void declaration
     */
    public final void headingFormat(@NotNull TextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        int n = 0;
        int n2 = lines.length - 1;
        if (n <= n2) {
            while (true) {
                void $receiver$iv;
                void i;
                Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n3 = element$iv = ((IntIterator)iterator).nextInt();
                    int n4 = sum$iv;
                    int n5 = lines[it].length() + 1;
                    sum$iv = n4 + n5;
                }
                int lineStart = sum$iv;
                int lineEnd = lineStart + lines[i].length();
                if (lineStart < lineEnd) {
                    int headingStart = 0;
                    int headingEnd = 0;
                    if (lineStart <= this.getSelectionStart() && this.getSelectionEnd() <= lineEnd || lineStart >= this.getSelectionStart() && this.getSelectionEnd() >= lineEnd || lineStart <= this.getSelectionStart() && this.getSelectionEnd() >= lineEnd && this.getSelectionStart() <= lineEnd || lineStart >= this.getSelectionStart() && this.getSelectionEnd() <= lineEnd && this.getSelectionEnd() >= lineStart) {
                        headingStart = lineStart;
                        headingEnd = lineEnd;
                    }
                    if (headingStart < headingEnd) {
                        this.getEditableText().setSpan((Object)new AztecHeadingSpan(textFormat, "", this.headerStyle.getVerticalPadding()), headingStart, headingEnd, 33);
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        this.getEditor().refreshText();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsHeading(@NotNull TextFormat textFormat, int selStart, int selEnd) {
        boolean bl;
        block6: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
            String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
            ArrayList<Integer> list = new ArrayList<Integer>();
            int n = 0;
            int n2 = lines.length - 1;
            if (n <= n2) {
                while (true) {
                    void $receiver$iv2;
                    void i;
                    Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                    int sum$iv = 0;
                    Iterator iterator = $receiver$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int element$iv;
                        int n3 = element$iv = ((IntIterator)iterator).nextInt();
                        int n4 = sum$iv;
                        int n5 = lines[it].length() + 1;
                        sum$iv = n4 + n5;
                    }
                    int lineStart = sum$iv;
                    int lineEnd = lineStart + lines[i].length();
                    if (lineStart < lineEnd && (lineStart >= selStart && selEnd >= lineEnd || lineStart <= selEnd && selEnd <= lineEnd || lineStart <= selStart && selStart <= lineEnd)) {
                        list.add((int)i);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (list.isEmpty()) {
                return false;
            }
            Iterable i = list;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                if (!this.containHeadingType(textFormat, it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsHeading(int index) {
        void $receiver$iv;
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        Iterable iterable = (Iterable)new IntRange(0, index - 1);
        int sum$iv = 0;
        Object[] objectArray = $receiver$iv.iterator();
        while (objectArray.hasNext()) {
            void it;
            int element$iv;
            int n = element$iv = ((IntIterator)objectArray).nextInt();
            int n2 = sum$iv;
            int n3 = lines[it].length() + 1;
            sum$iv = n2 + n3;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        objectArray = spans;
        Object[] objectArray2 = objectArray;
        return !(objectArray2.length == 0);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containHeadingType(TextFormat textFormat, int index) {
        void $receiver$iv;
        String[] lines = TextUtils.split((String)this.getEditableText().toString(), (String)"\n");
        if (index < 0 || index >= ((Object[])lines).length) {
            return false;
        }
        Iterable iterable = (Iterable)new IntRange(0, index - 1);
        int sum$iv = 0;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator).nextInt();
            int n2 = sum$iv;
            int n3 = lines[it].length() + 1;
            sum$iv = n2 + n3;
        }
        int start = sum$iv;
        int end = start + lines[index].length();
        if (start >= end) {
            return false;
        }
        int n = 0;
        AztecHeadingSpan[] spans = (AztecHeadingSpan[])this.getEditableText().getSpans(start, end, AztecHeadingSpan.class);
        if (n < spans.length) {
            AztecHeadingSpan span = spans[n];
            switch (LineBlockFormatter$WhenMappings.$EnumSwitchMapping$0[textFormat.ordinal()]) {
                case 1: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H1));
                }
                case 2: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H2));
                }
                case 3: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H3));
                }
                case 4: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H4));
                }
                case 5: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H5));
                }
                case 6: {
                    return Intrinsics.areEqual((Object)((Object)span.getHeading()), (Object)((Object)AztecHeadingSpan.Heading.H6));
                }
            }
            return false;
        }
        return false;
    }

    private final void applyComment(AztecCommentSpan.Comment comment) {
        Drawable drawable2;
        Object applyingOnTheEndOfBlockLine;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Object[] $receiver$iv = this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecBlockSpan.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            AztecBlockSpan it = (AztecBlockSpan)element$iv;
            if (this.getEditableText().getSpanEnd((Object)it) <= this.getSelectionEnd() || this.getEditableText().charAt(this.getSelectionEnd()) != '\n') continue;
            applyingOnTheEndOfBlockLine.element = true;
        }
        int commentStartIndex = this.getSelectionStart() + 1;
        int commentEndIndex = this.getSelectionStart() + comment.getHtml().length() + 1;
        this.getEditor().disableTextChangedListener();
        this.getEditableText().replace(this.getSelectionStart(), this.getSelectionEnd(), (CharSequence)("\n" + comment.getHtml() + (applyingOnTheEndOfBlockLine.element ? "" : "\n")));
        this.getEditor().removeBlockStylesFromRange(commentStartIndex, commentEndIndex + 1, true);
        this.getEditor().removeHeadingStylesFromRange(commentStartIndex, commentEndIndex + 1);
        this.getEditor().removeInlineStylesFromRange(commentStartIndex, commentEndIndex + 1);
        Context context = this.getEditor().getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"editor.context");
        switch (LineBlockFormatter$WhenMappings.$EnumSwitchMapping$1[comment.ordinal()]) {
            case 1: {
                drawable2 = ContextCompat.getDrawable((Context)this.getEditor().getContext(), (int)R.drawable.img_more);
                break;
            }
            case 2: {
                drawable2 = ContextCompat.getDrawable((Context)this.getEditor().getContext(), (int)R.drawable.img_page);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"when (comment) {\n       \u2026g_page)\n                }");
        AztecCommentSpan span = new AztecCommentSpan(context, drawable2);
        this.getEditableText().setSpan((Object)span, commentStartIndex, commentEndIndex, 33);
        this.getEditor().setSelection(commentEndIndex + 1);
        applyingOnTheEndOfBlockLine = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void insertMedia(@Nullable Drawable drawable2, @NotNull Attributes attributes, @Nullable AztecText.OnMediaTappedListener onMediaTappedListener) {
        Object v2;
        AztecBlockSpan spanBeforeMedia;
        AztecMediaSpan span;
        block5: {
            void $receiver$iv;
            Object v1;
            block4: {
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
                Context context = this.getEditor().getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"editor.context");
                span = new AztecMediaSpan(context, drawable2, attributes, onMediaTappedListener);
                Object[] objectArray = this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecBlockSpan.class);
                for (int i = 0; i < ((void)$receiver$iv2).length; ++i) {
                    void element$iv = $receiver$iv2[i];
                    AztecBlockSpan it = (AztecBlockSpan)element$iv;
                    if (!(this.getSelectionStart() == this.getEditableText().getSpanEnd((Object)it))) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            spanBeforeMedia = v1;
            Object[] objectArray = this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecBlockSpan.class);
            for (int element$iv = 0; element$iv < ((void)$receiver$iv).length; ++element$iv) {
                void element$iv2 = $receiver$iv[element$iv];
                AztecBlockSpan it = (AztecBlockSpan)element$iv2;
                if (!(this.getSelectionStart() == this.getEditableText().getSpanStart((Object)it))) continue;
                v2 = element$iv2;
                break block5;
            }
            v2 = null;
        }
        AztecBlockSpan spanAfterMedia = v2;
        int mediaStartIndex = this.getSelectionStart();
        int mediaEndIndex = this.getSelectionStart() + 1;
        this.getEditor().disableTextChangedListener();
        this.getEditableText().replace(this.getSelectionStart(), this.getSelectionEnd(), (CharSequence)Constants.INSTANCE.getIMG_STRING());
        if (spanAfterMedia != null) {
            this.getEditableText().setSpan((Object)spanAfterMedia, mediaStartIndex, this.getEditableText().getSpanEnd((Object)spanAfterMedia), 33);
        }
        if (spanBeforeMedia != null) {
            this.getEditableText().setSpan((Object)spanBeforeMedia, this.getEditableText().getSpanStart((Object)spanBeforeMedia), mediaEndIndex, 33);
        }
        this.getEditor().removeInlineStylesFromRange(mediaStartIndex, mediaEndIndex);
        this.getEditableText().setSpan((Object)span, mediaStartIndex, mediaEndIndex, 33);
        this.getEditableText().setSpan((Object)new AztecMediaClickableSpan(span), mediaStartIndex, mediaEndIndex, 33);
        this.getEditor().setSelection(mediaEndIndex);
        this.getEditor().setMediaAdded(true);
    }

    @NotNull
    public final HeaderStyle getHeaderStyle() {
        return this.headerStyle;
    }

    public LineBlockFormatter(@NotNull AztecText editor, @NotNull HeaderStyle headerStyle) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)editor), (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)headerStyle, (String)"headerStyle");
        super(editor);
        this.headerStyle = headerStyle;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/formatting/LineBlockFormatter$HeaderStyle;", "", "verticalPadding", "", "(I)V", "getVerticalPadding", "()I", "component1", "copy", "aztec_release"})
    public static final class HeaderStyle {
        private final int verticalPadding;

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public HeaderStyle(int verticalPadding) {
            this.verticalPadding = verticalPadding;
        }

        public final int component1() {
            return this.verticalPadding;
        }

        @NotNull
        public final HeaderStyle copy(int verticalPadding) {
            return new HeaderStyle(verticalPadding);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ HeaderStyle copy$default(HeaderStyle headerStyle, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n2 & 1) != 0) {
                n = headerStyle.verticalPadding;
            }
            return headerStyle.copy(n);
        }

        public String toString() {
            return "HeaderStyle(verticalPadding=" + this.verticalPadding + ")";
        }

        public int hashCode() {
            return this.verticalPadding;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HeaderStyle)) break block3;
                    HeaderStyle headerStyle = (HeaderStyle)object;
                    if (!(this.verticalPadding == headerStyle.verticalPadding)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

