/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecTagHandler;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.spans.AztecBlockSpan;
import org.wordpress.aztec.spans.AztecCommentSpan;
import org.wordpress.aztec.spans.AztecContentSpan;
import org.wordpress.aztec.spans.AztecCursorSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecLineBlockSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecParagraphStyle;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecSpan;
import org.wordpress.aztec.spans.BlockElementLinebreak;
import org.wordpress.aztec.spans.CommentSpan;
import org.wordpress.aztec.spans.HiddenHtmlSpan;
import org.wordpress.aztec.spans.ParagraphSpan;
import org.wordpress.aztec.spans.UnknownHtmlSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001RB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020!J \u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005H\u0002J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020!J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020*J(\u00103\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u00104\u001a\u00020\u00062\u0006\u0010%\u001a\u00020*H\u0002J\u0010\u00105\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020*H\u0002J\u0010\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020,H\u0002J\u0018\u00108\u001a\u00020,2\u0006\u0010%\u001a\u00020*2\b\b\u0002\u00109\u001a\u00020:J2\u0010;\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\b\b\u0002\u0010>\u001a\u00020:H\u0002J \u0010?\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010@\u001a\u00020*2\u0006\u00104\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*H\u0002J0\u0010C\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010D\u001a\u00020EH\u0002J0\u0010F\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010D\u001a\u00020EH\u0002J(\u0010G\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005H\u0002J:\u0010G\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\b\b\u0002\u0010I\u001a\u00020:H\u0002J(\u0010J\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005H\u0002J8\u0010K\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010D\u001a\u00020E2\u0006\u0010L\u001a\u00020MH\u0002J0\u0010N\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u0005H\u0002J0\u0010O\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010P\u001a\u00020QH\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\nR\u001a\u0010\u0019\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000f\u00a8\u0006S"}, d2={"Lorg/wordpress/aztec/AztecParser;", "", "()V", "closeMap", "Ljava/util/TreeMap;", "", "Lorg/wordpress/aztec/spans/HiddenHtmlSpan;", "getCloseMap$aztec_release", "()Ljava/util/TreeMap;", "setCloseMap$aztec_release", "(Ljava/util/TreeMap;)V", "hiddenIndex", "getHiddenIndex$aztec_release", "()I", "setHiddenIndex$aztec_release", "(I)V", "hiddenSpans", "", "getHiddenSpans$aztec_release", "()[I", "setHiddenSpans$aztec_release", "([I)V", "openMap", "getOpenMap$aztec_release", "setOpenMap$aztec_release", "spanCursorPosition", "getSpanCursorPosition$aztec_release", "setSpanCursorPosition$aztec_release", "addZwjCharToBlockSpans", "", "spanned", "Landroid/text/SpannableStringBuilder;", "adjustNestedSpanOrder", "Landroid/text/Editable;", "consumeCursorIfInInput", "out", "Ljava/lang/StringBuilder;", "text", "", "position", "fixBlockElementsRanges", "fromHtml", "Landroid/text/Spanned;", "source", "", "onMediaTappedListener", "Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "context", "Landroid/content/Context;", "markBlockElementLineBreaks", "input", "parseHiddenSpans", "span", "resetHiddenTagParser", "tidy", "html", "toHtml", "withCursor", "", "withinContent", "start", "end", "ignoreHeading", "withinHeading", "headingContent", "Lorg/wordpress/aztec/spans/AztecHeadingSpan;", "withinHtml", "withinList", "list", "Lorg/wordpress/aztec/spans/AztecListSpan;", "withinListThenQuote", "withinParagraph", "nl", "ignoreHeadingSpanCheck", "withinQuote", "withinQuoteThenList", "quote", "Lorg/wordpress/aztec/spans/AztecQuoteSpan;", "withinStyle", "withinUnknown", "unknownHtmlSpan", "Lorg/wordpress/aztec/spans/UnknownHtmlSpan;", "SpanToReset", "aztec_release"})
public final class AztecParser {
    private int hiddenIndex;
    @NotNull
    private TreeMap<Integer, HiddenHtmlSpan> closeMap = new TreeMap();
    @NotNull
    private TreeMap<Integer, HiddenHtmlSpan> openMap = new TreeMap();
    @NotNull
    private int[] hiddenSpans = new int[0];
    private int spanCursorPosition = -1;

    public final int getHiddenIndex$aztec_release() {
        return this.hiddenIndex;
    }

    public final void setHiddenIndex$aztec_release(int n) {
        this.hiddenIndex = n;
    }

    @NotNull
    public final TreeMap<Integer, HiddenHtmlSpan> getCloseMap$aztec_release() {
        return this.closeMap;
    }

    public final void setCloseMap$aztec_release(@NotNull TreeMap<Integer, HiddenHtmlSpan> treeMap) {
        Intrinsics.checkParameterIsNotNull(treeMap, (String)"<set-?>");
        this.closeMap = treeMap;
    }

    @NotNull
    public final TreeMap<Integer, HiddenHtmlSpan> getOpenMap$aztec_release() {
        return this.openMap;
    }

    public final void setOpenMap$aztec_release(@NotNull TreeMap<Integer, HiddenHtmlSpan> treeMap) {
        Intrinsics.checkParameterIsNotNull(treeMap, (String)"<set-?>");
        this.openMap = treeMap;
    }

    @NotNull
    public final int[] getHiddenSpans$aztec_release() {
        return this.hiddenSpans;
    }

    public final void setHiddenSpans$aztec_release(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.hiddenSpans = nArray;
    }

    public final int getSpanCursorPosition$aztec_release() {
        return this.spanCursorPosition;
    }

    public final void setSpanCursorPosition$aztec_release(int n) {
        this.spanCursorPosition = n;
    }

    @NotNull
    public final Spanned fromHtml(@NotNull String source, @Nullable AztecText.OnMediaTappedListener onMediaTappedListener, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String tidySource = this.tidy(source);
        SpannableStringBuilder spanned = new SpannableStringBuilder((CharSequence)Html.fromHtml(tidySource, new AztecTagHandler(), onMediaTappedListener, context));
        this.addZwjCharToBlockSpans(spanned);
        this.adjustNestedSpanOrder((Editable)spanned);
        this.fixBlockElementsRanges((Editable)spanned);
        return (Spanned)spanned;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toHtml(@NotNull Spanned text, boolean withCursor) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        StringBuilder out = new StringBuilder();
        Spanned cleanedUpText = this.markBlockElementLineBreaks(text);
        SpannableStringBuilder data = new SpannableStringBuilder((CharSequence)cleanedUpText).append(Constants.INSTANCE.getZWJ_CHAR());
        Object[] objectArray = data.getSpans(data.length() - 1, data.length(), HiddenHtmlSpan.class);
        if (objectArray.length == 0) {
            objectArray = data.getSpans(data.length() - 1, data.length(), AztecListSpan.class);
            if (objectArray.length == 0) {
                data.delete(data.length() - 1, data.length());
            }
        }
        Spanned spanned = (Spanned)data;
        Intrinsics.checkExpressionValueIsNotNull((Object)spanned, (String)"data");
        this.resetHiddenTagParser(spanned);
        HiddenHtmlSpan[] hidden = (HiddenHtmlSpan[])data.getSpans(0, data.length(), HiddenHtmlSpan.class);
        this.hiddenSpans = new int[((Object[])hidden).length * 2];
        Object[] objectArray2 = (Object[])hidden;
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            int end;
            void element$iv = $receiver$iv[i];
            HiddenHtmlSpan it = (HiddenHtmlSpan)element$iv;
            int n = this.hiddenIndex;
            this.hiddenIndex = n + 1;
            this.hiddenSpans[n] = it.getStartOrder();
            n = this.hiddenIndex;
            this.hiddenIndex = n + 1;
            this.hiddenSpans[n] = it.getEndOrder();
            int start = data.getSpanStart((Object)it);
            if (start != (end = data.getSpanEnd((Object)it)) || data.charAt(start) != '\n') continue;
            data.insert(start, (CharSequence)("" + Constants.INSTANCE.getMAGIC_CHAR()));
        }
        this.hiddenIndex = 0;
        Arrays.sort(this.hiddenSpans);
        if (withCursor) {
            AztecCursorSpan cursorSpan = (AztecCursorSpan)ArraysKt.firstOrNull((Object[])data.getSpans(0, data.length(), AztecCursorSpan.class));
            if (cursorSpan != null) {
                this.spanCursorPosition = data.getSpanStart((Object)cursorSpan);
            }
        } else {
            this.spanCursorPosition = -1;
        }
        Spanned spanned2 = (Spanned)data;
        Intrinsics.checkExpressionValueIsNotNull((Object)spanned2, (String)"data");
        this.withinHtml(out, spanned2);
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        return this.tidy(string);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String toHtml$default(AztecParser aztecParser, Spanned spanned, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toHtml");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return aztecParser.toHtml(spanned, bl);
    }

    private final void addZwjCharToBlockSpans(SpannableStringBuilder spanned) {
        Object[] $receiver$iv = spanned.getSpans(0, spanned.length(), AztecBlockSpan.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            AztecBlockSpan it = (AztecBlockSpan)element$iv;
            int start = spanned.getSpanStart((Object)it);
            int end = spanned.getSpanEnd((Object)it);
            if (spanned.charAt(end - 1) != '\n' || end - start != 1 && spanned.charAt(end - 2) != '\n') continue;
            spanned.insert(end - 1, (CharSequence)Constants.INSTANCE.getZWJ_STRING());
            if (end - start != 1) continue;
            spanned.setSpan((Object)it, start, end + 1, 33);
        }
    }

    public final void fixBlockElementsRanges(@NotNull Editable spanned) {
        Intrinsics.checkParameterIsNotNull((Object)spanned, (String)"spanned");
        Object[] $receiver$iv = spanned.getSpans(0, spanned.length(), AztecLineBlockSpan.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            AztecLineBlockSpan it = (AztecLineBlockSpan)element$iv;
            int spanStart = spanned.getSpanStart((Object)it);
            int spanEnd = spanned.getSpanEnd((Object)it);
            boolean willReduceSpan = 0 < spanEnd && spanEnd < spanned.length() && spanned.charAt(spanEnd) == '\n';
            boolean willDeleteLastChar = spanEnd == spanned.length() && spanned.charAt(spanEnd - 1) == '\n';
            boolean isListWithEmptyLastItem = it instanceof AztecListSpan && spanEnd - spanStart == 1;
            spanEnd = willReduceSpan && !isListWithEmptyLastItem ? spanEnd - 1 : spanEnd;
            spanned.removeSpan((Object)it);
            spanned.setSpan((Object)it, spanStart, spanEnd, 33);
            if (!willDeleteLastChar || isListWithEmptyLastItem) continue;
            spanned.delete(spanned.length() - 1, spanned.length());
        }
    }

    public final void adjustNestedSpanOrder(@NotNull Editable spanned) {
        Intrinsics.checkParameterIsNotNull((Object)spanned, (String)"spanned");
        Object[] $receiver$iv = spanned.getSpans(0, spanned.length(), AztecSpan.class);
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Iterable $receiver$iv2;
            Object element$iv = $receiver$iv[i];
            AztecSpan outsideSpan = (AztecSpan)element$iv;
            int spanStart = spanned.getSpanStart((Object)outsideSpan);
            int spanEnd = spanned.getSpanEnd((Object)outsideSpan);
            ArrayList<SpanToReset> spansToReset = new ArrayList<SpanToReset>();
            Object[] objectArray = spanned.getSpans(spanStart, spanEnd, AztecSpan.class);
            for (int j = 0; j < ((void)$receiver$iv2).length; ++j) {
                Object element$iv2 = $receiver$iv2[j];
                AztecSpan nestedSpan = (AztecSpan)element$iv2;
                if (Intrinsics.areEqual((Object)outsideSpan, (Object)nestedSpan)) continue;
                int nestedSpanStart = spanned.getSpanStart((Object)nestedSpan);
                int nestedSpanEnd = spanned.getSpanEnd((Object)nestedSpan);
                if (nestedSpanStart != spanStart && nestedSpanEnd != spanEnd) continue;
                spanned.removeSpan((Object)nestedSpan);
                AztecSpan aztecSpan = nestedSpan;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecSpan, (String)"nestedSpan");
                spansToReset.add(new SpanToReset(aztecSpan, nestedSpanStart, nestedSpanEnd));
            }
            $receiver$iv2 = spansToReset;
            if (!(!$receiver$iv2.isEmpty())) continue;
            spanned.removeSpan((Object)outsideSpan);
            spanned.setSpan((Object)outsideSpan, spanStart, spanEnd, 33);
            $receiver$iv2 = spansToReset;
            for (Object element$iv2 : $receiver$iv2) {
                SpanToReset spanToReset = (SpanToReset)element$iv2;
                spanned.setSpan((Object)spanToReset.getSpan(), spanToReset.getStart(), spanToReset.getEnd(), 33);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Spanned markBlockElementLineBreaks(@NotNull Spanned input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        text = new SpannableStringBuilder((CharSequence)input);
        $receiver$iv = text.getSpans(0, text.length(), AztecLineBlockSpan.class);
        for (var4_4 = 0; var4_4 < $receiver$iv.length; ++var4_4) {
            element$iv = $receiver$iv[var4_4];
            it = (AztecLineBlockSpan)element$iv;
            spanStart = text.getSpanStart((Object)it);
            spanEnd = text.getSpanEnd((Object)it);
            v0 = lookbehindRange = spanStart > 0 && text.charAt(spanStart - 1) == '\n' ? spanStart - 1 : spanStart - 2;
            if (lookbehindRange <= 0) ** GOTO lbl-1000
            var10_10 = text.getSpans(lookbehindRange, lookbehindRange, AztecLineBlockSpan.class);
            var11_11 = var10_10;
            if (var11_11.length == 0 == false) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = isFollowingBlockElement = false;
            }
            if (spanStart < 2 || isFollowingBlockElement) ** GOTO lbl-1000
            var10_10 = text.getSpans(spanStart - 2, spanStart - 2, BlockElementLinebreak.class);
            if (var10_10.length == 0) {
                text.setSpan((Object)new BlockElementLinebreak(), spanStart - 1, spanStart, 33);
            } else if (spanStart > 2 && text.charAt(spanStart - 1) == '\n' && text.charAt(spanStart - 2) == '\n' && isFollowingBlockElement) {
                var10_10 = text.getSpans(spanStart - 1, spanStart - 1, BlockElementLinebreak.class);
                for (var11_12 = 0; var11_12 < ((void)$receiver$iv).length; ++var11_12) {
                    element$iv = $receiver$iv[var11_12];
                    it = (BlockElementLinebreak)element$iv;
                    text.setSpan((Object)it, text.getSpanStart((Object)it) - 1, text.getSpanEnd((Object)it) - 1, 33);
                }
            }
            if (it instanceof AztecHeadingSpan) {
                if (spanEnd > 0 && text.length() > spanEnd && text.charAt(spanEnd) == '\n') {
                    text.setSpan((Object)new BlockElementLinebreak(), spanEnd, spanEnd, 17);
                    continue;
                }
                if (spanEnd <= 0 || text.length() <= spanEnd || text.charAt(spanEnd - 1) != '\n') continue;
                text.setSpan((Object)new BlockElementLinebreak(), spanEnd - 1, spanEnd - 1, 17);
                continue;
            }
            if (it instanceof AztecListSpan && spanEnd + 1 < text.length() && text.charAt(spanEnd) == '\n' && spanEnd > 0 && text.charAt(spanEnd - 1) != '\n') {
                text.setSpan((Object)it, spanStart, ++spanEnd, 17);
                continue;
            }
            if (text.length() >= spanEnd && spanEnd - 2 > spanStart && text.charAt(spanEnd - 1) == Constants.INSTANCE.getZWJ_CHAR() && text.charAt(spanEnd - 2) == '\n') {
                text.setSpan((Object)new BlockElementLinebreak(), spanEnd - 2, spanEnd - 1, 33);
                continue;
            }
            if (text.length() > spanEnd && spanEnd - 2 > spanStart && text.charAt(spanEnd - 1) == Constants.INSTANCE.getZWJ_CHAR() && text.charAt(spanEnd) == '\n') {
                text.setSpan((Object)new BlockElementLinebreak(), spanEnd - 1, spanEnd, 33);
                continue;
            }
            if (text.length() <= spanEnd || spanEnd - 1 <= spanStart || text.charAt(spanEnd) != Constants.INSTANCE.getZWJ_CHAR() && text.charAt(spanEnd) != '\n' || it instanceof AztecListSpan && spanEnd - spanStart > 1 && text.charAt(spanEnd - 1) == '\n') continue;
            text.setSpan((Object)new BlockElementLinebreak(), spanEnd - 1, spanEnd, 33);
        }
        return (Spanned)text;
    }

    private final void resetHiddenTagParser(Spanned text) {
        this.hiddenIndex = 0;
        this.closeMap.clear();
        this.openMap.clear();
        HiddenHtmlSpan[] spans = (HiddenHtmlSpan[])text.getSpans(0, text.length(), HiddenHtmlSpan.class);
        Object[] $receiver$iv = (Object[])spans;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            HiddenHtmlSpan p1 = (HiddenHtmlSpan)((Object)element$iv);
            p1.reset();
        }
    }

    private final void withinHtml(StringBuilder out, Spanned text) {
        int i = 0;
        while (i < text.length()) {
            int next = text.nextSpanTransition(i, text.length(), AztecParagraphStyle.class);
            AztecParagraphStyle[] styles = (AztecParagraphStyle[])text.getSpans(i, next, AztecParagraphStyle.class);
            if (((Object[])styles).length == 2) {
                if (styles[0] instanceof AztecListSpan && styles[1] instanceof AztecQuoteSpan) {
                    AztecParagraphStyle aztecParagraphStyle = styles[0];
                    if (aztecParagraphStyle == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecListSpan");
                    }
                    this.withinListThenQuote(out, text, i, next, (AztecListSpan)aztecParagraphStyle);
                } else if (styles[0] instanceof AztecQuoteSpan && styles[1] instanceof AztecListSpan) {
                    AztecParagraphStyle aztecParagraphStyle = styles[1];
                    if (aztecParagraphStyle == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecListSpan");
                    }
                    AztecParagraphStyle aztecParagraphStyle2 = styles[0];
                    if (aztecParagraphStyle2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecQuoteSpan");
                    }
                    this.withinQuoteThenList(out, text, i, next, (AztecListSpan)aztecParagraphStyle, (AztecQuoteSpan)aztecParagraphStyle2);
                } else {
                    AztecParser.withinContent$default(this, out, text, i, next, false, 16, null);
                }
            } else if (((Object[])styles).length == 1) {
                if (styles[0] instanceof AztecListSpan) {
                    AztecParagraphStyle aztecParagraphStyle = styles[0];
                    if (aztecParagraphStyle == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.AztecListSpan");
                    }
                    this.withinList(out, text, i, next, (AztecListSpan)aztecParagraphStyle);
                } else if (styles[0] instanceof AztecQuoteSpan) {
                    this.withinQuote(out, text, i, next);
                } else if (styles[0] instanceof UnknownHtmlSpan) {
                    AztecParagraphStyle aztecParagraphStyle = styles[0];
                    if (aztecParagraphStyle == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.UnknownHtmlSpan");
                    }
                    this.withinUnknown(out, text, i, next, (UnknownHtmlSpan)aztecParagraphStyle);
                } else if (styles[0] instanceof ParagraphSpan) {
                    this.withinParagraph(out, text, i, next);
                } else {
                    AztecParser.withinContent$default(this, out, text, i, next, false, 16, null);
                }
            } else {
                AztecParser.withinContent$default(this, out, text, i, next, false, 16, null);
            }
            i = next;
        }
        this.consumeCursorIfInInput(out, (CharSequence)text, text.length());
    }

    private final void withinUnknown(StringBuilder out, Spanned text, int start, int end, UnknownHtmlSpan unknownHtmlSpan) {
        this.consumeCursorIfInInput(out, (CharSequence)text, start);
        out.append((CharSequence)unknownHtmlSpan.getRawHtml());
        this.consumeCursorIfInInput(out, (CharSequence)text, end);
    }

    private final void withinListThenQuote(StringBuilder out, Spanned text, int start, int end, AztecListSpan list) {
        out.append("<" + list.getStartTag() + "><li>");
        this.withinQuote(out, text, start, end);
        out.append("</li></" + list.getEndTag() + ">");
    }

    private final void withinQuoteThenList(StringBuilder out, Spanned text, int start, int end, AztecListSpan list, AztecQuoteSpan quote) {
        out.append("<" + quote.getStartTag() + ">");
        this.withinList(out, text, start, end, list);
        out.append("</" + quote.getEndTag() + ">");
    }

    /*
     * WARNING - void declaration
     */
    private final void withinList(StringBuilder out, Spanned text, int start, int end, AztecListSpan list) {
        int n;
        int $receiver$iv2;
        Object lines;
        out.append("<" + list.getStartTag() + ">");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Object object = (Object[])text;
        Ref.ObjectRef objectRef2 = objectRef;
        Object object2 = ((Object)object.subSequence(start, end)).toString();
        objectRef2.element = TextUtils.split((String)object2, (String)"\n");
        object = (String[])lines.element;
        Object[] objectArray = object;
        if (!(objectArray.length == 0)) {
            object = (CharSequence)ArraysKt.last((Object[])((String[])lines.element));
            if (object.length() == 0) {
                void $receiver$iv2;
                object = ArraysKt.take((Object[])((String[])lines.element), (int)(((Object[])((String[])lines.element)).length - 1));
                objectRef2 = lines;
                void v0 = $receiver$iv2;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = (Collection)v0;
                String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                object2 = stringArray;
                objectRef2.element = (String[])object2;
            }
        }
        if (($receiver$iv2 = 0) <= (n = ((String[])lines.element).length - 1)) {
            while (true) {
                void $receiver$iv3;
                void i;
                int lineLength = ((String[])lines.element)[i].length();
                Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv3.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n2 = element$iv = ((IntIterator)iterator).nextInt();
                    int n3 = sum$iv;
                    object2 = ((String[])lines.element)[it].length() + 1;
                    sum$iv = n3 + ((Number)object2).intValue();
                }
                int lineStart = sum$iv;
                boolean isLastLineInList = ArraysKt.getIndices((Object[])((String[])lines.element)).getLast() == i;
                int lineEnd = lineStart + lineLength;
                if (!(lineStart > lineEnd || lineStart == lineEnd && isLastLineInList)) {
                    int itemSpanStart = start + lineStart + lineLength;
                    AztecListItemSpan[] itemSpans = (AztecListItemSpan[])text.getSpans(itemSpanStart, itemSpanStart + 1, AztecListItemSpan.class);
                    if (i == ArraysKt.getLastIndex((Object[])((String[])lines.element))) {
                        out.append("<li" + list.getLastItem().getAttributes() + ">");
                    } else {
                        Object[] objectArray2 = itemSpans;
                        Object[] objectArray3 = objectArray2;
                        if (!(objectArray3.length == 0)) {
                            out.append("<li" + itemSpans[0].getAttributes() + ">");
                        } else {
                            out.append("<li>");
                        }
                    }
                    AztecParser.withinContent$default(this, out, text, start + lineStart, start + lineEnd, false, 16, null);
                    this.consumeCursorIfInInput(out, (CharSequence)text, itemSpanStart);
                    out.append("</li>");
                }
                if (i == n) break;
                ++i;
            }
        }
        out.append("</" + list.getEndTag() + ">");
        lines = null;
    }

    private final void withinParagraph(StringBuilder out, Spanned text, int start, int end) {
        int i = start;
        while (i < end) {
            ParagraphSpan paragraph;
            int n;
            int next = text.nextSpanTransition(i, end, ParagraphSpan.class);
            ParagraphSpan[] paragraphs = (ParagraphSpan[])text.getSpans(i, next, ParagraphSpan.class);
            for (n = 0; n < paragraphs.length; ++n) {
                paragraph = paragraphs[n];
                out.append("<" + paragraph.getStartTag() + ">");
            }
            AztecParser.withinContent$default(this, out, text, i, next, false, 16, null);
            for (n = 0; n < paragraphs.length; ++n) {
                paragraph = paragraphs[n];
                out.append("</" + paragraph.getEndTag() + ">");
            }
            i = next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void withinHeading(StringBuilder out, Spanned headingContent, AztecHeadingSpan span) {
        SpannableStringBuilder cleanHeading = new SpannableStringBuilder((CharSequence)headingContent);
        cleanHeading.removeSpan((Object)span);
        String[] lines = TextUtils.split((String)cleanHeading.toString(), (String)"\n");
        int n = 0;
        int n2 = lines.length - 1;
        if (n <= n2) {
            while (true) {
                void $receiver$iv;
                void i;
                int lineLength = lines[i].length();
                Iterable iterable = (Iterable)new IntRange(0, (int)(i - true));
                int sum$iv = 0;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int element$iv;
                    int n3 = element$iv = ((IntIterator)iterator).nextInt();
                    int n4 = sum$iv;
                    int n5 = lines[it].length() + 1;
                    sum$iv = n4 + n5;
                }
                int lineStart = sum$iv;
                int lineEnd = lineStart + lineLength;
                if (lineLength != 0) {
                    out.append("<" + span.getStartTag() + ">");
                    this.withinContent(out, (Spanned)cleanHeading, lineStart, lineEnd, true);
                    out.append("</" + span.getEndTag() + ">");
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final void withinQuote(StringBuilder out, Spanned text, int start, int end) {
        int i = start;
        while (i < end) {
            AztecQuoteSpan quote;
            int n;
            int next = text.nextSpanTransition(i, end, AztecQuoteSpan.class);
            AztecQuoteSpan[] quotes = (AztecQuoteSpan[])text.getSpans(i, next, AztecQuoteSpan.class);
            for (n = 0; n < quotes.length; ++n) {
                quote = quotes[n];
                out.append("<" + quote.getStartTag() + ">");
            }
            AztecParser.withinContent$default(this, out, text, i, next, false, 16, null);
            for (n = 0; n < quotes.length; ++n) {
                quote = quotes[n];
                out.append("</" + quote.getEndTag() + ">");
            }
            i = next;
        }
    }

    private final void withinContent(StringBuilder out, Spanned text, int start, int end, boolean ignoreHeading) {
        int i = start;
        while (i < end) {
            int next = TextUtils.indexOf((CharSequence)((CharSequence)text), (char)'\n', (int)i, (int)end);
            if (next < 0) {
                next = end;
            }
            int nl = 0;
            while (next < end && text.charAt(next) == '\n') {
                boolean isVisualLinebreak;
                Object[] objectArray = text.getSpans(next, next, BlockElementLinebreak.class);
                Object[] objectArray2 = objectArray;
                boolean bl = isVisualLinebreak = !(objectArray2.length == 0);
                if (!isVisualLinebreak) {
                    ++nl;
                }
                ++next;
            }
            int zwjModifer = text.charAt(next - 1) == Constants.INSTANCE.getZWJ_CHAR() ? 1 : 0;
            this.withinParagraph(out, text, i, next - nl - zwjModifer, nl, ignoreHeading);
            i = next;
        }
    }

    static /* bridge */ /* synthetic */ void withinContent$default(AztecParser aztecParser, StringBuilder stringBuilder, Spanned spanned, int n, int n2, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withinContent");
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        aztecParser.withinContent(stringBuilder, spanned, n, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void withinParagraph(StringBuilder out, Spanned text, int start, int end, int nl, boolean ignoreHeadingSpanCheck) {
        AztecParser isHeadingSpanEncountered22;
        Ref.IntRef next = new Ref.IntRef();
        if (!ignoreHeadingSpanCheck) {
            void $receiver$iv2;
            int n;
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            Object[] objectArray = text.getSpans(start, end, AztecHeadingSpan.class);
            for (n = 0; n < ((void)$receiver$iv2).length; ++n) {
                void element$iv = $receiver$iv2[n];
                AztecHeadingSpan it = (AztecHeadingSpan)element$iv;
                CharSequence charSequence = text.subSequence(start, end);
                if (charSequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
                }
                Spanned spanned = (Spanned)charSequence;
                AztecHeadingSpan aztecHeadingSpan = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)aztecHeadingSpan, (String)"it");
                this.withinHeading(out, spanned, aztecHeadingSpan);
                ((Ref.BooleanRef)isHeadingSpanEncountered22).element = true;
            }
            if (((Ref.BooleanRef)isHeadingSpanEncountered22).element) {
                int $receiver$iv2 = 0;
                n = nl - 1;
                if ($receiver$iv2 <= n) {
                    while (true) {
                        void i;
                        out.append("<br>");
                        this.consumeCursorIfInInput(out, (CharSequence)text, end + i);
                        if (i == n) break;
                        ++i;
                    }
                }
                return;
            }
            isHeadingSpanEncountered22 = null;
        }
        isHeadingSpanEncountered22 = this;
        AztecParser i = isHeadingSpanEncountered22;
        int i2 = start;
        while (i2 < end || start == end) {
            void $receiver;
            int j;
            next.element = text.nextSpanTransition(i2, end, CharacterStyle.class);
            int it = 0;
            CharacterStyle[] spans = (CharacterStyle[])text.getSpans(i2, next.element, CharacterStyle.class);
            int n = spans.length - 1;
            if (it <= n) {
                while (true) {
                    CharacterStyle span;
                    if ((span = spans[j]) instanceof AztecContentSpan) {
                        out.append("<" + ((AztecContentSpan)span).getStartTag() + ">");
                    }
                    if (span instanceof AztecCommentSpan || span instanceof CommentSpan) {
                        out.append("<!--");
                    }
                    if (span instanceof AztecMediaSpan) {
                        out.append(((AztecMediaSpan)span).getHtml());
                        i2 = next.element;
                    }
                    if (span instanceof HiddenHtmlSpan) {
                        super.parseHiddenSpans(i2, out, (HiddenHtmlSpan)span, text);
                    }
                    if (j == n) break;
                    ++j;
                }
            }
            super.withinStyle(out, (CharSequence)text, i2, next.element, nl);
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((Object[])spans)));
            j = intProgression.getFirst();
            n = intProgression.getLast();
            int n2 = intProgression.getStep();
            int n3 = j;
            int n4 = n;
            if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
                while (true) {
                    CharacterStyle span;
                    if ((span = spans[j]) instanceof AztecContentSpan) {
                        out.append("</" + ((AztecContentSpan)span).getEndTag() + ">");
                    }
                    if (span instanceof AztecCommentSpan || span instanceof CommentSpan) {
                        out.append("-->");
                    }
                    if (span instanceof HiddenHtmlSpan) {
                        super.parseHiddenSpans(next.element, out, (HiddenHtmlSpan)span, text);
                    }
                    if (j == n) break;
                    j += n2;
                }
            }
            if (start == end) break;
            i2 = next.element;
        }
        int isHeadingSpanEncountered22 = 0;
        int n = nl - 1;
        if (isHeadingSpanEncountered22 <= n) {
            while (true) {
                void i3;
                out.append("<br>");
                this.consumeCursorIfInInput(out, (CharSequence)text, end + i3);
                if (i3 == n) break;
                ++i3;
            }
        }
        next = null;
    }

    static /* bridge */ /* synthetic */ void withinParagraph$default(AztecParser aztecParser, StringBuilder stringBuilder, Spanned spanned, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withinParagraph");
        }
        if ((n4 & 0x20) != 0) {
            bl = false;
        }
        aztecParser.withinParagraph(stringBuilder, spanned, n, n2, n3, bl);
    }

    private final void parseHiddenSpans(int position, StringBuilder out, HiddenHtmlSpan span, Spanned text) {
        int last;
        this.closeMap.put(span.getEndOrder(), span);
        this.openMap.put(span.getStartOrder(), span);
        do {
            HiddenHtmlSpan nextSpan;
            last = this.hiddenIndex;
            if (this.hiddenIndex >= this.hiddenSpans.length) break;
            int nextSpanIndex = this.hiddenSpans[this.hiddenIndex];
            Map map = this.openMap;
            Integer n = nextSpanIndex;
            Map map2 = map;
            Map map3 = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (map3.containsKey(n)) {
                if (this.openMap.get(nextSpanIndex) == null) {
                    Intrinsics.throwNpe();
                }
                if (!nextSpan.isOpened() && text.getSpanStart((Object)nextSpan) == position) {
                    out.append((CharSequence)nextSpan.getStartTag());
                    nextSpan.open();
                    int n2 = this.hiddenIndex;
                    this.hiddenIndex = n2 + 1;
                }
            }
            if (!this.closeMap.containsKey(nextSpanIndex)) continue;
            if (this.closeMap.get(nextSpanIndex) == null) {
                Intrinsics.throwNpe();
            }
            if (nextSpan.isParsed() || text.getSpanEnd((Object)nextSpan) != position) continue;
            out.append((CharSequence)nextSpan.getEndTag());
            nextSpan.parse();
            int n3 = this.hiddenIndex;
            this.hiddenIndex = n3 + 1;
        } while (last != this.hiddenIndex);
    }

    private final void withinStyle(StringBuilder out, CharSequence text, int start, int end, int nl) {
        int i = start;
        while (i < end) {
            char c = text.charAt(i);
            if (c == Constants.INSTANCE.getZWJ_CHAR()) {
                ++i;
                continue;
            }
            this.consumeCursorIfInInput(out, text, i);
            if (c == '<') {
                out.append("&lt;");
            } else if (c == '>') {
                out.append("&gt;");
            } else if (c == '&') {
                out.append("&amp;");
            } else if (c >= '\ud800' && c <= '\udfff') {
                char d;
                if (c < '\udc00' && i + 1 < end && (d = text.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    ++i;
                    int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                    out.append("&#").append(codepoint).append(";");
                }
            } else if (c > '~' || c < ' ') {
                if (c != '\n') {
                    out.append("&#").append((int)c).append(";");
                }
            } else if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    this.consumeCursorIfInInput(out, text, ++i);
                }
                out.append(' ');
            } else {
                out.append(c);
            }
            ++i;
        }
        if (nl == 0 && text.length() > i && text.charAt(i) == '\n') {
            this.consumeCursorIfInInput(out, text, i);
        }
    }

    private final void consumeCursorIfInInput(StringBuilder out, CharSequence text, int position) {
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.SpannableStringBuilder");
        }
        AztecCursorSpan cursorSpan = (AztecCursorSpan)ArraysKt.firstOrNull((Object[])((SpannableStringBuilder)charSequence).getSpans(position, position, AztecCursorSpan.class));
        if (cursorSpan != null) {
            out.append(AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG());
            ((SpannableStringBuilder)text).removeSpan((Object)cursorSpan);
        }
    }

    private final String tidy(String html) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)html, (String)"&#8203;", (String)"", (boolean)false, (int)4, null), (String)"&#65279;", (String)"", (boolean)false, (int)4, null);
        String string = "(</? ?br>)*((aztec_cursor)?)</blockquote>";
        string = new Regex(string);
        String string2 = "$2</blockquote>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</p>";
        string = new Regex(string);
        string2 = "$2</p>";
        charSequence = string.replace(charSequence, string2);
        string = "(</? ?br>)*((aztec_cursor)?)</li>";
        string = new Regex(string);
        string2 = "$2</li>";
        return string.replace(charSequence, string2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/wordpress/aztec/AztecParser$SpanToReset;", "", "span", "Lorg/wordpress/aztec/spans/AztecSpan;", "start", "", "end", "(Lorg/wordpress/aztec/spans/AztecSpan;II)V", "getEnd", "()I", "getSpan", "()Lorg/wordpress/aztec/spans/AztecSpan;", "getStart", "component1", "component2", "component3", "copy", "aztec_release"})
    public static final class SpanToReset {
        @NotNull
        private final AztecSpan span;
        private final int start;
        private final int end;

        @NotNull
        public final AztecSpan getSpan() {
            return this.span;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public SpanToReset(@NotNull AztecSpan span, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
            this.span = span;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public final AztecSpan component1() {
            return this.span;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final SpanToReset copy(@NotNull AztecSpan span, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
            return new SpanToReset(span, start, end);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SpanToReset copy$default(SpanToReset spanToReset, AztecSpan aztecSpan, int n, int n2, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n3 & 1) != 0) {
                aztecSpan = spanToReset.span;
            }
            if ((n3 & 2) != 0) {
                n = spanToReset.start;
            }
            if ((n3 & 4) != 0) {
                n2 = spanToReset.end;
            }
            return spanToReset.copy(aztecSpan, n, n2);
        }

        public String toString() {
            return "SpanToReset(span=" + this.span + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            AztecSpan aztecSpan = this.span;
            return ((aztecSpan != null ? aztecSpan.hashCode() : 0) * 31 + this.start) * 31 + this.end;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SpanToReset)) break block3;
                    SpanToReset spanToReset = (SpanToReset)object;
                    if (!Intrinsics.areEqual((Object)this.span, (Object)spanToReset.span) || !(this.start == spanToReset.start) || !(this.end == spanToReset.end)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

