/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;
import android.text.style.LineHeightSpan;
import android.text.style.TypefaceSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.IAztecAlignmentSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B-\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ8\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u000208H\u0016Jb\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u0010C\u001a\u00020\bH\u0016Jh\u0010D\u001a\u0002002\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010E\u001a\u00020\b2\u0006\u0010F\u001a\u00020\b2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\b2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\b2\u0006\u0010G\u001a\u00020HH\u0016R\u000e\u0010\u0010\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001f\"\u0004\b.\u0010!\u00a8\u0006L"}, d2={"Lorg/wordpress/aztec/spans/AztecPreformatSpan;", "Lorg/wordpress/aztec/spans/IAztecAlignmentSpan;", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "Landroid/text/style/LeadingMarginSpan;", "Landroid/text/style/LineBackgroundSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/TypefaceSpan;", "nestingLevel", "", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "preformatStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "align", "Landroid/text/Layout$Alignment;", "(ILorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;Landroid/text/Layout$Alignment;)V", "MARGIN", "TAG", "", "getTAG", "()Ljava/lang/String;", "getAlign", "()Landroid/text/Layout$Alignment;", "setAlign", "(Landroid/text/Layout$Alignment;)V", "getAttributes", "()Lorg/wordpress/aztec/AztecAttributes;", "setAttributes", "(Lorg/wordpress/aztec/AztecAttributes;)V", "endBeforeBleed", "getEndBeforeBleed", "()I", "setEndBeforeBleed", "(I)V", "getNestingLevel", "setNestingLevel", "getPreformatStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;", "setPreformatStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$PreformatStyle;)V", "rect", "Landroid/graphics/Rect;", "getRect", "()Landroid/graphics/Rect;", "startBeforeCollapse", "getStartBeforeCollapse", "setStartBeforeCollapse", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "drawBackground", "canvas", "Landroid/graphics/Canvas;", "paint", "Landroid/graphics/Paint;", "left", "right", "top", "baseline", "bottom", "lnum", "drawLeadingMargin", "x", "dir", "first", "", "layout", "Landroid/text/Layout;", "getLeadingMargin", "aztec_release"})
public final class AztecPreformatSpan
extends TypefaceSpan
implements IAztecAlignmentSpan,
IAztecBlockSpan,
LeadingMarginSpan,
LineBackgroundSpan,
LineHeightSpan {
    @NotNull
    private final String TAG = "pre";
    private int endBeforeBleed;
    private int startBeforeCollapse;
    @NotNull
    private final Rect rect;
    private final int MARGIN = 16;
    private int nestingLevel;
    @NotNull
    private AztecAttributes attributes;
    @NotNull
    private BlockFormatter.PreformatStyle preformatStyle;
    @Nullable
    private Layout.Alignment align;

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    @Override
    public int getEndBeforeBleed() {
        return this.endBeforeBleed;
    }

    @Override
    public void setEndBeforeBleed(int n) {
        this.endBeforeBleed = n;
    }

    @Override
    public int getStartBeforeCollapse() {
        return this.startBeforeCollapse;
    }

    @Override
    public void setStartBeforeCollapse(int n) {
        this.startBeforeCollapse = n;
    }

    @NotNull
    public final Rect getRect() {
        return this.rect;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        Spanned spanned = (Spanned)text;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.preformatStyle.getVerticalPadding();
            fm.top -= this.preformatStyle.getVerticalPadding();
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.preformatStyle.getVerticalPadding();
            fm.bottom += this.preformatStyle.getVerticalPadding();
        }
    }

    public void drawBackground(@NotNull Canvas canvas, @NotNull Paint paint, int left, int right, int top, int baseline, int bottom, @Nullable CharSequence text, int start, int end, int lnum) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        int color2 = paint.getColor();
        int alpha = (int)(this.preformatStyle.getPreformatBackgroundAlpha() * (float)255);
        paint.setColor(Color.argb((int)alpha, (int)Color.red((int)this.preformatStyle.getPreformatBackground()), (int)Color.green((int)this.preformatStyle.getPreformatBackground()), (int)Color.blue((int)this.preformatStyle.getPreformatBackground())));
        this.rect.set(left, top, right, bottom);
        canvas.drawRect(this.rect, paint);
        paint.setColor(color2);
    }

    public void drawLeadingMargin(@NotNull Canvas canvas, @NotNull Paint paint, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout layout2) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)layout2, (String)"layout");
        Paint.Style style2 = paint.getStyle();
        int color2 = paint.getColor();
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(this.preformatStyle.getPreformatColor());
        canvas.drawRect((float)x + (float)this.MARGIN, (float)top, (float)(x + this.MARGIN), (float)bottom, paint);
        paint.setStyle(style2);
        paint.setColor(color2);
    }

    public int getLeadingMargin(boolean first) {
        return this.MARGIN;
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public AztecAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AztecAttributes aztecAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)aztecAttributes, (String)"<set-?>");
        this.attributes = aztecAttributes;
    }

    @NotNull
    public final BlockFormatter.PreformatStyle getPreformatStyle() {
        return this.preformatStyle;
    }

    public final void setPreformatStyle(@NotNull BlockFormatter.PreformatStyle preformatStyle) {
        Intrinsics.checkParameterIsNotNull((Object)preformatStyle, (String)"<set-?>");
        this.preformatStyle = preformatStyle;
    }

    @Override
    @Nullable
    public Layout.Alignment getAlign() {
        return this.align;
    }

    @Override
    public void setAlign(@Nullable Layout.Alignment alignment) {
        this.align = alignment;
    }

    public AztecPreformatSpan(int nestingLevel, @NotNull AztecAttributes attributes, @NotNull BlockFormatter.PreformatStyle preformatStyle, @Nullable Layout.Alignment align) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)preformatStyle, (String)"preformatStyle");
        super("monospace");
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.preformatStyle = preformatStyle;
        this.align = align;
        this.TAG = "pre";
        this.endBeforeBleed = -1;
        this.startBeforeCollapse = -1;
        this.rect = new Rect();
        this.MARGIN = 16;
    }

    public /* synthetic */ AztecPreformatSpan(int n, AztecAttributes aztecAttributes, BlockFormatter.PreformatStyle preformatStyle, Layout.Alignment alignment, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        if ((n2 & 4) != 0) {
            preformatStyle = new BlockFormatter.PreformatStyle(0, 0.0f, 0, 0);
        }
        if ((n2 & 8) != 0) {
            alignment = null;
        }
        this(n, aztecAttributes, preformatStyle, alignment);
    }

    @Override
    @NotNull
    public Layout.Alignment getAlignment() {
        return IAztecAlignmentSpan.DefaultImpls.getAlignment(this);
    }

    @Override
    public boolean shouldParseAlignmentToHtml() {
        return IAztecAlignmentSpan.DefaultImpls.shouldParseAlignmentToHtml(this);
    }

    @Override
    @NotNull
    public String getStartTag() {
        return IAztecBlockSpan.DefaultImpls.getStartTag(this);
    }

    @Override
    @NotNull
    public String getEndTag() {
        return IAztecBlockSpan.DefaultImpls.getEndTag(this);
    }

    @Override
    public void applyInlineStyleAttributes(@NotNull Editable output, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        IAztecBlockSpan.DefaultImpls.applyInlineStyleAttributes(this, output, start, end);
    }

    @Override
    public void clearStartBeforeCollapse() {
        IAztecBlockSpan.DefaultImpls.clearStartBeforeCollapse(this);
    }

    @Override
    public boolean hasCollapsed() {
        return IAztecBlockSpan.DefaultImpls.hasCollapsed(this);
    }

    @Override
    public void clearEndBeforeBleed() {
        IAztecBlockSpan.DefaultImpls.clearEndBeforeBleed(this);
    }

    @Override
    public boolean hasBled() {
        return IAztecBlockSpan.DefaultImpls.hasBled(this);
    }
}

