/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers.event.sequence;

import android.os.Build;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.watchers.event.IEventInjector;
import org.wordpress.aztec.watchers.event.buckets.API25Bucket;
import org.wordpress.aztec.watchers.event.buckets.API26Bucket;
import org.wordpress.aztec.watchers.event.buckets.Bucket;
import org.wordpress.aztec.watchers.event.sequence.EventSequence;
import org.wordpress.aztec.watchers.event.sequence.UserOperationEvent;
import org.wordpress.aztec.watchers.event.text.TextWatcherEvent;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0002R!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/wordpress/aztec/watchers/event/sequence/ObservationQueue;", "Lorg/wordpress/aztec/watchers/event/sequence/EventSequence;", "Lorg/wordpress/aztec/watchers/event/text/TextWatcherEvent;", "injector", "Lorg/wordpress/aztec/watchers/event/IEventInjector;", "(Lorg/wordpress/aztec/watchers/event/IEventInjector;)V", "buckets", "Ljava/util/ArrayList;", "Lorg/wordpress/aztec/watchers/event/buckets/Bucket;", "Lkotlin/collections/ArrayList;", "getBuckets", "()Ljava/util/ArrayList;", "getInjector", "()Lorg/wordpress/aztec/watchers/event/IEventInjector;", "add", "", "element", "hasActiveBuckets", "processQueue", "", "Companion", "aztec_release"})
public final class ObservationQueue
extends EventSequence<TextWatcherEvent> {
    @NotNull
    private final ArrayList<Bucket> buckets;
    @NotNull
    private final IEventInjector injector;
    private static final int MAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS = 100;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ArrayList<Bucket> getBuckets() {
        return this.buckets;
    }

    public final boolean hasActiveBuckets() {
        return this.buckets.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean add(@NotNull TextWatcherEvent element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObservationQueue observationQueue = this;
        synchronized (observationQueue) {
            void var3_3;
            boolean added;
            block5: {
                added = super.add(element);
                if (this.buckets.size() != 0) break block5;
                boolean bl = added;
                return bl;
            }
            if (added) {
                this.processQueue();
            }
            void var5_5 = var3_3;
            return (boolean)var5_5;
        }
    }

    private final void processQueue() {
        long timeDistance;
        boolean foundOnePartialMatch = false;
        if (this.size() == 2 && (timeDistance = ((TextWatcherEvent)this.get(1)).getTimestamp() - ((TextWatcherEvent)this.get(0)).getTimestamp()) > (long)MAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS) {
            this.remove(0);
        }
        for (Bucket bucket : this.buckets) {
            for (UserOperationEvent operation : bucket.getUserOperations()) {
                if (this.size() < operation.getSequence().size()) {
                    if (!operation.isUserOperationPartiallyObservedInSequence(this)) continue;
                    foundOnePartialMatch = true;
                    continue;
                }
                UserOperationEvent.ObservedOperationResultType result = operation.isUserOperationObservedInSequence(this);
                if (operation.isFound(result)) {
                    TextWatcherEvent replacementEvent = operation.buildReplacementEventWithSequenceData(this);
                    this.injector.executeEvent(replacementEvent);
                    this.clear();
                }
                if (!operation.needsClear(result)) continue;
                this.clear();
            }
        }
        if (this.size() > 0 && !foundOnePartialMatch) {
            this.clear();
        }
    }

    @NotNull
    public final IEventInjector getInjector() {
        return this.injector;
    }

    public ObservationQueue(@NotNull IEventInjector injector) {
        Intrinsics.checkParameterIsNotNull((Object)injector, (String)"injector");
        this.injector = injector;
        this.buckets = new ArrayList();
        if (Build.VERSION.SDK_INT >= 26) {
            this.buckets.add(new API26Bucket());
        } else if (Build.VERSION.SDK_INT == 25) {
            this.buckets.add(new API25Bucket());
        }
    }

    static {
        MAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS = 100;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/wordpress/aztec/watchers/event/sequence/ObservationQueue$Companion;", "", "()V", "MAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS", "", "getMAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS", "()I", "aztec_release"})
    public static final class Companion {
        public final int getMAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS() {
            return MAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

