/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.PrettyPrint;
import com.eclipsesource.json.WriterConfig;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class JsonifyLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private CharSequenceTranslator translator = StringEscapePolicy.DEFAULT.getCharSequenceTranslator();

    public void setTranslator(CharSequenceTranslator translator) {
        this.translator = translator;
    }

    public String toString(PrintMode printMode) {
        StringWriter sw = new StringWriter();
        try {
            switch (printMode) {
                case REGULAR: {
                    Json.parse((String)this.toString()).writeTo((Writer)sw, (WriterConfig)PrettyPrint.singleLine());
                    break;
                }
                case PRETTY: {
                    Json.parse((String)this.toString()).writeTo((Writer)sw, WriterConfig.PRETTY_PRINT);
                    break;
                }
                default: {
                    return this.toString();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry mem : this.entrySet()) {
            sb.append('\"');
            sb.append(mem.getKey());
            sb.append('\"');
            sb.append(':');
            if (mem.getValue() instanceof String) {
                sb.append('\"');
                sb.append(this.translator.translate((CharSequence)((String)mem.getValue())));
                sb.append('\"');
            } else {
                sb.append(mem.getValue());
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }
}

