/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.flattener.ObjectMapperFactory;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class JsonifyLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private CharSequenceTranslator translator = StringEscapePolicy.DEFAULT.getCharSequenceTranslator();

    public void setTranslator(CharSequenceTranslator translator) {
        this.translator = translator;
    }

    public String toString(PrintMode printMode) {
        ObjectMapper mapper = ObjectMapperFactory.get();
        try {
            switch (printMode) {
                case PRETTY: {
                    return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapper.readTree(this.toString()));
                }
            }
            return this.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry mem : this.entrySet()) {
            sb.append('\"');
            sb.append(this.translator.translate((CharSequence)((String)mem.getKey())));
            sb.append('\"');
            sb.append(':');
            if (mem.getValue() instanceof String) {
                sb.append('\"');
                sb.append(this.translator.translate((CharSequence)((String)mem.getValue())));
                sb.append('\"');
            } else {
                sb.append(mem.getValue());
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }
}

