/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

public final class JsonPrinter {
    private JsonPrinter() {
    }

    public static String minimalPrint(String json) {
        if (json == null) {
            new NullPointerException();
        }
        StringBuilder minimalPrintBuilder = new StringBuilder();
        int n = -1;
        boolean inQuote = false;
        for (char jsonChar : json.toCharArray()) {
            char c;
            switch (jsonChar) {
                case '\"': {
                    if (c != '\\') {
                        inQuote = !inQuote;
                        minimalPrintBuilder.append(jsonChar);
                        break;
                    }
                }
                default: {
                    if (!inQuote && Character.toString(jsonChar).matches("\\s")) break;
                    minimalPrintBuilder.append(jsonChar);
                }
            }
            c = jsonChar;
        }
        return minimalPrintBuilder.toString();
    }

    public static String prettyPrint(String json) {
        return JsonPrinter.prettyPrint(json, "  ");
    }

    public static String prettyPrint(String json, String indentStr) {
        if (json == null) {
            new NullPointerException();
        }
        StringBuilder prettyPrintBuilder = new StringBuilder();
        int n = -1;
        int indentLevel = 0;
        boolean inQuote = false;
        boolean inBracket = false;
        for (char jsonChar : json.toCharArray()) {
            char c;
            switch (jsonChar) {
                case '\"': {
                    if (c != '\\') {
                        inQuote = !inQuote;
                        prettyPrintBuilder.append(jsonChar);
                        break;
                    }
                }
                case '{': {
                    prettyPrintBuilder.append(jsonChar);
                    if (inQuote) break;
                    JsonPrinter.appendNewLine(prettyPrintBuilder, ++indentLevel, indentStr);
                    break;
                }
                case '}': {
                    if (!inQuote) {
                        JsonPrinter.appendNewLine(prettyPrintBuilder, --indentLevel, indentStr);
                    }
                    prettyPrintBuilder.append(jsonChar);
                    break;
                }
                case '[': {
                    prettyPrintBuilder.append(jsonChar);
                    if (inQuote) break;
                    inBracket = true;
                    prettyPrintBuilder.append(' ');
                    break;
                }
                case ']': {
                    if (!inQuote) {
                        inBracket = false;
                        prettyPrintBuilder.append(' ');
                    }
                    prettyPrintBuilder.append(jsonChar);
                    break;
                }
                case ',': {
                    prettyPrintBuilder.append(jsonChar);
                    if (inQuote) break;
                    if (inBracket) {
                        prettyPrintBuilder.append(' ');
                        break;
                    }
                    JsonPrinter.appendNewLine(prettyPrintBuilder, indentLevel, indentStr);
                    break;
                }
                case ':': {
                    if (inQuote) {
                        prettyPrintBuilder.append(jsonChar);
                        break;
                    }
                    prettyPrintBuilder.append(' ');
                    prettyPrintBuilder.append(jsonChar);
                    prettyPrintBuilder.append(' ');
                    break;
                }
                default: {
                    if (!inQuote && Character.toString(jsonChar).matches("\\s")) break;
                    prettyPrintBuilder.append(jsonChar);
                }
            }
            c = jsonChar;
        }
        return prettyPrintBuilder.toString();
    }

    private static void appendNewLine(StringBuilder stringBuilder, int indentLevel, String indentStr) {
        stringBuilder.append('\n');
        for (int i = 0; i < indentLevel; ++i) {
            stringBuilder.append(indentStr);
        }
    }
}

